<!-- @file Maintaining the Drupal Bootstrap project. -->
<!-- @defgroup -->
<!-- @ingroup -->
# Maintainers

Generally speaking, these topics will not be very helpful to you unless you are
a maintainer for this project. If you're simply curious about the process or
even want to help improve this aspect of the project, all suggestions will be
appreciated!

## Prerequisites
For development, this project relies heavily on NodeJS/Grunt to automate some
very time consuming tasks and to ensure consistent output. If you do not have
these CLI tools, please install them now:

* https://nodejs.org
* http://gruntjs.com

## Installation
This project's installation may initially take a while to complete. Please read
through the entire topic before continuing and be aware of what to expect.
Suffice it to say: you will not have to manually update this project again.

After you have installed the prerequisite CLI tools, run `npm install` in this
directory. This will install the necessary NodeJS modules inside the
`node_modules` folder.

After NodeJS has finished installing its own modules, it will automatically
invoke `grunt install` for you. This is a grunt task that is specifically
designed to keep the project in sync amongst maintainers.

## Grunt
There are several tasks available to run, please execute `grunt --help` to view
the full list of tasks currently available. This topic only covers the most
important or commonly used tasks.

### `grunt install`
This task is automatically invoked as a `postinstall` event of `npm install`.
There should be no need to manually invoke this task. However, if you feel the
need to manual invoke this task, you may do so without fear of producing any
unintended side-effects. This is simply an alias for sub-tasks defined below.

### `grunt githooks`
This is a sub-task of `grunt install`. It will automatically install the
necessary git hooks for this project. These git hooks allow the project to keep
track of changes to files in order to automate and ensure certain files are
committed (e.g. compiled CSS files). Do not worry, if you already have existing
git hook files in place, this will work around them.

Any time there is a change to `package.json`, `Gruntfile.js`, `.githooks.js.hbs`
or any of the files in the `grunt` subdirectory, the `npm install` task will
automatically be executed by the git hook itself. This allows the workflow to
be altered by one maintainer and those changes propagated to the others the
next time they pull down the repository.

### `grunt sync`
This is a sub-task used by `grunt install`. It will automatically
download and install the various 3.x.x versions of the Bootstrap and Bootswatch
libraries for local development purposes in the `./lib` folder. This process
utilizes Bower and can initially take a while for it to fully complete.

Once you have the various versions of libraries have been installed, this task
becomes much faster. This task utilizes the jsDelivr API to determine which
versions to install. To avoid abusing API calls, this list is cached for one
week as the `.libraries` file in the root of this project. In the event that a
new list needs to be generated and the week cache expiration has not lifted,
you can either simply remove the file manually or run `grunt sync --force` to
force an API call and generate a new list.

### `grunt clean-vendor-dirs`
This is a sub-task used by `grunt install`. Drupal currently does not exclude
vendor directories when scanning directories of modules/themes to look for
.info files. Some NodeJS modules actually are installed with files that have
this same extension, yet cannot be parsed by Drupal. Due to the nature of how
Drupal currently parses these files, it can cause a PCRE recursion in PHP. This
ultimately leads to a segmentation fault and thus rendering the site inoperable.
For more details, see: https://www.drupal.org/node/2329453

### `grunt compile`
This task ensures that all the necessary variations of versions and themes of
Bootstrap and Bootswatch are compile from
`starterkits/less/less/overrides.less`. Typically, this task generates hundreds
of files and can take upwards of \~10 seconds to fully complete.

Optionally, if the `--dev` parameter is specified, this task will only compile
the starterkit's `overrides.less` file for the latest version of Bootstrap:

* `./css/<%= latestVersion/overrides.css`
* `./css/<%= latestVersion/overrides.min.css`

### `grunt watch`
This task is responsible for watching various source files and executing the
appropriate tasks these source files are normally consumed by. With the caveat
of long compilation times mentioned in the previous section, it is highly
recommended running this task as such: `grunt watch --dev`. Keep in mind that
this limits the rapid development of the `overrides.less` file to the default
Bootstrap theme. If you have switched themes, you must manually compile all
the version and theme override files.

## Releases
This project attempts to provide more structured release notes. This allows the
project to communicate more effectively to the users what exactly has changed
and where to go for additional information. This documentation is intended for
the project maintainers to help provide consistent results between releases.

### Release notes template
The following is just a template to show a typical structured format used as
release notes for this project:

```html
<h3 id="change-records">Change Records</h3>
<!-- Change records table HTML -->

Optionally, you can insert any additional verbiage here.
However, if it is long, it should really be a change record.

<p>&nbsp;</p>
<h3 id="notes">Notes</h3>

<p>&nbsp;</p>
<p>Changes since <!-- tag --> (<!-- commit count -->):</p>

<h3 id="features">New Features</h3>
<ul>
  <li><!-- Issue/Commit Message --></li>
</ul>

<h3 id="bugs">Bug Fixes</h3>
<ul>
  <li><!-- Issue/Commit Message --></li>
</ul>
```

### Create a Release Node

{.alert.alert-info} **NOTE:** This project currently relies on the
[Drush Git Release Notes](https://www.drupal.org/project/grn) tool to
automatically generate the the bulk of the release notes. This does, however,
requires maintainers to do the following extra steps. This entire process will
eventually be converted into a fully automated grunt task. Until then, please
download and install this tool and follow the remaining steps.

1. Create a [tag in git](https://www.drupal.org/node/1066342) that follows the
   previous version and push it to the repository.
2. Create a [project release node](https://www.drupal.org/node/1068944) for this
   newly created tag.
3. _(Skip this step if this is a new "alpha/beta" release)_ In a separate tab,
   go to this project's [releases](https://www.drupal.org/node/259843/release)
   page. Open and edit the previous release node. It should have followed the
   release note template. If it has, copy and paste its contents into the new
   release node body.
4. In a separate tab, go to the [change records](https://www.drupal.org/list-changes/bootstrap)
   for this project and filter by the new official release version
   ("alpha/beta/RC" releases should always use the next "official" version for
   their change records). If there are no change records, then remove this
   section. Otherwise, copy and paste the entire table into the template
   (replacing any existing one, if necessary).
5. Generate a list of issues/commits by executing the following from the root
   of the project:

   `drush release-notes <old> <new> --commit-count`
   (e.g. `drush release-notes 7.x-3.0 7.x-3.1 --commit-count`)

   If this is a follow-up "alpha/beta/RC" release, always use the last
   "alpha/beta/RC" release version instead. This will allow for a quicker
   parsing of the list to merge into the previously copied release notes:

   `drush release-notes <old> <new> --commit-count`
   (e.g. `drush release-notes 7.x-3.1-beta2 7.x-3.1-beta3 --commit-count`)

6. Copy the entire generated output into the template, just under where the
   "Change Records" section would be, replacing only the commit count (do not
   replace the "since last {offical} version").
7. Go though each item (`<li>`) that contains an issue link, ignoring duplicates
   and standalone verbiage (direct commits). Move (cut and paste) these items
   into the appropriate "New Features" or "Bug Fixes" sections.
8. Once complete the generated list should be empty (e.g. `<ul></ul>`), remove
   it.
9. Save the release node.
