const ManifestPlugin = require('webpack-manifest-plugin');
const path = require('path');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const webpack = require('webpack');


const paths = {
  appBuild: path.resolve(__dirname, 'lib/build'),
  appIndexJs: 'src/index.js',
  appSrc: '/src',
  publicUrl: '/assets',
  servedPath: '/',
};

// Note: defined here because it will be used more than once.
const cssFilename = 'static/css/[name].css';

module.exports = (env) => {
  const devMode = env.NODE_ENV !== 'production';
  return {
    mode: env.NODE_ENV, // "production" | "development" | "none"  // Chosen mode tells webpack to use its built-in optimizations accordingly.

    entry: {
      vehiculos: './lib/src/vehiculos/index.js',
      vehiculos_kilometraje: './lib/src/vehiculos/index_kilometraje.js',
      backups: './lib/src/backups/index.js',
      backups_ficha: './lib/src/backups/index_ficha.js',
      caja_grande: './lib/src/caja_grande/index.js',
    },

    output: {
      // The build folder.
      path: paths.appBuild,
      // Generated JS file names (with nested folders).
      // There will be one main bundle, and one file per asynchronous chunk.
      // We don't currently advertise code splitting but Webpack supports it.
      filename: 'static/js/[name].js',
      publicPath: paths.publicPath,
    },
    module: {
      // configuration regarding modules
      rules: [
        // First, run the linter.
        // It's important to do this before Babel processes the JS.
        {
          test: /\.(js|jsx|mjs)$/,
          enforce: 'pre',
          use: [
            {
              options: {
                eslintPath: require.resolve('eslint'),
              },
              loader: require.resolve('eslint-loader'),
            },
          ],
          include: paths.appSrc,
        },
        {
          // "oneOf" will traverse all following loaders until one will
          // match the requirements. When no loader matches it will fall
          // back to the "file" loader at the end of the loader list.
          oneOf: [
            // "url" loader works just like "file" loader but it also embeds
            // assets smaller than specified size as data URLs to avoid requests.
            {
              test: [/\.bmp$/, /\.gif$/, /\.jpe?g$/, /\.png$/],
              loader: require.resolve('url-loader'),
              options: {
                limit: 10000,
                name: 'static/media/[name].[hash:8].[ext]',
              },
            },
            // Process JS with Babel.
            {
              test: /\.(js|jsx|mjs)$/,
              include: paths.appSrc,
              loader: require.resolve('babel-loader'),
              options: {

                compact: true,
              },
            },

            {
              test: /\.css$/,
              loader: 'style-loader!css-loader',
            },

            /*
            {
              test: /\.css$/,
              use: [
                {
                  loader: MiniCssExtractPlugin.loader,
                  options: {
                    // you can specify a publicPath here
                    // by default it use publicPath in webpackOptions.output
                    // publicPath: '../'
                  },
                },
              ],
            },
            */


            // "file" loader makes sure assets end up in the `build` folder.
            // When you `import` an asset, you get its filename.
            // This loader doesn't use a "test" so it will catch all modules
            // that fall through the other loaders.
            {
              loader: require.resolve('file-loader'),
              // Exclude `js` files to keep "css" loader working as it injects
              // it's runtime that would otherwise processed through "file" loader.
              // Also exclude `html` and `json` extensions so they get processed
              // by webpacks internal loaders.
              exclude: [/\.(js|jsx|mjs)$/, /\.html$/, /\.json$/],
              options: {
                name: 'static/media/[name].[hash:8].[ext]',
              },
            },
          ],
        },
      ],
      /* Advanced module configuration (click to show) */
    },
    resolve: {
      // options for resolving module requests
      // (does not apply to resolving to loaders)
      modules: [
        'node_modules',
      ],
      // directories where to look for modules
      extensions: ['.js', '.json', '.jsx', '.css'],
      // extensions that are used
    },
    performance: {
      hints: false,
    },
    devtool: devMode ? 'source-map' : false, // enum  // enhance debugging by adding meta info for the browser devtools
    // source-map most detailed at the expense of build speed.
    context: __dirname, // string (absolute path!)
    // the home directory for webpack
    // the entry and module.rules.loader option
    //   is resolved relative to this directory
    target: 'web', // enum  // the environment in which the bundle should run
    // changes chunk loading behavior and available modules
    // externals: ["jquery"],  // Don't follow/bundle these modules, but request them at runtime from the environment
    // lets you provide options for webpack-serve
    // stats: "errors-only",  // lets you precisely control what bundle information gets displayed
    /* devServer: {
            proxy: { // proxy URLs to backend development server
                '/api': 'http://localhost:3000'
            },
            contentBase: path.join(__dirname, 'public'), // boolean | string | array, static file location
            compress: true, // enable gzip compression
            historyApiFallback: true, // true for index.html upon 404, object for multiple paths
            hot: true, // hot module replacement. Depends on HotModuleReplacementPlugin
            https: false, // true for self-signed, object for cert authority
            noInfo: true, // only errors & warns on hot reload
            // ...
        },
        */
    plugins: [
      new MiniCssExtractPlugin({
        // Options similar to the same options in webpackOptions.output
        // both options are optional
        filename: cssFilename,
        // chunkFilename: devMode ? '[id].css' : '[id].[hash].css',
      }),

      // Note: this won't work without ExtractTextPlugin.extract(..) in `loaders`.
      // new ExtractTextPlugin({
      //    filename: cssFilename,
      // }),
      // Generate a manifest file which contains a mapping of all asset filenames
      // to their corresponding output file so that tools can pick it up without
      // having to parse `index.html`.
      new ManifestPlugin({
        fileName: 'asset-manifest.json',
      }),

      // Moment.js is an extremely popular library that bundles large locale files
      // by default due to how Webpack interprets its code. This is a practical
      // solution that requires the user to opt into importing specific locales.
      // https://github.com/jmblog/how-to-optimize-momentjs-with-webpack
      // You can remove this if you don't use Moment.js:
      new webpack.IgnorePlugin(/^\.\/locale$/, /moment$/),
    ],

    watch: devMode,
  };
};
