<?php
/* template head */
if (function_exists('Dwoo_Plugin_include')===false)
	$this->getLoader()->loadPlugin('include');
if (function_exists('Dwoo_Plugin_capitalize')===false)
	$this->getLoader()->loadPlugin('capitalize');
/* end template head */ ob_start(); /* template body */ ?><form id="nueva_cotizacion_form" autocomplete="off" data-user-email="<?php echo $this->scope["datos"]["email_user"];?>">
    <div class="form-group row required">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Cliente</label>
            <?php echo Dwoo_Plugin_include($this, "../system/buscador_clientes.tpl", null, null, null, '_root', null);?>
        </div>
    </div>

    <div class="row margin-bot">
        <div class="col-md-1">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Cantidad</label>
                <div>
                    <input type="text" class="form-control cantidad_cotizacion"
                           data-validation="number" data-validation-allowing="float"
                           data-validation-optional="true"
                           data-validation-error-msg="Agrega una cantidad válida.">
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Imagen</label>
                <div>
                    <input type="file" accept="image/*" name="input_imagenes" class="form-control-file" />
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Descripción</label>
                <div>
                    <textarea rows="1" class="form-control descripcion_cotizacion"></textarea>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Precio Unitario</label>
                <div>
                    <input type="text" class="form-control precio_cotizacion"
                           data-validation="number" data-validation-allowing="float"
                           data-validation-optional="true"
                           data-validation-error-msg="Ingresa una cantidad correcta">
                </div>
            </div>
        </div>
        <div class="col-md-1">
            <label class="col-form-label font-weight-bold">Agregar</label>
            <button type="button" class="btn btn-success agregar_entity_cotizacion"
                    role="button">Agregar
            </button>
        </div>
    </div>

    <div class="row margin-bot">
        <div class="col-md-12">
            <table class="table table-entities-cotizacion table-sm table-hover table-bordered table-striped">
                <thead class="bg-faded">
                <tr>
                    <td class="font-weight-bold">Cantidad</td>
                    <td class="font-weight-bold">Imagen</td>
                    <td class="font-weight-bold">Descripción</td>
                    <td class="text-right font-weight-bold">Precio Unitario</td>
                    <td class="text-right font-weight-bold">Subtotal</td>
                    <td class="text-right font-weight-bold">Eliminar</td>
                </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                <tr>
                    <td colspan="3" class="text-center">Total</td>
                    <td class="text-right total_cotizacion"></td>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>


    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Sumatoria</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="sin_sumatoria" type="radio" id="CotcustomRadioInline1"
                           class="custom-control-input" value="0"
                           data-validation="required"
                           data-validation-error-msg="Indica si los precios llevan sumatoria o no.">
                    <label class="custom-control-label" for="CotcustomRadioInline1">Si</label>
                </div>
            </div>

            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="sin_sumatoria" type="radio" id="CotcustomRadioInline2"
                           class="custom-control-input" value="1">
                    <label class="custom-control-label" for="CotcustomRadioInline2">No</label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Precio con IVA incluido</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="cotizacion_iva_incluido" type="radio" id="CotcustomRadioInline3"
                           class="custom-control-input" value="1"
                           data-validation="required"
                           data-validation-error-msg="Indica si los precios llevan IVA incluido o no.">
                    <label class="custom-control-label" for="CotcustomRadioInline3">Si</label>
                </div>
            </div>

            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="cotizacion_iva_incluido" type="radio" id="CotcustomRadioInline4"
                           class="custom-control-input" value="0">
                    <label class="custom-control-label" for="CotcustomRadioInline4">No</label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Cotización Compartida</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="radio_seleccion_cotizacion_compartida" type="radio" id="CotcustomRadioInline5"
                           class="select_cotizacion_compartida custom-control-input" value="1"
                           data-validation="required"
                           data-validation-error-msg="Indica si la cotización es compartida o no.">
                    <label class="custom-control-label" for="CotcustomRadioInline5">Si</label>
                </div>
            </div>

            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="radio_seleccion_cotizacion_compartida" type="radio" id="CotcustomRadioInline6"
                           class="select_cotizacion_compartida custom-control-input" value="0">
                    <label class="custom-control-label" for="CotcustomRadioInline6">No</label>
                </div>
            </div>
        </div>


        <div class="col-md-3 col-sm-6 cotizacion_compartida_container" style="display: none;">
            <select class="custom-select cotizacion_compartida_con"
                    data-validation="required"
                    data-validation-error-msg="Indica con quién compartiste la cotización.">
                <option value="" hidden selected>Selecciona</option>
                <?php 
$_loop0_data = (isset($this->scope["datos"]["usuarios"]) ? $this->scope["datos"]["usuarios"]:null);
if ($this->isTraversable($_loop0_data) == true)
{
	foreach ($_loop0_data as $tmp_key => $this->scope["-loop-"])
	{
		$_loop0_scope = $this->setScope(array("-loop-"));
/* -- loop start output */
?>
                    <option value="<?php echo $this->scope["uid"];?>"><?php echo Dwoo_Plugin_capitalize($this, mb_strtolower((string) (isset($this->scope["name"]) ? $this->scope["name"] : null), $this->charset), false);?></option>
                <?php 
/* -- loop end output */
		$this->setScope($_loop0_scope, true);
	}
}
?>
            </select>
        </div>
    </div>


    <div class="form-group row">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Notas</label>
        <div class="col-md-5 col-sm-10">
            <textarea name="notas_cotizacion" class="form-control" rows="3"></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Texto extra Correo</label>
        <div class="col-md-5 col-sm-10">
            <div class="alert alert-info">*En caso de que necesites envíar información extra en el correo, puedes
                agregarla en el siguiente campo, y dicha información aparecerá en el cuerpo del correo.
            </div>
            <textarea name="texto_extra_correo_cotizacion" class="form-control" rows="3"></textarea>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success float-right" role="button" type="submit">Guardar</button>
            <button class="btn btn-primary float-left generar_vista_previa" role="button" type="button">Vista Previa</button>
        </div>
    </div>

</form><?php  /* end template body */
return $this->buffer . ob_get_clean();
?>