<?php
/* template head */
if (function_exists('Dwoo_Plugin_date_format')===false)
	$this->getLoader()->loadPlugin('date_format');
/* end template head */ ob_start(); /* template body */ ?><div class="row margin-bot">
    <div class="col-md-2 font-weight-bold text-right">
        Cliente:
    </div>
    <div class="col-md-9">
        <div class="col-md-10">
            <a target="_blank"
               href="clientes?id_cliente=<?php echo $this->scope["datos"]["proyecto"]["id_cliente"];?>&type=<?php echo $this->scope["datos"]["proyecto"]["tipo_cliente"];?>"><?php echo $this->scope["datos"]["proyecto"]["nombre_cliente"];?></a>
            <span class="float-right badge badge-secondary">
                    <i class="fas fa-star" aria-hidden="true"></i>: <?php echo mb_strtoupper((string) (isset($this->scope["datos"]["proyecto"]["tipo_clasificacion"]) ? $this->scope["datos"]["proyecto"]["tipo_clasificacion"]:null), $this->charset);?>
                | <?php if ((isset($this->scope["datos"]["proyecto"]["credito"]) ? $this->scope["datos"]["proyecto"]["credito"]:null) == 1) {
?>Credito <?php 
}
else {
?>Contado <?php 
}?></span>
        </div>
    </div>
</div>

<?php if ((isset($this->scope["datos"]["proyecto"]["id_contacto"]) ? $this->scope["datos"]["proyecto"]["id_contacto"]:null)) {
?>
    <div class="row margin-bot">
        <div class="col-md-2 font-weight-bold text-right">
            Contacto:
        </div>
        <div class="col-md-9">
            <div class="col-md-10">
                <a target="_blank"
                   href="clientes?id_cliente=<?php echo $this->scope["datos"]["proyecto"]["id_contacto"];?>&type=<?php echo $this->scope["datos"]["proyecto"]["tipo_contacto"];?>"><?php echo $this->scope["datos"]["proyecto"]["nombre_contacto"];?></a>
            </div>
        </div>
    </div>
<?php 
}?>

<div class="row margin-bot">
    <div class="col-md-2 font-weight-bold text-right">
        Fecha Creación:
    </div>
    <div class="col-md-9">
        <div class="col-md-10"><?php echo Dwoo_Plugin_date_format($this, (isset($this->scope["datos"]["proyecto"]["created_at"]) ? $this->scope["datos"]["proyecto"]["created_at"]:null), "%d/%m/%Y %H:%M", null);?></div>
    </div>
</div>
<div class="row">
    <div class="col-md-6 text-center font-weight-bold">Proyecto CCTV</div>
    <div class="col-md-6 text-center font-weight-bold">Salida de Almacén</div>
</div>
<hr>
<div class="row">
    <div class="col-md-6 side-a-vista">
        <div class="row margin-bot editable_fields_proyecto" style="display: none;">
            <div class="col-md-1">
                <div class="form-group">
                    <label class="col-form-label">Cantidad</label>
                    <div>
                        <input type="text" class="form-control cantidad_proyecto"
                               data-validation="number" data-validation-allowing="float"
                               data-validation-optional="true"
                               data-validation-error-msg="Agrega una cantidad válida.">
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label class="col-form-label">Tipo</label>
                    <div>
                        <select name="tipo_entity_proyecto" data-validation="required"
                                data-validation-error-msg="Selecciona un tipo" class="custom-select">
                            <option value="" hidden selected>Selecciona un tipo</option>
                            <option value="1">Pieza</option>
                            <option value="2">Servicio</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <label class="col-form-label">Descripción</label>
                    <div>
                        <textarea rows="1" class="form-control descripcion_proyecto"></textarea>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label class="col-form-label">Precio Unitario</label>
                    <div>
                        <input type="text" class="form-control precio_proyecto"
                               data-validation="number" data-validation-allowing="float"
                               data-validation-optional="true"
                               data-validation-error-msg="Ingresa una cantidad correcta">
                    </div>
                </div>
            </div>
            <div class="col-md-1">
                <label class="col-form-label">Agregar</label>
                <button type="button" class="btn btn-outline-success agregar_entity_proyecto"
                        role="button">Agregar
                </button>
            </div>
        </div>

        <table class="table table-sm table-bordered table-hover table-striped non-editable-table">
            <thead class="bg-faded">
            <tr>
                <th>Tipo</th>
                <th>Cantidad</th>
                <th>Descripción</th>
                <th>Precio Unitario</th>
                <th>Subtotal</th>
            </tr>
            </thead>
            <tbody>
            <?php 
$_loop0_data = (isset($this->scope["datos"]["datos"]) ? $this->scope["datos"]["datos"]:null);
if ($this->isTraversable($_loop0_data) == true)
{
	foreach ($_loop0_data as $tmp_key => $this->scope["-loop-"])
	{
		$_loop0_scope = $this->setScope(array("-loop-"));
/* -- loop start output */
?>
                <tr>
                    <td><?php if ((isset($this->scope["tipo"]) ? $this->scope["tipo"] : null) == 1) {
?>Pieza<?php 
}
else {
?>Servicio<?php 
}?></td>
                    <td><?php echo $this->scope["cantidad"];?></td>
                    <td><?php echo nl2br((string) (isset($this->scope["descripcion"]) ? $this->scope["descripcion"] : null));?></td>
                    <td class="text-right"><?php echo number_format((isset($this->scope["precio"]) ? $this->scope["precio"] : null), 2, '.', ',');?></td>
                    <td class="text-right"><?php echo number_format((isset($this->scope["subtotal"]) ? $this->scope["subtotal"] : null), 2, '.', ',');?></td>
                </tr>
            <?php 
/* -- loop end output */
		$this->setScope($_loop0_scope, true);
	}
}
?>
            </tbody>
            <tfoot>
            <th class="text-center" colspan="4">Total</th>
            <th class="text-right"><?php echo number_format((isset($this->scope["datos"]["total"]) ? $this->scope["datos"]["total"]:null), 2, '.', ',');?></th>
            </tfoot>
        </table>


        <table class="table table-sm table-bordered table-hover table-striped editable-table" style="display: none;">
            <thead class="bg-faded">
            <tr>
                <th>Tipo</th>
                <th>Cantidad</th>
                <th>Descripción</th>
                <th>Precio Unitario</th>
                <th>Subtotal</th>
                <th>Eliminar</th>
            </tr>
            </thead>
            <tbody>
            <?php 
$_loop1_data = (isset($this->scope["datos"]["datos"]) ? $this->scope["datos"]["datos"]:null);
if ($this->isTraversable($_loop1_data) == true)
{
	foreach ($_loop1_data as $tmp_key => $this->scope["-loop-"])
	{
		$_loop1_scope = $this->setScope(array("-loop-"));
/* -- loop start output */
?>
                <tr class="entity_proyecto" data-id-dato="<?php echo $this->scope["id_dato"];?>">
                    <td class="entity_tipo_proyecto" data-tipo="<?php echo $this->scope["tipo"];?>"><?php if ((isset($this->scope["tipo"]) ? $this->scope["tipo"] : null) == 1) {
?>Pieza<?php 
}
else {
?>Servicio<?php 
}?></td>
                    <td class="entity_cantidad_proyecto"><?php echo $this->scope["cantidad"];?></td>
                    <td class="entity_descripcion_proyecto" style="word-break: break-all;"><?php echo nl2br((string) (isset($this->scope["descripcion"]) ? $this->scope["descripcion"] : null));?></td>
                    <td class="text-right entity_proyecto_precio"
                        data-precio="<?php echo $this->scope["precio"];?>"><?php echo number_format((isset($this->scope["precio"]) ? $this->scope["precio"] : null), 2, '.', ',');?></td>
                    <td class="text-right entity_proyecto_subtotal"
                        data-subtotal="<?php echo $this->scope["subtotal"];?>"><?php echo number_format((isset($this->scope["subtotal"]) ? $this->scope["subtotal"] : null), 2, '.', ',');?></td>
                    <td class="text-center text-danger cursor-pointer eliminar_entity_proyecto">Eliminar</td>
                </tr>
            <?php 
/* -- loop end output */
		$this->setScope($_loop1_scope, true);
	}
}
?>
            </tbody>
            <tfoot>
            <th class="text-center" colspan="4">Total</th>
            <th class="text-right total_editable_table_proyecto"><?php echo number_format((isset($this->scope["datos"]["total"]) ? $this->scope["datos"]["total"]:null), 2, '.', ',');?></th>
            </tfoot>
        </table>

        <div class="deleted_entities_proyecto"></div>


        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-danger float-right cancelar_edicion_proyecto" role="button"
                        style="display: none;">Cancelar
                </button>
                <a class="btn btn-primary float-left mx-2" href="/cctv/vista/<?php echo $this->scope["datos"]["proyecto"]["id_proyecto"];?>" target="_blank">Imprimir</a>
                <?php if (! (isset($this->scope["datos"]["proyecto"]["finalizado"]) ? $this->scope["datos"]["proyecto"]["finalizado"]:null)) {
?>
                <button class="btn btn-success float-right mx-2 editar_proyecto" role="button">Editar</button>
                <button class="btn btn-success float-right guardar_edicion_proyecto mx-2" role="button"
                        data-id-proyecto="<?php echo $this->scope["datos"]["proyecto"]["id_proyecto"];?>" style="display: none;">Guardar
                </button>
                <?php 
}?>
            </div>
        </div>
    </div>

    <div class="col-md-6 side-b-vista">
        <table class="table table-sm table-bordered table-hover table-striped">
            <?php if ((isset($this->scope["datos"]["mercancia"]) ? $this->scope["datos"]["mercancia"]:null)) {
?>
            <thead class="bg-faded">
            <tr>
                <th>UPC</th>
                <th>Producto</th>
                <th>Serie</th>
                <th class="text-right">Costo</th>
            </tr>
            </thead>
            <tbody>
            <?php 
$_loop2_data = (isset($this->scope["datos"]["mercancia"]) ? $this->scope["datos"]["mercancia"]:null);
if ($this->isTraversable($_loop2_data) == true)
{
	foreach ($_loop2_data as $tmp_key => $this->scope["-loop-"])
	{
		$_loop2_scope = $this->setScope(array("-loop-"));
/* -- loop start output */
?>
                <tr>
                    <td><?php echo $this->scope["upc_producto"];?></td>
                    <td><?php echo $this->scope["nombre_producto"];?></td>
                    <td><?php echo $this->scope["serie_producto"];?></td>
                    <td class="text-right"><?php echo number_format((isset($this->scope["costo"]) ? $this->scope["costo"] : null), 2, '.', ',');?></td>
                </tr>
            <?php 
/* -- loop end output */
		$this->setScope($_loop2_scope, true);
	}
}
?>
            </tbody>
            <?php 
}?>
            <?php if ((isset($this->scope["datos"]["mercanciae"]) ? $this->scope["datos"]["mercanciae"]:null)) {
?>
            <thead>
                <tr>
                    <th colspan="3">Concepto extra</th>
                    <th class="text-right">Costo</th>
                </tr>
            </thead>
            <tbody>
                <?php 
$_loop3_data = (isset($this->scope["datos"]["mercanciae"]) ? $this->scope["datos"]["mercanciae"]:null);
if ($this->isTraversable($_loop3_data) == true)
{
	foreach ($_loop3_data as $tmp_key => $this->scope["-loop-"])
	{
		$_loop3_scope = $this->setScope(array("-loop-"));
/* -- loop start output */
?>
                <tr>
                    <td colspan="3"><?php echo $this->scope["nombre_producto"];?></td>
                    <td class="text-right"><?php echo number_format((isset($this->scope["costo"]) ? $this->scope["costo"] : null), 2, '.', ',');?></td>
                </tr>
                <?php 
/* -- loop end output */
		$this->setScope($_loop3_scope, true);
	}
}
?>
            </tbody>
            <?php 
}?>
            <tfoot>
            <th class="text-center" colspan="3">Total</th>
            <th class="text-right"><?php echo number_format((isset($this->scope["datos"]["total_mercancia"]) ? $this->scope["datos"]["total_mercancia"]:null), 2, '.', ',');?></th>
            </tfoot>
        </table>
    </div>
</div><?php  /* end template body */
return $this->buffer . ob_get_clean();
?>