<?php
include drupal_get_path('module', 'partners') . '/lib/classes/website/class.website.php';
$GLOBALS['configuracionJs'] =
    array('website' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('website/render_template/'),
            'ruta_consultas' => url('website/consultas/'),
        )
    );

//***************************************************************
//------------------------ WEBSITE PRINCIPAL  -------------------
//***************************************************************
function website_principal()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/website.js');
    $result = render_template('php', 'website.index');
    return $result;
}

//***************************************************************
//------------------------ WEBSITE PRINCIPAL  -------------------
//***************************************************************


//***************************************************************
//---------------------- WEBSITE CONSULTAS  ---------------------
//***************************************************************
function website_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new website_sys($tipo, $datos);
}

//***************************************************************
//---------------------- WEBSITE CONSULTAS  ---------------------
//***************************************************************


//***************************************************************
//------------------- WEBSITE RENDER TEMPLATE  ------------------
//***************************************************************
function website_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}

//***************************************************************
//------------------- WEBSITE RENDER TEMPLATE  ------------------
//***************************************************************


//***************************************************************
//------------------ GENERATE CHECKOUT PAYPAL  ------------------
//***************************************************************
function website_facturacion_paypal()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/facturacion_paypal.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
    $result = render_template('php', 'website.index_facturacion_paypal');
    return $result;
}

//***************************************************************
//------------------ GENERATE CHECKOUT PAYPAL  ------------------
//***************************************************************


//***************************************************************
//-------------------- PROCESS PAYPAL PAYMENT  ------------------
//***************************************************************
function website_facturacion_paypal_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/facturacion_paypal_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
    if ($_GET['success'] == "true") {
        $data['success'] = true;
    } else {
        $data['success'] = false;
    }
    $result = render_template('php', 'website.index_facturacion_paypal_process', $data);
    return $result;
}

//***************************************************************
//-------------------- PROCESS PAYPAL PAYMENT  ------------------
//***************************************************************


//***************************************************************
//------------------ GENERATE CHECKOUT PAYU ---------------------
//***************************************************************
/**
 * @return string|void
 * @deprecated Ya no se usa PayU
 */
function website_facturacion_payu()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/facturacion_payu.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_payu.css');
    $result = render_template('php', 'website.index_facturacion_payu');
    return $result;
}

//***************************************************************
//------------------ GENERATE CHECKOUT PAYU  --------------------
//***************************************************************


//***************************************************************
//-------------------- PROCESS PAYU PAYMENT  --------------------
//***************************************************************
/**
 * @return string|void
 * @deprecated ya no se usa PayU
 */
function website_facturacion_payu_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/facturacion_payu_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_payu.css');

    $data = [];
    if (empty($_GET['transactionState'])) {
        $data['successTransaccion'] = false;
    } else {
        $ApiKey = "cD47Ek32qhgVMPO2CB3ppPRgFz";
        $merchant_id = $_REQUEST['merchantId'];
        $referenceCode = $_REQUEST['referenceCode'];
        $TX_VALUE = $_REQUEST['TX_VALUE'];
        $New_value = number_format($TX_VALUE, 1, '.', '');
        $currency = $_REQUEST['currency'];
        $transactionState = $_REQUEST['transactionState'];
        $firma_cadena = "$ApiKey~$merchant_id~$referenceCode~$New_value~$currency~$transactionState";
        $firmacreada = md5($firma_cadena);
        $firma = $_REQUEST['signature'];
        $data['reference_pol'] = $_REQUEST['reference_pol'];
        $data['extra1'] = $_REQUEST['description'];
        $data['lapPaymentMethod'] = $_REQUEST['lapPaymentMethod'];
        $data['transactionId'] = $_REQUEST['transactionId'];
        $data['TX_VALUE'] = $TX_VALUE;
        $data['currency'] = $currency;
        $data['referenceCode'] = $referenceCode;
        if ($_REQUEST['transactionState'] == 4) {
            $data['estadoTx'] = "Transacción aprobada";
        } else if ($_REQUEST['transactionState'] == 6) {
            $data['estadoTx'] = "Transacción rechazada";
        } else if ($_REQUEST['transactionState'] == 104) {
            $data['estadoTx'] = "Error";
        } else if ($_REQUEST['transactionState'] == 7) {
            $data['estadoTx'] = "Transacción pendiente";
        } else {
            $data['estadoTx'] = $_REQUEST['mensaje'];
        }


        if (strtoupper($firma) == strtoupper($firmacreada)) {
            $data['successTransaccion'] = true;
        } else {
            $data['successTransaccion'] = false;
        }
    }

    $result = render_template('php', 'website.index_facturacion_payu_process', $data);
    return $result;
}

//***************************************************************
//-------------------- PROCESS PAYU PAYMENT  --------------------
//***************************************************************

//***************************************************************
//------------------- CONFIRMATION PAYU PAYMENT  ----------------
//***************************************************************
/**
 * PayU: una vez se completa una transacción, envia los detalles por POST a esta url
 * @throws Exception
 * @deprecated Ya no se usa PayU
 */
function website_facturacion_payu_confirmation()
{
    if (!empty($_POST)) {
        // Capturar los detalles de la transacción sin importar su estado.
        $datos = $_POST;
        db_insert('partners_payu_transactions')
            ->fields(array(
                'transaction_id' => $datos['transaction_id'],
                'state_pol' => $datos['state_pol'],
                'response_message_pol' => $datos['response_message_pol'],
                'response_code_pol' => $datos['response_message_pol'],
                'payment_method_id' => $datos['payment_method_id'],
                'payment_method_type' => $datos['payment_method_type'],
                'payment_method_name' => $datos['payment_method_name'],
                'reference_sale' => $datos['reference_sale'],
                'currency' => $datos['currency'],
                'date_' => $datos['date'],
                'description' => $datos['description'],
                'nickname_buyer' => $datos['nickname_buyer'],
                'email_buyer' => $datos['email_buyer'],
            ))
            ->execute();

        // Solamente cuando la transaccion sea aprovada (state_pol = 4) se haran movimientos en nuestra base de datos.
        if ($datos['state_pol'] == 4) {
            $decrypt = encrypt_decrypt('decrypt', $datos['reference_sale']);
            $data = explode('~', $decrypt);
            $serie = $data[0];
            $folio = $data[1];
            db_update('partners_cobranza')
                ->fields(array(
                    'factura_pagada' => 2 // 2 = PayU
                ))
                ->condition('folio', $folio)
                ->condition('serie', $serie)
                ->execute();
        }
    } else {
        echo "No POST data received";
    }


}

//***************************************************************
//------------------- CONFIRMATION PAYU PAYMENT  ----------------
//***************************************************************


//***************************************************************
//---------------------- SERVICIOS PREPAGO ----------------------
//***************************************************************
function website_servicios_prepago()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/servicios_prepago.js');
    drupal_add_js($ruta_lib . 'plugin/js/material-components-web.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/servicios_prepago.css');
    drupal_add_css($ruta_lib . 'plugin/css/material-components-web.min.css');
    $result = render_template('php', 'website.index_servicios_prepago');
    return $result;
}

//***************************************************************
//---------------------- SERVICIOS PREPAGO ----------------------
//***************************************************************


//***************************************************************
//--------------- PROCESS PAYPAL PAYMENT PREPAGO  ---------------
//***************************************************************
function website_prepago_paypal_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/prepago_paypal_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
    if ($_GET['success'] == "true") {
        $data['success'] = true;
    } else {
        $data['success'] = false;
    }
    $result = render_template('php', 'website.index_prepago_paypal_process', $data);
    return $result;
}

//***************************************************************
//--------------- PROCESS PAYPAL PAYMENT PREPAGO  ---------------
//***************************************************************


//***************************************************************
//----------------- PROCESS PAYU PAYMENT PREPAGO ----------------
//***************************************************************
/**
 * @return string|void
 * @deprecated Ya no se usa PayU
 */
function website_prepago_payu_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/website/js/prepago_payu_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_payu.css');

    $data = [];
    if (empty($_GET['transactionState'])) {
        $data['successTransaccion'] = false;
    } else {
        $ApiKey = "4Vj8eK4rloUd272L48hsrarnUA";
        $merchant_id = $_REQUEST['merchantId'];
        $referenceCode = $_REQUEST['referenceCode'];
        $TX_VALUE = $_REQUEST['TX_VALUE'];
        $New_value = number_format($TX_VALUE, 1, '.', '');
        $currency = $_REQUEST['currency'];
        $transactionState = $_REQUEST['transactionState'];
        $firma_cadena = "$ApiKey~$merchant_id~$referenceCode~$New_value~$currency~$transactionState";
        $firmacreada = md5($firma_cadena);
        $firma = $_REQUEST['signature'];
        $data['reference_pol'] = $_REQUEST['reference_pol'];
        $data['extra1'] = $_REQUEST['description'];
        $data['lapPaymentMethod'] = $_REQUEST['lapPaymentMethod'];
        $data['transactionId'] = $_REQUEST['transactionId'];
        $data['TX_VALUE'] = $TX_VALUE;
        $data['currency'] = $currency;
        $data['referenceCode'] = $referenceCode;
        $data['isApproved'] = false;
        if ($_REQUEST['transactionState'] == 4) {
            $data['estadoTx'] = "Transacción aprobada";
            $data['isApproved'] = true;
        } else if ($_REQUEST['transactionState'] == 6) {
            $data['estadoTx'] = "Transacción rechazada";
        } else if ($_REQUEST['transactionState'] == 104) {
            $data['estadoTx'] = "Error";
        } else if ($_REQUEST['transactionState'] == 7) {
            $data['estadoTx'] = "Transacción pendiente";
        } else {
            $data['estadoTx'] = $_REQUEST['mensaje'];
        }


        if (strtoupper($firma) == strtoupper($firmacreada)) {
            $data['successTransaccion'] = true;
        } else {
            $data['successTransaccion'] = false;
        }
    }

    $result = render_template('php', 'website.index_prepago_payu_process', $data);
    return $result;
}

//***************************************************************
//----------------- PROCESS PAYU PAYMENT PREPAGO ----------------
//***************************************************************


//***************************************************************
//--------------- CONFIRMATION PAYU PAYMENT PREPAGO -------------
//***************************************************************
/**
 * PayU: una vez se completa una transacción, envia los detalles por POST a esta url
 * @throws Exception
 * @deprecated Ya no se usa PayU
 */
function website_prepago_payu_confirmation()
{
    if (!empty($_POST)) {
        // Capturar los detalles de la transacción sin importar su estado.
        $datos = $_POST;
        db_insert('partners_payu_transactions')
            ->fields(array(
                'transaction_id' => $datos['transaction_id'],
                'state_pol' => $datos['state_pol'],
                'response_message_pol' => $datos['response_message_pol'],
                'response_code_pol' => $datos['response_message_pol'],
                'payment_method_id' => $datos['payment_method_id'],
                'payment_method_type' => $datos['payment_method_type'],
                'payment_method_name' => $datos['payment_method_name'],
                'reference_sale' => $datos['reference_sale'],
                'currency' => $datos['currency'],
                'date_' => $datos['date'],
                'description' => $datos['description'],
                'nickname_buyer' => $datos['nickname_buyer'],
                'email_buyer' => $datos['email_buyer'],
            ))
            ->execute();

        // Solamente cuando la transaccion sea aprovada (state_pol = 4) se haran movimientos en nuestra base de datos.
        if ($datos['state_pol'] == 4) {

            $data['id_orden'] = $datos['reference_sale'];
            $data['payment_method_name'] = $datos['payment_method_name'];
            $m_type = $datos['payment_method_type'];
            $method = "";
            switch ($m_type) {
                case 2:
                    $method = "Tarjeta de Crédito ";
                    break;
                case 6:
                    $method = "Tarjeta de débito ";
                    break;
                case 7:
                    $method = "Pago en Efectivo ";
                    break;
            }
            $data['metodo_pago'] = $method . ' ' . $datos['payment_method_name'];
            new website_sys('process_payu_payment_prepago', $data);
        }
    } else {
        echo "No POST data received";
    }
}
//***************************************************************
//--------------- CONFIRMATION PAYU PAYMENT PREPAGO -------------
//***************************************************************
