<?php
include drupal_get_path('module', 'partners') . '/lib/classes/web/class.web.php';
$GLOBALS['configuracionJs'] =
    array(
      'web' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('web/render_template/'),
            'ruta_consultas' => url('web/consultas/'),
            'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
            'ruta_lista_contactos' => url('system/tools/lista_contactos/')
        ),
      'clientes' =>
        array(
          'ruta_sys_tools' => url('system/tools/'),
          'ruta_reporte_base' => url('clientes/reporte_base'),
          'render_template' => url('clientes/render_template/'),
          'ruta_capturar' => url('clientes/capturar/'),
          'ruta_vista_cliente' => url('clientes/vista_clientes/'),
          'ruta_vista_contacto' => url('clientes/vista_contactos/')
        )
    );

//***************************************************************
//------------------------ WEB PRINCIPAL  -----------------------
//***************************************************************
function web_principal()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/web/js/web.js');
    drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
    $datos['allowed'] = user_access('web_administrador');
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
        ->fields('u', array('uid', 'name'))
        ->condition('status', 1)
        ->condition('uid', $uids, 'IN')
        ->condition('uid', 26, '!=')
        ->orderBy('name', 'ASC')
        ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['usuarios'] = $usuarios;
    $result = render_template('php', 'web.index', $datos);
    return $result;
}

//***************************************************************
//------------------------ WEB PRINCIPAL  -----------------------
//***************************************************************

//***************************************************************
//------------------------- WEB DOMINIOS ------------------------
//***************************************************************
function web_dominios()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/web/js/dominios.js');
    $result = render_template('php', 'web.index_dominios');
    return $result;
}

//***************************************************************
//------------------------- WEB DOMINIOS  -----------------------
//***************************************************************


//***************************************************************
//------------------------ WEB CONSULTAS  -----------------------
//***************************************************************
function web_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new web_sys($tipo, $datos);
}

//***************************************************************
//------------------------ WEB CONSULTAS  -----------------------
//***************************************************************


//***************************************************************
//----------------------- WEB RENDER TEMPLATE  ------------------
//***************************************************************
function web_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}
//***************************************************************
//----------------------- WEB RENDER TEMPLATE  ------------------
//***************************************************************
