<?php
include drupal_get_path('module', 'partners') . '/lib/classes/taller/class.taller.php';
$GLOBALS['configuracionJs'] =
  array(
    'taller' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'render_template' => url('taller/render_template/'),
      'ruta_consultas' => url('taller/consultas/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
      'ruta_lista_contactos' => url('system/tools/lista_contactos/'),
      'ruta_auth_user' => url('system/tools/auth_user'),
      'ruta_vista_reporte' => url('centrodeservicio/vista/')
    ),
    'clientes' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_reporte_base' => url('clientes/reporte_base'),
      'render_template' => url('clientes/render_template/'),
      'ruta_capturar' => url('clientes/capturar/'),
      'ruta_vista_cliente' => url('clientes/vista_clientes/'),
      'ruta_vista_contacto' => url('clientes/vista_contactos/')
    )
  );

//***************************************************************
//------------------------ TALLER PRINCIPAL  --------------------
//***************************************************************
function taller_principal()
{
  global $ruta_lib, $user;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/taller/js/taller.js');
  drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  if ($user->uid == 26) {
    $datos['allow'] = false;
  } else {
    $datos['allow'] = true;
  }
  $role = user_role_load_by_name('Soporte');
  $query = 'SELECT ur.uid
      FROM {users_roles} AS ur
      WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();
  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $result = render_template('php', 'taller.index', $datos);
  return $result;
}

//***************************************************************
//------------------------ TALLER PRINCIPAL  --------------------
//***************************************************************


//***************************************************************
//--------------------- TALLER ADMINISTRADOR --------------------
//***************************************************************
function taller_admin()
{
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/taller/js/taller_admin.js');
  drupal_add_js($ruta_lib . 'plugin/js/bootstrap4-toggle.min.js');
  drupal_add_css($ruta_lib . 'plugin/css/bootstrap4-toggle.min.css');

  $role = user_role_load_by_name('Todos');
  $query = 'SELECT ur.uid
      FROM {users_roles} AS ur
      WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;

  if (user_has_role(user_role_load_by_name('Auxiliar')->rid) || user_has_role(user_role_load_by_name('Supervisor')->rid)) {
    $datos['limited'] = false;
  } else {
    $datos['limited'] = true;
  }

  $result = render_template('php', 'taller.index_admin', $datos);
  return $result;
}
//***************************************************************
//---------------------- TALLER ADMINISTRADOR -------------------
//***************************************************************


//***************************************************************
//----------------------- TALLER BUSCADOR  ----------------------
//***************************************************************
function taller_buscador()
{
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/taller/js/taller_buscador.js');
  $result = render_template('php', 'taller.index_buscador');
  return $result;
}

//***************************************************************
//----------------------- TALLER BUSCADOR  ----------------------
//***************************************************************


//***************************************************************
//---------------------- TALLER CONSULTAS  ----------------------
//***************************************************************
function taller_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $_POST = json_decode(file_get_contents('php://input'), 0);
  $datos = $_POST;
  new taller_sys($tipo, $datos);
}

//***************************************************************
//---------------------- TALLER CONSULTAS  ----------------------
//***************************************************************


//***************************************************************
//------------------- TALLER RENDER TEMPLATE  -------------------
//***************************************************************
function taller_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- TALLER RENDER TEMPLATE  -------------------
//***************************************************************


//***************************************************************
//------------------------- TALLER VISTA  -----------------------
//***************************************************************
function taller_vista($id_registro, $tipo = null, $type = null)
{
  new taller_sys('render_vista', array("id_registro" => $id_registro, "type" => $type, "tipo" => $tipo));
}
//***************************************************************
//------------------------- TALLER VISTA  -----------------------
//***************************************************************
