<?php
include drupal_get_path('module', 'partners') . '/lib/classes/servicios/class.servicios.php';
$GLOBALS['configuracionJs'] =
  array(
    'servicios' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
      'render_template' => url('servicios/render_template/'),
      'ruta_consultas' => url('servicios/consultas/'),
      'ruta_vista_reporte' => url('servicios/vista/'),
      'ruta_lista_contactos' => url('system/tools/lista_contactos/')
    ),
    'clientes' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_reporte_base' => url('clientes/reporte_base'),
      'render_template' => url('clientes/render_template/'),
      'ruta_capturar' => url('clientes/capturar/'),
      'ruta_vista_cliente' => url('clientes/vista_clientes/'),
      'ruta_vista_contacto' => url('clientes/vista_contactos/')
    ),
    'polizas' =>
    array(
      'ruta_consultas' => url('polizas/consultas/'),
    ),
  );

//***************************************************************
//------------------------ SERVICIOS PRINCIPAL  -----------------
//***************************************************************
function servicios_principal()
{
  global $ruta_lib, $user;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/servicios/js/servicios.js');
  drupal_add_js($ruta_lib . 'plugin/js/jquery.steps.js');
  drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  drupal_add_js($ruta_lib . 'plugin/js/eSign.js');
  drupal_add_js($ruta_lib . 'modulos/firma/firma.js');
  drupal_add_css($ruta_lib . 'plugin/css/eSign.css');
  drupal_add_css($ruta_lib . 'plugin/css/jquery.steps.css');
  $datos['user_email'] = $user->mail;
  $result = render_template('php', 'servicios.index', $datos);
  return $result;
}

//***************************************************************
//------------------------ SERVICIOS PRINCIPAL  -----------------
//***************************************************************


//***************************************************************
//------------------------ SERVICIOS ADMIN ----------------------
//***************************************************************
function servicios_admin()
{
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/servicios/js/servicios.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');

  $role = user_role_load_by_name('Todos');
  $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $result = render_template('php', 'servicios.index_admin', $datos);
  return $result;
}

//***************************************************************
//------------------------ SERVICIOS ADMIN ----------------------
//***************************************************************


//***************************************************************
//------------------- SERVICIOS RENDER TEMPLATE  ----------------
//***************************************************************
function servicios_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- SERVICIOS RENDER TEMPLATE  ----------------
//***************************************************************


//***************************************************************
//---------------------- SERVICIOS CONSULTAS  -------------------
//***************************************************************
function servicios_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $_POST = json_decode(file_get_contents('php://input'), 0);
  $datos = $_POST;
  new servicios_sys($tipo, $datos);
}

//***************************************************************
//---------------------- SERVICIOS CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------------- SERVICIOS VISTA   -------------------
//***************************************************************
function servicios_vista($id_servicio, $type = null)
{
  new servicios_sys('render_vista', array("id_servicio" => $id_servicio, "type" => $type));
}
//***************************************************************
//------------------------- SERVICIOS VISTA   -------------------
//***************************************************************

/**
 * Autorizar sericio
 * @return string
 */
function servicio_autorizar()
{
  try {
    global $ruta_lib;
    basic_includes();
    $query = drupal_get_query_parameters()['token'];
    $query = base64url_decode($query);
    $query = explode('~', $query);
    $token = $query[0];
    $email = $query[1];

    $query = db_select('partners_servicios', 'ps');
    $query->fields('ps', array('autorizado', 'token', 'id_servicio', 'autorizado_por', 'encuesta', 'autorizado_fecha', 'horas_totales', 'id_cliente', 'folio_poliza'));
    $query->leftJoin('field_data_field_nombre_completo', 'f', 'f.entity_id = ps.created_by');
    $query->addField('f', 'field_nombre_completo_value', 'nombre_tecnico');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
    $query->fields('pc', array('credito', 'tipo_clasificacion', 'nombre_cliente'));
    $query->condition('token', $token);
    $query = $query->execute();
    $row = $query->fetchAssoc();

    if ($row['id_servicio'] > 6399) {
      $folio = strtoupper($row['tipo_clasificacion']) . '-' . $row['id_servicio'];
    } else {
      # Conservar los folios anteriores con la misma serie.
      $folio = (($row['credito'] == 1) ? 'A' : 'B') . '-' . $row['id_servicio'];
    }

    setlocale(LC_TIME, "es_MX.UTF-8");
    $datos = array(
      'token' => $token,
      'email' => $email,
      'idServicio' => $row['id_servicio'],
      'folio' => $folio,
      'encuesta' => $row['encuesta'],
      'fecha' => strftime("%A %e de %B del %Y a las %R", strtotime($row['autorizado_fecha'])),
      'autorizado' => ($row['autorizado'] > 0),
      'cliente' => $row['nombre_cliente'],
      'tecnico' => $row['nombre_tecnico'],
      'detalle' => $row['detalle_servicio'],
    );

    if (!!(int)$row['autorizado']) {
      $datos += ['autorizadoPor' => $row['autorizado_por']];
    } else {
      db_update('partners_servicios')
        ->fields(array(
          'autorizado_por' => $email,
          'autorizado' => 1,
          'autorizado_fecha' => date('Y-m-d H:i:s')
        ))
        ->condition('id_servicio', $row['id_servicio'])
        ->execute();
    }

    return render_template('php', 'servicios.autorizado', $datos);
  } catch (\Exception $e) {
    echo $e->getMessage();
  }
}

/**
 * Enviar encuesta
 * @return string
 */
function servicio_encuesta()
{
  try {
    $_POST = json_decode(file_get_contents('php://input'), 0);

    (new servicios_sys('', true))->send_mail(
      'servicios.mail_encuesta',
      (array)$_POST,
      "encuesta de servicio {$_POST->folioServicio}",
      ['encuesta_servicio@pcpartners.com.mx' => 'Pc Partners - Encuesta de servicio'],
      ['roberto@pcpartners.com.mx']
    );

    db_update('partners_servicios')
      ->fields(array(
        'encuesta' => true
      ))
      ->condition('id_servicio', $_POST->idServicio)
      ->execute();

    echo json_encode(array("Encuesta enviada"));
  } catch (Exception $e) {
    echo $e->getMessage();
  }
}
