<?php
include drupal_get_path('module', 'partners') . '/lib/classes/renovaciones/class.renovaciones.php';
$GLOBALS['configuracionJs'] =
    array(
      'renovaciones' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('renovaciones/render_template/'),
            'ruta_consultas' => url('renovaciones/consultas/'),
            'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
            'ruta_lista_contactos' => url('system/tools/lista_contactos/')
        ),
      'clientes' =>
        array(
          'ruta_sys_tools' => url('system/tools/'),
          'ruta_reporte_base' => url('clientes/reporte_base'),
          'render_template' => url('clientes/render_template/'),
          'ruta_capturar' => url('clientes/capturar/'),
          'ruta_vista_cliente' => url('clientes/vista_clientes/'),
          'ruta_vista_contacto' => url('clientes/vista_contactos/')
        )
    );

//***************************************************************
//--------------------- RENOVACIONES PRINCIPAL  -----------------
//***************************************************************
function renovaciones_principal()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/renovaciones/js/renovaciones.js');
    drupal_add_js($ruta_lib . 'modulos/renovaciones/js/rrule.js');
    drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
    drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
        ->fields('u', array('uid', 'name'))
        ->condition('status', 1)
        ->condition('uid', $uids, 'IN')
        ->condition('uid', 26, '!=')
        ->orderBy('name', 'ASC')
        ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $taxonomy = [];
    $vid_c = taxonomy_vocabulary_machine_name_load("renovaciones_cctv")->vid;
    $terms_c = taxonomy_get_tree($vid_c);
    foreach ($terms_c as $key => $val) {
        $taxonomy[] = array("name" => $val->name, "tid" => $val->tid);
    }
    $vid_v = taxonomy_vocabulary_machine_name_load("renovaciones_ventas")->vid;
    $terms_v = taxonomy_get_tree($vid_v);
    foreach ($terms_v as $key => $val) {
        $taxonomy[] = array("name" => $val->name, "tid" => $val->tid);
    }

    $vid_w = taxonomy_vocabulary_machine_name_load("renovaciones_web")->vid;
    $terms_w = taxonomy_get_tree($vid_w);
    foreach ($terms_w as $key => $val) {
        $taxonomy[] = array("name" => $val->name, "tid" => $val->tid);
    }

    $vid_s = taxonomy_vocabulary_machine_name_load("renovaciones_soporte")->vid;
    $terms_s = taxonomy_get_tree($vid_s);
    foreach ($terms_s as $key => $val) {
        $taxonomy[] = array("name" => $val->name, "tid" => $val->tid);
    }

    $datos['usuarios'] = $usuarios;
    $datos['tipos_renovaciones'] = $taxonomy;
    $datos['allowed'] = user_access('renovaciones_administrador');
    $result = render_template('php', 'renovaciones.index', $datos);
    return $result;
}

//***************************************************************
//--------------------- RENOVACIONES PRINCIPAL  -----------------
//***************************************************************


//***************************************************************
//-------------------- RENOVACIONES CONSULTAS  ------------------
//***************************************************************
function renovaciones_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new renovaciones_sys($tipo, $datos);
}

//***************************************************************
//-------------------- RENOVACIONES CONSULTAS  ------------------
//***************************************************************


//***************************************************************
//------------------- RENOVACIONES RENDER TEMPLATE  -------------
//***************************************************************
function renovaciones_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}
//***************************************************************
//------------------- RENOVACIONES RENDER TEMPLATE  -------------
//***************************************************************
