<?php
include drupal_get_path('module', 'partners') . '/lib/classes/recibo/class.recibo.php';
$GLOBALS['configuracionJs'] =
  array(
    'recibo' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'render_template' => url('recibo/render_template/'),
      'ruta_consultas' => url('recibo/consultas/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/')
    ),
    'clientes' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_reporte_base' => url('clientes/reporte_base'),
      'render_template' => url('clientes/render_template/'),
      'ruta_capturar' => url('clientes/capturar/'),
      'ruta_vista_cliente' => url('clientes/vista_clientes/'),
      'ruta_vista_contacto' => url('clientes/vista_contactos/')
    )
  );

//***************************************************************
//------------------------ RECIBO PRINCIPAL  --------------------
//***************************************************************
function recibo_principal()
{

  global $ruta_lib, $user;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/recibo/js/recibo.js');
  drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  drupal_add_js($ruta_lib . 'modulos/user/js/responsiveslides.min.js');
  $role = user_role_load_by_name('Todos');
  $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $datos['user_mail'] = $user->mail;
  $datos['allowed'] = user_access('recibos_administrador') || user_access('recibos_auxiliar');
  $result = render_template('php', 'recibo.index', $datos);
  return $result;
}

//***************************************************************
//------------------------ RECIBO PRINCIPAL  --------------------
//***************************************************************

//***************************************************************
//------------------------- RECIBO REPORTE ----------------------
//***************************************************************
function recibo_reporte()
{
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/recibo/js/recibo_reporte.js');
  drupal_add_css($ruta_lib . 'plugin/css/partnersCalc.css');
  drupal_add_js($ruta_lib . 'plugin/js/partnersCalc.js');
  $result = render_template('php', 'recibo.index_reporte');
  return $result;
}

//***************************************************************
//------------------------ RECIBO PRINCIPAL  --------------------
//***************************************************************


//***************************************************************
//---------------------- RECIBO CONSULTAS  ----------------------
//***************************************************************
function recibo_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $_POST = json_decode(file_get_contents('php://input'), 0);
  $datos = $_POST;
  new recibo_sys($tipo, $datos);
}

//***************************************************************
//---------------------- RECIBO CONSULTAS  ----------------------
//***************************************************************


//***************************************************************
//------------------- RECIBO RENDER TEMPLATE  -------------------
//***************************************************************
function recibo_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- RECIBO RENDER TEMPLATE  -------------------
//***************************************************************


//***************************************************************
//-------------------------- RECIBO VISTA  ----------------------
//***************************************************************
function recibo_vista($id_recibo, $type = NULL)
{
  new recibo_sys('render_vista', array("id_recibo" => $id_recibo, "type" => $type));
}
//***************************************************************
//-------------------------- RECIBO VISTA  ----------------------
//***************************************************************
