<?php
include drupal_get_path('module', 'partners') . '/lib/classes/polizas/class.polizas.php';
include drupal_get_path('module', 'partners') . '/lib/classes/clientes/class.clientes.php';

$GLOBALS['configuracionJs'] =
  array(
    'polizas' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
      'render_template' => url('polizas/render_template/'),
      'ruta_consultas' => url('polizas/consultas/'),
      'ruta_vista_poliza' => url('polizas/vista/'),
      'ruta_lista_contactos' => url('system/tools/lista_contactos/'),
      'ruta_generar_reporte_servicios' => url('estado_paquete/generar_reporte/'),
    ),
    'clientes' =>
    array(
      'ruta_capturar' => url('clientes/capturar/'),
    )
  );

//***************************************************************
//------------------------ POLIZAS PRINCIPAL  --------------------
//***************************************************************
function polizas_principal()
{
  global $user;
  global $ruta_lib;
  // Si los paquetes solo los pueden ver los supervisores:
  //if (!user_access('polizas_administrador', $user)) {
  //  drupal_goto('/');
  //}
  basic_includes();
  //drupal_add_js(drupal_get_path('module', 'partners') . '/lib/modulos/polizas/js/polizas.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  drupal_add_js($ruta_lib . '/modulos/polizas/js/polizas.js');
  $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
  $role = user_role_load_by_name('Todos');
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $tipo_poliza = db_select('partners_paquetes_polizas', 'p')
    ->fields('p', array('tid', 'nombre'))
    ->orderBy('nombre', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $datos['allowed'] = user_access('polizas_general');
  $datos['tipo'] = $tipo_poliza;
  if (in_array('Supervisor', array_values($user->roles))) {
    $datos['is_admin'] = 1;
  } else {
    $datos['is_admin'] = 0;
  }
  $result = render_template('php', 'polizas.index', $datos);

  return $result;
}
//***************************************************************
//------------------------ POLIZAS PRINCIPAL  --------------------
//***************************************************************


function polizas_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $_POST = json_decode(file_get_contents('php://input'), 0);
  $datos = $_POST;
  new polizas_sys($tipo, $datos);
}


//***************************************************************
//------------------- POLIZAS RENDER TEMPLATE  -------------
//***************************************************************
function polizas_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- POLIZAS RENDER TEMPLATE  -------------
//***************************************************************



//***************************************************************
//------------------- POLIZAS ESTADO DE CUENTA  -------------
//***************************************************************
function poliza_estado_cuenta($data = null)
{
  basic_includes();

  global $ruta_lib;

  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  drupal_add_js($ruta_lib . 'modulos/polizas/js/polizas_estado.js');
  $envio = new stdClass;
  $envio->id_poliza = $_GET['token'];
  $envio->t = 1; // para que regrese los datos en vez de mostrarlos
  $tpl = new polizas_sys('procesar_token', $envio);
  $result = $tpl->procesar_token($envio);
  return render_template('php', 'polizas.index_estado_paquete', $result);
}

function generar_reporte_servicios()
{
  global $ruta_lib;

  $_POST = json_decode(file_get_contents('php://input'), 0);
  $datos = $_POST;
  new polizas_sys('generar_reporte_servicios', $datos);
}

//***************************************************************
//------------------- ---------------------- -----------------
//***************************************************************
