<?php
include drupal_get_path('module', 'partners') . '/lib/classes/pendientes/class.pendientes.php';
$GLOBALS['configuracionJs'] =
    array(
      'pendientes' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
            'render_template' => url('pendientes/render_template/'),
            'ruta_consultas' => url('pendientes/consultas/'),
            'ruta_vista_pendiente' => url('pendientes/vista/'),
        ),
      'clientes' =>
        array(
          'ruta_sys_tools' => url('system/tools/'),
          'ruta_reporte_base' => url('clientes/reporte_base'),
          'render_template' => url('clientes/render_template/'),
          'ruta_capturar' => url('clientes/capturar/'),
          'ruta_vista_cliente' => url('clientes/vista_clientes/'),
          'ruta_vista_contacto' => url('clientes/vista_contactos/')
        )
    );

//***************************************************************
//----------------------- PENDIENTES PRINCIPAL  -----------------
//***************************************************************
function pendientes_principal()
{
    global $ruta_lib, $user;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/pendientes/js/pendientes.js');
    drupal_add_js($ruta_lib . 'modulos/pendientes/js/calendar.js');
    drupal_add_js($ruta_lib . 'modulos/pendientes/js/es-MX.js');
    drupal_add_js($ruta_lib . 'plugin/js/underscore-min.js');
    drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
    drupal_add_css($ruta_lib . 'modulos/pendientes/css/calendar.css');
    $datos = [];

    $areas = db_select('partners_areas', 'pa')
        ->fields('pa')
        ->execute()->fetchAll(PDO::FETCH_ASSOC);

    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
        ->fields('u', array('uid', 'name'))
        ->condition('status', 1)
        ->condition('uid', $uids, 'IN')
        ->condition('uid', 26, '!=')
        ->orderBy('name', 'ASC')
        ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['areas'] = $areas;
    $datos['usuarios'] = $usuarios;
    $datos['user_uid'] = $user->uid;
    if(strpos($_SERVER['HTTP_USER_AGENT'], 'Android') !== false || strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone') !== false) {
      $datos['mobile'] = true;
    } else {
      $datos['mobile'] = false;
    }
    $result = render_template('php', 'pendientes.index', $datos);
    return $result;
}

//***************************************************************
//----------------------- PENDIENTES PRINCIPAL  -----------------
//***************************************************************


//***************************************************************
//---------------------- PENDIENTES CAPTURAR  -------------------
//***************************************************************
function pendientes_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    $go = new pendientes_sys($tipo, $datos);
}

//***************************************************************
//---------------------- PENDIENTES CAPTURAR  -------------------
//***************************************************************

//***************************************************************
//---------------------- PENDIENTES VISTA   ---------------------
//***************************************************************
function pendientes_vista($id_pendiente = null)
{
    $datos = pendientes_sys::vista_pendiente($id_pendiente);

    echo render_template('php', 'pendientes.vista_pendiente', $datos);
}

//***************************************************************
//---------------------- PENDIENTES VISTA   ---------------------
//***************************************************************


//***************************************************************
//------------------ PENDIENTES RENDER TEMPLATE  ----------------
//***************************************************************
function pendientes_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}

//***************************************************************
//------------------- PENDIENTES RENDER TEMPLATE  ---------------
//***************************************************************

