<?php
include drupal_get_path('module', 'partners') . '/lib/classes/mercancia/class.mercancia.php';
$GLOBALS['configuracionJs'] =
    array('mercancia' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
            'render_template' => url('mercancia/render_template/'),
            'ruta_consultas' => url('mercancia/consultas/'),
            'ruta_vista_salida' => url('mercancia/vista/')
        ),
      'clientes' =>
        array(
          'ruta_sys_tools' => url('system/tools/'),
          'ruta_reporte_base' => url('clientes/reporte_base'),
          'render_template' => url('clientes/render_template/'),
          'ruta_capturar' => url('clientes/capturar/'),
          'ruta_vista_cliente' => url('clientes/vista_clientes/'),
          'ruta_vista_contacto' => url('clientes/vista_contactos/')
        )
    );

//***************************************************************
//------------------------ MERCANCIA PRINCIPAL  -----------------
//***************************************************************
function mercancia_principal()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/mercancia/js/mercancia.js');
    drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
        ->fields('u', array('uid', 'name'))
        ->condition('status', 1)
        ->condition('uid', $uids, 'IN')
        ->condition('uid', 26, '!=')
        ->orderBy('name', 'ASC')
        ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['usuarios'] = $usuarios;
    $result = render_template('php', 'mercancia.index', $datos);
    return $result;
}

//***************************************************************
//------------------------ MERCANCIA PRINCIPAL  -----------------
//***************************************************************


//***************************************************************
//---------------------- MERCANCIA CONSULTAS  -------------------
//***************************************************************
function mercancia_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new mercancia_sys($tipo, $datos);
}

//***************************************************************
//---------------------- MERCANCIA CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------- MERCANCIA RENDER TEMPLATE  ----------------
//***************************************************************
function mercancia_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}

//***************************************************************
//------------------- MERCANCIA RENDER TEMPLATE  ----------------
//***************************************************************


//***************************************************************
//----------------------- SALIDA MERCANCIA VISTA  ---------------
//***************************************************************
function salida_mercancia_vista($type = null, $id_salida)
{
    new mercancia_sys('render_vista', array("id_salida" => $id_salida, "type" => $type));
}
//***************************************************************
//----------------------- SALIDA MERCANCIA VISTA  ---------------
//***************************************************************
