<?php
include drupal_get_path('module', 'partners') . '/lib/classes/user/class.user.php';
$GLOBALS['configuracionJs'] =
    array('user' =>
        array(
            'ruta_bg' => url('sites/default/files/bg/'),
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('home/render_template/'),
            'ruta_consultas' => url('home/consultas/'),
            'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
            'ruta_lista_contactos' => url('system/tools/lista_contactos/')
        )
    );

//***************************************************************
//------------------------ CLIENTES PRINCIPAL  ------------------
//***************************************************************
function user_home()
{
    global $ruta_lib, $user;
    setlocale(LC_TIME, "es_MX");
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/user/js/user.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/user/css/user.css');
    drupal_add_js($ruta_lib . 'modulos/user/js/responsiveslides.min.js');
    drupal_add_css($ruta_lib.'modulos/user/css/rslides.css');
    $check_nip = db_select('partners_users_auth', 'pua')
        ->fields('pua', array('nip'))
        ->condition('uid', $user->uid)
        ->execute()->fetchField();
    $data['user_name'] = user_load($user->uid)->field_nombre_completo['und'][0]['value'];
    $data['user_puesto'] = user_load($user->uid)->field_puesto['und'][0]['value'];
    $data['check_nip'] = $check_nip;
    $blocks = block_get_blocks_by_region('region_intranet');
    $data['region_intranet'] = render($blocks);
    $data['user_email'] = $user->mail;

    // Es admin para clientes
    if(user_access('clientes_administrador')){
      $data['user_admin_clientes'] = true;
      $get_clientes_eliminar = db_select('partners_clientes', 'pc');
      $get_clientes_eliminar->fields('pc', array('nombre_cliente', 'id_cliente', 'tipo_cliente'));
      $get_clientes_eliminar->condition('solicitar_cancelacion', 1);
      $get_clientes_eliminar->condition('cancelado', 0);
      $clientes_eliminar = $get_clientes_eliminar->execute()->fetchAll(PDO::FETCH_ASSOC);
      $data['clientes_eliminar'] = $clientes_eliminar;

    }else{
      $data['user_admin_clientes'] = false;
    }

    // Pendientes User
    $c = new user_sys('get_pendientes_user', json_encode(1));
    $pendientes = $c->get_pendientes_user($user->uid);
    $data['pendientes'] = $pendientes;
    $result = render_template('php', 'user.index', $data);

    return $result;
}

//***************************************************************
//------------------------ CLIENTES PRINCIPAL  ------------------
//***************************************************************


//***************************************************************
//------------------------- HOME CONSULTAS  ---------------------
//***************************************************************
function home_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new user_sys($tipo, $datos);
}

//***************************************************************
//------------------------- HOME CONSULTAS  ---------------------
//***************************************************************


//***************************************************************
//---------------------- HOME RENDER TEMPLATE  ------------------
//***************************************************************
function home_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}

//***************************************************************
//---------------------- HOME RENDER TEMPLATE  ------------------
//***************************************************************


//***************************************************************
//--------------- CONFIRMATION PAYU PAYMENT PAYOUT --------------
//***************************************************************
/**
 * PayU: una vez se completa una transacción, envia los detalles por POST a esta url
 * @throws Exception
 * @deprecated Ya no se usa PayU
 */
function website_payout_payu_confirmation()
{
    if (!empty($_POST)) {
        // Capturar los detalles de la transacción sin importar su estado.
        $datos = $_POST;
        db_insert('partners_payu_transactions')
            ->fields(array(
                'transaction_id' => $datos['transaction_id'],
                'state_pol' => $datos['state_pol'],
                'response_message_pol' => $datos['response_message_pol'],
                'response_code_pol' => $datos['response_message_pol'],
                'payment_method_id' => $datos['payment_method_id'],
                'payment_method_type' => $datos['payment_method_type'],
                'payment_method_name' => $datos['payment_method_name'],
                'reference_sale' => $datos['reference_sale'],
                'currency' => $datos['currency'],
                'date_' => $datos['date'],
                'description' => $datos['description'],
                'nickname_buyer' => $datos['nickname_buyer'],
                'email_buyer' => $datos['email_buyer'],
            ))
            ->execute();

        // Solamente cuando la transaccion sea aprovada (state_pol = 4) se haran movimientos en nuestra base de datos.
        if ($datos['state_pol'] == 4) {

            $data['id_orden'] = $datos['reference_sale'];
            $data['payment_method_name'] = $datos['payment_method_name'];
            $m_type = $datos['payment_method_type'];
            $method = "";
            switch ($m_type) {
                case 2:
                    $method = "Tarjeta de Crédito ";
                    break;
                case 6:
                    $method = "Tarjeta de débito ";
                    break;
                case 7:
                    $method = "Pago en Efectivo ";
                    break;
            }
            $data['metodo_pago'] = $method . ' ' . $datos['payment_method_name'];
            $data['email_buyer'] = $datos['email_buyer'];
            new user_sys('process_payu_payment_payout', $data);

        }
    } else {
        echo "No POST data received";
    }
}

//***************************************************************
//--------------- CONFIRMATION PAYU PAYMENT PAYOUT --------------
//***************************************************************


//***************************************************************
//--------------- PROCESS PAYPAL PAYMENT PAYOUT  ----------------
//***************************************************************
function website_payout_paypal_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/user/js/payout_paypal_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
    if ($_GET['success'] == "true") {
        $data['success'] = true;
    } else {
        $data['success'] = false;
    }
    $result = render_template('php', 'user.index_payout_paypal_process', $data);
    return $result;
}

//***************************************************************
//--------------- PROCESS PAYPAL PAYMENT PAYOUT  ----------------
//***************************************************************


//***************************************************************
//----------------- PROCESS PAYU PAYMENT PAYOUT -----------------
//***************************************************************

/**
 * @return string|void
 * @deprecated Ya no se usa PayU
 */
function website_payout_payu_process()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/user/js/payout_payu_process.js');
    drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
    drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_payu.css');

    $data = [];
    if (empty($_GET['transactionState'])) {
        $data['successTransaccion'] = false;
    } else {
        $ApiKey = "4Vj8eK4rloUd272L48hsrarnUA";
        $merchant_id = $_REQUEST['merchantId'];
        $referenceCode = $_REQUEST['referenceCode'];
        $TX_VALUE = $_REQUEST['TX_VALUE'];
        $New_value = number_format($TX_VALUE, 1, '.', '');
        $currency = $_REQUEST['currency'];
        $transactionState = $_REQUEST['transactionState'];
        $firma_cadena = "$ApiKey~$merchant_id~$referenceCode~$New_value~$currency~$transactionState";
        $firmacreada = md5($firma_cadena);
        $firma = $_REQUEST['signature'];
        $data['reference_pol'] = $_REQUEST['reference_pol'];
        $data['extra1'] = $_REQUEST['description'];
        $data['lapPaymentMethod'] = $_REQUEST['lapPaymentMethod'];
        $data['transactionId'] = $_REQUEST['transactionId'];
        $data['TX_VALUE'] = $TX_VALUE;
        $data['currency'] = $currency;
        $data['referenceCode'] = $referenceCode;
        $data['isApproved'] = false;
        if ($_REQUEST['transactionState'] == 4) {
            $data['estadoTx'] = "Transacción aprobada";
            $data['isApproved'] = true;
        } else if ($_REQUEST['transactionState'] == 6) {
            $data['estadoTx'] = "Transacción rechazada";
        } else if ($_REQUEST['transactionState'] == 104) {
            $data['estadoTx'] = "Error";
        } else if ($_REQUEST['transactionState'] == 7) {
            $data['estadoTx'] = "Transacción pendiente";
        } else {
            $data['estadoTx'] = $_REQUEST['mensaje'];
        }


        if (strtoupper($firma) == strtoupper($firmacreada)) {
            $data['successTransaccion'] = true;
        } else {
            $data['successTransaccion'] = false;
        }
    }

    $result = render_template('php', 'user.index_payout_payu_process', $data);
    return $result;
}

//***************************************************************
//----------------- PROCESS PAYU PAYMENT PAYOUT -----------------
//***************************************************************
