<?php
include drupal_get_path('module', 'partners') . '/lib/classes/facturas_web/class.facturas_web.php';
$GLOBALS['configuracionJs'] =
    array('facturas_web' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('facturas_web/render_template/'),
            'ruta_consultas' => url('facturas_web/consultas/'),
            'ruta_enviar_con_servicio' => url('facturas_web/enviar_factura_servicio')
        )
    );

//***************************************************************
//-------------------- FACTURAS WEB PRINCIPAL  ------------------
//***************************************************************
function facturas_web_principal()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/facturas_web/js/facturas_web.js');
    $result = render_template('php', 'facturas_web.index');
    return $result;
}

//***************************************************************
//-------------------- FACTURAS WEB PRINCIPAL  ------------------
//***************************************************************


//***************************************************************
//------------------- FACTURAS WEB CONSULTAS  -------------------
//***************************************************************
function facturas_web_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new facturas_web_sys($tipo, $datos);
}

//***************************************************************
//------------------- FACTURAS WEB CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------- FACTURAS WEB RENDER TEMPLATE  -------------
//***************************************************************
function facturas_web_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}
//***************************************************************
//------------------- FACTURAS WEB RENDER TEMPLATE  -------------
//***************************************************************


//***************************************************************
//-------- FACTURAS WEB ENVIAR FACTURA CON SERVICIO ADJUNTO  ----
//***************************************************************
function facturas_web_enviar_factura_servicio()
{
    if ($_FILES['file'] == NULL) {
        echo json_encode(array(
            "status" => "error",
            "message" => "No se ha seleccionado ningún archivo."
        ));
    } else {
        // Guardar el archivo temporalmente en el servidor para después meterlo en el zip.
        $ruta_pdf = HOME_SERVER . 'facturas_tmp/' . $_FILES['file']['name'];
        move_uploaded_file($_FILES['file']['tmp_name'], $ruta_pdf);

        // Abrir zip
        $zip = new ZipArchive;
        if ($zip->open(HOME_SERVER . 'facturas/' . $_POST['factura'] . '.zip') === TRUE) {

            // Si hay archivos a eliminar, eliminarlos mediante su index.
            if ($_POST['deleted_files'] !== '') {
                $files_i = explode(',', $_POST['deleted_files']);
                for ($i = 0; $i < count($files_i); $i++) {
                    $zip->deleteIndex($files_i[$i]);
                }
            }

            // Agregar el .pdf del servicio al zip y después cerrar el zip.
            $zip->addFile($ruta_pdf, $_FILES['file']['name']);


            $zip->close();


            // Una vez que se allá agregado el pdf del servicio al zip, se elimina este pdf que solo se necesitaba
            // temporalmente
            unlink($ruta_pdf);


            // Se realiza proceso de envió de correos.
            $data['emails'] = $_POST['emails'];
            $data['ruta'] = HOME_SERVER . 'facturas/' . $_POST['factura'] . '.zip';
            $data['num_factura'] = substr($_POST['factura'], -5);
            $data['factura_name'] = $_POST['factura'];
            facturas_web_sys::enviar_correos_factura($data);
        } else {
            echo json_encode(array(
                "status" => "error",
                "message" => "Ocurrio un error al tratar de abrir el zip de la factura."
            ));
        }
    }
}

//***************************************************************
//-------- FACTURAS WEB ENVIAR FACTURA CON SERVICIO ADJUNTO  ----
//***************************************************************