<?php
include drupal_get_path('module', 'partners') . '/lib/classes/cotizaciones/class.cotizaciones.php';
include drupal_get_path('module', 'partners') . '/lib/classes/servicios/class.servicios.php';
$GLOBALS['configuracionJs'] =
  array(
    'cotizaciones' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'render_template' => url('cotizaciones/render_template/'),
      'ruta_consultas' => url('cotizaciones/consultas/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
      'ruta_lista_contactos' => url('system/tools/lista_contactos/')
    ),
    'clientes' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'ruta_reporte_base' => url('clientes/reporte_base'),
      'render_template' => url('clientes/render_template/'),
      'ruta_capturar' => url('clientes/capturar/'),
      'ruta_vista_cliente' => url('clientes/vista_clientes/'),
      'ruta_vista_contacto' => url('clientes/vista_contactos/')
    )
  );

//***************************************************************
//-------------------- COTIZACIONES PRINCIPAL  ------------------
//***************************************************************
function cotizaciones_principal()
{

  global $ruta_lib, $user;
  basic_includes();

  drupal_add_js($ruta_lib . 'plugin/js/datatables.min.js');
  drupal_add_js($ruta_lib . 'plugin/js/datetime-moment.js');
  drupal_add_js($ruta_lib . 'modulos/clientes/js/reclasificar.js');
  drupal_add_js($ruta_lib . 'modulos/correo/correo.js');
  drupal_add_js($ruta_lib . 'modulos/cotizaciones/js/cotizaciones.js');

  drupal_add_css($ruta_lib . 'plugin/css/datatables.min.css');
  $datos['allowed'] = user_access('cotizaciones_administrador');
  $datos['allowed_cctv'] = in_array("CCTV", user_load($user->uid)->roles);
  $role = user_role_load_by_name('Todos');
  $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $result = render_template('php', 'cotizaciones.index', $datos);
  return $result;
}

//***************************************************************
//-------------------- COTIZACIONES PRINCIPAL  ------------------
//***************************************************************


//***************************************************************
//------------------- COTIZACIONES CONSULTAS  -------------------
//***************************************************************
function cotizaciones_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $datos = [];
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_FILES)) {
      // Cuando se envian archivos, normalmente se quiere enviar otra
      // información, por ello en JS se crea un FormData y ahí en ese objeto
      // se pasa la información necesaria, entonces aquí se modifica la forma
      // enla que se recibe la información.
      $datos['data'] = $_POST;
      $datos['files'] = $_FILES;
    } else {
      $datos = json_decode(file_get_contents('php://input'), 0);
    }
  }
  new cotizaciones_sys($tipo, $datos);
}

//***************************************************************
//------------------- COTIZACIONES CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------- COTIZACIONES RENDER TEMPLATE  -------------
//***************************************************************
function cotizaciones_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- COTIZACIONES RENDER TEMPLATE  -------------
//***************************************************************

//***************************************************************
//----------------------- COTIZACIONES VISTA  -------------------
//***************************************************************
function cotizaciones_vista($id_cotizacion, $type = NULL)
{
  new cotizaciones_sys('render_vista', array("id_cotizacion" => $id_cotizacion, "type" => $type));
}
//***************************************************************
//----------------------- COTIZACIONES VISTA  -------------------
//***************************************************************

function datos_facturacion()
{
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/cotizaciones/js/datos_facturacion.js');
  return render_template('php', 'cotizaciones.datos_facturacion');
}

function datos_facturacion_enviar()
{
  $RFC_FISICA = "/^[A-Z]{4}[0-9]{6}[A-Z0-9]{3}$/";
  $RFC_MORAL = "/^[A-Z]{3}[0-9]{6}[A-Z0-9]{3}$/";
  $CORREO = "/^[^\s@]+@[^\s@]+\.[^\s@]+$/i";
  $TELEFONO = "/^[0-9]{10}$/";
  try {
    $data = $_POST;
    if ($data['persona'] != 'fisica' && $data['persona'] != 'moral') {
      throw new Exception("Debes seleccionar un tipo de persona");
    }
    if (strlen($data['nombre']) <= 0) {
      throw new Exception("Debes ingresar la razón social");
    }
    switch ($data['persona']) {
      case 'fisica':
        if (!preg_match($RFC_FISICA, strtoupper($data['rfc']))) {
          throw new Exception("El RFC para persona física debe ser [A-Z]{4}[0-9]{6}[A-Z0-9]{3}");
        }
        break;
      case 'moral':
        if (!preg_match($RFC_MORAL, strtoupper($data['rfc']))) {
          throw new Exception("El RFC para persona moral debe ser [A-Z]{3}[0-9]{6}[A-Z0-9]{3}");
        }
        break;
    }
    if (strlen($data['calle']) <= 0) {
      throw new Exception("Debes ingresar la calle");
    }
    if (strlen($data['numExt']) <= 0) {
      throw new Exception("Debes ingresar el número exterior");
    }
    if (strlen($data['colonia']) <= 0) {
      throw new Exception("Debes ingresar la colonia");
    }
    if (strlen($data['ciudad']) <= 0) {
      throw new Exception("Debes ingresar la ciudad");
    }
    if (strlen($data['cp']) <= 0) {
      throw new Exception("Debes ingresar el códgo postal");
    }
    if (strlen($data['formaPago']) <= 0) {
      throw new Exception("Debes ingresar una forma de pago");
    }
    if (strlen($data['usoCFDI']) <= 0) {
      throw new Exception("Debes ingresar el uso del CFDI");
    }
    if (!preg_match($CORREO, $data['correo'])) {
      throw new Exception("El correo debe tener un formato válido");
    }
    if (!preg_match($TELEFONO, $data['telefono'])) {
      throw new Exception("El teléfono debe tener un formato válido");
    }

    $data['rfc'] = strtoupper($data['rfc']);

    (new servicios_sys('', true))->send_mail(
      'cotizaciones.datos_facturacion_correo',
      (array) $data,
      "Info facturación para " . $data['nombre'],
      ['datos_facturacion@pcpartners.com.mx' => 'Pc Partners - Datos de facturación'],
      ['facturacion@pcpartners.com.mx', 'ventas@pcpartners.com.mx']
    );

    echo json_encode([
      "message" => "Ok"
    ]);
  } catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
      "message" => $e->getMessage()
    ]);
  }
}