<?php
include drupal_get_path('module', 'partners') . '/lib/classes/cobranza/class.cobranza.php';
$GLOBALS['configuracionJs'] =
    array('cobranza' =>
        array(
            'ruta_sys_tools' => url('system/tools/'),
            'render_template' => url('cobranza/render_template/'),
            'ruta_consultas' => url('cobranza/consultas/'),
            'ruta_enviar_con_servicio' => url('cobranza/enviar_factura_servicio'),
            'ruta_get_file_url' => url('facturacion/get_file_url'),
            'ruta_facturacion_process_estado_cuenta' => url('facturacion/process_estado_cuenta'),
            'ruta_facturacion_process_file_estado_cuenta' => url('facturacion/process_file_estado_cuenta'),
            'ruta_facturacion_get_file_estado_cuenta' => url('facturacion/get_file_estado_cuenta'),
            'ruta_vista_cliente_cobranza' => url('cobranza/vista_clientes'),
        )
    );

//***************************************************************
//------------------------ COBRANZA PRINCIPAL  ------------------
//***************************************************************



if(isset($_REQUEST['codigo']) || strpos($_SERVER['REQUEST_URI'], 'vista_clientes') !== false){
  $id = explode('/', $_SERVER['REQUEST_URI']);
  $c = $_POST['codigo'] != null ? $_POST['codigo'] : end($id);
  echo cobranza_sys::vista_cliente($c);

  ////echo cobranza_vista_clientes($_POST['codigo']);
  die();

}
function cobranza_principal()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza.js');
    $result = render_template('php', 'cobranza.index');
    return $result;
}

//***************************************************************
//------------------------ COBRANZA PRINCIPAL  ------------------
//***************************************************************

//***************************************************************
//----------------------- COBRANZA PRINCIPAL 2 ------------------
//***************************************************************
function cobranza_principal_2()
{

    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_2.js');
    $result = render_template('php', 'cobranza.index_2');
    return $result;
}

//***************************************************************
//----------------------- COBRANZA PRINCIPAL 2 ------------------
//***************************************************************

//***************************************************************
//-------------- COBRANZA RECIBO ELECTRONICO DE PAGO ------------
//***************************************************************
function cobranza_rep()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_rep.js');
    $result = render_template('php', 'cobranza.index_rep');
    return $result;
}
//***************************************************************
//-------------- COBRANZA RECIBO ELECTRONICO DE PAGO ------------
//***************************************************************


//***************************************************************
//-------- COBRANZA ENVIAR FACTURA CON SERVICIO ADJUNTO  --------
//***************************************************************
function cobranza_enviar_factura_servicio()
{
    if ($_FILES['file'] == NULL) {
        echo json_encode(array(
            "status" => "error",
            "message" => "No se ha seleccionado ningún archivo."
        ));
    } else {
        // Guardar el archivo temporalmente en el servidor para después meterlo en el zip.
        $ruta_pdf = HOME_SERVER . 'facturas_tmp/' . $_FILES['file']['name'];
        move_uploaded_file($_FILES['file']['tmp_name'], $ruta_pdf);

        // Abrir zip
        $zip = new ZipArchive;
        if ($zip->open(HOME_SERVER . 'facturas/' . $_POST['factura'] . '.zip') === TRUE) {

            // Si hay archivos a eliminar, eliminarlos mediante su index.
            if ($_POST['deleted_files'] !== '') {
                $files_i = explode(',', $_POST['deleted_files']);
                for ($i = 0; $i < count($files_i); $i++) {
                    $zip->deleteIndex($files_i[$i]);
                }
            }

            // Agregar el .pdf del servicio al zip y después cerrar el zip.
            $zip->addFile($ruta_pdf, $_FILES['file']['name']);

            $zip->close();

            // Una vez que se allá agregado el pdf del servicio al zip, se elimina este pdf que solo se necesitaba
            // temporalmente
            unlink($ruta_pdf);


            // Se realiza proceso de envió de correos.
            $data['emails'] = $_POST['emails'];
            $data['ruta'] = HOME_SERVER . 'facturas/' . $_POST['factura'] . '.zip';
            $data['num_factura'] = substr($_POST['factura'], -5);
            $data['factura_name'] = $_POST['factura'];
          $data['conTarjeta'] = $_POST['conTarjeta'];
            cobranza_sys::enviar_correos_factura($data);
        } else {
            echo json_encode(array(
                "status" => "error",
                "message" => "Ocurrio un error al tratar de abrir el zip de la factura."
            ));
        }
    }
}

//***************************************************************
//-------- COBRANZA ENVIAR FACTURA CON SERVICIO ADJUNTO  --------
//***************************************************************

//***************************************************************
//---------------------- COBRANZA CONSULTAS  -------------------
//***************************************************************

function cobranza_consultas($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    new cobranza_sys($tipo, $datos);
}

//***************************************************************
//---------------------- COBRANZA CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------- COBRANZA RENDER TEMPLATE  -----------------
//***************************************************************
function cobranza_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}

//***************************************************************
//------------------- COBRANZA RENDER TEMPLATE  -----------------
//***************************************************************


//***************************************************************
//------------------ COBRANZA PROCESAR DESCARGA -----------------
//***************************************************************
function cobranza_procesar_descarga()
{
    $token = false;
    if (isset($_GET['token']) and !empty($_GET['token'])) {
        $data['success'] = true;
        $token = encrypt_decrypt('decrypt', $_GET['token']);
    } else {
        $data['success'] = false;
    }

    if ($token != false) {
        // Si existe el token, procesar los diferentes escenarios
        $datos = explode('~', $token);
        $type = $datos[0];

        // El tipo de archivo a descargar es PDF de la factura, entonces solo mostrar directamente el pdf.
        if ($type == 1) {
            header("Content-type: application/pdf");
            new cobranza_sys('download_cobranza_file', array("token" => $_GET['token']));
        } else if ($type == 2) {
            // El tipo de archivo a descargar es el XML de la factura, entonces mostrar la página y forzar la descarga del XML.
            global $ruta_lib;
            basic_includes();
            drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
            drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
            drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_descarga.js');

            $result = render_template('php', 'cobranza.index_descargas', $data);
            return $result;
        } else if ($type == 3) {
            // El tipo de archivo a descargar es PDF del reporte de servicio, verificar si es solo un servicio entonces
            // mostrar directamente el pdf, y si son varios servicios, mostrar la página para que el cliente abra el servicio que quiera.

            # $datos[2] = Cantidad
            if ($datos[2] > 1) {
                // Son varios archivos, mostrar la página para descargarlos
                global $ruta_lib;
                basic_includes();
                drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
                drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
                drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_descarga.js');

                $result = render_template('php', 'cobranza.index_descargas', $data);
                return $result;
            } else {
                // Es uno solo, mostrar directamente el pdf.
                new cobranza_sys('download_cobranza_file', array("token" => $_GET['token']));

            }
        } else if ($type == 4) {
            // El tipo de archivo a descargar es PDF del reporte de centro de Servicio, verificar si es solo un servicio entonces
            // mostrar directamente el pdf, y si son varios reportes, mostrar la página para que el cliente abra el reporte que quiera.

            # $datos[2] = Cantidad
            if ($datos[2] > 1) {
                // Son varios archivos, mostrar la página para descargarlos.
                global $ruta_lib;
                basic_includes();
                drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
                drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
                drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_descarga.js');

                $result = render_template('php', 'cobranza.index_descargas', $data);
                return $result;
            } else {
                // Es uno solo, mostrar directamente el pdf.
                new cobranza_sys('download_cobranza_file', array("token" => $_GET['token']));

            }

        }

    } else {
        // No existe el token, regresar la pantalla de error.

        global $ruta_lib;
        basic_includes();
        drupal_add_js($ruta_lib . 'modulos/user/js/parallax-background.min.js');
        drupal_add_css($ruta_lib . 'modulos/website/css/facturacion_paypal.css');
        drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_descarga.js');

        $result = render_template('php', 'cobranza.index_descargas', $data);
        return $result;
    }
}

//***************************************************************
//------------------ COBRANZA PROCESAR DESCARGA -----------------
//***************************************************************

//***************************************************************
//--------------------- COBRANZA GET FILE URL -------------------
//***************************************************************
/**
 * Se manda aquí el token para después desencriptarlo, y después se procede a descargar el archivo.
 */
function cobranza_get_file_url()
{
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $token = $_POST;
    $data['token'] = $token;
    new cobranza_sys('proccess_solicitud_archivo', $data);
}

//***************************************************************
//--------------------- COBRANZA GET FILE URL -------------------
//***************************************************************

//***************************************************************
//------------------ COBRANZA PROCESAR DESCARGA -----------------
//***************************************************************
/**
 * Si termina aqui, es porque es seguro que el archivo si existe, entonces solo forzar la descarga
 */
function cobranza_download_file()
{
    $data['token'] = $_GET['token'];
    new cobranza_sys('download_cobranza_file', $data);
}

//***************************************************************
//------------------ COBRANZA PROCESAR DESCARGA -----------------
//***************************************************************


//***************************************************************
//------------------- COBRANZA ESTADO CUENTA --------------------
//***************************************************************
/**
 * Genera la vista del estado de cuenta de los clientes, en base a un token el cual contiene el RFC del cliente
 */
function cobranza_estado_cuenta()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/cobranza/js/cobranza_estado_cuenta.js');

    // Validar que el usuario tenga permiso de supervisor para poder mostrar el botón de enviar estado de cuenta.
    $data['allow'] = false;
    if (user_access('cobranza_administrador')) {
        $data['allow'] = true;
    }
    $result = render_template('php', 'cobranza.index_estado_cuenta', $data);
    return $result;
}

//***************************************************************
//------------------- COBRANZA ESTADO CUENTA --------------------
//***************************************************************


//***************************************************************
//----------- COBRANZA PROCESAR ESTADO CUENTA CLIENTE -----------
//***************************************************************
/**
 * Genera la vista del estado de cuenta de los clientes, en base a un token el cual contiene el RFC del cliente
 */
function facturacion_process_estado_cuenta()
{
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $token = $_POST;
    $data['token'] = $token;
    new cobranza_sys('cobranza_process_estado_cuenta', $data);
}

//***************************************************************
//----------- COBRANZA PROCESAR ESTADO CUENTA CLIENTE -----------
//***************************************************************


//***************************************************************
//---------- COBRANZA DESCARGAR ESTADO CUENTA CLIENTE -----------
//***************************************************************
/**
 * Recibe el nombre del archivo, para posteriormente regresar el archivo a descargar
 * @param $file
 */
function facturacion_get_file_estado_cuenta()
{
    $data['file'] = $_GET['file'];
    new cobranza_sys('get_file_estado_cuenta', $data);

}

//***************************************************************
//---------- COBRANZA DESCARGAR ESTADO CUENTA CLIENTE -----------
//***************************************************************

//***************************************************************
//---------- COBRANZA DESCARGAR ESTADO CUENTA CLIENTE -----------
//***************************************************************
/**
 * Recibe los datos del estado de cuenta a generar
 */
function facturacion_process_file_estado_cuenta()
{
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $data = $_POST;
    new cobranza_sys('descargar_estado_cuenta', $data);

}
//***************************************************************
//---------- COBRANZA DESCARGAR ESTADO CUENTA CLIENTE -----------
//***************************************************************



function cobranza_vista_clientes($id_cliente)
{
    $datos = cobranza_sys::vista_cliente($id_cliente);
    // esta es solo la vista para los clientes, y dentro  cambian campos
    // dependiendo del tipo_negocio del cliente
    // Habrá más vistas para cada tipo_cliente

    return $datos;
}

