<?php
include drupal_get_path('module', 'partners') . '/lib/classes/clientes/class.clientes.php';
include drupal_get_path('module', 'partners') . '/lib/classes/clientes/class.reporte_clientes.php';
$GLOBALS['configuracionJs'] =
    array('clientes' =>
      array(
        'ruta_sys_tools' => url('system/tools/'),
        'ruta_reporte_base' => url('clientes/reporte_base'),
        'render_template' => url('clientes/render_template/'),
        'ruta_capturar' => url('clientes/capturar/'),
        'ruta_vista_cliente' => url('clientes/vista_clientes/'),
        'ruta_vista_contacto' => url('clientes/vista_contactos/')
      )
    );

//***************************************************************
//------------------------ CLIENTES PRINCIPAL  ------------------
//***************************************************************
function clientes_principal()
{
    global $ruta_lib;
    basic_includes();
    drupal_add_js($ruta_lib . 'modulos/clientes/js/clientes.js');
    drupal_add_js($ruta_lib . 'plugin/js/datatables.min.js');
    drupal_add_js($ruta_lib . 'plugin/js/datetime-moment.js');
    drupal_add_css($ruta_lib . 'plugin/css/datatables.min.css');
    $result = render_template('php', 'clientes.index');
    return $result;
}

//***************************************************************
//------------------------ CLIENTES PRINCIPAL  ------------------
//***************************************************************


//***************************************************************
//---------------------- CLIENTES REPORTE BASE  -----------------
//***************************************************************
function reporte_base()
{
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;

    $go = new clientes_reporte($datos);
}

//***************************************************************
//---------------------- CLIENTES REPORTE BASE  -----------------
//***************************************************************


//***************************************************************
//-------------------------- CLIENTES VISTA   -------------------
//***************************************************************
function vista_clientes($id_cliente)
{
    $datos = clientes_sys::vista_cliente($id_cliente);
    // esta es solo la vista para los clientes, y dentro  cambian campos
    // dependiendo del tipo_negocio del cliente

    // Habrá más vistas para cada tipo_cliente
    echo render_template('php', 'clientes.vista_cliente', $datos);
}

//***************************************************************
//-------------------------- CLIENTES VISTA   -------------------
//***************************************************************


//***************************************************************
//-------------------------- CONTACTO VISTA   -------------------
//***************************************************************
function vista_contactos($id_contacto)
{
    $datos = clientes_sys::vista_contacto($id_contacto);
    echo render_template('php', 'clientes.vista_contacto', $datos);
}

//***************************************************************
//-------------------------- CONTACTO VISTA   -------------------
//***************************************************************

//***************************************************************
//------------------------- CLIENTES CAPTURAR  ------------------
//***************************************************************
function clientes_capturar($tipo = null)
{
    $tipo = trim($tipo);
    $_POST = json_decode(file_get_contents('php://input'), 0);
    $datos = $_POST;
    $go = new clientes_sys($tipo, $datos);
}

//***************************************************************
//------------------------- CLIENTES CAPTURAR  ------------------
//***************************************************************


//***************************************************************
//-------------------- CLIENTES RENDER TEMPLATE  ----------------
//***************************************************************
function clientes_render_template($dir, $data = null)
{
    render_template('js', $dir, $data);
}
//***************************************************************
//-------------------- CLIENTES RENDER TEMPLATE  ----------------
//***************************************************************


//***************************************************************
//------------------------ CLIENTES MAPA  -----------------------
//***************************************************************
function clientes_mapa()
{
    $result = '
	<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD_X02tvBw0cpJzwA-RkDiBJ_3qJStSVkM&libraries=places"></script>
	<input id="pac-input" class="controls" type="text" placeholder="Busqueda">
	<div id="map-canvas"></div>
	<style>
	#map-canvas
	{
		height: 100%;
		width: 100%;
	}
	.controls {
  margin-top: 10px;
  border: 1px solid transparent;
  border-radius: 2px 0 0 2px;
  box-sizing: border-box;
  -moz-box-sizing: border-box;
  height: 32px;
  outline: none;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
}
#pac-input {
  background-color: #fff;
  font-family: Roboto;
  font-size: 15px;
  font-weight: 300;
  margin-left: 12px;
  padding: 0 11px 0 13px;
  text-overflow: ellipsis;
  width: 300px;
}
#pac-input:focus {
  border-color: #4d90fe;
}
.pac-container {
  font-family: Roboto;
}
#type-selector {
  color: #fff;
  background-color: #4d90fe;
  padding: 5px 11px 0px 11px;
}
#type-selector label {
  font-family: Roboto;
  font-size: 13px;
  font-weight: 300;
}
    </style>
    <title>Places Searchbox</title>
    <style>
      #target {
        width: 345px;
      }
	</style>
	<script>
var markers = [];
function initialize()
{
		var haightAshbury = {lat: 20.6854551, lng: -103.3542671};
        myOptions = {
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP,

        },
        map = new google.maps.Map( document.getElementById( "map-canvas" ), myOptions ),

	    map.panTo( new google.maps.LatLng( 20.6854551, -103.3542671 ) );
		addMarker(haightAshbury);
		parent.document.getElementById("coordenadas").value = "20.6854551,-103.3542671";
		var input = document.getElementById("pac-input");
		var searchBox = new google.maps.places.SearchBox(input);
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

		google.maps.event.addListener(map, "click", function (event) {
    		var latitude = event.latLng.lat();
    		var longitude = event.latLng.lng();
   		 	parent.document.getElementById("coordenadas").value = latitude + "," + longitude;
			setMapOnAll(null);
			addMarker(event.latLng);
		});



		map.addListener("bounds_changed", function() {
	    	searchBox.setBounds(map.getBounds());
  		});
searchBox.addListener("places_changed", function() {
    var places = searchBox.getPlaces();
    if (places.length == 0) {
      return;
    }
    // Clear out the old markers.
    markers.forEach(function(marker) {
      marker.setMap(null);
    });
    markers = [];
    // For each place, get the icon, name and location.
    var bounds = new google.maps.LatLngBounds();
	var contador = 0;
    places.forEach(function(place) {
		if (contador == 0){
      // Create a marker for each place.
      markers.push(new google.maps.Marker({
        map: map,
        title: place.name,
        position: place.geometry.location
      }));
	  parent.document.getElementById("coordenadas").value = place.geometry.location.lat() + "," + place.geometry.location.lng();
      if (place.geometry.viewport) {
        // Only geocodes have viewport.
        bounds.union(place.geometry.viewport);
      } else {
        bounds.extend(place.geometry.location);
      }
	  contador++;
		}
    });
    map.fitBounds(bounds);
  });
}
function addMarker(location) {
  var marker = new google.maps.Marker({
    position: location,
    map: map,
	draggable: true
  });
  markers.push(marker);
}
function setMapOnAll(map)
{
  for (var i = 0; i < markers.length; i++)
  {
   		markers[i].setMap(map);
  }
}
	initialize();
	</script>

	';
    echo $result;
    return NULL;
}
//***************************************************************
//------------------------ CLIENTES MAPA  -----------------------
//***************************************************************


//***************************************************************
//--------------------- CLIENTES MAPA EDITAR  -------------------
//***************************************************************
function clientes_mapa_editar()
{
    $result = '
	<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyD_X02tvBw0cpJzwA-RkDiBJ_3qJStSVkM&libraries=places"></script>
	<input id="pac-input" class="controls" type="text" placeholder="Busqueda">
	<div id="map-canvas"></div>
	<style>
	#map-canvas
	{
		height: 100%;
		width: 100%;
	}
	.controls {
  margin-top: 10px;
  border: 1px solid transparent;
  border-radius: 2px 0 0 2px;
  box-sizing: border-box;
  -moz-box-sizing: border-box;
  height: 32px;
  outline: none;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
}
#pac-input {
  background-color: #fff;
  font-family: Roboto;
  font-size: 15px;
  font-weight: 300;
  margin-left: 12px;
  padding: 0 11px 0 13px;
  text-overflow: ellipsis;
  width: 300px;
}
#pac-input:focus {
  border-color: #4d90fe;
}
.pac-container {
  font-family: Roboto;
}
#type-selector {
  color: #fff;
  background-color: #4d90fe;
  padding: 5px 11px 0px 11px;
}
#type-selector label {
  font-family: Roboto;
  font-size: 13px;
  font-weight: 300;
}
    </style>
    <title>Places Searchbox</title>
    <style>
      #target {
        width: 345px;
      }
	</style>
	<script>
var markers = [];
function initialize()
{
        var current_place = parent.document.getElementById("coordenadas_editar").value.split(",");
        var latt = parseFloat(current_place[0]);
        var longg = parseFloat(current_place[1]);
		var haightAshbury = {lat: latt, lng: longg};
        myOptions = {
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP,

        },
        map = new google.maps.Map( document.getElementById( "map-canvas" ), myOptions ),

	    map.panTo( new google.maps.LatLng( latt, longg ) );
		addMarker(haightAshbury);
		var input = document.getElementById("pac-input");
		var searchBox = new google.maps.places.SearchBox(input);
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
		google.maps.event.addListener(map, "click", function (event) {
    		var latitude = event.latLng.lat();
    		var longitude = event.latLng.lng();
   		 	parent.document.getElementById("coordenadas_editar").value = latitude + "," + longitude;
			setMapOnAll(null);
			addMarker(event.latLng);
		});



		map.addListener("bounds_changed", function() {
	    	searchBox.setBounds(map.getBounds());
  		});
searchBox.addListener("places_changed", function() {
    var places = searchBox.getPlaces();
    if (places.length == 0) {
      return;
    }
    // Clear out the old markers.
    markers.forEach(function(marker) {
      marker.setMap(null);
    });
    markers = [];
    // For each place, get the icon, name and location.
    var bounds = new google.maps.LatLngBounds();
	var contador = 0;
    places.forEach(function(place) {
		if (contador == 0){
      // Create a marker for each place.
      markers.push(new google.maps.Marker({
        map: map,
        title: place.name,
        position: place.geometry.location
      }));
	  parent.document.getElementById("coordenadas_editar").value = place.geometry.location.lat() + "," + place.geometry.location.lng();
      if (place.geometry.viewport) {
        // Only geocodes have viewport.
        bounds.union(place.geometry.viewport);
      } else {
        bounds.extend(place.geometry.location);
      }
	  contador++;
		}
    });
    map.fitBounds(bounds);
  });
}
function addMarker(location) {
  var marker = new google.maps.Marker({
    position: location,
    map: map,
	draggable: true
  });
  markers.push(marker);
}
function setMapOnAll(map)
{
  for (var i = 0; i < markers.length; i++)
  {
   		markers[i].setMap(map);
  }
}
	initialize();
	</script>

	';
    echo $result;
    return NULL;
}
//***************************************************************
//--------------------- CLIENTES MAPA EDITAR  -------------------
//***************************************************************
