<?php
include drupal_get_path('module', 'partners') . '/lib/classes/capacitacion/class.capacitacion.php';
$GLOBALS['configuracionJs'] =
  array('capacitacion' =>
    array(
      'ruta_sys_tools' => url('system/tools/'),
      'render_template' => url('capacitacion/render_template/'),
      'ruta_consultas' => url('capacitacion/consultas/'),
      'ruta_lista_clientes' => url('system/tools/lista_clientes/'),
      'ruta_lista_contactos' => url('system/tools/lista_contactos/')
    )
  );

//***************************************************************
//-------------------- CAPACITACIÓN PRINCIPAL  ------------------
//***************************************************************
function capacitacion_principal()
{

  global $ruta_lib, $user;
  basic_includes();
  drupal_add_js($ruta_lib . 'modulos/capacitacion/js/capacitacion.js');
  $datos['allowed'] = user_access('capacitacion_administrador');
  $role = user_role_load_by_name('Todos');
  $query = 'SELECT ur.uid
    FROM {users_roles} AS ur
    WHERE ur.rid = :rid';
  $result = db_query($query, array(':rid' => $role->rid));
  $uids = $result->fetchCol();

  $usuarios = db_select('users', 'u')
    ->fields('u', array('uid', 'name'))
    ->condition('status', 1)
    ->condition('uid', $uids, 'IN')
    ->condition('uid', 26, '!=')
    ->orderBy('name', 'ASC')
    ->execute()->fetchAll(PDO::FETCH_ASSOC);
  $datos['usuarios'] = $usuarios;
  $result = render_template('php', 'capacitacion.index', $datos);
  return $result;
}

//***************************************************************
//-------------------- CAPACITACIÓN PRINCIPAL  ------------------
//***************************************************************


//***************************************************************
//------------------- CAPACITACIÓN CONSULTAS  -------------------
//***************************************************************
function capacitacion_consultas($tipo = null)
{
  $tipo = trim($tipo);
  $datos = json_decode(file_get_contents('php://input'), 0);
  new capacitacion_sys($tipo, $datos);
}

//***************************************************************
//------------------- CAPACITACIÓN CONSULTAS  -------------------
//***************************************************************


//***************************************************************
//------------------- CAPACITACION RENDER TEMPLATE  -------------
//***************************************************************
function capacitacion_render_template($dir, $data = null)
{
  render_template('js', $dir, $data);
}

//***************************************************************
//------------------- CAPACITACION RENDER TEMPLATE  -------------
//***************************************************************

//***************************************************************
//----------------------- CAPACITACION VISTA  -------------------
//***************************************************************
function capacitacion_vista($id_registro, $type = NULL)
{
  new capacitacion_sys('render_vista', array("id_registro" => $id_registro, "type" => $type));
}
//***************************************************************
//----------------------- CAPACITACION VISTA  -------------------
//***************************************************************