<?php
//***************************************************************
//-------------------- BACKUPS PRINCIPAL  -----------------------
//***************************************************************
use Partners\Backups\BackupsController;
use Partners\Backups\BackupsRouter;

$GLOBALS['configuracionJs'] =
  array(
    'clientes' =>
      array(
        'ruta_sys_tools' => url('system/tools/'),
        'ruta_reporte_base' => url('clientes/reporte_base'),
        'render_template' => url('clientes/render_template/'),
        'ruta_capturar' => url('clientes/capturar/'),
        'ruta_vista_cliente' => url('clientes/vista_clientes/'),
        'ruta_vista_contacto' => url('clientes/vista_contactos/')
      )
  );

/**
 * @return string|void
 */
function backups_principal()
{
  if(!user_is_logged_in()){
    drupal_access_denied();
    return;
  }
  global $ruta_lib;
  basic_includes();
  drupal_add_js($ruta_lib . 'build/static/js/backups.js');
  drupal_add_js($ruta_lib . 'modulos/renovaciones/js/rrule.js');
  drupal_add_css($ruta_lib . 'plugin/css/fontawesome-all.min.css');
  $result = render_template('php', 'backups.index');
  return $result;
}
//***************************************************************
//-------------------- BACKUPS PRINCIPAL  -----------------------
//***************************************************************

//***************************************************************
//------------------- BACKUPS FICHA INFORMATIVA  ----------------
//***************************************************************
function backups_ficha(){
  global $ruta_lib;
  drupal_add_js($ruta_lib . 'build/static/js/backups_ficha.js');
  drupal_add_css($ruta_lib . 'plugin/css/fontawesome-all.min.css');
  $result = render_template('php', 'backups.index_ficha');
  return $result;
}
//***************************************************************
//------------------- BACKUPS FICHA INFORMATIVA  ----------------
//***************************************************************

//***************************************************************
//-------------------- BACKUPS CONSULTAS  -----------------------
//***************************************************************
function backups_consultas($tipo = null)
{
  new BackupsRouter($tipo);
}
//***************************************************************
//-------------------- BACKUPS CONSULTAS  -----------------------
//***************************************************************
