<div class="row">
    <div class="col-12">
        <div class="card border-primary">
            <div class="card-header text-center cursor-pointer bg-primary text-white" data-toggle="collapse"
                 data-target="#datos_generales_vehiculo"
                 aria-expanded="false">Datos Vehículo
            </div>
            <div class="collapse show" id="datos_generales_vehiculo">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <label class="font-weight-bold">Vehículo</label>
                            <p>
                                <span>{$datos.vehiculo.nombreVehiculo}</span>
                            </p>
                        </div>

                        <div class="col-md-3">
                            <label class="font-weight-bold">Año</label>
                            <p>{$datos.vehiculo.anoVehiculo}</p>
                        </div>

                        <div class="col-md-3">
                            <label class="font-weight-bold">Placa</label>
                            <p>{$datos.vehiculo.placaVehiculo}</p>
                        </div>

                        <div class="col-md-3">
                            <label class="font-weight-bold">Serie</label>
                            <p>{$datos.vehiculo.serieVehiculo}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row my-3">
    <div class="col-12">
        <div class="card border-primary">
            <div class="card-header text-center cursor-pointer bg-primary text-white" data-toggle="collapse"
                 data-target="#datos_seguro"
                 aria-expanded="false">Seguro
            </div>
            <div class="collapse show" id="datos_seguro">
                <div class="card-body">
                    {if $datos.seguro}
                        <table class="table table-sm table-bordered table-hover">
                            <thead>
                            <tr>
                                <th>Compañia</th>
                                <th>Poliza</th>
                                <th>Fecha Vencimiento</th>
                                <th>Forma Pago</th>
                                <th class="text-right">Precio</th>
                            </tr>
                            </thead>
                            <tbody>
                            {loop $datos.seguro}
                                <tr class="ver_seguro_vista_vehiculo cursor-pointer" data-seguro-file="{$pdf}" data-files-url="{$__unkownProperties.url_files}">
                                    <td>{$compania}</td>
                                    <td>{$poliza}</td>
                                    <td>{date('d-m-Y', $fechaVencimiento)}</td>
                                    <td>{$formaPago}</td>
                                    <td class="text-right">{number_format($precio, 2, '.', ',')}</td>
                                </tr>
                            {/loop}
                            </tbody>
                        </table>
                    {else}
                        <p class="text-danger">Este vehículo no tiene seguro registrado.</p>
                    {/if}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row my-3">
    <div class="col-12">
        <div class="card border-primary">
            <div class="card-header text-center cursor-pointer bg-primary text-white" data-toggle="collapse"
                 data-target="#datos_refrendo"
                 aria-expanded="false">Datos Refrendo
            </div>
            <div class="collapse show" id="datos_refrendo">
                <div class="card-body">
                    {if $datos.refrendo}
                        <table class="table table-sm table-hover table-bordered">
                            <thead>
                            <tr>
                                <th>Año</th>
                            </tr>
                            </thead>
                            <tbody>
                            {loop $datos.refrendo}
                                <tr class="ver_refrendo_vista_vehiculo cursor-pointer" data-refrendo-file="{$pdf}" data-files-url="{$__unkownProperties.url_files}">
                                    <td>{date('Y', $fechaRefrendo)}</td>
                                </tr>
                            {/loop}
                            </tbody>
                        </table>
                    {else}
                        <p class="text-danger">Este vehículo no tiene ningún refrendo registrado.</p>
                    {/if}
                </div>
            </div>
        </div>
    </div>
</div>