<!DOCTYPE html>
<html lang="en" xmlns="https://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
    xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
    <meta charset="utf-8"> <!-- utf-8 works for most cases -->
    <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
    <meta name="x-apple-disable-message-reformatting"> <!-- Disable auto-scale in iOS 10 Mail entirely -->
    <title></title> <!-- The title tag shows in email notifications, like Android 4.4. -->
    <!-- Web Font / @font-face : BEGIN -->
    <!-- NOTE: If web fonts are not required, lines 10 - 27 can be safely removed. -->
    <!-- Desktop Outlook chokes on web font references and defaults to Times New Roman, so we force a safe fallback font. -->
    <!--[if mso]>
    <style> * {
        font-family: sans-serif !important;
    } </style> <![endif]-->
    <!-- All other clients get the webfont reference; some will render the font and others will silently fail to the fallbacks. More on that here: https://stylecampaign.com/blog/2015/02/webfont-support-in-email/ -->
    <!--[if !mso]><!-->
    <!-- insert web font reference, eg: <link href='https://fonts.googleapis.com/css?family=Roboto:400,700' rel='stylesheet' type='text/css'> -->
    <!--<![endif]-->
    <!-- Web Font / @font-face : END -->
    <!-- CSS Reset : BEGIN -->
    <style>
        /* What it does: Remove spaces around the email design added by some email clients. */
        /* Beware: It can remove the padding / margin and add a background color to the compose a reply window. */
        html,
        body {
            margin: 0 auto !important;
            padding: 0 !important;
            height: 100% !important;
            width: 100% !important;
        }

        /* What it does: Stops email clients resizing small text. */
        * {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        /* What it does: Centers email on Android 4.4 */
        div[style*="margin: 16px 0"] {
            margin: 0 !important;
        }

        /* What it does: Stops Outlook from adding extra spacing to tables. */
        table,
        td {
            mso-table-lspace: 0pt !important;
            mso-table-rspace: 0pt !important;
        }

        /* What it does: Fixes webkit padding issue. Fix for Yahoo mail table alignment bug. Applies table-layout to the first 2 tables then removes for anything nested deeper. */
        table {
            border-spacing: 0 !important;
            border-collapse: collapse !important;
            table-layout: fixed !important;
            margin: 0 auto !important;
        }

        table table table {
            table-layout: auto;
        }

        /* What it does: Uses a better rendering method when resizing images in IE. */
        img {
            -ms-interpolation-mode: bicubic;
        }

        /* What it does: A work-around for email clients meddling in triggered links. */
        *[x-apple-data-detectors],
        /* iOS */
        .unstyle-auto-detected-links *,
        .aBn {
            border-bottom: 0 !important;
            cursor: default !important;
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        /* What it does: Prevents Gmail from displaying a download button on large, non-linked images. */
        .a6S {
            display: none !important;
            opacity: 0.01 !important;
        }

        /* If the above doesn't work, add a .g-img class to any image in question. */
        img.g-img+div {
            display: none !important;
        }

        /* What it does: Prevents underlining the button text in Windows 10 */
        .button-link {
            text-decoration: none !important;
        }

        /* What it does: Removes right gutter in Gmail iOS app: https://github.com/TedGoas/Cerberus/issues/89 */
        /* Create one of these media queries for each additional viewport size you'd like to fix */
        /* iPhone 4, 4S, 5, 5S, 5C, and 5SE */
        @media only screen and (min-device-width: 320px) and (max-device-width: 374px) {
            .email-container {
                min-width: 320px !important;
            }
        }

        /* iPhone 6, 6S, 7, 8, and X */
        @media only screen and (min-device-width: 375px) and (max-device-width: 413px) {
            .email-container {
                min-width: 375px !important;
            }
        }

        /* iPhone 6+, 7+, and 8+ */
        @media only screen and (min-device-width: 414px) {
            .email-container {
                min-width: 414px !important;
            }
        }
    </style> <!-- CSS Reset : END -->
    <!-- Reset list spacing because Outlook ignores much of our inline CSS. -->
    <!--[if mso]>
    <style type="text/css"> ul, ol {
        margin: 0 !important;
    }

    li {
        margin-left: 30px !important;
    }

    li.list-item-first {
        margin-top: 0 !important;
    }

    li.list-item-last {
        margin-bottom: 10px !important;
    } </style> <![endif]-->
    <!-- Progressive Enhancements : BEGIN -->
    <style>
        /* What it does: Hover styles for buttons */
        .button-td,
        .button-a {
            transition: all 100ms ease-in;
        }

        .button-td-primary:hover,
        .button-a-primary:hover {
            background: #555555 !important;
            border-color: #555555 !important;
        }

        /* Media Queries */
        @media screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                margin: auto !important;
            }

            /* What it does: Forces elements to resize to the full width of their container. Useful for resizing images beyond their max-width. */
            .fluid {
                max-width: 100% !important;
                height: auto !important;
                margin-left: auto !important;
                margin-right: auto !important;
            }

            /* What it does: Forces table cells into full-width rows. */
            .stack-column,
            .stack-column-center {
                display: block !important;
                width: 100% !important;
                max-width: 100% !important;
                direction: ltr !important;
            }

            /* And center justify these ones. */
            .stack-column-center {
                text-align: center !important;
            }

            /* What it does: Generic utility class for centering. Useful for images, buttons, and nested tables. */
            .center-on-narrow {
                text-align: center !important;
                display: block !important;
                margin-left: auto !important;
                margin-right: auto !important;
                float: none !important;
            }

            table.center-on-narrow {
                display: inline-block !important;
            }

            /* What it does: Adjust typography on small screens to improve readability */
            .email-container p {
                font-size: 17px !important;
            }
        }
    </style> <!-- Progressive Enhancements : END -->
    <!-- What it does: Makes background images in 72ppi Outlook render at correct size. -->
    <!--[if gte mso 9]>
    <xml>
        <o:OfficeDocumentSettings>
            <o:AllowPNG/>
            <o:PixelsPerInch>96</o:PixelsPerInch>
        </o:OfficeDocumentSettings>
    </xml> <![endif]-->
</head>

<body width="100%" style="margin: 0; mso-line-height-rule: exactly;">
    <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td>
                <![endif]--> <!-- Email Body : BEGIN -->
    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="600"
           style="margin: auto;" class="email-container">
        <tr>
            <td>
                <table>
                    <tr>
                        <td valign="top">
                            <table cellspacing="0" cellpadding="0" width="100%">
                                <tr>
                                    <td class="mobile-padding" style="text-align:left;">
                                        Hola
                                        <b>{if $datos.orden.id_contacto != 0}{$datos.orden.nombre_contacto}{else}{$datos.orden.nombre_cliente}{/if} </b>,
                                        <br> Por
                                        este medio le informamos que su pago <b
                                                style="color:#1d4581;">ha sido aprovado!</b>, a continuación le
                                        presentamos más información.<br></td>
                                </tr>
                                <tr>
                                    <td class="mobile-padding" style="; text-align: center;"><b
                                                style="font-size:21px; color:#1d4581;">Orden
                                            P-{$datos.orden.id_orden}</b></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>
                                        <br> <b> <i>En las próximas horas nos comunicaremos con usted para
                                                brindarle más información.</i></b>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="mobile-padding"
                                        style="background: #efefef; -webkit-box-shadow: 1px 1px 15px 1px rgba(0,0,0,0.1); box-shadow: 1px 0px 3px 1px rgba(0,0,0,0.1); padding: 10px; -webkit-border-radius: 1px 1px 0 0; border-radius: 6px 6px 0 0; text-align: center;">
                                        Datos Pago
                                    </td>
                                </tr>
                                <tr>
                                    <td class="mobile-padding"
                                        style="text-align:left;">
                                        <table cellspacing="0" cellpadding="0" width="600">
                                            <tr>
                                                <td style="padding-top: 10px;" colspan="2">
                                                    {if $datos.orden.id_contacto != 0}
                                                                            {*Si tiene contacto, entonces es empresa *}
                                                                            <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; text-transform: uppercase; font-size: 0.75rem; line-height: 2rem; letter-spacing: 0.16667em;">{$datos.orden.nombre_cliente}</span>
                                                                            <br>
                                                                            <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.orden.nombre_contacto}</span>
                                                                            <br>
                                                                            <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.email_cliente}</span>
                                                                            <br>
                                                    {else}
                                                                            <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.orden.nombre_cliente}</span>
                                                                            <br>
                                                                            <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.email_cliente}</span>
                                                                            <br>
                                                    {/if}
                                                </td>
                                            </tr>

                                            <tr>
                                                <td colspan="2" style="padding: 10px 0;">
                                                    <table style="margin: 0 !important; width: 100%;">
                                                        <tr style="height: 1px; background: #e3e3e3; ">
                                                            <td></td>
                                                        </tr>
                                                    </table>

                                                </td>
                                            </tr>

                                            <tr>
                                                <td style="text-align: left">
                                                    <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">Detalle</span>
                                                    <br> <span
                                                            style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">Método de Pago</span>
                                                </td>
                                                <td style=" text-align: right;">
                                                    <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.orden.descripcion_servicio}</span>
                                                    <br>
                                                    <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">{$datos.metodo_pago}</span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2" style="padding: 10px 0;">
                                                    <table style="margin: 0 !important; width: 100%;">
                                                        <tr style="height: 1px; background: #e3e3e3; ">
                                                            <td></td>
                                                        </tr>
                                                    </table>

                                                </td>
                                            </tr>


                                            <tr>
                                                <td style="text-align: left; padding-bottom: 25px;">
                                                    <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;">Total</span>
                                                </td>
                                                <td style=" text-align: right; padding-bottom: 25px;">
                                                    <span style="box-sizing: border-box; font-family: Roboto, sans-serif; -webkit-font-smoothing: antialiased; font-size: 1rem; line-height: 1.5rem; letter-spacing: 0.03125em; text-decoration: inherit; text-transform: inherit;"><b
                                                                style="color:#1d4581; font-size: 18px;">$ {number_format($datos.orden.total,2,'.',',')}
                                                            MXN</b></span>
                                                </td>
                                            </tr>

                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <br><br> <b>Atentamente</b> <br> <b>PC PARTNERS</b><br> <b>Administración.</b>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td class="mobile-padding"><br>
                            <table cellspacing="0" cellpadding="0" width="100%">
                                <tr>
                                    <td><p style="text-align: justify;">Domicilio: <br> Av. Federalismo Norte #561 <br>
                                            Col. Sagrada Familia</p></td>
                                    <td><p style="text-align: center;">Teléfonos: <br> (33) 3126-8308 con 6 líneas.</p>
                                    </td>
                                </tr>
                                <tr><p style="text-align: justify;"><br>Correo: <br> <a
                                                href="mailto:administracion@pcpartners.com.mx">administracion@pcpartners.com.mx</a>
                                    </p></tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <table cellspacing="0" cellpadding="0" width="600" style="background-color:#c2c2c2;">
                    <tr>
                        <td valign="top" align="center">
                            <table cellspacing="0" cellpadding="30">
                                <tr>
                                    <td style="text-align:center;"><a href="https://pcpartners.com.mx"> <img width="61"
                                                                                                             height="51"
                                                                                                             src="https://www.intranet.partnersinterno.com/sites/default/files/img/web_email_ico.png"
                                                                                                             alt="Pc Partners"/>
                                        </a> <a href="https://www.facebook.com/pcpartnersmx"> <img width="61"
                                                                                                   height="51"
                                                                                                   src="https://www.intranet.partnersinterno.com/sites/default/files/img/businessv1_09.gif"
                                                                                                   alt="facebook"/> </a>
                                        <a href="https://twitter.com/pcpartnersmx"> <img width="61" height="51"
                                                                                         src="https://www.intranet.partnersinterno.com/sites/default/files/img/businessv1_07.gif"
                                                                                         alt="twitter"/> </a> <a
                                                href="https://plus.google.com/106221580788564249589"> <img width="61"
                                                                                                           height="51"
                                                                                                           src="https://www.intranet.partnersinterno.com/sites/default/files/img/businessv1_08.gif"
                                                                                                           alt="google plus"/>
                                        </a></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td valign="top">
                            <table style="margin:0 auto;" cellspacing="0" cellpadding="5">
                                <tr>
                                    <td style="text-align:center; margin:0 auto;" width="100%"><a href="#"
                                                                                                  style="text-align:center;">
                                            <img style="margin:0 auto;" width="100" height="33"
                                                 src="https://www.intranet.partnersinterno.com/sites/default/files/img/logohd.png"
                                                 alt="logo link"/> </a></td>
                                </tr>
                                <tr>
                                    <td><p style="font-size: 10px; text-align: justify;">Este e-mail se ha generado
                                            automáticamente. Si tienes alguna duda o pregunta, por favor comunícate a
                                            nuestros teléfonos. </p>
                                        <p style="font-size: 10px; text-align: justify;"> (33) 3126-8308 con 6
                                            líneas. </p></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table> <!-- Email Body : END --> <!--[if mso | IE]>
            </td>
        </tr>
    </table>
    <![endif]-->
</body>
</html>