<div style="background-color: #F6F6F6; min-height: 660px;">
    <div class="container-fluid py-4">
        {if $datos.region_intranet}
            <div class="row">
                <div class="col-12">
                    {$datos.region_intranet}
                </div>
            </div>
        {/if}
        <div class="row mb-5">

            {*
            Pendientes
            *}

            <div class="col-md-4 col-12 mb-2">
                <div class="card">
                    <div class="card-body">
                        <h4 cla ss="card-title">Pendientes no finalizados</h4>

                        <ul class="rslides1">
                        {loop $datos.pendientes}
                        <li>
                          <a href="/pendientes/?id_pendiente={$id_pendiente}" target="_blank" class="list-group-item list-group-item-action">
                              <div class="d-flex justify-content-between">
                                  <h5 class="mb-1">{$nombre_cliente}</h5>
                                  <small><span class="badge badge-info badge-pill p-1">{date_format($fecha_pendiente, '%d %B %Y')}</span></small>
                              </div>
                              <p class="mb-1">{$descripcion_pendiente}</p>
                          </a>
                          </li>
                        {/loop}
                        </ul>
                    </div>
                    <div class="pendientes_nav list-group-item justify-content-between d-flex">
                    </div>

                </div>
            </div>

            {*
            Eliminar Clientes
            *}

            {if $datos.user_admin_clientes == true}
                <div class="col-md-4 col-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Clientes para eliminar</h4>
                            <ul class="rslides2">
                            {loop $datos.clientes_eliminar}
                            <li style="height: auto;">
                              <a href="/clientes?id_cliente={$id_cliente}&type={$tipo_cliente}" target="_blank" class="list-group-item list-group-item-action">
                                  <div class="d-flex justify-content-between">
                                      <h5 class="mb-1">{$nombre_cliente}</h5>
                                  </div>
                                  <br>
                              </a>
                            </li>
                            {/loop}
                            </ul>
                        </div>
                        <div class="clientes_eliminar list-group-item justify-content-between d-flex">
                        </div>
                    </div>
                </div>
            {/if}

            {*
            Cambiar NIP
            *}

            <div class="col-md-4 col-12">
                <div class="card">
                    <div class="card-body">
                        {if $datos.check_nip}
                            <h4 class="card-title">Cambiar NIP</h4>
                            <div class="alert alert-danger wrong_pass_container" role="alert" style="display: none;">
                                <strong>No lo recuerdas?</strong> Si olvidaste tu NIP, pidele a un administrador que te
                                resetee el NIP.
                            </div>
                            <form autocomplete="off" id="change_user_current_nip">
                                <div class="form-group">
                                    <label>NIP Actual</label>
                                    <div>
                                        <input type="password" class="form-control"
                                               placeholder="Ingresa tu NIP Actual" name="current_nip"
                                               autocomplete="new-password" data-validation="required"
                                               data-validation-error-msg="Ingresa tu NIP Actual">
                                    </div>
                                    <small id="emailHelp" class="form-text text-muted">Necesitamos tu NIP actual para
                                        confirmar tu identidad.
                                    </small>
                                </div>

                                <div class="form-group">
                                    <label>Nuevo NIP</label>
                                    <div>
                                        <input type="password" class="form-control"
                                               placeholder="Ingresa tu nuevo NIP" name="new_nip"
                                               autocomplete="new-password"
                                               data-validation="required"
                                               data-validation-error-msg="Ingresa tu nuevo NIP">
                                    </div>
                                </div>

                                <button class="btn btn-success float-right" type="submit" role="button">Guardar
                                    Cambios
                                </button>
                            </form>
                        {else}
                            <h4 class="card-title">Crear NIP</h4>
                            <form autocomplete="off" id="create_user_nip">
                                <div class="form-group">
                                    <label>NIP</label>
                                    <div>
                                        <input type="password" class="form-control"
                                               placeholder="Ingresa tu NIP" name="new_nip"
                                               autocomplete="new-password" data-validation="required"
                                               data-validation-error-msg="Ingresa tu NIP">
                                    </div>
                                    <small id="emailHelp" class="form-text text-muted">Este NIP lo usarás para poderte
                                        identificar en el sistema sin necesidad de estar logueado en tu cuenta.
                                    </small>
                                </div>

                                <button class="btn btn-success float-right" type="submit" role="button">Crear NIP
                                </button>
                            </form>
                        {/if}

                    </div>
                </div>
            </div>

            {*
            Generar Orden de Pago
            *}

            <div class="col-md-4 col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="card-title">Generar Orden de Pago</h4>

                        <form autocomplete="off" id="nueva_orden_form" data-email-user="{$datos.user_email}">
                            <div class="form-group">
                                <label>Cliente</label>
                                <div style="padding-right: 20px;    ">
                                    {include "../system/buscador_clientes.tpl"}
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Descripción</label>
                                <div>
                                    <input type="text" class="form-control"
                                           placeholder="Ingresa una breve descripción del cobro"
                                           name="descripcion_orden"
                                           data-validation="required"
                                           data-validation-error-msg="Ingresa una descripción">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Cantidad</label>
                                <div style="width: 25%;">
                                    <input type="text" class="form-control text-right"
                                           name="cantidad_orden"
                                           data-validation="number"
                                           data-validation-allowing="float" data-sanitize="numberFormat"
                                           data-sanitize-number-format="0,0.00"
                                           data-validation-error-msg="Obligatorio">
                                </div>
                            </div>

                            <button class="btn btn-success float-right" type="submit" role="button">Generar</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>


        {*
        <div class="col-md-12">
            <div class="row margin-bot">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Meta Mensual $ 99,999</h4>
                            <h6 class="card-subtitle mb-2 text-muted">Meta Actual</h6>
                            <h3 class="display-1">$ 89,999</h3>
                            <div class="progress">
                                <div class="progress-bar" role="progressbar" style="width: 75%;" aria-valuenow="75"
                                     aria-valuemin="0" aria-valuemax="100">75%
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Avisos Recientes</h4>
                            <ul class="list-group">
                                <li class="list-group-item justify-content-between">Dapibus ac facilisis in <span
                                            class="badge badge-primary">Roberto</span></li>
                                <li class="list-group-item justify-content-between">Morbi leo risus <span
                                            class="badge badge-warning">Rocio</span></li>
                                <li class="list-group-item justify-content-between">Porta ac consectetur ac <span
                                            class="badge badge-primary">Erick</span></li>
                                <li class="list-group-item justify-content-between">Vestibulum at eros <span
                                            class="badge badge-warning">Rocio</span></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row margin-bot">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Servicios Mensuales</h4>
                            <canvas id="myChart"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Pendientes para este Día</h4>
                            <div class="list-group">
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-danger">Urgente</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-danger">Urgente</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-success">Cuando haya vuelta</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row margin-bot">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Clientes Frecuentes</h4>
                            <canvas id="myChart2" ></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title">Pendientes atrasados</h4>
                            <div class="list-group">
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-danger">Urgente</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-danger">Urgente</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                                <a href="#"
                                   class="list-group-item list-group-item-action flex-column align-items-start">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-1">Cliente</h5>
                                        <small><span class="badge badge-success">Cuando haya vuelta</span></small>
                                    </div>
                                    <p class="mb-1">Descripción del Pendiente.</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        *}
    </div>
</div>

