{include 'vista_datos_generales.tpl' }
{load_templates 'render_revision.tpl'}
{if $datos.revision_inicial.revision_realizada == 0}
    <div class="row margin-bot">
        <div class="col-md-12">
            <p class="display-5">Aún no se realiza la revisión inicial de este registro.</p>
        </div>
    </div>
{else}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#datos_revision_inicial_{$datos.revision_inicial.random_number}"
                     aria-expanded="false">
                    Revisión Inicial
                </div>
                <div class="collapse show" id="datos_revision_inicial_{$datos.revision_inicial.random_number}">
                    <div class="card-body">
                        {render_revision $datos.revision_inicial}
                    </div>
                </div>

                <div class="card-footer text-muted">
                    <div class="text-center">Revisión Inicial realizada
                        por: {$datos.revision_inicial.revision_info.nombre_usuario_creo}
                        el {date_format $datos.revision_inicial.revision_info.created_at "%d/%m/%Y %l:%M %P"} </div>
                </div>
            </div>
        </div>
    </div>
{/if}

{if $datos.presupuesto.status_presupuesto == 0}
    <div class="row margin-bot">
        <div class="col-md-12">
            <p class="display-5">Aún no se realiza el presupuesto de este registro.</p>
        </div>
    </div>
{elseif $datos.presupuesto.status_presupuesto == 1}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white">
                    Presupuesto
                    Inicial {if $datos.presupuesto.info_presupuesto.created_at != $datos.presupuesto.info_presupuesto.updated_at} | Última vez editado por {$datos.presupuesto.info_presupuesto.nombre_usuario_edito} el {date_format $datos.presupuesto.info_presupuesto.updated_at "%d/%m/%Y %l:%M %P"} {/if}
                </div>
                <div class="card-body">
                    <div class="row margin-bot">
                        <div class="col-md-12">
                            <table class="table table-sm table-hover table-bordered table-striped">
                                <thead class="bg-faded">
                                <tr>
                                    <td>Tipo</td>
                                    <td>Cantidad</td>
                                    <td>Descripción</td>
                                    <td>Precio Unitario</td>
                                    <td>Subtotal</td>
                                    <td>IVA</td>
                                </tr>
                                </thead>
                                <tbody>
                                {loop $datos.presupuesto.presupuesto}
                                    <tr class="entity_presupuesto_editando" data-id-dato="{$id_dato}">
                                        <td class="entity_presupuesto_tipo_editando"
                                            data-tipo-presupuesto="{$tipo}  ">{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                        <td class="text-right entity_presupuesto_cantidad_editando">{$cantidad}</td>
                                        <td class="entity_presupuesto_descripcion_editando"
                                            style="word-break: break-all;">{$descripcion}</td>
                                        <td class="text-right entity_presupuesto_precio_editando"
                                            data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                                        <td class="text-right entity_presupuesto_subtotal_editando"
                                            data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                                        <td class="text-center">
                                            {if $iva == 1 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_editando"
                                                               type="checkbox" checked value="1"
                                                               id="TVcustomCheckInline1"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TVcustomCheckInline1"></label>
                                                    </div>
                                                </div>
                                            {elseif $iva == 0 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_editando"
                                                               type="checkbox" value="1" id="TVcustomCheckInline2"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TVcustomCheckInline2"></label>
                                                    </div>
                                                </div>
                                            {/if}
                                        </td>
                                    </tr>
                                {/loop}
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="4" class="text-center">Total</td>
                                    <td class="text-right total_presupuesto_editando">{number_format $datos.presupuesto.total_presupuesto,2,'.',','}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{elseif $datos.presupuesto.status_presupuesto == 2}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#presupuesto_inicial_{$datos.random_number}"
                     aria-expanded="false">
                    Presupuesto
                    Inicial
                </div>
                <div class="collapse show" id="presupuesto_inicial_{$datos.random_number}">
                    <div class="card-body">
                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td>Precio Unitario</td>
                                        <td>Subtotal</td>
                                        <td>IVA</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {loop $datos.presupuesto.presupuesto_inicial}
                                        <tr>
                                            <td>{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                            <td>{$cantidad}</td>
                                            <td style="word-break: break-all;">{$descripcion}</td>
                                            <td>{number_format $precio,2,'.',','}</td>
                                            <td>{number_format $subtotal,2,'.',','}</td>
                                            <td class="text-center">
                                                {if $iva == 1 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   id="TVcustomCheckInline3"
                                                                   type="checkbox" checked value="1"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline3"></label>
                                                        </div>
                                                    </div>
                                                {elseif $iva == 0 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   type="checkbox" value="1" id="TVcustomCheckInline4"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline4"></label>
                                                        </div>
                                                    </div>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/loop}
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right">{number_format $datos.presupuesto.total_presupuesto_inicial,2,'.',','}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#presupuesto_autorizado_{$datos.random_number}"
                     aria-expanded="false">
                    Presupuesto Autorizado creado
                    por {$datos.presupuesto.info_presupuesto.nombre_usuario_ingreso_autorizacion}
                    el {date_format $datos.presupuesto.info_presupuesto.fecha_autorizado "%d/%m/%Y %l:%M %P"} {if $datos.presupuesto.info_presupuesto.updated_at != $datos.presupuesto.info_presupuesto.fecha_autorizado}
                        | Última vez modificado por {$datos.presupuesto.info_presupuesto.nombre_usuario_edito}
                        el {date_format $datos.presupuesto.info_presupuesto.updated_at "%d/%m/%Y %l:%M %P"} {/if}
                </div>

                <div class="collapse show" id="presupuesto_autorizado_{$datos.random_number}">

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <p class="lead">Presupuesto Autorizado
                                    por {$datos.presupuesto.info_presupuesto.autorizado_por}</p>
                            </div>
                        </div>
                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td>Precio Unitario</td>
                                        <td>Subtotal</td>
                                        <td>IVA</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {loop $datos.presupuesto.presupuesto}
                                        <tr class="entity_presupuesto" data-id-dato="{$id_dato}">
                                            <td class="entity_presupuesto_tipo"
                                                data-tipo-presupuesto="{$tipo}  ">{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                            <td class="text-right entity_presupuesto_cantidad">{$cantidad}</td>
                                            <td class="entity_presupuesto_descripcion"
                                                style="word-break: break-all;">{$descripcion}</td>
                                            <td class="text-right entity_presupuesto_precio"
                                                data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                                            <td class="text-right entity_presupuesto_subtotal"
                                                data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                                            <td class="text-center">
                                                {if $iva == 1 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input entity_presupuesto_iva"
                                                                   type="checkbox" checked value="1" id="TVcustomCheckInline5"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline5"></label>
                                                        </div>
                                                    </div>
                                                {elseif $iva == 0 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input entity_presupuesto_iva"
                                                                   type="checkbox" value="1" id="TVcustomCheckInline6"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline6"></label>
                                                        </div>
                                                    </div>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/loop}
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right total_presupuesto">{number_format $datos.presupuesto.total_presupuesto,2,'.',','}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{elseif $datos.presupuesto.status_presupuesto == 3}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-danger">
                <div class="card-header text-center bg-danger text-white cursor-pointer" data-toggle="collapse"
                     data-target="#presupuesto_no_autorizado_{$datos.random_number}"
                     aria-expanded="false">
                    Presupuesto
                    No Autorizado
                </div>
                <div class="collapse show" id="presupuesto_no_autorizado_{$datos.random_number}">
                    <div class="card-body">
                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td>Precio Unitario</td>
                                        <td>Subtotal</td>
                                        <td>IVA</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {loop $datos.presupuesto.presupuesto_inicial}
                                        <tr>
                                            <td>{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                            <td>{$cantidad}</td>
                                            <td style="word-break: break-all;">{$descripcion}</td>
                                            <td>{number_format $precio,2,'.',','}</td>
                                            <td>{number_format $subtotal,2,'.',','}</td>
                                            <td class="text-center">
                                                {if $iva == 1 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input" id="TVcustomCheckInline7"
                                                                   type="checkbox" checked value="1"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline7"></label>
                                                        </div>
                                                    </div>
                                                {elseif $iva == 0 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   type="checkbox" value="1" id="TVcustomCheckInline8"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TVcustomCheckInline8"></label>
                                                        </div>
                                                    </div>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/loop}
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right">{number_format $datos.presupuesto.total_presupuesto_inicial,2,'.',','}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p class="display-5">{$datos.presupuesto.info_presupuesto.no_autorizado_por} indicó
                                    que {if $datos.presupuesto.info_presupuesto.que_hacer == 1} desea donar su equipo {else} pasará a recoger su equipo  {/if}
                                    a Pc Partners.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{/if}

{if $datos.proceso.revision_realizada == 0}
  {* <div class="row margin-bot">
      <div class="col-md-12">
          <p class="display-5">Aún no se realiza el proceso a este registro.</p>
      </div>
  </div> *}
{else}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#datos_proceso_{$datos.random_number}"
                     aria-expanded="false">
                    Proceso
                </div>
                <div class="collapse show" id="datos_proceso_{$datos.random_number}">
                    <div class="card-body">

                        {render_revision $datos.proceso}
                    </div>
                </div>

                <div class="card-footer text-muted">
                    <div class="text-center">Proceso realizado
                        por: {$datos.proceso.revision_info.nombre_usuario_creo}
                        el {date_format $datos.proceso.revision_info.created_at "%d/%m/%Y %l:%M %P"} </div>
                </div>
            </div>
        </div>
    </div>
{/if}



{if $datos.revision_final.revision_realizada == 0}
    <div class="row margin-bot">
        <div class="col-md-12">
            <p class="display-5">Aún no se realiza la revisión final a este registro.</p>
        </div>
    </div>
{else}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#datos_revision_final_{$datos.random_number}"
                     aria-expanded="false">
                    Revisión Final
                </div>
                <div class="collapse show" id="datos_revision_final_{$datos.random_number}">
                    <div class="card-body">
                        {render_revision $datos.revision_final}
                    </div>
                </div>

                <div class="card-footer text-muted">
                    <div class="text-center">Revisión Final realizada
                        por: {$datos.revision_final.revision_info.nombre_usuario_creo}
                        el {date_format $datos.revision_final.revision_info.created_at "%d/%m/%Y %l:%M %P"} </div>
                </div>
            </div>
        </div>
    </div>
{/if}
