{include 'vista_datos_generales.tpl' }

{if $datos.revision_realizada == 0}
    <form autocomplete="off" id="form-revision-final"
          data-id-registro="{$datos.id_registro}">
        <div class="row">
            <div class="col-md-12">
                <div class="card border-success">
                    <div class="card-header text-center bg-success text-white">
                        Revisión Final
                    </div>
                    <div class="card-body">
                        {include 'render_revision.tpl'}
                    </div>
                    <div class="card-footer text-muted">
                        <button class="btn btn-success float-right" type="submit" role="button">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
{else}
    <div class="row">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#datos_revision_final_{$datos.random_number}"
                     aria-expanded="false">
                    Revisión Final
                </div>
                <div class="collapse show" id="datos_revision_final_{$datos.random_number}">
                    <div class="card-body">
                        {include 'render_revision.tpl'}
                    </div>
                </div>

                <div class="card-footer text-muted">
                    <div class="text-center">Revisión Final realizada
                        por: {$datos.revision_info.nombre_usuario_creo}
                        el {date_format $datos.revision_info.created_at "%d/%m/%Y %l:%M %P"} </div>
                </div>
            </div>
        </div>
    </div>
{/if}


