{include 'vista_datos_generales.tpl' }

{if $datos.status_presupuesto == 0}
    {*Sin Presupuesto*}
    <form autocomplete="off" id="form-presupuesto-inicial"
          data-id-registro="{$datos.id_registro}" data-correo-cliente="{$datos.correo_cliente}"
          data-correo-contacto="{$datos.correo_contacto}">
        <div class="row">
            <div class="col-md-12">
                <div class="card border-success">
                    <div class="card-header text-center bg-success text-white">
                        Presupuesto
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-check form-check-inline">
                                    <div class="custom-control custom-checkbox custom-control-inline">
                                        <input class="custom-control-input sin_servicio_checkbox"
                                               id="TPcustomCheckInline1" type="checkbox"
                                               value="1">
                                        <label class="custom-control-label" for="TPcustomCheckInline1">Sin
                                            Servicio</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row margin-bot">
                            <div class="col-md-1">
                                <div class="form-group">
                                    <label class="col-form-label">Cantidad</label>
                                    <div>
                                        <input type="text" class="form-control cantidad_presupuesto"
                                               data-validation="number" data-validation-allowing="float"
                                               data-validation-optional="true"
                                               data-validation-error-msg="Agrega una cantidad válida.">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="col-form-label">Tipo</label>
                                    <div>
                                        <select class="custom-select tipo_presupuesto">
                                            <option value="" selected hidden>Selecciona un tipo</option>
                                            <option value="1">Pieza</option>
                                            <option value="2" class="tipo_servicio_presupuesto">Servicio</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-form-label">Descripción</label>
                                    <div>
                                        <textarea rows="1" class="form-control descripcion_presupuesto"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="col-form-label">Precio Unitario</label>
                                    <div>
                                        <input type="text" class="form-control precio_presupuesto"
                                               data-validation="number" data-validation-allowing="float"
                                               data-validation-optional="true"
                                               data-validation-error-msg="Ingresa una cantidad correcta">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1">
                                <label class="col-form-label">Agregar</label>
                                <button type="button" class="btn btn-success agregar_entity_presupuesto"
                                        role="button">Agregar
                                </button>
                            </div>
                        </div>

                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-entities-presupuesto table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td class="text-right">Precio Unitario</td>
                                        <td class="text-right">Subtotal</td>
                                        <td>IVA</td>
                                        <td>Eliminar</td>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right total_presupuesto"></td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer text-muted">
                        <button class="btn btn-success float-right" type="submit" role="button">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
{elseif $datos.status_presupuesto == 1}
    {*Presupuesto Realizado, seleccionar autorizado o no autorizado*}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white">
                    Presupuesto
                    Inicial {if $datos.info_presupuesto.created_at != $datos.info_presupuesto.updated_at} | Última vez editado por {$datos.info_presupuesto.nombre_usuario_edito} el {date_format $datos.info_presupuesto.updated_at "%d/%m/%Y %l:%M %P"} {/if}
                </div>
                <div class="card-body">
                    <div class="row show_on_editing" style="display: none;">
                        <div class="col-md-12">
                            <div class="form-check form-check-inline">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input class="custom-control-input sin_servicio_checkbox_editando"
                                           id="TPcustomCheckInline2" type="checkbox"
                                           value="1">
                                    <label class="custom-control-label" for="TPcustomCheckInline2">Sin
                                        Servicio</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row margin-bot show_on_editing" style="display: none;">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="col-form-label">Cantidad</label>
                                <div>
                                    <input type="text" class="form-control cantidad_presupuesto_editando">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Tipo</label>
                                <div>
                                    <select class="custom-select tipo_presupuesto_editando">
                                        <option value="" selected hidden>Selecciona un tipo</option>
                                        <option value="1">Pieza</option>
                                        <option value="2" class="tipo_servicio_presupuesto_editando">Servicio</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-form-label">Descripción</label>
                                <div>
                                    <textarea rows="1" class="form-control descripcion_presupuesto_editando"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Precio Unitario</label>
                                <div>
                                    <input type="text" class="form-control precio_presupuesto_editando">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label class="col-form-label">Agregar</label>
                            <button type="button" class="btn btn-success agregar_entity_presupuesto_editando"
                                    role="button">Agregar
                            </button>
                        </div>
                    </div>

                    <div class="row margin-bot">
                        <div class="col-md-12">
                            <table class="table table-sm table-hover table-bordered table-striped editable_table_presupuesto">
                                <thead class="bg-faded">
                                <tr>
                                    <td>Tipo</td>
                                    <td>Cantidad</td>
                                    <td>Descripción</td>
                                    <td class="text-right">Precio Unitario</td>
                                    <td class="text-right">Subtotal</td>
                                    <td>IVA</td>
                                    <td class="show_on_editing" style="display: none;">Eliminar</td>
                                </tr>
                                </thead>
                                <tbody>
                                {loop $datos.presupuesto}
                                    <tr class="entity_presupuesto_editando" data-id-dato="{$id_dato}">
                                        <td class="entity_presupuesto_tipo_editando"
                                            data-tipo-presupuesto="{$tipo}  ">{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                        <td class="text-right entity_presupuesto_cantidad_editando">{$cantidad}</td>
                                        <td class="entity_presupuesto_descripcion_editando"
                                            style="word-break: break-all;">{$descripcion}</td>
                                        <td class="text-right entity_presupuesto_precio_editando"
                                            data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                                        <td class="text-right entity_presupuesto_subtotal_editando"
                                            data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                                        <td class="text-center">
                                            {if $iva == 1 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_editando"
                                                               type="checkbox" checked value="1"
                                                               id="TPcustomCheckInline3"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline3"></label>
                                                    </div>
                                                </div>
                                            {elseif $iva == 0 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_editando"
                                                               type="checkbox" value="1" id="TPcustomCheckInline4"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline4"></label>
                                                    </div>
                                                </div>
                                            {/if}
                                        </td>
                                        <td class="show_on_editing eliminar_entity_presupuesto_editando text-center text-danger cursor-pointer"
                                            style="display: none;">Eliminar
                                        </td>
                                    </tr>
                                {/loop}
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="4" class="text-center">Total</td>
                                    <td class="text-right total_presupuesto_editando">{number_format $datos.total_presupuesto,2,'.',','}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="deleted_entities_presupuesto"></div>
                <div class="card-footer text-muted">
                    <button class="btn btn-success float-right editar_presupuesto" type="button" role="button"
                            data-id-registro="{$datos.id_registro}" data-id-presupuesto="{$datos.id_presupuesto}">Editar
                    </button>
                    <button class="btn btn-success guardar_edicion_presupuesto show_on_editing float-right"
                            data-id-registro="{$datos.id_registro}" data-id-presupuesto="{$datos.id_presupuesto}"
                            style=" display:none;"
                            role="button" type="button">Guardar
                    </button>
                    <button class="btn btn-danger cancelar_edicion_presupuesto show_on_editing float-right"
                            style="display:none; margin-right: 5px;" role="button" type="button">Cancelar
                    </button>
                    <button class="btn btn-primary float-right enviar_presupuesto_inicial" style="margin-right: 5px;"
                            type="button" role="button" data-id-registro="{$datos.id_registro}"
                            data-correo-cliente="{$datos.correo_cliente}"
                            data-id-cliente="{$datos.id_cliente}"
                            data-correo-contacto="{$datos.correo_contacto}">Enviar
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white">
                    Seguimiento Presupuesto
                </div>
                <div class="card-body">
                    <div class="row seleccion_presupuesto_container">
                        <div class="col-md-12">
                            <p class="font-weight-bold">Presupuesto Autorizado</p>
                            <div class="form-check form-check-inline">
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input name="radio_seleccion_presupuesto" id="TPcustomRadioInline1" type="radio"
                                           class="custom-control-input" value="1">
                                    <label class="custom-control-label" for="TPcustomRadioInline1">Si</label>
                                </div>
                            </div>
                            <div class="form-check form-check-inline">
                                <div class="custom-control custom-radio custom-control-inline">
                                    <input name="radio_seleccion_presupuesto" type="radio" id="TPcustomRadioInline2"
                                           class="custom-control-input" value="2">
                                    <label class="custom-control-label" for="TPcustomRadioInline2">No</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row show_on_autorizando" style="display: none;">
                        <div class="col-md-12">
                            <div class="form-check form-check-inline">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input class="custom-control-input sin_servicio_checkbox_autorizando"
                                           type="checkbox"
                                           id="TPcustomCheckInline5"
                                           value="1">
                                    <label class="custom-control-label" for="TPcustomCheckInline5">Sin Servicio</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row margin-bot show_on_autorizando" style="display: none;">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="col-form-label">Cantidad</label>
                                <div>
                                    <input type="text" class="form-control cantidad_presupuesto_autorizando">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Tipo</label>
                                <div>
                                    <select class="custom-select tipo_presupuesto_autorizando">
                                        <option value="" selected hidden>Selecciona un tipo</option>
                                        <option value="1">Pieza</option>
                                        <option value="2" class="tipo_servicio_presupuesto_autorizando">Servicio
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-form-label">Descripción</label>
                                <div>
                                    <textarea rows="1"
                                              class="form-control descripcion_presupuesto_autorizando"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Precio Unitario</label>
                                <div>
                                    <input type="text" class="form-control precio_presupuesto_autorizando">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label class="col-form-label">Agregar</label>
                            <button type="button" class="btn btn-success agregar_entity_presupuesto_autorizando"
                                    role="button">Agregar
                            </button>
                        </div>
                    </div>

                    <div class="row margin-bot show_on_autorizando" style="display: none;">
                        <div class="col-md-12">
                            <table class="table table-sm table-hover table-bordered table-striped autorizando_table_presupuesto">
                                <thead class="bg-faded">
                                <tr>
                                    <td>Tipo</td>
                                    <td>Cantidad</td>
                                    <td>Descripción</td>
                                    <td class="text-right">Precio Unitario</td>
                                    <td class="text-right">Subtotal</td>
                                    <td>IVA</td>
                                    <td class="show_on_autorizando" style="display: none;">Eliminar</td>
                                </tr>
                                </thead>
                                <tbody>
                                {loop $datos.presupuesto}
                                    <tr class="entity_presupuesto_autorizando" data-id-dato="{$id_dato}" data-nuevo="1">
                                        <td class="entity_presupuesto_tipo_autorizando"
                                            data-tipo-presupuesto="{$tipo}  ">{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                        <td class="text-right entity_presupuesto_cantidad_autorizando">{$cantidad}</td>
                                        <td class="entity_presupuesto_descripcion_autorizando"
                                            style="word-break: break-all;">{$descripcion}</td>
                                        <td class="text-right entity_presupuesto_precio_autorizando"
                                            data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                                        <td class="text-right entity_presupuesto_subtotal_autorizando"
                                            data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                                        <td class="text-center">
                                            {if $iva == 1 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_autorizando"
                                                               type="checkbox" checked value="1"
                                                               id="TPcustomCheckInline6"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline6"></label>
                                                    </div>
                                                </div>
                                            {elseif $iva == 0 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva_autorizando"
                                                               type="checkbox" value="1" id="TPcustomCheckInline7"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline7"></label>
                                                    </div>
                                                </div>
                                            {/if}
                                        </td>
                                        <td class="show_on_autorizando eliminar_entity_presupuesto_autorizando text-center text-danger cursor-pointer"
                                            style="display: none;">Eliminar
                                        </td>
                                    </tr>
                                {/loop}
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="4" class="text-center">Total</td>
                                    <td class="text-right total_presupuesto_autorizando">{number_format $datos.total_presupuesto,2,'.',','}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="row show_on_autorizando" style="display: none;">
                        <div class="col-md-4">
                            <div class="form-group required">
                                <label class="col-form-label">Autorizado por</label>
                                <div>
                                    <input type="text" class="form-control" name="autorizado_por"
                                           placeholder="Quién lo autorizó?">
                                </div>

                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group required">
                                <label class="col-form-label">Fecha Compromiso</label>
                                <div id="fecha_compromiso_container">
                                    <div class="input-group date">
                                        <input type='text' class="form-control fecha_compromiso_input"
                                               name="fecha_compromiso"
                                               data-validation="date"
                                               data-validation-format="dd/mm/yyyy"
                                               data-validation-error-msg="Selecciona la fecha de compromiso."/>
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group float-right">
                                <label class="col-form-label">Autorizar Presupuesto</label>
                                <div>
                                    <button class="btn btn-success guardar_presupuesto_autorizado" role="button"
                                            type="button" data-id-registro="{$datos.id_registro}"
                                            data-id-presupuesto="{$datos.id_presupuesto}">
                                        Guardar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row margin-bot show_on_no_autorizado" style="display: none;">
                        <div class="col-md-4">
                            <div class="form-group required">
                                <label class="col-form-label">Qué desea hacer?</label>
                                <div>
                                    <div class="form-check form-check-inline">
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input name="radio_seleccion_que_hacer" type="radio"
                                                   id="TPcustomRadioInline3"
                                                   class="custom-control-input" value="1">
                                            <label class="custom-control-label" for="TPcustomRadioInline3">Donar</label>
                                        </div>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <div class="custom-control custom-radio custom-control-inline">
                                            <input name="radio_seleccion_que_hacer" type="radio"
                                                   id="TPcustomRadioInline4"
                                                   class="custom-control-input" value="2">
                                            <label class="custom-control-label" for="TPcustomRadioInline4">Pasar a
                                                Recoger</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group required">
                                <label class="col-form-label">No Autorizado por</label>
                                <div>
                                    <input type='text' class="form-control" name="no_autorizado_por"
                                           placeholder="No autorizó"/>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group float-right">
                                <br>
                                <div>
                                    <button class="btn btn-success guardar_presupuesto_no_utorizado" role="button"
                                            type="button" data-id-registro="{$datos.id_registro}"
                                            data-id-presupuesto="{$datos.id_presupuesto}">Guardar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
{elseif $datos.status_presupuesto == 2}
    {*Presupuesto Autorizado*}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white cursor-pointer" data-toggle="collapse"
                     data-target="#presupuesto_inicial_{$datos.random_number}"
                     aria-expanded="false">
                    Presupuesto
                    Inicial
                </div>
                <div class="collapse show" id="presupuesto_inicial_{$datos.random_number}">
                    <div class="card-body">
                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td class="text-right">Precio Unitario</td>
                                        <td class="text-right">Subtotal</td>
                                        <td>IVA</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {loop $datos.presupuesto_inicial}
                                        <tr>
                                            <td>{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                            <td>{$cantidad}</td>
                                            <td style="word-break: break-all;">{$descripcion}</td>
                                            <td class="text-right">{number_format $precio,2,'.',','}</td>
                                            <td class="text-right">{number_format $subtotal,2,'.',','}</td>
                                            <td class="text-center">
                                                {if $iva == 1 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   type="checkbox" checked value="1"
                                                                   id="TPcustomCheckInline8"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TPcustomCheckInline8"></label>
                                                        </div>
                                                    </div>
                                                {elseif $iva == 0 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   type="checkbox" value="1" id="TPcustomCheckInline9"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TPcustomCheckInline9"></label>
                                                        </div>
                                                    </div>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/loop}
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right">{number_format $datos.total_presupuesto_inicial,2,'.',','}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card border-success">
                <div class="card-header text-center bg-success text-white">
                    Presupuesto Autorizado creado por {$datos.info_presupuesto.nombre_usuario_ingreso_autorizacion}
                    el {date_format $datos.info_presupuesto.fecha_autorizado "%d/%m/%Y %l:%M %P"} {if $datos.info_presupuesto.updated_at != $datos.info_presupuesto.fecha_autorizado}
                        | Última vez modificado por {$datos.info_presupuesto.nombre_usuario_edito}
                        el {date_format $datos.info_presupuesto.updated_at "%d/%m/%Y %l:%M %P"} {/if}
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <p class="lead">Presupuesto Autorizado por {$datos.info_presupuesto.autorizado_por}</p>
                        </div>
                    </div>
                    <div class="row show_on_editar_autorizado" style="display: none;">
                        <div class="col-md-12">
                            <div class="form-check form-check-inline">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input class="custom-control-input sin_servicio_checkbox"
                                           type="checkbox" id="TPcustomCheckInline10"
                                           value="1">
                                    <label class="custom-control-label"
                                           for="TPcustomCheckInline10">Sin Servicio</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row margin-bot show_on_editar_autorizado" style="display: none;">
                        <div class="col-md-1">
                            <div class="form-group">
                                <label class="col-form-label">Cantidad</label>
                                <div>
                                    <input type="text" class="form-control cantidad_presupuesto">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Tipo</label>
                                <div>
                                    <select class="custom-select tipo_presupuesto">
                                        <option value="" selected hidden>Selecciona un tipo</option>
                                        <option value="1">Pieza</option>
                                        <option value="2" class="tipo_servicio_presupuesto">Servicio
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-form-label">Descripción</label>
                                <div>
                                    <textarea rows="1"
                                              class="form-control descripcion_presupuesto"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="col-form-label">Precio Unitario</label>
                                <div>
                                    <input type="text" class="form-control precio_presupuesto">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <label class="col-form-label">Agregar</label>
                            <button type="button" class="btn btn-success agregar_entity_presupuesto"
                                    role="button">Agregar
                            </button>
                        </div>
                    </div>

                    <div class="row margin-bot">
                        <div class="col-md-12">
                            <table class="table table-sm table-hover table-bordered table-striped table-entities-presupuesto">
                                <thead class="bg-faded">
                                <tr>
                                    <td>Tipo</td>
                                    <td>Cantidad</td>
                                    <td>Descripción</td>
                                    <td class="text-right">Precio Unitario</td>
                                    <td class="text-right">Subtotal</td>
                                    <td>IVA</td>
                                    <td class="show_on_editar_autorizado" style="display: none;">Eliminar</td>
                                </tr>
                                </thead>
                                <tbody>
                                {loop $datos.presupuesto}
                                    <tr class="entity_presupuesto" data-id-dato="{$id_dato}">
                                        <td class="entity_presupuesto_tipo"
                                            data-tipo-presupuesto="{$tipo}  ">{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                        <td class="text-right entity_presupuesto_cantidad">{$cantidad}</td>
                                        <td class="entity_presupuesto_descripcion"
                                            style="word-break: break-all;">{$descripcion}</td>
                                        <td class="text-right entity_presupuesto_precio"
                                            data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                                        <td class="text-right entity_presupuesto_subtotal"
                                            data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                                        <td class="text-center">
                                            {if $iva == 1 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva"
                                                               type="checkbox" checked value="1"
                                                               id="TPcustomCheckInline11"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline11"></label>
                                                    </div>
                                                </div>
                                            {elseif $iva == 0 AND $tipo == 1}
                                                <div class="form-check form-check-inline">
                                                    <div class="custom-control custom-checkbox custom-control-inline">
                                                        <input class="custom-control-input entity_presupuesto_iva"
                                                               type="checkbox" value="1" id="TPcustomCheckInline12"
                                                               onclick="this.checked=!this.checked;">
                                                        <label class="custom-control-label"
                                                               for="TPcustomCheckInline12"></label>
                                                    </div>
                                                </div>
                                            {/if}
                                        </td>
                                        <td class="show_on_editar_autorizado eliminar_entity_presupuesto text-center text-danger cursor-pointer"
                                            style="display: none;">Eliminar
                                        </td>
                                    </tr>
                                {/loop}
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="4" class="text-center">Total</td>
                                    <td class="text-right total_presupuesto">{number_format $datos.total_presupuesto,2,'.',','}</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="deleted_entities_presupuesto"></div>
                <div class="card-footer text-muted">
                    <button class="btn btn-success float-right editar_presupuesto_autorizado" type="button"
                            role="button"
                            data-id-registro="{$datos.id_registro}" data-id-presupuesto="{$datos.id_presupuesto}">Editar
                    </button>
                    <button class="btn btn-success guardar_edicion_presupuesto_autorizado show_on_editar_autorizado float-right"
                            data-id-registro="{$datos.id_registro}" data-id-presupuesto="{$datos.id_presupuesto}"
                            style=" display:none;"
                            role="button" type="button">Guardar
                    </button>
                    <button class="btn btn-danger cancelar_edicion_presupuesto_autorizado show_on_editar_autorizado float-right"
                            style="display:none; margin-right: 5px;" role="button" type="button">Cancelar
                    </button>
                    <button class="btn btn-primary float-right enviar_presupuesto_autorizado" style="margin-right: 5px;"
                            type="button" role="button" data-id-registro="{$datos.id_registro}"
                            data-correo-cliente="{$datos.correo_cliente}"
                            data-id-cliente="{$datos.id_cliente}"
                            data-correo-contacto="{$datos.correo_contacto}">Enviar
                    </button>
                </div>
            </div>
        </div>
    </div>
{elseif $datos.status_presupuesto == 3}
    {*Presupuesto No Autorizado*}
    <div class="row margin-bot">
        <div class="col-md-12">
            <div class="card border-danger">
                <div class="card-header text-center bg-danger text-white cursor-pointer" data-toggle="collapse"
                     data-target="#presupuesto_no_autorizado_{$datos.random_number}"
                     aria-expanded="false">
                    Presupuesto
                    No Autorizado
                </div>
                <div class="collapse show" id="presupuesto_no_autorizado_{$datos.random_number}">
                    <div class="card-body">
                        <div class="row margin-bot">
                            <div class="col-md-12">
                                <table class="table table-sm table-hover table-bordered table-striped">
                                    <thead class="bg-faded">
                                    <tr>
                                        <td>Tipo</td>
                                        <td>Cantidad</td>
                                        <td>Descripción</td>
                                        <td class="text-right">Precio Unitario</td>
                                        <td class="text-right">Subtotal</td>
                                        <td>IVA</td>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {loop $datos.presupuesto_inicial}
                                        <tr>
                                            <td>{if $tipo == 1} Pieza {else}Servicio {/if}</td>
                                            <td>{$cantidad}</td>
                                            <td style="word-break: break-all;">{$descripcion}</td>
                                            <td class="text-right">{number_format $precio,2,'.',','}</td>
                                            <td class="text-right">{number_format $subtotal,2,'.',','}</td>
                                            <td class="text-center">
                                                {if $iva == 1 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   id="TPcustomCheckInline13"
                                                                   type="checkbox" checked value="1"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TPcustomCheckInline13"></label>
                                                        </div>
                                                    </div>
                                                {elseif $iva == 0 AND $tipo == 1}
                                                    <div class="form-check form-check-inline">
                                                        <div class="custom-control custom-checkbox custom-control-inline">
                                                            <input class="custom-control-input"
                                                                   id="TPcustomCheckInline14"
                                                                   type="checkbox" value="1"
                                                                   onclick="this.checked=!this.checked;">
                                                            <label class="custom-control-label"
                                                                   for="TPcustomCheckInline14"></label>
                                                        </div>
                                                    </div>
                                                {/if}
                                            </td>
                                        </tr>
                                    {/loop}
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td colspan="4" class="text-center">Total</td>
                                        <td class="text-right">{number_format $datos.total_presupuesto_inicial,2,'.',','}</td>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p class="display-5">{$datos.info_presupuesto.no_autorizado_por} indicó
                                    que {if $datos.info_presupuesto.que_hacer == 1} desea donar su equipo {else} pasará a recoger su equipo  {/if}
                                    a Pc Partners.</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
{/if}
