<html lang="es">
<head>
    <meta charset="utf-8"/>
    <title>Table Style</title>
    <meta name="viewport" content="initial-scale=1.0; maximum-scale=1.0; width=device-width;">
    <style>
        @import url(http://fonts.googleapis.com/css?family=Roboto:400,500,700,300,100);

        body {
            background-color: #3e94ec;
            font-family: "Roboto", helvetica, arial, sans-serif;
            font-size: 13px;
            font-weight: 400;
            text-rendering: optimizeLegibility;
        }

        div.table-title {
            display: block;
            margin: auto;
            max-width: 600px;
            padding: 5px;
            width: 100%;
        }

        .table-title h3 {
            color: #fafafa;
            font-size: 20px;
            font-weight: 400;
            font-style: normal;
            font-family: "Roboto", helvetica, arial, sans-serif;
            text-shadow: -1px -1px 1px rgba(0, 0, 0, 0.1);
            text-transform: uppercase;
        }

        .table-fill {
            background: white;
            border-radius: 3px;
            border-collapse: collapse;
            height: 320px;
            margin: auto;
            max-width: 600px;
            padding: 5px;
            width: 100%;
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1);
            animation: float 5s infinite;
        }

        th {
            color: #D5DDE5;
            background: #1b1e24;
            border-bottom: 4px solid #9ea7af;
            border-right: 1px solid #343a45;
            font-size: 15px;
            font-weight: 100;
            padding: 12px;
            text-align: left;
            text-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
            vertical-align: middle;
        }

        th:first-child {
            border-top-left-radius: 3px;
        }

        th:last-child {
            border-top-right-radius: 3px;
            border-right: none;
        }

        tr {
            border-top: 1px solid #C1C3D1;
            border-bottom-: 1px solid #C1C3D1;
            color: #666B85;
            font-size: 13px;
            font-weight: normal;
            text-shadow: 0 1px 1px rgba(256, 256, 256, 0.1);
        }

        tr:first-child {
            border-top: none;
        }

        tr:last-child {
            border-bottom: none;
        }

        tr:nth-child(odd) td {
            background: #EBEBEB;
        }

        tr:last-child td:first-child {
            border-bottom-left-radius: 3px;
        }

        tr:last-child td:last-child {
            border-bottom-right-radius: 3px;
        }

        td {
            background: #FFFFFF;
            padding: 10px;
            text-align: left;
            vertical-align: middle;
            font-weight: 300;
            font-size: 13px;
            text-shadow: -1px -1px 1px rgba(0, 0, 0, 0.1);
            border-right: 1px solid #C1C3D1;
        }

        td:last-child {
            border-right: 0px;
        }

        th.text-left {
            text-align: left;
        }

    </style>
<body style="background-color: #3e94ec; padding-top:20px; padding-bottom:20px;">
<div class="table-title">
    <h3 style="text-align:center;">Solicitud de Factura por: {$datos.nombre_usuario}</h3>
</div>
<table class="table-fill">
    <thead>
    <tr>
        <th class="text-left">Dato</th>
        <th class="text-left">Valor</th>
    </tr>
    </thead>
    <tbody class="table-hover">
    <tr>
        <td class="text-left">Nombre</td>
        <td class="text-left">{$datos.nombre_cliente}</td>
    </tr>
    <tr>
        <td class="text-left">RFC</td>
        <td class="text-left">{$datos.rfc}</td>
    </tr>
    {if $datos.curp}
        <tr>
            <td class="text-left">CURP</td>
            <td class="text-left">{$datos.curp}</td>
        </tr>
    {/if}
    <tr>
        <td class="text-left">Calle y Número</td>
        <td class="text-left">{$datos.calle}</td>
    </tr>
    <tr>
        <td class="text-left">Colonia</td>
        <td class="text-left">{$datos.colonia}</td>
    </tr>
    <tr>
        <td class="text-left">Código Postal</td>
        <td class="text-left">{$datos.cp}</td>
    </tr>
    <tr>
        <td class="text-left">Ciudad</td>
        <td class="text-left">{$datos.ciudad}</td>
    </tr>
    <tr>
        <td class="text-left">Estado</td>
        <td class="text-left">{$datos.estado}</td>
    </tr>
    <tr>
        <td class="text-left">Concepto</td>
        <td class="text-left">{$datos.concepto}</td>
    </tr>
    <tr>
        <td class="text-left">Cantidad (Precio sin IVA)</td>
        <td class="text-left">{number_format $datos.cantidad,2,'.',','}</td>
    </tr>
    <tr>
        <td class="text-left">Método de pago y últimos 4 dígitos</td>
        <td class="text-left">{$datos.rfc}</td>
    </tr>
    <tr>
        <td class="text-left">Teléfono</td>
        <td class="text-left">{$datos.telefono}</td>
    </tr>
    <tr>
        <td class="text-left">Email</td>
        <td class="text-left">{$datos.email}</td>
    </tr>
    {if $datos.email1}
        <tr>
            <td class="text-left">Email Alternativo</td>
            <td class="text-left">{$datos.email1}</td>
        </tr>
    {/if}
    {if $datos.email2}
        <tr>
            <td class="text-left">Email Alternativo</td>
            <td class="text-left">{$datos.email2}</td>
        </tr>
    {/if}
    {if $datos.observaciones}
        <tr>
            <td class="text-left">Observaciones</td>
            <td class="text-left">{$datos.observaciones}</td>
        </tr>
    {/if}


    </tbody>
</table>
</body>
</html>