<div class="card m-5 round shadow-lg">
  <div class="card-body">
    <div class="autorizado">
      {if !$datos.idServicio}
        <p>
          El token ya no es válido
        </p>
      {else}
        {if $datos.autorizado}
          <p>
            Servicio autorizado desde el correo <b><em>{$datos.autorizadoPor}</em></b>.
          </p>
          <p>
            El {$datos.fecha}.
          </p>
        {else}
          <p>
            Gracias por autorizar el servicio <b>{$datos.folio}</b>
          </p>
        {/if}
      {/if}
    </div>
  </div>
</div>
{if $datos.idServicio and !$datos.encuesta}
  <div class="card w-50 p-2 round mx-auto mb-5 border-success collapse show" id="encuestaPanel">
    <h2 class="text-center">Encuesta de servicio</h2>
    <div class="card-body">
      <form id="encuestaForm">
        <input name="folioServicio" type="hidden" value="{$datos.folio}">
        <input name="idServicio" type="hidden" value="{$datos.idServicio}">
        <div class="form-group">
          <!-- Comentario abierto -->
          <label>Observaciones, comentarios o sugerencias:</label>
          <textarea name="observaciones" class="form-control" rows="3"></textarea>
          <!-- . -->
        </div>
        <!-- Evalua servicio -->
        Considera que el servicio prestado fue:
        <div class="d-flex justify-content-around m-3">
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="servicio" id="servicioExcelente" value="excelente">
            <label class="form-check-label" for="servicioExcelente">Excelente</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="servicio" id="servicioBueno" value="bueno">
            <label class="form-check-label" for="servicioBueno">Bueno</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="servicio" id="servicioRegular" value="regular">
            <label class="form-check-label" for="servicioRegular">Regular</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="servicio" id="servicioMalo" value="malo">
            <label class="form-check-label" for="servicioMalo">Malo</label>
          </div>
        </div>
        <!-- . -->
        <!-- Evalua persona -->
        La capacidad técnica del personal fue:
        <div class="d-flex justify-content-around m-3">
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="personal" id="personalExcelente" value="excelente">
            <label class="form-check-label" for="personalExcelente">Excelente</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="personal" id="personalBueno" value="bueno">
            <label class="form-check-label" for="personalBueno">Bueno</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="personal" id="personalRegular" value="regular">
            <label class="form-check-label" for="personalRegular">Regular</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="personal" id="personalMalo" value="malo">
            <label class="form-check-label" for="personalMalo">Malo</label>
          </div>
        </div>
        <!-- . -->
        <!-- Evalua amabilidad y disposición -->
        La amabilidad y disposición del personal fue:
        <div class="d-flex justify-content-around m-3">
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="amabilidad" id="amabilidadExcelente" value="excelente">
            <label class="form-check-label" for="amabilidadExcelente">Excelente</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="amabilidad" id="amabilidadBueno" value="bueno">
            <label class="form-check-label" for="amabilidadBueno">Bueno</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="amabilidad" id="amabilidadRegular" value="regular">
            <label class="form-check-label" for="amabilidadRegular">Regular</label>
          </div>
          <div class="form-group form-check-inline">
            <input class="form-check-input" type="radio" name="amabilidad" id="amabilidadMalo" value="malo">
            <label class="form-check-label" for="amabilidadMalo">Malo</label>
          </div>
        </div>
        <input type="hidden" name="cliente" value="{$datos.cliente}">
        <input type="hidden" name="tecnico" value="{$datos.tecnico}">
        <input type="hidden" name="detalle" value="{$datos.detalle}">
        <!-- . -->
        <div>
          <button id="btnCont" type="submit" class="btn btn-success">Enviar encuesta</button>
        </div>
      </form>
    </div>
  </div>
  <div id="encuestaTerminada" class="card w-50 p-2 round mx-auto mb-5 border-success collapse">
    <div class="card-body text-center text-success">
      <div>
        <i class="fas fa-check-circle fa-10x"></i>
      </div>
      <div>
        ¡Gracias!
      </div>
    </div>
  </div>
{/if}
<style>
  .autorizado {
    font-size: 20pt;
    text-align: center;
  }

  .round {
    border-radius: 1.25rem;
  }
</style>
<script>
  (function() {
    window.history.pushState(null, document.title, '/');
    document.getElementById('encuestaForm').addEventListener('submit', (e) => {
      e.preventDefault();
      const BTN = jQuery('#btnCont');
      BTN.partnersBtnControl('start');

      const form = document.getElementById('encuestaForm');
      const DATA = {
        observaciones: form['observaciones'].value,
        servicio: form['servicio'].value,
        personal: form['personal'].value,
        amabilidad: form['amabilidad'].value,
        folioServicio: form['folioServicio'].value,
        idServicio: form['idServicio'].value,
        cliente: form['cliente'].value,
        tecnico: form['tecnico'].value,
        detalle: form['detalle'].value,
      }
      console.table(DATA);
      fetch('/servicios/encuesta', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'accept': 'application/json'
          },
          body: JSON.stringify(DATA),
        })
        .then(res => {
          console.log(res.json());
          jQuery('#encuestaPanel').collapse('hide');
          jQuery('#encuestaTerminada').collapse('show');
          BTN.partnersBtnControl('end');
        })
        .catch(err => {
          console.error(err.message);
          BTN.partnersBtnControl('end');
        });
    });
  }());
</script>