<form id="nueva_renovacion_form" autocomplete="off">
    <div class="form-group row required">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Cliente</label>
            {include "../system/buscador_clientes.tpl"}
        </div>
    </div>

    <div class="form-group row required">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Clasificación</label><br>
            <select class="custom-select" name="tipo_renovacion" data-validation="required"
                    data-validation-error-msg="Selecciona un tipo de renovación.">
                <option value="" hidden selected>Selecciona</option>
                {loop $datos}
                    <option value="{$tid}">{$name}</option>
                {/loop}
            </select>
        </div>
    </div>
    <div class="form-group row required">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Producto, Servicio o Dominio</label><br>
            <input type="text" class="form-control" name="producto_renovacion" data-validation="required"
                   data-validation-error-msg="Ingresa ya sea un producto, servicio o dominio.">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Detalle</label><br>
            <textarea class="form-control" rows="2" name="detalle_producto_renovacion"
                      placeholder="Serie Contpaq, Licencia NOD32, Periodo, etc."></textarea>
        </div>
    </div>
    <div class="form-group row required">
        <div class="col-md-4 col-sm-12" id="fecha-renovacion-container">
            <label class="font-weight-bold col-form-label">Fecha Renovación</label> <br>
            <div class="input-group date">
                <input type="text" class="form-control fecha_renovacion_input"/>
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                </div>
            </div>
        </div>
        <div class="col-md-5 col-sm-12">
            <label class="font-weight-bold col-form-label">Frecuencia Renovación</label><br>
            <div class="input-group">
                <div class="input-group-prepend">
                    <span class="input-group-text">Cada</span>
                </div>
                <input type="text" class="form-control input_frecuencia" data-validation="number"
                       data-validation-error-msg="Ingresa un número correcto.">
                <div>
                    <select class="custom-select select_frecuencia">
                        <option value="WEEKLY">Semana(s)</option>
                        <option value="MONTHLY">Mes(s)</option>
                        <option value="YEARLY">Año(s)</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row required">
        <div class="col-md-3 col-sm-12">
            <label class="font-weight-bold col-form-label">Precio</label><br>
            <input type="text" class="form-control text-right" name="precio_producto_renovacion"
                   data-validation="number"
                   data-validation-allowing="float"
                   data-sanitize="numberFormat"
                   data-sanitize-number-format="0,0.00"
                   data-validation-error-msg="Ingresa el precio de la renovación.">
        </div>
    </div>
    <div class="form-group row">
        <div class="col-md-10 col-sm-12">
            <label class="font-weight-bold col-form-label">Observaciones</label><br>
            <textarea class="form-control" rows="2" name="notas_internas"
                      placeholder="Alguna observación interna."></textarea>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success float-right" type="submit" role="button">Guardar</button>
        </div>
    </div>
</form>