<form id="nueva_cotizacion_proyecto_form" autocomplete="off" data-user-email="{$datos.email_user}">
    <div class="form-group row required">
        <div class="col-md-10 col-sm-12">
            <label class="col-form-label font-weight-bold">Cliente</label>
            {include "../system/buscador_clientes.tpl"}
        </div>
    </div>

    <div class="row margin-bot">
        <div class="col-md-1">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Cantidad</label>
                <div>
                    <input type="text" class="form-control cantidad_cotizacion_proyecto"
                           data-validation="number" data-validation-allowing="float"
                           data-validation-optional="true"
                           data-validation-error-msg="Agrega una cantidad válida.">
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Tipo</label>
                <div>
                    <select name="tipo_entity_cotizacion_proyecto" data-validation="required"
                            data-validation-error-msg="Selecciona un tipo" class="custom-select">
                        <option value="" hidden selected>Selecciona un tipo</option>
                        <option value="1">Pieza</option>
                        <option value="2">Servicio</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Descripción</label>
                <div>
                    <textarea rows="1" class="form-control descripcion_cotizacion_proyecto"></textarea>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="form-group">
                <label class="col-form-label font-weight-bold">Precio Unitario</label>
                <div>
                    <input type="text" class="form-control precio_cotizacion_proyecto"
                           data-validation="number" data-validation-allowing="float"
                           data-validation-optional="true"
                           data-validation-error-msg="Ingresa una cantidad correcta">
                </div>
            </div>
        </div>
        <div class="col-md-1">
            <label class="col-form-label font-weight-bold">Agregar</label>
            <button type="button" class="btn btn-success agregar_entity_cotizacion_proyecto"
                    role="button">Agregar
            </button>
        </div>
    </div>

    <div class="row margin-bot">
        <div class="col-md-12">
            <table class="table table-entities-cotizacion-proyecto table-sm table-hover table-bordered table-striped">
                <thead class="bg-faded">
                <tr>
                    <td class="font-weight-bold">Cantidad</td>
                    <td class="font-weight-bold">Tipo</td>
                    <td class="font-weight-bold">Descripción</td>
                    <td class="text-right font-weight-bold">Precio Unitario</td>
                    <td class="text-right font-weight-bold">Subtotal</td>
                    <td class="font-weight-bold text-right">Eliminar</td>
                </tr>
                </thead>
                <tbody></tbody>
                <tfoot>
                <tr>
                    <td colspan="4" class="text-center font-weight-bold">Total</td>
                    <td class="text-right total_cotizacion_proyecto"></td>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>


    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Sumatoria</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="sin_sumatoria_proyecto" type="radio" id="CotPcustomRadioInline1"
                           class="custom-control-input " value="0"
                           data-validation="required"
                           data-validation-error-msg="Indica si los precios llevan sumatoria o no.">
                    <label class="custom-control-label" for="CotPcustomRadioInline1">Si</label>
                </div>
            </div>
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="sin_sumatoria_proyecto" type="radio" id="CotPcustomRadioInline2"
                           class="custom-control-input" value="1">
                    <label class="custom-control-label" for="CotPcustomRadioInline2">No</label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Precio con IVA incluido</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="cotizacion_iva_incluido_proyecto" type="radio" id="CotPcustomRadioInline3"
                           class="custom-control-input" value="1"
                           data-validation="required"
                           data-validation-error-msg="Indica si los precios llevan IVA incluido o no.">
                    <label class="custom-control-label" for="CotPcustomRadioInline3">Si</label>
                </div>
            </div>
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="cotizacion_iva_incluido_proyecto" type="radio" id="CotPcustomRadioInline4"
                           class="custom-control-input" value="0">
                    <label class="custom-control-label" for="CotPcustomRadioInline4">No</label>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Cotización Compartida</label>
        <div class="col-md-3 col-sm-6">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="radio_seleccion_cotizacion_compartida_proyecto" type="radio"
                           id="CotPcustomRadioInline5"
                           class="select_cotizacion_compartida_proyecto custom-control-input" value="1"
                           data-validation="required"
                           data-validation-error-msg="Indica si la cotización es compartida o no.">
                    <label class="custom-control-label" for="CotPcustomRadioInline5">Si</label>
                </div>
            </div>
            <div class="form-check form-check-inline">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="radio_seleccion_cotizacion_compartida_proyecto" type="radio"
                           id="CotPcustomRadioInline6"
                           class="select_cotizacion_compartida_proyecto custom-control-input" value="0">
                    <label class="custom-control-label" for="CotPcustomRadioInline6">No</label>
                </div>
            </div>
        </div>


        <div class="col-md-3 col-sm-6 cotizacion_compartida_container_proyecto" style="display: none;">
            <select class="custom-select cotizacion_compartida_con_proyecto"
                    data-validation="required"
                    data-validation-error-msg="Indica con quién compartiste la cotización.">
                <option value="" hidden selected>Selecciona</option>
                {loop $datos.usuarios}
                    <option value="{$uid}">{capitalize(lower($name))}</option>
                {/loop}
            </select>
        </div>
    </div>


    <div class="form-group row">
        <label class="col-md-2 col-sm-12 col-form-label">Notas</label>
        <div class="col-md-5 col-sm-10">
            <textarea name="notas_cotizacion_proyecto" class="form-control" rows="3"></textarea>
        </div>
    </div>

    <div class="form-group row">
        <label class="col-md-2 col-sm-12 col-form-label font-weight-bold">Texto extra Correo</label>
        <div class="col-md-5 col-sm-10">
            <div class="alert alert-info">*En caso de que necesites envíar información extra en el correo, puedes
                agregarla en el siguiente campo, y dicha información aparecerá en el cuerpo del correo.
            </div>
            <textarea name="texto_extra_correo_cotizacion" class="form-control" rows="3"></textarea>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success float-right" role="button" type="submit">Guardar</button>
        </div>
    </div>

</form>