<form autocomplete="off" id="servicio-adjunto-form">
    <div class="card card-outline-success">
        <div class="card-header text-center bg-success text-white">
            Factura <b>{$datos.folio_factura}</b> del cliente <b>{$datos.nombre_cliente}</b></div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <ul class="list-group files-in-zip-list">

                        {for i $datos.datos}
                            {if $datos.datos.$i.delete === true}
                                <li class="list-group-item list-group-item-action"><i
                                            class="fas fa-times-circle text-danger cursor-pointer eliminar_archivo_from_zip"
                                            data-index="{$i}"
                                            style="padding-right: 10px; font-size:20px;"
                                            aria-hidden="true"></i>{$datos.datos.$i.name} </li>
                            {else}
                                <li class="list-group-item list-group-item-action">{$datos.datos.$i.name} </li>
                            {/if}
                        {/for}
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <span class="lead">Adjuntar Archivo (.pdf):</span>

    <div class="row">
        <div class="col-md-8"><input type="file" accept="application/pdf" class="form-control"
                                     name="archivo_adjunto_servicio"></div>
    </div>

    <div class="row">
        <div class="col-md-12 my-2"><span class="lead">Enviar correos a:</span></div>
        <div class="col-md-12">
            <input type="text" class="emails_to_send_" value="{$datos.emails}">
        </div>
        <div class="col-md-12">
            <div class="form-check form-check-inline">
                <div class="custom-control custom-checkbox custom-control-inline">
                    <input class="custom-control-input enviarme_copia_correo_adjuntar"
                           type="checkbox" id="COBRcustomCheckInline1"
                           value="1" data-user-email="{$datos.user_email}">
                    <label class="custom-control-label" for="COBRcustomCheckInline1">Enviarme una copia.</label>
                </div>
              <div class="custom-control custom-checkbox custom-control-inline">
                <input class="custom-control-input"
                       type="checkbox" id="enviarConPagoTarjeta"
                       value="1" data-user-email="{$datos.user_email}">
                <label class="custom-control-label" for="enviarConPagoTarjeta">Con pago en tarjerta</label>
              </div>
            </div>
        </div>
        {if $datos.type_used_emails == 'comercial'}
            <div class="col-md-12">
                <div class="alert alert-warning">No se econtraron correos en el sistema interno para este cliente, se
                    usarán
                    los correos del Comercial.
                </div>
            </div>
        {elseif $datos.type_used_emails == 'sistema'}
            <div class="col-md-12">
                <div class="alert alert-info">Se encontraron contactos para facturación en el sistema, se usarán estos
                    correos y NO los del Comercial.
                </div>
            </div>
        {elseif $datos.type_used_emails == 'rfc_publico'}
            <div class="col-md-12">
                <div class="alert alert-warning">No se buscaron correos de este cliente por que tiene el RFC
                    XAXX010101000.
                </div>
            </div>
        {/if}
    </div>

    <div class="row">
        <div class="index_to_delete"></div>
        <div class="col-md-12 my-2">
            <button class="btn btn-success float-right" data-factura="{$datos.factura}"
                    data-codigo-cliente="{$datos.cod_cliente}" data-cliente-id="{$datos.id_cliente}" role="button" type="submit">Enviar
            </button>
        </div>
    </div>
</form>
