<div class="row margin-bot">
    <div class="col-md-6 col-sm-12">
        <div class="card">
            <div class="card-header text-center">
                Datos Generales
            </div>
            <div class="card-body">
                <div class="form-group row custom_form_group">
                    <label class="col-sm-3 "><b>Nombre de Cliente:</b></label>
                    <div class="col-sm-9">
                        <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="nombre_cliente"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.nombre_cliente}
                            </span>
                        </p>
                    </div>
                </div>
                {if $datos.cliente.tipo_cliente != 'Proveedor'}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Tipo de Empresa:</b></label>
                        <div class="col-sm-9">
                            <span class="editable-custom-tipo-empresa"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-values="{$datos.found_areas}"
                                  data-edit-column="tipo_negocio"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.negocio}
                            </span>
                        </div>
                    </div>
                {/if}
                <div class="form-group row custom_form_group">
                    <label class="col-sm-3 "><b>Giro de la Empresa:</b></label>
                    <div class="col-sm-9">
                        <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="giro_empresa"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.giro_empresa}</span>
                        </p>
                    </div>
                </div>

                {*Si es tipo_negocio = Negocio o Distribuidor, para hacer loop sin celular ni correo y
                mostrar página web*}
                {if $datos.tipo == 1 || $datos.tipo == 3 || $datos.tipo == 5}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Página Web:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <a href="{$datos.cliente.pagina_web}" target="_blank" class="editable-text-field"
                                   data-edit-id="{$datos.cliente.id_cliente}"
                                   data-edit-column="pagina_web"
                                   data-edit-table="partners_clientes"
                                   data-edit-table-key="id_cliente">{$datos.cliente.pagina_web}</a>
                            </p>
                        </div>
                    </div>
                    {loop $datos.datos}
                    {if $tipo_dato == 1}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Teléfono:</b> <i
                                        class="fas fa-plus-circle text-primary cursor-pointer float-right add_dato_extra"
                                        data-id-cliente="{$id_cliente}" data-type="phone" style="font-size:20px;"></i>
                            </label>
                            <div class="col-sm-9">
                                <p class="form-control-static editable-field">
                                    <a href="tel:{$dato_valor}" class="editable-text-field"
                                       data-edit-id="{$id_dato}"
                                       data-edit-column="dato_valor"
                                       data-edit-table="partners_clientes_datos"
                                       data-edit-table-key="id_dato">{$dato_valor}</a>
                                </p>
                            </div>
                        </div>
                    {/if}

                    {if $tipo_dato == 11}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Teléfono Extra:</b></label>
                            <div class="col-sm-7">
                                <p class="form-control-static editable-field"><a
                                            href="tel:{$dato_valor}">{$dato_valor}</a></p>
                            </div>
                            <div class="col-md-2" style="overflow:hidden;">
                                <i class="fas fa-pencil-alt partners-edit" data-edit-type="text"
                                   data-edit-widget-type="phone" data-edit-id="{$id_dato}"
                                   data-edit-column="dato_valor"
                                   data-remove-dato-extra="true"
                                   data-edit-table="partners_clientes_datos" data-edit-table-key="id_dato" role="button"
                                   aria-hidden="true"></i>
                            </div>
                        </div>
                    {/if}
                    {/loop}


                    {*Si es tipo_negocio = Particular o Prospecto, para hacer loop con correo y celular *}
                {elseif $datos.tipo == 2 || $datos.tipo == 4}
                    {*Si es prospecto mostrar lo de como se entero y que compro*}
                    {loop $datos.datos}
                    {if $tipo_dato == 1}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Teléfono:</b> <i
                                        class="fas fa-plus-circle text-primary cursor-pointer float-right add_dato_extra"
                                        data-id-cliente="{$id_cliente}" data-type="phone" style="font-size:20px;"></i>
                            </label>
                            <div class="col-sm-9">
                                <p class="form-control-static editable-field">
                                    <a href="tel:{$dato_valor}" class="editable-text-field"
                                       data-edit-id="{$id_dato}"
                                       data-edit-column="dato_valor"
                                       data-edit-table="partners_clientes_datos"
                                       data-edit-table-key="id_dato">{$dato_valor}</a>
                                </p>
                            </div>
                        </div>
                    {/if}

                    {if $tipo_dato == 11}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Teléfono Extra:</b></label>
                            <div class="col-sm-7">
                                <p class="form-control-static editable-field"><a
                                            href="tel:{$dato_valor}">{$dato_valor}</a></p>
                            </div>
                            <div class="col-md-2" style="overflow:hidden;">
                                <i class="fas fa-pencil-alt partners-edit" data-edit-type="text"
                                   data-edit-widget-type="phone" data-edit-id="{$id_dato}"
                                   data-edit-column="dato_valor"
                                   data-remove-dato-extra="true"
                                   data-edit-table="partners_clientes_datos" data-edit-table-key="id_dato" role="button"
                                   aria-hidden="true"></i>
                            </div>
                        </div>
                    {/if}


                    {if $tipo_dato == 2}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Celular:</b> <i
                                        class="fas fa-plus-circle text-primary cursor-pointer float-right add_dato_extra"
                                        data-id-cliente="{$id_cliente}" data-type="cel" style="font-size:20px;"></i>
                            </label>
                            <div class="col-sm-9">
                                <p class="form-control-static editable-field">
                                    <a href="tel:{$dato_valor}" class="editable-text-field"
                                       data-edit-id="{$id_dato}"
                                       data-edit-column="dato_valor"
                                       data-edit-table="partners_clientes_datos"
                                       data-edit-table-key="id_dato">{$dato_valor}</a>
                                </p>
                            </div>
                        </div>
                    {/if}

                    {if $tipo_dato == 12}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Celular Extra:</b></label>
                            <div class="col-sm-7">
                                <p class="form-control-static editable-field"><a
                                            href="tel:{$dato_valor}">{$dato_valor}</a></p>
                            </div>
                            <div class="col-md-2" style="overflow:hidden;">
                                <i class="fas fa-pencil-alt partners-edit" data-edit-type="text"
                                   data-edit-widget-type="phone" data-edit-id="{$id_dato}"
                                   data-edit-column="dato_valor"
                                   data-remove-dato-extra="true"
                                   data-edit-table="partners_clientes_datos" data-edit-table-key="id_dato" role="button"
                                   aria-hidden="true"></i>
                            </div>
                        </div>
                    {/if}
                    {if $tipo_dato == 3}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Correo:</b> <i
                                        class="fas fa-plus-circle text-primary cursor-pointer float-right add_dato_extra"
                                        data-id-cliente="{$id_cliente}" data-type="email" style="font-size:20px;"></i>
                            </label>
                            <div class="col-sm-9">
                                <p class="form-control-static editable-field">
                                    <a href="mailto:{$dato_valor}" class="editable-text-field"
                                       data-edit-id="{$id_dato}"
                                       data-edit-column="dato_valor"
                                       data-edit-table="partners_clientes_datos"
                                       data-edit-table-key="id_dato">{$dato_valor}</a>
                                </p>
                            </div>
                        </div>
                    {/if}

                    {if $tipo_dato == 13}
                        <div class="form-group row custom_form_group">
                            <label class="col-sm-3 "><b>Correo Extra:</b></label>
                            <div class="col-sm-7">
                                <p class="form-control-static editable-field"><a
                                            href="mailto:{$dato_valor}">{$dato_valor}</a></p>
                            </div>
                            <div class="col-md-2" style="overflow:hidden;">
                                <i class="fas fa-pencil-alt partners-edit" data-edit-type="text"
                                   data-edit-widget-type="email" data-edit-id="{$id_dato}"
                                   data-edit-column="dato_valor"
                                   data-remove-dato-extra="true"
                                   data-edit-table="partners_clientes_datos" data-edit-table-key="id_dato" role="button"
                                   aria-hidden="true"></i>
                            </div>
                        </div>
                    {/if}
                    {/loop}

                {/if}
                {if $datos.tipo == 4}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Como se enteró:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="como_se_entero"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{if $datos.cliente.como_se_entero == 'otro'} {$datos.cliente.descripcion_otro} {else} {$datos.cliente.como_se_entero} {/if}</span>
                            </p>
                        </div>
                    </div>
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Qué compró o qué servicio se le prestó:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="compra_servicio"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.compra_servicio}</span>
                            </p>
                        </div>
                    </div>
                {/if}
                <div class="form-group row custom_form_group">
                    <label class="col-sm-3 "><b>Alias:</b></label>
                    <div class="col-sm-9">
                        <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="alias"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.alias}</span>
                        </p>
                    </div>
                </div>
                <div class="form-group row custom_form_group">
                    <label class="col-sm-3 "><b>Relacionado con:</b></label>
                    <div class="col-sm-9">
                        <p class="form-control-static editable-field">
                            <span class="editable-text-field"
                                  data-edit-id="{$datos.cliente.id_cliente}"
                                  data-edit-column="relacionado"
                                  data-edit-table="partners_clientes"
                                  data-edit-table-key="id_cliente">{$datos.cliente.relacionado}</span>
                        </p>
                    </div>
                </div>
                <div class="form-group row custom_form_group">
                    <label class="col-sm-3 "><b>Datos Facturación:</b></label>
                    <div class="col-sm-7">
                        <div class="deleted_datos_facturacion"></div>
                        <table class="table table-sm table-hover table-bordered table-striped table_datos_facturacion">
                            <thead class="table-success font-weight-bold">
                            <tr>
                                <td>Nombre Facturación</td>
                                <td>RFC</td>
                            </tr>
                            </thead>
                            <tbody>
                            {loop $datos.datos_facturacion}
                                <tr class="tr_dato_facturacion" data-nuevo="false" data-id-dato="{$id_dato}">
                                    <td class="td_facturacion_name">{$nombre_facturacion}</td>
                                    <td class="td_facturacion_rfc">{$rfc}</td>
                                </tr>
                            {/loop}
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-2" style="overflow:hidden;">
                        <i class="fas fa-pencil-alt editar_datos_facturacion cursor-pointer"
                           style="font-size: 20px;color: #f0cd00;"
                           data-id-cliente="{$datos.cliente.id_cliente}"
                           role="button" aria-hidden="true"></i>
                        <i class="fas fa-save guardar_datos_facturacion text-success"
                           style="display:none; font-size: 20px;"
                           data-id-cliente="{$datos.cliente.id_cliente}"
                           role="button" aria-hidden="true"></i>
                        <i class="cancelar_edicion_facturacion fas fa-ban float-right text-danger"
                           style="display:none; font-size: 20px;"
                           data-id-cliente="{$datos.cliente.id_cliente}"
                           role="button" aria-hidden="true"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-sm-12">
        <div class="card">
            <div class="card-header text-center">
                Domicilio
            </div>
            <div class="card-body">

                {loop $datos.datos}
                {if $tipo_dato == 5}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Calle y Numero:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <span class="editable-text-field"
                                      data-edit-id="{$id_dato}"
                                      data-edit-column="dato_valor"
                                      data-edit-table="partners_clientes_datos"
                                      data-edit-table-key="id_dato">{$dato_valor}</span>
                            </p>
                        </div>
                    </div>
                {elseif $tipo_dato == 7}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Colonia:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <span class="editable-text-field"
                                      data-edit-id="{$id_dato}"
                                      data-edit-column="dato_valor"
                                      data-edit-table="partners_clientes_datos"
                                      data-edit-table-key="id_dato">{$dato_valor}</span>
                            </p>
                        </div>
                    </div>
                {elseif $tipo_dato == 6}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Cruzamientos:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <span class="editable-text-field"
                                      data-edit-id="{$id_dato}"
                                      data-edit-column="dato_valor"
                                      data-edit-table="partners_clientes_datos"
                                      data-edit-table-key="id_dato">{$dato_valor}</span>
                            </p>
                        </div>
                    </div>
                {elseif $tipo_dato == 10}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Ver Mapa desde:</b></label>
                        <div class="col-sm-7">
                            <p class="form-control-static editable-field"
                               data-cord="{$dato_valor}">
                                <a
                                        href="https://www.google.com.mx/maps/dir/My+Location/{$dato_valor}/"
                                        target="_blank" id="cliente-current-location-dir"><i class="fas fa-street-view"
                                                                                             aria-hidden="true"></i>
                                    Ubicación
                                    Actual </a> | <a
                                        href="https://www.google.com.mx/maps/dir/20.685434,-103.354240/{$dato_valor}/"
                                        target="_blank"><i class="fas fa-map-marker-alt" aria-hidden="true"></i> Pc
                                    Partners</a></p>
                        </div>
                        <div class="col-md-2" style="overflow:hidden;">
                            <i class="fas fa-pencil-alt  partners-edit" data-edit-type="maps"
                               data-edit-id="{$id_dato}"
                               data-edit-column="dato_valor"
                               data-edit-table="partners_clientes_datos" data-edit-table-key="id_dato" role="button"
                               aria-hidden="true"></i>
                        </div>
                    </div>
                {elseif $tipo_dato == 8}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Ciudad y Estado:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <span class="editable-text-field"
                                      data-edit-id="{$id_dato}"
                                      data-edit-column="dato_valor"
                                      data-edit-table="partners_clientes_datos"
                                      data-edit-table-key="id_dato">{$dato_valor}</span>
                            </p>
                        </div>
                    </div>
                {elseif $tipo_dato == 9}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Horario:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static editable-field">
                                <span class="editable-text-field"
                                      data-edit-id="{$id_dato}"
                                      data-edit-column="dato_valor"
                                      data-edit-table="partners_clientes_datos"
                                      data-edit-table-key="id_dato">{$dato_valor}</span>
                            </p>
                        </div>
                    </div>
                {/if}
                {/loop}

            </div>
        </div>
    </div>
</div>

<div class="row margin-bot">
    <div class="col-md-6 col-sm-12">
        <div class="card">
            <div class="card-header text-center">
                Contactos
            </div>
            <div class="card-body">
                <table class="table table-sm table-bordered table-bordered table-striped">
                    <tbody>
                    {loop $datos.contactos}
                        <tr>
                            <td class="vista_contacto cursor-pointer" data-id-padre="{$id_padre}"
                                data-id="{$id_cliente}">{$nombre_cliente}</td>
                            <td class="vista_contacto cursor-pointer" data-id-padre="{$id_padre}"
                                data-id="{$id_cliente}">{$puesto_contacto}</td>
                            <td>
                                <div class=" custom-control custom-checkbox my-1 mr-sm-2">
                                    <input type="checkbox" class="custom-control-input marcar_contacto_facturacion"
                                           data-id-contacto="{$id_cliente}"
                                           data-status="{$contacto_facturacion}"
                                            {if $contacto_facturacion == 1} checked {/if}
                                           id="customControlInline{$id_cliente}">
                                    <label class="custom-control-label"
                                           for="customControlInline{$id_cliente}">Facturación</label>
                                </div>
                            </td>
                        </tr>
                    {/loop}
                    </tbody>
                </table>
                <br>

                {if $datos.cliente.cancelado != 1}
                    <button type="button" class="btn btn-primary nuevo_contacto"
                            data-id="{$datos.cliente.id_cliente}" data-nombre-cliente="{$datos.cliente.nombre_cliente}"
                            role="button">Agregar Contacto
                    </button>
                {/if}
            </div>
        </div>
    </div>
    {if $datos.tipo != 5}
        <div class="col-md-6 col-sm-12">
            <div class="card">
                <div class="card-header text-center">
                    Interno
                </div>
                <div class="card-body">
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Cliente de Áreas:</b></label>
                        <div class="col-sm-9">
                            <p class="form-control-static">
                                <span class="editable-custom-areas"
                                      data-edit-id="{$datos.cliente.id_cliente}"
                                      data-edit-values="{$datos.found_areas}"
                                      data-edit-column="areas_cliente"
                                      data-edit-table="partners_clientes"
                                      data-edit-table-key="id_cliente">{foreach $datos.found_areas_text val}{$val}
                                        <br>
                                    {/foreach}</span>
                            </p>
                        </div>
                    </div>

                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Clasificación:</b></label>
                        <div class="col-sm-7">
                            <p class="form-control-static editable-field">{upper($datos.cliente.tipo_clasificacion)}
                                | {$datos.credito} <span
                                        class="btn badge badge-pill float-right ml-2 ver_observaciones_internas
                                        {if $datos.cliente.observaciones_internas == null}badge-secondary{else}badge-warning{/if}"
                                        data-id-cliente="{$datos.cliente.id_cliente}">Obs</span>
                                <span class="btn badge badge-pill badge-info float-right sugerir_reclasificacion_cliente"
                                      data-id-cliente="{$datos.cliente.id_cliente}"
                                      data-clasificacion-cliente="{$datos.cliente.tipo_clasificacion}">Sugerir reclasificación</span>
                            </p>
                        </div>

                        <div class="col-md-2" style="overflow:hidden;">
                            {if $datos.user_allowed == true}
                                {*Si tiene permisos para editar todas las clasificaciones del cliente *}
                                <i class="fas fa-pencil-alt mover_clasificacion_cliente cursor-pointer"
                                   style="font-size: 20px; color: #f0cd00;"
                                   data-id-cliente="{$datos.cliente.id_cliente}"
                                   data-clasificacion-cliente="{$datos.cliente.tipo_clasificacion}"
                                   data-has-permissions="true" aria-hidden="true"></i>
                            {else}
                                {*No tiene permiso, entonces solo puede mover el cliente de C a B *}
                                <i class="fas fa-pencil-alt mover_clasificacion_cliente cursor-pointer"
                                   style="font-size: 20px; color: #f0cd00;"
                                   data-id-cliente="{$datos.cliente.id_cliente}"
                                   data-clasificacion-cliente="{$datos.cliente.tipo_clasificacion}"
                                   data-has-permissions="false" aria-hidden="true"></i>
                            {/if}
                        </div>
                    </div>

                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Notas Internas:</b></label>
                        {if $datos.user_allowed == true}
                            <div class="col-sm-9">
                                <p class="form-control-static">
                                    <span class="editable-textarea-field"
                                          data-edit-id="{$datos.cliente.id_cliente}"
                                          data-edit-column="clasificacion_notas"
                                          data-edit-table="partners_clientes"
                                          data-edit-table-key="id_cliente">{$datos.cliente.clasificacion_notas}</span>
                                </p>
                            </div>
                        {/if}
                    </div>


                    {if $datos.cliente.tipo_clasificacion == 'P' || $datos.cliente.tipo_clasificacion == 'p'}
                    <div class="form-group row custom_form_group">
                        <label class="col-sm-3 "><b>Horas de Saldo:</b></label>
                            <div class="col-sm-9">
                                <p class="form-control-static">
                                    <span class="editable-textarea-field"
                                          data-edit-id="{$datos.cliente.id_cliente}"
                                          data-edit-column="saldo_horas"
                                          data-edit-table="partners_clientes"
                                          data-edit-table-key="id_cliente">{$datos.cliente.saldo_horas}</span>
                                </p>
                            </div>
                    </div>
                    {/if}


                </div>
            </div>
            <button class="btn btn-success my-2 area_ventas_cliente"
                    data-nombre-cliente="{$datos.cliente.nombre_cliente}" data-id-cliente="{$datos.cliente.id_cliente}">
                Ventas
            </button>
        </div>
    {/if}
</div>
{if $datos.cliente.cancelado != 1 && $datos.user_allowed == true}
    <div class="row">
        <div class="col-md-12">
            <div class="float-left">
                <button type="button" class="btn btn-danger cancelar_cliente" role="button"
                        data-nombre-cliente="{$datos.cliente.nombre_cliente}"
                        data-tipo-cliente="{$datos.cliente.tipo_cliente}"
                        data-id-cliente="{$datos.cliente.id_cliente}">Eliminar Cliente
                </button>
            </div>

            {if $datos.cliente.solicitar_cancelacion}
                <div class="float-left ml-2">
                    <button type="button" class="btn btn-warning cancelar_solicitud_cancelacion_cliente" role="button"
                            data-nombre-cliente="{$datos.cliente.nombre_cliente}"
                            data-tipo-cliente="{$datos.cliente.tipo_cliente}"
                            data-id-cliente="{$datos.cliente.id_cliente}">Cancelar solicitud de eliminación
                    </button>
                </div>
            {/if}

            <div class="float-right">
                <button type="button" class="btn btn-warning toggleEdit" role="button">Editar</button>
            </div>

        </div>
    </div>
{else}
    <div class="row">
        <div class="col-md-12">
            {if $datos.cliente.solicitar_cancelacion == 0}
            <div class="float-left">
                <button type="button" class="btn btn-danger solicitar_cancelar_cliente" role="button"
                        data-nombre-cliente="{$datos.cliente.nombre_cliente}"
                        data-tipo-cliente="{$datos.cliente.tipo_cliente}"
                        data-id-cliente="{$datos.cliente.id_cliente}">Solicitar eliminación del cliente
                </button>
            </div>
            {/if}
            <div class="float-right">
                <button type="button" class="btn btn-warning toggleEdit" role="button">Editar</button>
            </div>
        </div>
    </div>
{/if}

<div class="row">
    <div class="col-md-12 text-center">
        {if $datos.cliente.cancelado == 1}
            <small class="font-italic text-danger">{$datos.created_updated}</small>
        {else}
            <small class="font-italic">{$datos.created_updated}</small>
        {/if}
    </div>
</div>
