<div class="row margin-bot">
    <div class="col-md-2 font-weight-bold text-right">
        Cliente:
    </div>
    <div class="col-md-9">
        <div class="col-md-10">
            <a target="_blank"
               href="clientes?id_cliente={$datos.proyecto.id_cliente}&type={$datos.proyecto.tipo_cliente}">{$datos.proyecto.nombre_cliente}</a>
            <span class="float-right badge badge-secondary">
                    <i class="fas fa-star" aria-hidden="true"></i>: {upper $datos.proyecto.tipo_clasificacion}
                | {if $datos.proyecto.credito == 1}Credito {else}Contado {/if}</span>
        </div>
    </div>
</div>

{if $datos.proyecto.id_contacto}
    <div class="row margin-bot">
        <div class="col-md-2 font-weight-bold text-right">
            Contacto:
        </div>
        <div class="col-md-9">
            <div class="col-md-10">
                <a target="_blank"
                   href="clientes?id_cliente={$datos.proyecto.id_contacto}&type={$datos.proyecto.tipo_contacto}">{$datos.proyecto.nombre_contacto}</a>
            </div>
        </div>
    </div>
{/if}

<div class="row margin-bot">
    <div class="col-md-2 font-weight-bold text-right">
        Fecha Creación:
    </div>
    <div class="col-md-9">
        <div class="col-md-10">{date_format $datos.proyecto.created_at "%d/%m/%Y %H:%M"}</div>
    </div>
</div>
<div class="row">
    <div class="col-md-6 text-center font-weight-bold">Proyecto CCTV</div>
    <div class="col-md-6 text-center font-weight-bold">Salida de Almacén</div>
</div>
<hr>
<div class="row">
    <div class="col-md-6 side-a-vista">
        <div class="row margin-bot editable_fields_proyecto" style="display: none;">
            <div class="col-md-1">
                <div class="form-group">
                    <label class="col-form-label">Cantidad</label>
                    <div>
                        <input type="text" class="form-control cantidad_proyecto"
                               data-validation="number" data-validation-allowing="float"
                               data-validation-optional="true"
                               data-validation-error-msg="Agrega una cantidad válida.">
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label class="col-form-label">Tipo</label>
                    <div>
                        <select name="tipo_entity_proyecto" data-validation="required"
                                data-validation-error-msg="Selecciona un tipo" class="custom-select">
                            <option value="" hidden selected>Selecciona un tipo</option>
                            <option value="1">Pieza</option>
                            <option value="2">Servicio</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
                <div class="form-group">
                    <label class="col-form-label">Descripción</label>
                    <div>
                        <textarea rows="1" class="form-control descripcion_proyecto"></textarea>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="form-group">
                    <label class="col-form-label">Precio Unitario</label>
                    <div>
                        <input type="text" class="form-control precio_proyecto"
                               data-validation="number" data-validation-allowing="float"
                               data-validation-optional="true"
                               data-validation-error-msg="Ingresa una cantidad correcta">
                    </div>
                </div>
            </div>
            <div class="col-md-1">
                <label class="col-form-label">Agregar</label>
                <button type="button" class="btn btn-outline-success agregar_entity_proyecto"
                        role="button">Agregar
                </button>
            </div>
        </div>

        <table class="table table-sm table-bordered table-hover table-striped non-editable-table">
            <thead class="bg-faded">
            <tr>
                <th>Tipo</th>
                <th>Cantidad</th>
                <th>Descripción</th>
                <th>Precio Unitario</th>
                <th>Subtotal</th>
            </tr>
            </thead>
            <tbody>
            {loop $datos.datos}
                <tr>
                    <td>{if $tipo == 1}Pieza{else}Servicio{/if}</td>
                    <td>{$cantidad}</td>
                    <td>{nl2br $descripcion}</td>
                    <td class="text-right">{number_format $precio,2,'.',','}</td>
                    <td class="text-right">{number_format $subtotal,2,'.',','}</td>
                </tr>
            {/loop}
            </tbody>
            <tfoot>
            <th class="text-center" colspan="4">Total</th>
            <th class="text-right">{number_format $datos.total,2,'.',','}</th>
            </tfoot>
        </table>


        <table class="table table-sm table-bordered table-hover table-striped editable-table" style="display: none;">
            <thead class="bg-faded">
            <tr>
                <th>Tipo</th>
                <th>Cantidad</th>
                <th>Descripción</th>
                <th>Precio Unitario</th>
                <th>Subtotal</th>
                <th>Eliminar</th>
            </tr>
            </thead>
            <tbody>
            {loop $datos.datos}
                <tr class="entity_proyecto" data-id-dato="{$id_dato}">
                    <td class="entity_tipo_proyecto" data-tipo="{$tipo}">{if $tipo == 1}Pieza{else}Servicio{/if}</td>
                    <td class="entity_cantidad_proyecto">{$cantidad}</td>
                    <td class="entity_descripcion_proyecto" style="word-break: break-all;">{nl2br $descripcion}</td>
                    <td class="text-right entity_proyecto_precio"
                        data-precio="{$precio}">{number_format $precio,2,'.',','}</td>
                    <td class="text-right entity_proyecto_subtotal"
                        data-subtotal="{$subtotal}">{number_format $subtotal,2,'.',','}</td>
                    <td class="text-center text-danger cursor-pointer eliminar_entity_proyecto">Eliminar</td>
                </tr>
            {/loop}
            </tbody>
            <tfoot>
            <th class="text-center" colspan="4">Total</th>
            <th class="text-right total_editable_table_proyecto">{number_format $datos.total,2,'.',','}</th>
            </tfoot>
        </table>

        <div class="deleted_entities_proyecto"></div>


        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-danger float-right cancelar_edicion_proyecto" role="button"
                        style="display: none;">Cancelar
                </button>
                <a class="btn btn-primary float-left mx-2" href="/cctv/vista/{$datos.proyecto.id_proyecto}" target="_blank">Imprimir</a>
                {if !$datos.proyecto.finalizado}
                <button class="btn btn-success float-right mx-2 editar_proyecto" role="button">Editar</button>
                <button class="btn btn-success float-right guardar_edicion_proyecto mx-2" role="button"
                        data-id-proyecto="{$datos.proyecto.id_proyecto}" style="display: none;">Guardar
                </button>
                {/if}
            </div>
        </div>
    </div>

    <div class="col-md-6 side-b-vista">
        <table class="table table-sm table-bordered table-hover table-striped">
            {if $datos.mercancia}
            <thead class="bg-faded">
            <tr>
                <th>UPC</th>
                <th>Producto</th>
                <th>Serie</th>
                <th class="text-right">Costo</th>
            </tr>
            </thead>
            <tbody>
            {loop $datos.mercancia}
                <tr>
                    <td>{$upc_producto}</td>
                    <td>{$nombre_producto}</td>
                    <td>{$serie_producto}</td>
                    <td class="text-right">{number_format $costo,2,'.',','}</td>
                </tr>
            {/loop}
            </tbody>
            {/if}
            {if $datos.mercanciae}
            <thead>
                <tr>
                    <th colspan="3">Concepto extra</th>
                    <th class="text-right">Costo</th>
                </tr>
            </thead>
            <tbody>
                {loop $datos.mercanciae}
                <tr>
                    <td colspan="3">{$nombre_producto}</td>
                    <td class="text-right">{number_format $costo,2,'.',','}</td>
                </tr>
                {/loop}
            </tbody>
            {/if}
            <tfoot>
            <th class="text-center" colspan="3">Total</th>
            <th class="text-right">{number_format $datos.total_mercancia,2,'.',','}</th>
            </tfoot>
        </table>
    </div>
</div>