<div class="vista_equipos_container">
    <div class="row">
        <div class="col-8">
            <h3>{$datos.nombre_bucket}</h3>
        </div>
        <div class="col-4 total_espacio_edit"></div>
    </div>

    <div class="row">
        <div class="col-12">
            {if $datos.equipos}
                <table class="table table-striped table-sm table-bordered table_equipos"
                       data-paquete="{$datos.paquete}">
                    <thead>
                    <tr>
                        <th>Nombre Equipo</th>
                        <th class="text-right">Espacio Asignado</th>
                        <th class="text-center">Espacio Usado</th>
                        <th class="text-center">Última consulta</th>
                    </tr>
                    </thead>
                    <tbody>
                    {loop $datos.equipos}
                        <tr data-id-equipo="{$id_equipo_backup}" data-nombre="{$nombre_equipo}"
                            data-espacio="{$uso_espacio}"
                            data-uso-real="{$uso_real}">
                            <td>{$nombre_equipo}</td>
                            <td class="text-right">{number_format($uso_espacio, 2, '.', ',')} GB</td>
                            {if $disk_used > 0}
                                <td class="progress-bar progress-bar-striped text-dark {$color}"
                                    data-percentage="{$disk_used}"
                                    style="width: {$disk_used}%">{number_format($uso_real, 2, '.', ',')} GB
                                </td>
                            {else}
                                <td>{number_format($uso_real, 2, '.', ',')}</td>
                            {/if}

                            {if $ultima_fecha_uso_real}
                                <td class="cursor-pointer consultar_uso_equipo text-center"
                                    data-id-equipo="{$id_equipo_backup}"
                                    data-id-backup="{$id_backup}">{date('d/m/Y H:i', $ultima_fecha_uso_real)}</td>
                            {else}
                                <td class="cursor-pointer consultar_uso_equipo text-center"
                                    data-id-equipo="{$id_equipo_backup}"
                                    data-id-backup="{$id_backup}">Sin consultar
                                </td>
                            {/if}

                        </tr>
                    {/loop}
                    </tbody>
                </table>
                <table class="table table-striped table-sm table-bordered table_equipos_editing" style="display: none;"
                       data-paquete="{$datos.paquete}">
                    <thead>
                    <tr>
                        <th>Nombre Equipo</th>
                        <th class="text-right">Espacio Asignado GB</th>
                        <th class="text-right">Espacio Usado GB</th>
                        <th class="text-center"><i class="fas fa-trash-alt"></i></th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            {else}
                <p class="text-danger">Sin equipos registrados</p>
            {/if}
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button class="btn btn-warning editar_equipos_respaldo float-right" type="button">Editar</button>
            <button class="btn btn-success guardar_edicion_equipos_respaldo float-right ml-2" type="button"
                    style="display: none;" data-id-backup="{$datos.id_backup}">Guardar
            </button>
            <button class="btn btn-warning cancelar_edicion_equipos_respaldo float-right" type="button"
                    style="display: none;" data-id-backup="{$datos.id_backup}">Cancelar Edición
            </button>
        </div>
    </div>

</div>