<form id="nuevo_backup_form" autocomplete="off">
    <div class="form-group row required container_buscador_cliente">
        <label class="col-md-2 col-sm-12 col-form-label">Cliente</label>
        <div class="col-md-10 col-sm-12">
            {include '../system/buscador_clientes.tpl' }
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-12 col-form-label">Nombre Bucket</label>
        <div class="col-md-6 col-12">
            <input type="text" class="form-control" name="nombre_bucket" data-validation="custom"
                   data-validation-regexp="^[0-9A-Za-z\-]+$"
                   data-validation-error-msg="Solamente permite usar caracteres alfanuméricos y guión medio.">
        </div>
    </div>

    <div class="form-group row required">
        <label class="col-md-2 col-12 col-form-label">Paquete Respaldo</label>
        <div class="col-md-3 col-12">
            <select name="paquete_respaldo" class="form-control" data-validation="required"
                    data-validation-error-msg="Selecciona un paquete">
                <option value="" selected hidden>Selecciona...</option>
                <option value="1">300 GB</option>
                <option value="2">500 GB</option>
                <option value="3">1 TB</option>
                <option value="4">2 TB</option>
            </select>
        </div>
    </div>

    <div class="form-group row required equipos_container" style="display: none;">
        <label class="col-md-2 col-12 col-form-label">Número de Equipos</label>
        <div class="col-md-2 col-12">
            <input type="number" class="form-control" min="1" name="numero_equipos" data-validation="number"
                   data-validation-error-msg="Ingresa el número de Equipos.">
        </div>
        <div class="col-8 container_uso_disco"></div>
    </div>

    <div class="form-group row required equipos_container" style="display: none;">
        <div class="col-md-12 col-12 offset-md-2">
            <div id="container_list_equipos"></div>
        </div>
    </div>

    <div class="container_renovacion" style="display: none;">
        <p class="lead font-weight-bold text-center">Renovación</p>
        <hr>

        <div class="form-group row required">
            <label class="col-md-2 col-12 col-form-label">Fecha Renovación</label>
            <div class="col-md-3 col-12">
                <div class="input-group date">
                    <input type="text" class="form-control fecha_gasto"/>
                    <div class="input-group-prepend">
                        <span class="input-group-text input-group-addon"><i class="fas fa-calendar-alt"></i></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group row required">
            <label class="col-md-2 col-12 col-form-label">Frecuencia Renovación</label>
            <div class="col-md-6 col-12">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text">Cada</span>
                    </div>
                    <input type="text" class="form-control" name="input_frecuencia" data-validation="number"
                           data-validation-error-msg="Ingresa un número correcto.">
                    <div>
                        <select class="custom-select" name="select_frecuencia">
                            <option value="WEEKLY">Semana(s)</option>
                            <option value="MONTHLY">Mes(s)</option>
                            <option value="YEARLY">Año(s)</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group row required">
            <label class="col-md-2 col-12 col-form-label">Precio</label>
            <div class="col-md-3 col-12">
                <input type="text" class="form-control text-right" name="precio_renovacion"
                       data-validation="required"
                       data-validation-error-msg="Ingresa el precio de la renovación.">
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-2 col-12 col-form-label">Observaciones Renovación</label>
            <div class="col-md-6 col-12">
                <textarea rows="3" class="form-control" name="observaciones_renovacion"></textarea>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button class="btn btn-success float-right" type="submit" role="button">Guardar</button>
        </div>
    </div>

</form>