import $ from 'jquery';
import { capturarKm, loadValesVehiculo } from './vehiculoFns';

$(document).ready(() => {
  $.validate({
    form: '#nuevo_km_form',
    errorMessageClass: 'invalid-feedback',
    inputParentClassOnError: 'text-danger',
    inputParentClassOnSuccess: 'text-success',
    errorElementClass: 'is-invalid',
    successElementClass: 'is-valid',
  });

  // ***************************************************************
  // --------------------- CAPTURAR KILOMETRAJE --------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_km_form', (e) => {
    capturarKm(e, false, true);
  });
  $(document).on('change', '#nuevo_km_form select[name="id_vehiculo"]', (e) => {
    loadValesVehiculo($(e.currentTarget).val());
  });
  // ***************************************************************
  // --------------------- CAPTURAR KILOMETRAJE --------------------
  // ***************************************************************
});
