import $ from 'jquery';
import moment from 'moment';
import _ from 'lodash';
import '../../plugin/js/modal';
import '../../plugin/js/tooltip';
import 'bootstrap-datepicker';
import '../../plugin/css/daterangepicker.css';
import Reporteador from '../utilities/js/reporteador';
import DateRangePicker from '../utilities/js/dateRangePicker';
import PartnersObs from '../utilities/js/partnersObs';
import { axiosInstance as axios, urls, datePickerLng } from './config/config';
import * as VehiculoFns from './vehiculoFns';

$.fn.datepicker.dates.es = datePickerLng;
$(document).ready(() => {
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************
  const start = moment().startOf('year');
  const end = moment().endOf('year');
  const reporteadorOptions = {
    automatic_update: 1,
    updating: 0,
    filter: {
      search_bar: null,
      start_date: start,
      end_date: end,
    },
  };
  const reporteador = new Reporteador('#reporteador', `${urls.consultas}reporte_base`, reporteadorOptions, axios, () => {}, () => {});


  const picker = new DateRangePicker('#reportrange', start, end, {}, '.parent-calendar');
  $(picker.getElement()).on('apply.daterangepicker', (event, datePicker) => {
    picker.updateDates(datePicker.startDate, datePicker.endDate);
    const newData = _.cloneDeep(reporteador.getCurrentData());
    newData.filter.start_date = datePicker.startDate.format('DD/MM/YYYY');
    newData.filter.end_date = datePicker.endDate.format('DD/MM/YYYY');
    reporteador.rebuildOptions(newData);
  });
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------- ALTA VEHICULO -----------------------
  // ***************************************************************
  $(document).on('click', '.alta_vehiculo', () => {
    VehiculoFns.vistaNuevoVehiculo();
  });
  // ***************************************************************
  // ------------------------- ALTA VEHICULO -----------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- CAPTURAR VEHICULO -----------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_vehiculo_form', (e) => {
    VehiculoFns.capturarVehiculo(e, reporteador);
  });
  // ***************************************************************
  // --------------------- CAPTURAR VEHICULO -----------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- GASTO / REPARACION ----------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_gasto', () => {
    VehiculoFns.vistaNuevoGasto();
  });
  // ***************************************************************
  // --------------------- GASTO / REPARACION ----------------------
  // ***************************************************************

  // ***************************************************************
  // ---------------------- CAPTURAR GASTO -------------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_gasto_form', (e) => {
    VehiculoFns.capturarGasto(e, reporteador);
  });
  // ***************************************************************
  // ---------------------- CAPTURAR GASTO -------------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------- SEGURO ------------------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_seguro', () => {
    VehiculoFns.vistaNuevoSeguro();
  });
  // ***************************************************************
  // ------------------------- SEGURO ------------------------------
  // ***************************************************************

  // ***************************************************************
  // ---------------------- CAPTURAR SEGURO ------------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_seguro_form', (e) => {
    VehiculoFns.capturarSeguro(e, reporteador);
  });
  // ***************************************************************
  // ---------------------- CAPTURAR SEGURO ------------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------- KILOMETRAJE -------------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_km', () => {
    VehiculoFns.vistaNuevoKm();
  });
  $(document).on('change', '#nuevo_km_form select[name="id_vehiculo"]', (e) => {
    VehiculoFns.loadValesVehiculo($(e.currentTarget).val());
  });
  // ***************************************************************
  // ------------------------- KILOMETRAJE -------------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- CAPTURAR KILOMETRAJE --------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_km_form', (e) => {
    VehiculoFns.capturarKm(e, reporteador);
  });
  // ***************************************************************
  // --------------------- CAPTURAR KILOMETRAJE --------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------- AFINACIÓN ---------------------------
  // ***************************************************************
  $(document).on('click', '.nueva_afinacion', () => {
    VehiculoFns.vistaNuevaAfinacion();
  });
  // ***************************************************************
  // ------------------------- AFINACIÓN ---------------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- CAPTURAR AFINACIÓN ----------------------
  // ***************************************************************
  $(document).on('submit', '#nueva_afinacion_form', (e) => {
    VehiculoFns.capturarAfinacion(e, reporteador);
  });
  // ***************************************************************
  // --------------------- CAPTURAR AFINACIÓN ----------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------------- REFRENDO ---------------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_refrendo', () => {
    VehiculoFns.vistaNuevoRefrendo();
  });
  // ***************************************************************
  // -------------------------- REFRENDO ---------------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- CAPTURAR REFRENDO -----------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_refrendo_form', (e) => {
    VehiculoFns.capturarRefrendo(e, reporteador);
  });
  // ***************************************************************
  // --------------------- CAPTURAR REFRENDO -----------------------
  // ***************************************************************

  // ***************************************************************
  // --------------------- VISUALIZAR ARCHIVOS ---------------------
  // ***************************************************************
  $(document).on('click', '.ver_seguro', (e) => {
    const file = $(e.currentTarget).parents('tr').attr('data-seguro-file');
    const fileUrl = $(e.currentTarget).parents('tr').attr('data-files-url');

    VehiculoFns.visualizarArchivo(file, fileUrl);
  });

  $(document).on('click', '.ver_refrendo', (e) => {
    const file = $(e.currentTarget).parents('tr').attr('data-refrendo-file');
    const fileUrl = $(e.currentTarget).parents('tr').attr('data-files-url');

    VehiculoFns.visualizarArchivo(file, fileUrl);
  });
  // ***************************************************************
  // --------------------- VISUALIZAR ARCHIVOS ---------------------
  // ***************************************************************


  // ***************************************************************
  // ------------------------ COPY TO CLIPBOARD --------------------
  // ***************************************************************
  $(document).on('click', '.copy_to_clipboard', (e) => {
    VehiculoFns.copyToClipboard(e);
  });
  // ***************************************************************
  // ------------------------ COPY TO CLIPBOARD --------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------ VISTA VEHÍCULO -----------------------
  // ***************************************************************
  $(document).on('click', '.vista_vehiculo', (e) => {
    VehiculoFns.vistaVehiculo(e);
  });
  // ***************************************************************
  // ------------------------ VISTA VEHÍCULO -----------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- VER ARCHIVOS VISTA VEHICULO --------------
  // ***************************************************************
  $(document).on('click', '.ver_seguro_vista_vehiculo', (e) => {
    const file = $(e.currentTarget).attr('data-seguro-file');
    const fileUrl = $(e.currentTarget).attr('data-files-url');
    VehiculoFns.visualizarArchivo(file, fileUrl);
  });

  $(document).on('click', '.ver_refrendo_vista_vehiculo', (e) => {
    const file = $(e.currentTarget).attr('data-refrendo-file');
    const fileUrl = $(e.currentTarget).attr('data-files-url');
    VehiculoFns.visualizarArchivo(file, fileUrl);
  });
  // ***************************************************************
  // -------------------- VER ARCHIVOS VISTA VEHICULO --------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------ VER KILOMETRAJE ----------------------
  // ***************************************************************
  $(document).on('click', '.vista-kilometraje', (e) => {
    VehiculoFns.vistaKilometraje(e);
  });
  // ***************************************************************
  // ------------------------ VER KILOMETRAJE ----------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------ VER GASTO ANUAL ----------------------
  // ***************************************************************
  $(document).on('click', '.vista-gasto-anual', (e) => {
    VehiculoFns.vistaGastoAnual(e);
  });
  // ***************************************************************
  // ------------------------ VER GASTO ANUAL ----------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- COBRANZA OBSERVACIONES -------------------
  // ***************************************************************
  $(document).on('click', '.status_obs', (e) => {
    const idGasto = $(e.currentTarget).parents('tr').attr('data-id-gasto');
    const Obs = new PartnersObs({
      modalId: 'modal-vehiculo-gastos-observaciones',
      url: `${urls.consultas}load_obs`,
      dbOptions: {
        index: 'id_gasto',
        idIndex: idGasto,
        tabla: 'partners_vehiculos_gastos',
        col: 'observaciones',
      },
      axios,
      axiosSuccess() {
        reporteador.forceUpdate();
      },
    });
    Obs.initObs();
  });
  // ***************************************************************
  // -------------------- COBRANZA OBSERVACIONES -------------------
  // ***************************************************************

  // ***************************************************************
  // ----------------------- ENTRADA VALES -------------------------
  // ***************************************************************
  $(document).on('click', '.nueva_entrada_vales', () => {
    VehiculoFns.vistaNuevaEntradaVales();
  });
  // ***************************************************************
  // ----------------------- ENTRADA VALES -------------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- CAPTURAR ENTRADA VALES -------------------
  // ***************************************************************
  $(document).on('submit', '#nueva_entrada_vales_form', (e) => {
    VehiculoFns.capturarEntradaVales(e, reporteador);
  });
  // ***************************************************************
  // -------------------- CAPTURAR ENTRADA VALES -------------------
  // ***************************************************************

  // ***************************************************************
  // ----------------------- ENTRADA VALES -------------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_vale', () => {
    VehiculoFns.vistaNuevoVale();
  });
  // ***************************************************************
  // ----------------------- ENTRADA VALES -------------------------
  // ***************************************************************

  // ***************************************************************
  // ----------------------- CAPTURAR VALE -------------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_vale_form', (e) => {
    VehiculoFns.capturarVale(e, reporteador);
  });
  // ***************************************************************
  // ----------------------- CAPTURAR VALE -------------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- VISTA VALES VEHICULO ---------------------
  // ***************************************************************
  $(document).on('click', '.ver_vales', (e) => {
    VehiculoFns.vistaVales(e);
  });
  // ***************************************************************
  // -------------------- VISTA VALES VEHICULO ---------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- VISTA REPORTE VALES ----------------------
  // ***************************************************************
  $(document).on('click', '.reporte_vales', (e) => {
    VehiculoFns.vistaReporteVales(e);
  });
  // ***************************************************************
  // -------------------- VISTA REPORTE VALES ----------------------
  // ***************************************************************
});
