import $ from 'jquery';
import iziToast from 'izitoast';
import PartnersModal from './partnersModal';
import './partnersBtn';

export default class partnersObs {
  constructor(options) {
    const defaultOptions = {
      modalId: 'modal-obs',
      url: '',
      dbOptions: {
        index: '',
        idIndex: '',
        tabla: '',
        col: 'observaciones',
      },
      modalTitle: 'Observaciones',
      axios: null,
      axiosSuccess() {
      },
    };

    this.options = Object.assign(defaultOptions, options);
  }

  /**
   * Inicializa las observaciones, abriendo un Modal y cargando las observaciones que tenga el
   * registro que se está consultando.
   */
  initObs() {
    this.modal = new PartnersModal(
      {
        title: this.options.modalTitle,
        modalSize: 'modal-lg',
        modalId: this.options.modalId,
        onModalMounted(modalId, callback) {
          $(`#${modalId}`).modal('show').on('hidden.bs.modal', () => callback(modalId));
        },
      },
    );

    this.modal.openModal();
    const opt = Object.assign({}, this.options.dbOptions);
    opt.type = 1;
    this.options.axios.post(this.options.url, opt)
      .then((res) => {
        if (res.data.status === 'success') {
          $(`#${this.options.modalId} .modal-body`).html(res.data.message);
          this.saveButton = $('#guardar-observacion');
          this.textArea = $('#textarea-observacion');
          this.saveButton.click($.proxy(this.capturarObservaciones, this));
        }
      });
  }

  /**
   * Captura las nuevas observaciones, simulando visualemente el append de un <tr> al momento
   * de que se capturó correctamente en la base de datos
   */
  capturarObservaciones() {
    const textoObservacion = this.textArea.val();
    if (!$.trim(textoObservacion).length) {
      iziToast.error({
        title: 'Error',
        message: 'Ingresa una observación',
      });
      return;
    }
    this.saveButton.partnersBtnControl('start', this.saveButton);
    this.textArea.val('');
    const envio = Object.assign({}, this.options.dbOptions);
    envio.type = 2;
    envio.new_val = textoObservacion;
    this.options.axios.post(this.options.url, envio)
      .then((res) => {
        if (res.data.status === 'success') {
          $(`#${this.options.modalId} .modal-body .tabla-obs > tbody:last-child`).append(res.data.message);
          this.saveButton.partnersBtnControl('end', this.saveButton);
          this.textArea.focus();
          this.options.axiosSuccess();
        }
      });
  }
}
