import loader from './loader';

export default class partnersModal {
  constructor(options) {
    const minOptions = {
      title: 'Partners Modal',
      content: '',
      headerClassColor: 'bg-primary text-white',
      modalSize: '',
      closeBtnClass: 'btn-danger',
      closeBtnPosition: 'left',
      modalClasses: [],
      modalId: `${Date.now()}_temporal`,
      shrinkModal: false,
      forceWidth: '',
      modalTitleAlign: 'center',
      noFooter: '',
      ajaxSuccessAlert: '',
      ajaxErrorAlert: '',
      staticBackdrop: '',
      onModalMounted() {},
      onModalShown() {},
    };

    this.options = Object.assign(minOptions, options);
    const content = this.options.content !== '' ? this.options.content : loader;

    const forceWidth = this.options.forceWidth !== false ? `max-width:${this.options.forceWidth}%` : '';

    const staticBackdrop = this.options.staticBackdrop !== '' ? 'data-backdrop="static"' : '';

    if (this.options.shrinkModal) {
      this.template = `<div class="modal fade ${this.options.modalClasses.join(' ')}" id="${this.options.modalId}" role="dialog" ${staticBackdrop} tabindex="-1" >
                     <div class="modal-dialog ${this.options.modalSize}" role="document" style="margin-top:0; ${forceWidth}">
                    <div class="modal-content" >
                    <div class="modal-header ${this.options.headerClassColor}" style="height:10px;">
                    <h4 class="modal-title w-100 text-${this.options.modalTitleAlign}" style="font-size:1rem; margin-top:-7px;" >${this.options.title}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="padding-top: 5px;"> <span aria-hidden="true">&times;</span> </button>
                    </div>
                    <div class="modal-body" style="padding:10px 25px !important;">${content}</div>${this.options.noFooter}</div>
                    </div>
                    </div>`;
    } else {
      this.template = `<div class="modal fade ${this.options.modalClasses.join(' ')}" id="${this.options.modalId}" role="dialog" ${staticBackdrop} tabindex="-1" >
                     <div class="modal-dialog ${this.options.modalSize}" style="${forceWidth}" role="document">
                    <div class="modal-content" >
                    <div class="modal-header ${this.options.headerClassColor}">
                    <h4 class="modal-title w-100 text-${this.options.modalTitleAlign}">${this.options.title}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
                    </div>
                    <div class="modal-body" style="padding:10px 25px !important;">${content}</div>${this.options.noFooter}</div>
                    </div>
                    </div>`;
    }


    this.initModal();
  }

  initModal() {
    // Destruye cualquier otro modal que pueda existir con este id.
    this.destroyModal();

    // Lo inserta en el body
    const modal = document.createElement('div');
    modal.innerHTML = this.template;
    document.getElementsByTagName('body')[0].appendChild(modal.firstChild);

    // El modal se debe de abrir desde donde se creó la instancia de la clase.
  }

  openModal() {
    // Quiero que cuando cierren el modal, lo destruya, entonces aquí paso una
    // referencia de donde lo destruyo y la llamo al event listener de hide modal.
    this.options.onModalMounted(this.options.modalId, this.destroyModal);

    // Simular los 300ms que tarda en aparecer el modal.
    setTimeout(() => {
      this.options.onModalShown();
    }, 300);
  }


  updateBody(body) {
    document.querySelectorAll(`#${this.options.modalId} .modal-body`)[0].innerHTML = body;
  }

  destroyModal(modalId = this.options.modal) {
    const el = document.getElementById(modalId);
    if (el) {
      el.parentNode.removeChild(el);
    }
  }
}
