import $ from 'jquery';
import iziToast from 'izitoast';
import { prepareEvs } from '../../../plugin/js/reclasificacion';

const generarContactos = (dataSrc, idCliente) => {
  const url = `/clientes?id_cliente=${idCliente}&type=1`;
  $.ajax({
    type: 'POST',
    url: dataSrc + idCliente,
    contentType: 'application/json; charset=utf-8',
    dataType: 'json',
    success(response) {
      if (response.status === 'success') {
        const contactos = JSON.parse(response.message);
        let options = '';
        $.each(contactos, (key, val) => {
          options += `<option value="${val.id_cliente}" data-email-contacto="${val.email}">${val.nombre_cliente}</option>`;
        });
        $('.select_lista_contactos').empty().append(options);

        $('.contacto_container').show();
        $('.agregar_nuevo_contacto').attr('href', url).attr('target', '_blank');
      } else if (response.status === 'error') {
        iziToast.error({
          title: 'Error',
          message: response.message,
        });
        $('.agregar_nuevo_contacto').attr('href', url).attr('target', '_blank');
        $('.contacto_container').show();
        $('.select_lista_contactos').empty().append('<option value="0">Cliente sin contactos</option>');
      }
    },
    error(xhr) {
      iziToast.error({
        title: 'Ocurrio un error: ',
        message: `Request Status: ${xhr.status} Status Text: ${xhr.statusText}`,
      });
    },
  });
};

/**
 * Función para generar el color que le corresponde a un tipo de clasificación.
 * @param tipoClasificacion
 * @returns {string}
 */
const getColorClasificacion = (tipoClasificacion) => {
  let colorClasificacion;
  switch (tipoClasificacion) {
    case 'a':
      colorClasificacion = 'success';
      break;
    case 'b':
      colorClasificacion = 'success';
      break;
    case 'c':
      colorClasificacion = 'warning';
      break;
    case 'd':
      colorClasificacion = 'danger';
      break;
    case 'e':
      colorClasificacion = 'danger';
      break;
    default:
      colorClasificacion = 'danger';
  }
  return colorClasificacion;
};

/**
 * Función para generar un buscador de Clientes en el input especificado
 * @param inputName
 * @param dataSrcUrl
 */
const partnersBuscador = (inputName, dataSrcUrl) => {
  $(`${inputName}`).typeahead({
    order: 'asc',
    minlength: 1,
    maxItem: 15,
    hint: true,
    accent: true,
    group: {
      template: '{{group}}',
    },
    maxItemPerGroup: 5,
    backdrop: {
      'background-color': '#fff',
    },
    template(query, item) {
      let tipoClasificacion = item.tipo_clasificacion;
      const colorClasificacion = getColorClasificacion(tipoClasificacion);

      tipoClasificacion = tipoClasificacion.toUpperCase();

      const creditoContado = (+item.credito === 1) ? 'Crédito' : 'Contado';
      if (+item.tipo_cliente !== 3) {
        return `<p> <span>{{nombre_cliente}}</span>
          <span class="float-right badge badge-${colorClasificacion}">
          <i class="fa fa-star" aria-hidden="true"/>: ${tipoClasificacion} | ${creditoContado}</span> </p> `;
      }
      return '<p><span>{{nombre_cliente}}</span> </p> ';
    },
    dynamic: true,
    dropdownFilter: 'Todos',
    emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
    source: {
      Clientes: {
        display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
        ajax: {
          url: dataSrcUrl,
          path: 'data.datos.clientes',
        },
      },
      Contactos: {
        display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
        ajax: {
          url: dataSrcUrl,
          path: 'data.datos.contactos',
        },
      },
      Proveedores: {
        display: ['nombre_cliente', 'alias', 'email', 'nombre_facturacion', 'pagina_web'],
        ajax: {
          url: dataSrcUrl,
          path: 'data.datos.proveedores',
        },
      },
    },
    callback: {
      onClickAfter(node, a, item) {
        let tipoClasificacion = item.tipo_clasificacion;
        const colorClasificacion = getColorClasificacion(tipoClasificacion);
        tipoClasificacion = tipoClasificacion.toUpperCase();
        const creditoContado = (+item.credito === 1) ? 'Crédito' : 'Contado';
        if (+item.tipo_cliente !== 3) {
          $('.quick_info_client').html(`<span class="badge badge-${colorClasificacion}">
                <i class="fa fa-star" aria-hidden="true"/>: ${tipoClasificacion} | ${creditoContado}</span> </p>`);
          const id_cliente = item.id_cliente;
          const settings = Drupal.settings;
          prepareEvs(1, {
            colorClasificacion,
            tipoClasificacion,
            creditoContado,
            id_cliente,
            settings,
          });
        }

        // Bindear el id del cliente al input
        node.attr('data-id-cliente', item.id_cliente);
        node.attr('data-email-cliente', item.email);

        // Generar lista contactos solo para clientes Negocio/Distribuidor
        if (+item.tipo_negocio === 1 || +item.tipo_negocio === 3) {
          generarContactos('/system/tools/lista_contactos/', item.id_cliente);

          // Solamente agrega este attr cuando debe de tener contactos
          node.attr('data-tipo-negocio', item.tipo_negocio);
        } else {
          $('.contacto_container').hide();
          $('.select_lista_contactos').empty();
        }
      },
      onSearch(node, a) {
        if (a === '') {
          // Para prevenir errores de sobrescribir o duplicar
          $('.contacto_container').hide();
          $('.select_lista_contactos').empty();
          $('.quick_info_client').html('');
          node.removeAttr('data-id-cliente');
          node.removeAttr('data-tipo-negocio');
          node.removeAttr('data-email-cliente');
        }
      },
    },
  });
};

export default partnersBuscador;
