import $ from 'jquery';

/**
 * Agrega un loading al botón para simular que está trabajando después de haber hecho un submit.
 * @param m Método, ya sea start o end
 * @param el, el element del botón porque se pierde la referencia de this
 */
$.fn.partnersBtnControl = (m, el) => {
  const method = m.replace(/^[ ]+|[ ]+$/g, '');
  const currentElWidth = el.outerWidth();
  const currentHtml = el.html();
  if (method === 'start') {
    el.attr('data-html', currentHtml);
    el.attr('data-width', currentElWidth);
    el.attr('disabled', true);
    el.animate({
      width: currentElWidth + 50,
    }, 'fast', () => {
      setTimeout(() => {
        el.html(`${currentHtml}<div class="spinner_btn"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>`);
      }, 200);
    });
  } else if (method === 'end') {
    setTimeout(() => {
      const saveHtml = el.attr('data-html');
      const saveW = el.attr('data-width');
      el.removeAttr('disabled');
      el.removeAttr('data-html');
      el.removeAttr('data-width');
      el.css('width', saveW);
      el.html(saveHtml);
    }, 1000);
  }
};
