import $ from 'jquery';
import moment from 'moment';
import _ from 'lodash';
import iziToast from 'izitoast';
import numbro from 'numbro';
import '../../plugin/js/modal';
import 'izitoast/dist/css/iziToast.min.css';
import '../../plugin/js/jquery.form-validator';
import '../../plugin/css/daterangepicker.css';
import { axiosInstance as axios, urls } from './config/config';
import DateRangePicker from '../utilities/js/dateRangePicker';
import Reporteador from '../utilities/js/reporteador';
import PartnersModal from '../utilities/js/partnersModal';
import '../utilities/js/partnersBtn';

$(document).ready(() => {
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************
  const start = moment().startOf('day');
  const end = moment().endOf('day');
  const reporteadorOptions = {
    automatic_update: 1,
    updating: 0,
    filter: {
      search_bar: null,
      start_date: start,
      end_date: end,
    },
  };
  const reporteador = new Reporteador('#reporteador', `${urls.consultas}reporte_base`, reporteadorOptions, axios, () => {
  }, () => {
  });

  const picker = new DateRangePicker('#reportrange', start, end);
  $(picker.getElement()).on('apply.daterangepicker', (event, datePicker) => {
    picker.updateDates(datePicker.startDate, datePicker.endDate);
    const newData = _.cloneDeep(reporteador.getCurrentData());
    newData.filter.start_date = datePicker.startDate.format('DD/MM/YYYY');
    newData.filter.end_date = datePicker.endDate.format('DD/MM/YYYY');
    reporteador.rebuildOptions(newData);
  });

  function search() {
    const stringToSearch = $('.input_buscador_caja_grande').val();
    const newData = _.cloneDeep(reporteador.getCurrentData());
    newData.filter.search_bar = stringToSearch;
    reporteador.rebuildOptions(newData);
  }

  // Filtrado - Texto
  // eslint-disable-next-line func-names
  $(document).on('keyup', '.input_buscador_caja_grande', function (e) {
    clearTimeout($.data(this, 'timer'));
    if (e.keyCode === 13) search(true);
    else $(this).data('timer', setTimeout(search, 200));
  });
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************

  // ***************************************************************
  // ---------------------------- ENTRADA --------------------------
  // ***************************************************************
  $(document).on('click', '.nueva_entrada', (e) => {
    e.preventDefault();
    const Modal = new PartnersModal({
      title: 'Nueva Entrada',
      modalSize: 'modal-lg',
      modalId: 'nueva-entrada-caja-modal',
      onModalMounted(modalId, callback) {
        // noinspection JSUnresolvedFunction
        $(`#${modalId}`).modal('show').on('hidden.bs.modal', () => callback(modalId));
      },
    });

    Modal.openModal();

    axios.post(`${urls.consultas}nueva_entrada`, 1)
      .then((res) => {
        const data = { ...res.data };
        if (data.status === 'success') {
          Modal.updateBody(data.message);
          $.validate({
            form: '#nueva_entrada_form',
            errorMessageClass: 'invalid-feedback',
            inputParentClassOnError: 'text-danger',
            inputParentClassOnSuccess: 'text-success',
            errorElementClass: 'is-invalid',
          });
        } else if (data.status === 'error') {
          iziToast.error({
            title: 'Error',
            message: data.message,
          });
        }
      });
  });

  $(document).on('submit', '#nueva_entrada_form', (e) => {
    e.preventDefault();
    const btn = $(e.currentTarget).find('button[type="submit"]');
    const datos = $('#nueva_entrada_form').serializeArray();
    const datosEnvio = {};
    for (let i = 0; i < datos.length; i += 1) {
      datosEnvio[datos[i].name] = datos[i].value;
    }

    const cantidadEntrada = numbro(datosEnvio.cantidad_entrada).value();
    if (cantidadEntrada <= 0) {
      iziToast.error({
        title: 'Error',
        message: 'Ingresa una cantidad mayor a 0',
      });
      return;
    }

    btn.partnersBtnControl('start', btn);

    datosEnvio.cantidad_entrada = cantidadEntrada;
    axios.post(`${urls.consultas}capturar_entrada_caja`, datosEnvio)
      .then((res) => {
        if (res.data.status === 'success') {
          $('#nueva-entrada-caja-modal').modal('hide');
          reporteador.forceUpdate();
          iziToast.success({
            title: 'Bien!',
            message: res.data.message,
          });
        }
      });
  });
  // ***************************************************************
  // ---------------------------- ENTRADA --------------------------
  // ***************************************************************


  // ***************************************************************
  // ---------------------------- SALIDA ---------------------------
  // ***************************************************************
  $(document).on('click', '.nueva_salida', (e) => {
    e.preventDefault();
    const Modal = new PartnersModal({
      title: 'Nueva Salida',
      modalSize: 'modal-lg',
      modalId: 'nueva-salida-caja-modal',
      onModalMounted(modalId, callback) {
        // noinspection JSUnresolvedFunction
        $(`#${modalId}`).modal('show').on('hidden.bs.modal', () => callback(modalId));
      },
    });

    Modal.openModal();

    axios.post(`${urls.consultas}nueva_salida`, 1)
      .then((res) => {
        const data = { ...res.data };
        if (data.status === 'success') {
          Modal.updateBody(data.message);
          $.validate({
            form: '#nueva_salida_form',
            errorMessageClass: 'invalid-feedback',
            inputParentClassOnError: 'text-danger',
            inputParentClassOnSuccess: 'text-success',
            errorElementClass: 'is-invalid',
          });
        } else if (data.status === 'error') {
          iziToast.error({
            title: 'Error',
            message: data.message,
          });
        }
      });
  });


  $(document).on('blur', '.cantidad_salida, .cantidad_entrada', (e) => {
    const cantidadTotal = numbro($(e.currentTarget).val());

    // Cuando  no hay ningún número numbro no puede formatear o regresar simplemente 0 como
    // lo hacia numeral. Entonces hay que tratarlo diferente y hacer más condiciones.
    if (cantidadTotal.value() === undefined) {
      const removedText = $(e.currentTarget).val().replace(/\D+/g, '');
      if (removedText.length > 0) {
        $(e.currentTarget).val(numbro(removedText).format('0,0.00'));
      } else {
        $(e.currentTarget).val(numbro(0).format('0,0.00'));
      }
    } else {
      $(e.currentTarget).val(numbro(cantidadTotal).format('0,0.00'));
    }
  });


  $(document).on('submit', '#nueva_salida_form', (e) => {
    e.preventDefault();
    const btn = $(e.currentTarget).find('button[type="submit"]');
    const datos = $('#nueva_salida_form').serializeArray();
    const datosEnvio = {};
    for (let i = 0; i < datos.length; i += 1) {
      datosEnvio[datos[i].name] = datos[i].value;
    }

    const cantidadSalida = numbro(datosEnvio.cantidad_salida).value();
    if (cantidadSalida <= 0) {
      iziToast.error({
        title: 'Error',
        message: 'Ingresa una cantidad mayor a 0',
      });
      return;
    }

    btn.partnersBtnControl('start', btn);

    datosEnvio.cantidad_salida = cantidadSalida * -1;
    console.log(datosEnvio);
    axios.post(`${urls.consultas}capturar_salida_caja`, datosEnvio)
      .then((res) => {
        if (res.data.status === 'success') {
          $('#nueva-salida-caja-modal').modal('hide');
          reporteador.forceUpdate();
          iziToast.success({
            title: 'Bien!',
            message: res.data.message,
          });
        }
      });
  });
  // ***************************************************************
  // ---------------------------- SALIDA ---------------------------
  // ***************************************************************
});
