import axios from 'axios';
import jsLogger from '../../utilities/js/jsLogger';


// Drupal base URL para este modulo.
const baseURL = '/caja_grande';
const axiosInstance = axios.create({
  baseURL,
});

// Add a request interceptor
axiosInstance.interceptors.request.use(config => config, (error) => {
  jsLogger(error);
  return Promise.reject(error);
});

axiosInstance.interceptors.response.use(config => config, (error) => {
  jsLogger(error);
  return Promise.reject(error);
});


// Drupal URL's provenientes de .module
const urls = {
  sys_tools: '/system/tools/',
  template: '/render_template/',
  consultas: '/consultas/',
};


export { axiosInstance, urls };