import $ from 'jquery';
import moment from 'moment';
import _ from 'lodash';
import '../../plugin/js/modal';
import '../../plugin/js/tooltip';
import 'bootstrap-datepicker';
import '../../plugin/css/bootstrap-datepicker3.css';
import Reporteador from '../utilities/js/reporteador';
import DateRangePicker from '../utilities/js/dateRangePicker';
import { axiosInstance as axios, urls, datePickerLng } from './config/config';
import * as BackupsFns from './backupsFns';
import PartnersObs from '../utilities/js/partnersObs';
$.fn.datepicker.dates.es = datePickerLng;
$(document).ready(() => {
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************
  const start = moment().startOf('year');
  const end = moment().endOf('year');
  const reporteadorOptions = {
    automatic_update: 1,
    updating: 0,
    filter: {
      search_bar: null,
      start_date: start,
      end_date: end,
    },
  };
  const reporteador = new Reporteador('#reporteador', `${urls.consultas}reporte_base`, reporteadorOptions, axios, () => {
  }, () => {
  });


  const picker = new DateRangePicker('#reportrange', start, end, {}, '.parent-calendar');
  $(picker.getElement()).on('apply.daterangepicker', (event, datePicker) => {
    picker.updateDates(datePicker.startDate, datePicker.endDate);
    const newData = _.cloneDeep(reporteador.getCurrentData());
    newData.filter.start_date = datePicker.startDate.format('DD/MM/YYYY');
    newData.filter.end_date = datePicker.endDate.format('DD/MM/YYYY');
    reporteador.rebuildOptions(newData);
  });
  // ***************************************************************
  // --------------------------- REPORTE BASE ----------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------------- NUEVO RESPALDO ---------------------
  // ***************************************************************
  $(document).on('click', '.nuevo_respaldo', () => {
    BackupsFns.vistaNuevoBackup();
  });
  // ***************************************************************
  // -------------------------- NUEVO RESPALDO ---------------------
  // ***************************************************************

  // ***************************************************************
  // ----------------------- CAPTURAR RESPALDO ---------------------
  // ***************************************************************
  $(document).on('submit', '#nuevo_backup_form', (e) => {
    BackupsFns.capturarBackup(e, reporteador);
  });
  // ***************************************************************
  // ----------------------- CAPTURAR RESPALDO ---------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- HANDLE NUMERO EQUIPOS --------------------
  // ***************************************************************
  $(document).on('change', 'input[name="numero_equipos"]', (e) => {
    BackupsFns.handleNumeroEquipos(e);
  });

  $(document).on('change', '.equipo_nombre', (e) => {
    BackupsFns.handleEquipoNombreChange(e);
  });

  $(document).on('change keyup', '.equipo_uso', (e) => {
    BackupsFns.handleEquipoUsoChange(e);
  });

  $(document).on('change', 'select[name="paquete_respaldo"]', () => {
    BackupsFns.showEquiposContainer();
  });
  // ***************************************************************
  // -------------------- HANDLE NUMERO EQUIPOS --------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------ VISTA EQUIPOS ------------------------
  // ***************************************************************
  $(document).on('click', '.vista_equipos', (e) => {
    BackupsFns.vistaEquipos($(e.currentTarget).parents('tr').attr('data-id-backup'));
  });

  $(document).on('click', '.consultar_uso_equipo', (e) => {
    BackupsFns.consultarUsoEquipo($(e.currentTarget).attr('data-id-backup'), $(e.currentTarget).attr('data-id-equipo'), e);
  });

  $(document).on('click', '.consultar_uso_bucket', (e) => {
    BackupsFns.consultarUsoBucket($(e.currentTarget).parents('tr').attr('data-id-backup'), e, reporteador);
  });
  // ***************************************************************
  // ------------------------ VISTA EQUIPOS ------------------------
  // ***************************************************************

  // ***************************************************************
  // ------------------------ EDITAR EQUIPOS -----------------------
  // ***************************************************************
  $(document).on('click', '.editar_equipos_respaldo', (e) => {
    BackupsFns.vistaEditarEquipos(e);
  });

  $(document).on('change', '.nombre_equipo_editing', (e) => {
    BackupsFns.handleEditNombreEquipo(e);
  });

  $(document).on('change, keyup', '.espacio_equipo_editing', (e) => {
    BackupsFns.handleEditEspacioEquipo(e);
  });

  $(document).on('click', '.eliminar_equipo_edicion', (e) => {
    BackupsFns.eliminarEquipoEditar(e);
  });

  $(document).on('click', '.cancelar_edicion_equipos_respaldo', (e) => {
    BackupsFns.cancelarEdicion(e);
  });

  $(document).on('click', '.guardar_edicion_equipos_respaldo', (e) => {
    BackupsFns.guardarEdicionEquipos(e, reporteador);
  });

  $(document).on('click', '.agregar_nuevo_equipo_edicion', () => {
    BackupsFns.agregarEquipoEdicion();
  });
  // ***************************************************************
  // ------------------------ EDITAR EQUIPOS -----------------------
  // ***************************************************************


  // ***************************************************************
  // ------------------------ EDITAR PAQUETE -----------------------
  // ***************************************************************
  $(document).on('click', '.cambiar_paquete_backup', (e) => {
    BackupsFns.cambiarPaquete(e, reporteador);
  });
  // ***************************************************************
  // ------------------------ EDITAR PAQUETE -----------------------
  // ***************************************************************


  // ***************************************************************
  // ---------------------- ELIMINAR SERVICIO ----------------------
  // ***************************************************************
  $(document).on('click', '.pre_eliminar_backup', (e) => {
    BackupsFns.preEliminarServicio(e, reporteador);
  });

  $(document).on('click', '.eliminar_backup', (e) => {
    BackupsFns.eliminarServicio(e, reporteador);
  });
  // ***************************************************************
  // ---------------------- ELIMINAR SERVICIO ----------------------
  // ***************************************************************

  // ***************************************************************
  // ---------------------- STATUS ACCESS KEY ----------------------
  // ***************************************************************
  $(document).on('click', '.inactivar_access_key', (e) => {
    BackupsFns.inactivarAccessKey(e, reporteador);
  });

  $(document).on('click', '.activar_access_key', (e) => {
    BackupsFns.activarAccessKey(e, reporteador);
  });
  // ***************************************************************
  // ---------------------- STATUS ACCESS KEY ----------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- BACKUPS OBSERVACIONES --------------------
  // ***************************************************************
  $(document).on('click', '.status_obs', (e) => {
    const idBackup = $(e.currentTarget).parents('tr').attr('data-id-backup');
    const Obs = new PartnersObs({
      modalId: 'modal-backup-observaciones',
      url: `${urls.consultas}load_obs`,
      dbOptions: {
        index: 'id_backup',
        idIndex: idBackup,
        tabla: 'partners_backups',
        col: 'observaciones',
      },
      axios,
      axiosSuccess() {
        reporteador.forceUpdate();
      },
    });
    Obs.initObs();
  });
  // ***************************************************************
  // -------------------- BACKUPS OBSERVACIONES --------------------
  // ***************************************************************

  // ***************************************************************
  // -------------------- COPY TO CLIPBOARD KEYS -------------------
  // ***************************************************************
  $(document).on('click', '.copy_access_key', () => {
    BackupsFns.copyToKeyBoard('.access_key_text', '#vista-informacion-respaldo-modal .modal-body');
  });

  $(document).on('click', '.copy_secret_key', () => {
    BackupsFns.copyToKeyBoard('.secret_key_text', '#vista-informacion-respaldo-modal .modal-body');
  });

  $(document).on('click', '.copy_nombre_bucket', () => {
    BackupsFns.copyToKeyBoard('.nombre_bucket_text', '#vista-informacion-respaldo-modal .modal-body');
  });
  // ***************************************************************
  // -------------------- COPY TO CLIPBOARD KEYS -------------------
  // ***************************************************************

  // ***************************************************************
  // ----------------------- SEND SECRET KEYS ----------------------
  // ***************************************************************
  $(document).on('click', '.send-secret-key', (e) => {
    BackupsFns.sendSecretKey(e, reporteador);
  });
  // ***************************************************************
  // ----------------------- SEND SECRET KEYS ----------------------
  // ***************************************************************
});
