import axios from 'axios';
import jsLogger from '../../utilities/js/jsLogger';


// Drupal base URL para este modulo.
const baseURL = '/backups';
const axiosInstance = axios.create({
  baseURL,
});

// Add a request interceptor
axiosInstance.interceptors.request.use(config => config, (error) => {
  jsLogger(error);
  return Promise.reject(error);
});

axiosInstance.interceptors.response.use(config => config, (error) => {
  jsLogger(error);
  return Promise.reject(error);
});


// Drupal URL's provenientes de .module
const urls = {
  sys_tools: '/system/tools/',
  template: '/render_template/',
  consultas: '/consultas/',
};

const datePickerLng = {
  days: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
  daysShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb'],
  daysMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
  months: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
  monthsShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
  today: 'Hoy',
  monthsTitle: 'Meses',
  clear: 'Borrar',
  weekStart: 1,
  format: 'dd/mm/yyyy',
};

export { axiosInstance, urls, datePickerLng };
