// Follow the UMD template https://github.com/umdjs/umd/blob/master/templates/returnExportsGlobal.js
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module unless amdModuleId is set
        define(["jquery"], function (a0) {
            return (factory(a0));
        });
    } else if (typeof exports === 'object') {
        // Node. Does not work with strict CommonJS, but
        // only CommonJS-like environments that support module.exports,
        // like Node.
        module.exports = factory(require("jquery"));
    } else {
        factory(jQuery);
    }
}(this, function ($) {
    var PartnersFilter = function (table, options, cb) {

        // Set defaults settings for options.
        this.table = $(table);
        this.isShowing = false;
        this.element = false;
        this.sumatory = false;
        this.sumatory_cols = [];
        this.current_filter_view = 'value';
        this.globalFitlers = [];
        this.cb = cb;


        // Posible options overriding
        if (_.isEmpty(options)) options = [];

        if (typeof options.sumatory == "boolean") {
            this.sumatory = options.sumatory;
        }

        if ($.isArray(options.sumatory_cols)) {
            this.sumatory_cols = options.sumatory_cols;
        }

        // Init
        this.initialize();


        // Template
        this.template = '<div class="dropdown-menu-filter dropdown-menu">' +
            '<div class="container-fluid">' +
            '<div class="row">' +
            '<div class="col-md-6">' +
            '<button class="btn btn-light partners-filter-asc" role="button" style="padding-right:20px; border:1px solid #e3e3e3;">' +
            '<i class="fa fa-long-arrow-up buttons-filter-icon" aria-hidden="true"></i> Asc</button>' +
            '</div>' +
            '<div class="col-md-6">' +
            '<button class="btn btn-light partners-filter-desc" role="button" style="border: 1px solid #e3e3e3;">' +
            '<i class="fa fa-long-arrow-down buttons-filter-icon" aria-hidden="true"></i> Desc</button></div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12 text-right">' +
            '<small><a href="#" class="filter-view" data-view="condition">Filtra por Condición</a> | <a href="#" class="filter-view font-weight-bold" data-view="value">Filtra por Valor</a> </small>' +
            '</div>' +
            '</div>' +
            '<div class="row">' +
            '<div class="col-md-12">' +
            '<input type="text" class="form-control search-bar-filter apply-on-enter" placeholder="Buscar...">' +
            '</div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12">' +
            '<div class="form-check cursor-pointer"> <input class="form-check-input all-checkbox-items" id="select-all-checkbox" type="checkbox"  checked="checked"> <label class="form-check-label" for="select-all-checkbox">Seleccionar Todas</label> </div>' +
            '</div>' +
            '</div>' +
            '<div class="row">' +
            '<div class="col-md-12">' +
            '<div class="col-items-filter-container">' +
            '</div>' +
            '</div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12 text-right">' +
            '<button class="btn btn-light mx-2 partners-filter-apply" role="button" style="border: 1px solid #e3e3e3;">Aplicar</button>' +
            '<button class="btn btn-light partners-filter-clean" role="button" style="border: 1px solid #e3e3e3;">Limpiar</button>' +
            '</div>' +
            '</div>' +
            '</div></div>';

        this.template_condition = '<div class="dropdown-menu-filter dropdown-menu">' +
            '<div class="container-fluid">' +
            '<div class="row">' +
            '<div class="col-md-6">' +
            '<button class="btn btn-light partners-filter-asc" role="button" style="padding-right:20px; border: 1px solid #e3e3e3">' +
            '<i class="fa fa-long-arrow-up buttons-filter-icon" aria-hidden="true"></i> Asc</button>' +
            '</div>' +
            '<div class="col-md-6">' +
            '<button class="btn btn-light partners-filter-desc" role="button" style="border: 1px solid #e3e3e3;">' +
            '<i class="fa fa-long-arrow-down buttons-filter-icon" aria-hidden="true"></i> Desc</button></div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12 text-right">' +
            '<small><a href="#" class="filter-view font-weight-bold" data-view="condition">Filtra por Condición</a> | <a href="#" class="filter-view" data-view="value">Filtra por Valor</a> </small>' +
            '</div>' +
            '</div>' +
            '<div class="row">' +
            '<div class="col-md-12">' +
            '<span>Mostrar datos donde el valor</span>' +
            '<select class="form-control select_condition_values_filter_first my-1">' +
            '</select>' +
            '<input type="text" class="form-control condition_value_filter_first apply-on-enter">' +
            '</div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12 text-center">' +
            '<div class="form-check form-check-inline"> ' +
            '<label class="form-check-label font-weight-bold"> ' +
            '<input class="form-check-input" type="radio" name="choose_condition_filter" value="and" checked>Y</label> </div> ' +
            '<div class="form-check form-check-inline"> <label class="form-check-label font-weight-bold"> ' +
            '<input class="form-check-input" type="radio" name="choose_condition_filter" value="or">O</label> </div>' +
            '</div>' +
            '</div>' +
            '<div class="row">' +
            '<div class="col-md-12">' +
            '<select class="form-control select_condition_values_filter_second my-1">' +
            '</select>' +
            '<input type="text" class="form-control condition_value_filter_second apply-on-enter">' +
            '</div>' +
            '</div>' +
            '<div class="row my-2">' +
            '<div class="col-md-12 text-right">' +
            '<button class="btn btn-light mx-2 partners-filter-apply" role="button" style="border: 1px solid #e3e3e3;">Aplicar</button>' +
            '<button class="btn btn-light partners-filter-clean" role="button" style="border: 1px solid #e3e3e3;">Limpiar</button>' +
            '</div>' +
            '</div>' +
            '</div></div>';

        // Event Listeners.
        this.table.find('.partners-filter').on('click.partnersfilter', $.proxy(this.toggle, this));


    };

    PartnersFilter.prototype = {
        constructor: PartnersFilter,

        initialize: function () {
            this.table.find('thead').find('tr').find('th').each(function (i) {
                var $this = $(this);
                if (!$this.hasClass('dont-filter')) {
                    var filter_ico = $('<i>')
                        .addClass('fa fa-filter partners-filter')
                        .attr('aria-hidden', true)
                        .attr('data-index', i)
                        .css({
                            color: '#c0c0c0',
                            'font-size': '20px',
                            float: 'right',
                            cursor: 'pointer'
                        });
                    $this.append(filter_ico);
                }
            });

            this.table.find('tbody').find('tr').each(function (i) {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                $this.attr('data-row-index', i);
            });

            if (this.sumatory) {
                this.sumColsTotal();
            }
        },

        toggle: function (e) {
            this.element = $(e.target);
            if (this.isShowing) {
                this.hide(e);
            } else {
                this.show(e);
            }
        },

        hide: function () {
            $('.dropdown-menu-filter').remove();
            this.isShowing = false;
        },

        show: function (e) {
            this.hide();
            // Create a click proxy that is private to this instance of the filter, for unbinding
            this._outsideClickProxy = $.proxy(function (e) {
                this.outsideClick(e);
            }, this);

            // Bind global datepicker mousedown for hiding
            $(document)
                .on('mousedown.partnersfilter', this._outsideClickProxy)
                // also support mobile devices
                .on('touchend.partnersfilter', this._outsideClickProxy)
                // and also close when focus changes to outside the filter (eg. tabbing between controls)
                .on('focusin.partnersfilter', this._outsideClickProxy);

            // Reposition the filter if the window is resized while it's open
            $(window).on('resize.partnersfilter', $.proxy(function () {
                this.move(e);
            }, this));

            if (this.current_filter_view == 'value') {
                this.renderFilter(e);
            } else if (this.current_filter_view == 'condition') {
                this.renderViewCondition(e);
            }


            // Bind Filter actions
            $('.all-checkbox-items').off().on('click.partnersfilter', $.proxy(this.toggleAllCheckboxs, this));
            $('.checkbox-item').off().on('click.partnersfilter', $.proxy(this.toggleSingleCheckbox, this));
            $('.search-bar-filter').off().on('keyup.partnersfilter', $.proxy(this.filterCheckboxList, this));

            this._applyFilter = $.proxy(function () {
                this.applyFilter(e);
            }, this);

            this._cleanFilter = $.proxy(function () {
                this.cleanFilter(e);
            }, this);

            this._filterView = $.proxy(function (a) {
                a.preventDefault();
                this.toggleFilterView(e, a);
            }, this);

            this._sortAsc = $.proxy(function () {
                this.sortAsc(e);
            }, this);

            this._sortDesc = $.proxy(function () {
                this.sortDesc(e);
            }, this);


            $('.partners-filter-apply').off().on('click.partnersfilter', this._applyFilter);
            $('.partners-filter-clean').off().on('click.partnersfilter', this._cleanFilter);
            $('.partners-filter-asc').off().on('click.partnersfilter', this._sortAsc);
            $('.partners-filter-desc').off().on('click.partnersfilter', this._sortDesc);
            $('.filter-view').off().on('click.partnersfilter', this._filterView);
            $('.apply-on-enter').on('keyup', function (e) {
                if (e.keyCode == 13) {
                    $('.partners-filter-apply').click();
                }
            });

            this.isShowing = true;
        },

        outsideClick: function (e) {
            var target = $(e.target);
            // Si se da un click en la página excepto en el filter
            // llamar this.hide()
            if (
                e.type == "focusin" ||
                target.closest(this.element).length ||
                target.hasClass('dropdown-menu-filter') ||
                target.parents('div').hasClass('datepicker') ||
                target.closest('div').hasClass('dropdown-menu-filter') ||
                target.parents('div').hasClass('dropdown-menu-filter')
            ) return;
            this.hide();
            this.element.trigger('outsideClick.partnersfilter', this);
        },

        calculatePosition: function (e) {
            var $this = $(e.target);
            var top = $this.offset().top + $this.outerHeight();
            var left;
            var right = ($(window).width() - ($this.offset().left + $this.outerWidth()));

            // Todo: Cuando no tenga espacio para aprecer hacia abajo, hacer que se renderice hacia arriba.

            // 256 el el width  del dropdown-menu-filter
            if (right < 256) {
                left = $this.offset().left - 256 + $this.outerWidth();
            } else {
                left = $this.offset().left;
            }
            return [left, top];
        },

        move: function (e) {
            var p = this.calculatePosition(e);
            $('.dropdown-menu-filter').css({
                position: 'absolute',
                left: p[0],
                top: p[1],
                right: 'auto',
                display: 'block',
                zIndex: '9999'
            });
        },

        gatherColValues: function (index) {
            var values = [];
            var table = $(this.table);
            table.find('tbody').find('tr').each(function () {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                var $_this = $this.find('td').eq(index);
                values.push($_this.text().trim());
            });

            values = _.sortBy(values, [function (o) {
                return o;
            }]);
            return _.uniq(values);
        },

        gatherColValuesByTrVisible: function (index) {
            var values = [];
            var table = $(this.table);
            table.find('tbody').find('tr').each(function () {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                if ($this.css('display') == 'none') return;
                var $_this = $this.find('td').eq(index);
                values.push($_this.text().trim());
            });

            values = _.sortBy(values, [function (o) {
                return o;
            }]);
            return _.uniq(values);
        },

        gatherColValuesByPrevious: function (index, previous_index, previous_filtered_list) {
            var values = [];
            var table = $(this.table);
            table.find('tbody').find('tr').each(function () {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                var $_prev_this = $this.find('td').eq(previous_index);
                var $_this = $this.find('td').eq(index);
                if (_.findIndex(previous_filtered_list, function (o) {
                    return o == $_prev_this.text().trim()
                }) > -1) {
                    values.push($_this.text().trim());
                }
            });
            values = _.sortBy(values, [function (o) {
                return o;
            }]);
            return _.uniq(values);
        },

        renderListItems: function (index) {

            var items, checkbox_list = [], checked_values, previous_col, current_index;
            if (_.isEmpty(this.globalFitlers)) {
                items = this.gatherColValues(index);
                // Porque es la primera vez que la tabla se ha filtrado, entonces todos los checkbox
                // estarán en checked por default
                _.forEach(items, function (val) {
                    checkbox_list.push({
                        checked: true,
                        value: val
                    });
                });
            } else {
                if (_.findIndex(this.globalFitlers, function (o) {
                    return o.index == index
                }) > -1) {
                    if (_.nth(this.globalFitlers, -2) == undefined) {
                        items = this.gatherColValues(index);
                        // Sacar los valores que fueron marcados para filtrar.
                        // 0 es usado como index porque en este punto este es el unico elemento en this.globalfilters
                        checked_values = _.nth(this.globalFitlers, 0);

                        // Porque no hay filtros anteriores, significa que este es el único, por lo tanto deberá
                        // sacar los valores de la tabla original.
                        _.forEach(items, function (val) {
                            if (_.findIndex(checked_values.filtered_list, function (o) {
                                return o == val;
                            }) > -1) {
                                checkbox_list.push({
                                    checked: true,
                                    value: val
                                });
                            } else {
                                checkbox_list.push({
                                    checked: false,
                                    value: val
                                });
                            }
                        });
                    } else {
                        if (_.nth(this.globalFitlers, -1).index == index) {
                            previous_col = _.nth(this.globalFitlers, -2);

                            if (_.isEmpty(previous_col.filtered_list)) {
                                // Cuando está vacio, solamente puede ser porque el filtro anterior fue por condición,
                                // entonces como no registra nada el filtro por condición, deberá recoger los valores
                                // en base a la tabla resultante del filtro anterior.
                                var x = [];
                                _.forEach(previous_col.table_tr, function (o) {
                                    x.push(o.value.trim());
                                });
                                items = this.gatherColValuesByPrevious(index, previous_col.index, x);
                            } else {
                                items = this.gatherColValuesByPrevious(index, previous_col.index, previous_col.filtered_list);
                            }
                            // Sacar los valores que fueron marcados para filtrar
                            // -1 es usado como index porque ahí estan los ultimos valores de los checkbox que fueron marcados.
                            checked_values = _.nth(this.globalFitlers, -1);

                            _.forEach(items, function (val) {
                                if (_.findIndex(checked_values.filtered_list, function (o) {
                                    return o == val;
                                }) > -1) {
                                    checkbox_list.push({
                                        checked: true,
                                        value: val
                                    });
                                } else {
                                    checkbox_list.push({
                                        checked: false,
                                        value: val
                                    });
                                }
                            });

                        } else {
                            previous_col = _.nth(this.globalFitlers, -1);
                            items = this.gatherColValuesByPrevious(index, previous_col.index, previous_col.filtered_list);
                            current_index = _.findIndex(this.globalFitlers, function (o) {
                                return o.index == index;
                            });
                            checked_values = _.nth(this.globalFitlers, current_index);

                            _.forEach(items, function (val) {
                                if (_.findIndex(checked_values.filtered_list, function (o) {
                                    return o == val;
                                }) > -1) {
                                    checkbox_list.push({
                                        checked: true,
                                        value: val
                                    });
                                } else {
                                    checkbox_list.push({
                                        checked: false,
                                        value: val
                                    });
                                }
                            });
                        }
                    }
                } else {
                    items = this.gatherColValuesByTrVisible(index);

                    // Porque es un nuevo filtro, recolectará los valores de la tabla que está visible
                    // en ese momento.
                    _.forEach(items, function (val) {
                        checkbox_list.push({
                            checked: true,
                            value: val
                        });
                    });
                }
            }

            return checkbox_list;
        },

        renderFilter: function (e) {
            var el = $(e.target);
            var index = el.attr('data-index');
            var items = this.renderListItems(index);
            var template = this.template;

            var position = this.calculatePosition(e);
            var left = position[0];
            var top = position[1];


            var rendered_filter = $(this.template);
            var $tooltip = rendered_filter.css({
                position: 'absolute',
                left: left,
                top: top,
                right: 'auto',
                display: 'block',
                zIndex: '9999'
            }).show();

            var itemList = '';
            _.forEach(items, function (value) {
                var r = Math.floor((Math.random() * 100000) + 1);
                if (value.checked) {
                    itemList += '<div class="col-item-filter is-showing"><div class="form-check cursor-pointer"> <input class="form-check-input checkbox-item" type="checkbox" id="' + r + '" checked="checked"> <label class="form-check-label" for="' + r + '"> ' + value.value.trim() + '</label> </div> </div>'
                } else {
                    itemList += '<div class="col-item-filter is-showing"><div class="form-check cursor-pointer"> <input class="form-check-input checkbox-item" type="checkbox" id="' + r + '"> <label class="form-check-label" for="' + r + '"> ' + value.value.trim() + '</label> </div> </div>'
                }
            });

            $tooltip.appendTo('body');
            $('.col-items-filter-container').html(itemList);

            return $(template);
        },

        gatherTableRows: function (index) {
            var values = [], lastFiltered;
            var table = $(this.table);


            if (_.isEmpty(this.globalFitlers)) {
                table.find('tbody').find('tr').each(function () {
                    var $this = $(this);
                    if ($this.find('td').hasClass('has-tfoot')) return;
                    var $_this = $this.find('td').eq(index);
                    values.push({
                        trIndex: $this.attr('data-row-index'),
                        value: $_this.text().trim()
                    });
                });
            } else {
                if (_.findIndex(this.globalFitlers, function (o) {
                    return o.index == index
                }) > -1) {
                    if (_.nth(this.globalFitlers, -2) == undefined) {
                        table.find('tbody').find('tr').each(function () {
                            var $this = $(this);
                            if ($this.find('td').hasClass('has-tfoot')) return;
                            var $_this = $this.find('td').eq(index);
                            values.push({
                                trIndex: $this.attr('data-row-index'),
                                value: $_this.text().trim()
                            });
                        });
                    } else {
                        if (_.nth(this.globalFitlers, -1).index == index) {
                            lastFiltered = _.nth(this.globalFitlers, -2);
                            var filtered_list = [];

                            if (_.isEmpty(lastFiltered.filtered_list)) {
                                // Cuando está vacio, solamente puede ser porque el filtro anterior fue por condición,
                                // entonces como no registra nada el filtro por condición, deberá recoger los valores
                                // en base a la tabla resultante del filtro anterior.
                                _.forEach(lastFiltered.table_tr, function (o) {
                                    filtered_list.push(o.value.trim());
                                });
                            } else {
                                filtered_list = lastFiltered.filtered_list;
                            }
                            table.find('tbody').find('tr').each(function () {
                                var $this = $(this);
                                if ($this.find('td').hasClass('has-tfoot')) return;
                                var $_this = $this.find('td').eq(index);
                                var $_prev_this = $this.find('td').eq(lastFiltered.index);
                                _.findIndex(filtered_list, function (o) {
                                    if (o == $_prev_this.text().trim()) {
                                        values.push({
                                            trIndex: $this.attr('data-row-index'),
                                            value: $_this.text().trim()
                                        });
                                    }
                                });
                            });
                        } else {
                            lastFiltered = _.nth(this.globalFitlers, -1);
                            table.find('tbody').find('tr').each(function () {
                                var $this = $(this);
                                if ($this.find('td').hasClass('has-tfoot')) return;
                                var $_this = $this.find('td').eq(index);
                                var $_prev_this = $this.find('td').eq(lastFiltered.index);
                                _.findIndex(lastFiltered.filtered_list, function (o) {
                                    if (o == $_prev_this.text().trim()) {
                                        values.push({
                                            trIndex: $this.attr('data-row-index'),
                                            value: $_this.text().trim()
                                        });
                                    }
                                });
                            });
                        }
                    }
                } else {
                    table.find('tbody').find('tr').each(function () {
                        var $this = $(this);
                        if ($this.find('td').hasClass('has-tfoot')) return;
                        if ($this.css('display') == 'none') return;
                        var $_this = $this.find('td').eq(index);
                        values.push({
                            trIndex: $this.attr('data-row-index'),
                            value: $_this.text().trim()
                        });
                    });
                }
            }
            return _.uniq(values);
        },

        applyFilter: function (e) {
            var $target = $(e.target);
            var filter_view = this.current_filter_view;
            var index = $target.attr('data-index');
            var filter_list = [];
            if (filter_view == 'value') {
                $('.col-items-filter-container').find('.col-item-filter.is-showing').each(function () {
                    var $this = $(this);
                    if ($this.find('.checkbox-item').is(':checked')) {
                        filter_list.push($this.text().trim());
                    } else {
                    }
                });
                var table_items = this.gatherTableRows(index);
                var tr_list = this.processFilterByValue(table_items, filter_list);
            } else {
                var type_of_col = $(e.target).closest('th');
                var condition = $('input[name="choose_condition_filter"]:checked').val();
                var first_condition_filter = $('.select_condition_values_filter_first option:selected').val();
                var first_condition_value = $('.condition_value_filter_first').val().trim();
                var second_condition_filter = $('.select_condition_values_filter_second option:selected').val();
                var second_condition_value = $('.condition_value_filter_second').val().trim();


                if (first_condition_filter == 'not_set' && second_condition_filter == 'not_set') {
                    iziToast.error({
                        title: 'Error',
                        message: 'Selecciona al menos una condición'
                    });
                    return;
                }

                if (first_condition_value.length < 1 && second_condition_value.length < 1) {
                    iziToast.error({
                        title: 'Error',
                        message: 'Ingresa al menos un valor a condicionar'
                    });
                    return;
                }

                var table_items = this.gatherTableRows(index);
                var conditionFilter = {};
                var col_type;
                if (type_of_col.hasClass('filter-text')) {
                    col_type = 'text';
                } else if (type_of_col.hasClass('filter-date')) {
                    col_type = 'date';
                } else if (type_of_col.hasClass('filter-number')) {
                    col_type = 'number';
                }

                conditionFilter.condition = condition;
                conditionFilter.c1 = first_condition_filter;
                conditionFilter.c2 = second_condition_filter;
                conditionFilter.cv1 = first_condition_value;
                conditionFilter.cv2 = second_condition_value;
                var tr_list = this.processFilterByCondition(table_items, col_type, conditionFilter);

            }

            this.updateTableResults(tr_list);
            this.registerFiters(e, tr_list, filter_list, conditionFilter);
            $target.addClass('active-partners-filter');

            if (this.sumatory) {
                this.sumColsTotal();
            }

            this.hide();
        },

        processFilterByValue: function (table_items, filter_list) {
            var valueToCompare;
            var filtered_tr = [];
            var tr_list = [];
            _.forEach(filter_list, function (value) {
                valueToCompare = value;
                filtered_tr.push(_.filter(table_items, function (o) {
                    return valueToCompare == o.value;
                }));
            });
            _.forEach(filtered_tr, function (elm) {
                _.forEach(elm, function (v) {
                    tr_list.push(v);
                });
            });
            return tr_list;
        },

        processFilterByCondition: function (table_items, col_type, conditionFilter) {
            if (col_type == 'text') {

                var filtered_tr = [];
                _.forEach(table_items, function (o) {

                        if (conditionFilter.c2 == 'not_set') {
                            if (conditionFilter.c1 == 'equal') {
                                if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase()) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c1 == 'not_equal') {
                                if (conditionFilter.cv1.toUpperCase() !== o.value.toUpperCase()) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c1 == 'begins_with') {
                                if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "")) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c1 == 'ends_with') {
                                if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$")) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c1 == 'contains') {
                                if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c1 == 'not_contains') {
                                if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0) {
                                    filtered_tr.push(o);
                                }
                            }
                        } else if (conditionFilter.c1 == 'not_set') {
                            // Cuando solo llenan la parte de abajo de la condición
                            if (conditionFilter.c2 == 'equal') {
                                if (conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c2 == 'not_equal') {
                                if (conditionFilter.cv2.toUpperCase() !== o.value.toUpperCase()) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c2 == 'begins_with') {
                                if (o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c2 == 'ends_with') {
                                if (o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c2 == 'contains') {
                                if (o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                    filtered_tr.push(o);
                                }
                            } else if (conditionFilter.c2 == 'not_contains') {
                                if (o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                    filtered_tr.push(o);
                                }
                            }
                        } else if (conditionFilter.c1 != 'not_set' && conditionFilter.c2 != 'not_set') {
                            // Se llenaron ambas
                            if (conditionFilter.condition == 'and') {
                                if (conditionFilter.c1 == 'equal') {

                                    // Se deja esta condición, pero en realidad nunca va a dar verdadero
                                    if (conditionFilter.c2 == 'equal') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }


                                } else if (conditionFilter.c1 == 'not_equal') {

                                    if (conditionFilter.c2 == 'equal') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }


                                } else if (conditionFilter.c1 == 'begins_with') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'ends_with') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'contains') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'not_contains') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 && o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                }
                            } else if (conditionFilter.condition == 'or') {
                                if (conditionFilter.c1 == 'equal') {

                                    // Se deja esta condición, pero en realidad nunca va a dar verdadero
                                    if (conditionFilter.c2 == 'equal') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (conditionFilter.cv1.toUpperCase() == o.value.toUpperCase() || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }


                                } else if (conditionFilter.c1 == 'not_equal') {

                                    if (conditionFilter.c2 == 'equal') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (conditionFilter.cv1.toUpperCase() != o.value.toUpperCase() || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }


                                } else if (conditionFilter.c1 == 'begins_with') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().match("^" + conditionFilter.cv1.toUpperCase() + "") || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'ends_with') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().match("" + conditionFilter.cv1.toUpperCase() + "$") || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'contains') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) > -1 || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                } else if (conditionFilter.c1 == 'not_contains') {
                                    if (conditionFilter.c2 == 'equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || conditionFilter.cv2.toUpperCase() == o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_equal') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || conditionFilter.cv2.toUpperCase() != o.value.toUpperCase()) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'begins_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || o.value.toUpperCase().match("^" + conditionFilter.cv2.toUpperCase() + "")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'ends_with') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || o.value.toUpperCase().match("" + conditionFilter.cv2.toUpperCase() + "$")) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) > -1) {
                                            filtered_tr.push(o);
                                        }
                                    } else if (conditionFilter.c2 == 'not_contains') {
                                        if (o.value.toUpperCase().indexOf(conditionFilter.cv1.toUpperCase()) < 0 || o.value.toUpperCase().indexOf(conditionFilter.cv2.toUpperCase()) < 0) {
                                            filtered_tr.push(o);
                                        }
                                    }
                                }
                            }
                        }
                    }
                );
            } else if (col_type == 'number') {
                var filtered_tr = [];
                _.forEach(table_items, function (o) {
                    var o_value = parseFloat(o.value.replace(/,/g, ''));
                    var cv1 = parseFloat(conditionFilter.cv1);
                    var cv2 = parseFloat(conditionFilter.cv2);
                    if (conditionFilter.c2 == 'not_set') {
                        if (conditionFilter.c1 == 'equal') {
                            if (cv1 == o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'not_equal') {
                            if (cv1 !== o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'greater_than') {
                            if (o_value > cv1) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'greater_or_equal_than') {
                            if (o_value >= cv1) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'less_than') {
                            if (o_value < cv1) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'less_or_equal_than') {
                            if (o_value <= cv1) {
                                filtered_tr.push(o);
                            }
                        }
                    } else if (conditionFilter.c1 == 'not_set') {
                        // Cuando solo llenan la parte de abajo de la condición
                        if (conditionFilter.c2 == 'equal') {
                            if (cv2 == o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'not_equal') {
                            if (cv2 !== o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'greater_than') {
                            if (o_value > cv2) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                            if (o_value >= cv2) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'less_than') {
                            if (o_value < cv2) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'less_or_equal_than') {
                            if (o_value <= cv2) {
                                filtered_tr.push(o);
                            }
                        }
                    } else if (conditionFilter.c1 != 'not_set' && conditionFilter.c2 != 'not_set') {
                        // Se llenaron ambas condiciones
                        if (conditionFilter.condition == 'and') {
                            if (conditionFilter.c1 == 'equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 == o_value && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (cv1 == o_value && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (cv1 == o_value && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (cv1 == o_value && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (cv1 == o_value && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (cv1 == o_value && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'not_equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 != o_value && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (cv1 != o_value && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (cv1 != o_value && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (cv1 != o_value && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (cv1 != o_value && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (cv1 != o_value && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'greater_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value > cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value > cv1 && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value > cv1 && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value > cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value > cv1 && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value > cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'greater_or_equal_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value >= cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value >= cv1 && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value >= cv1 && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value >= cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value >= cv1 && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value >= cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'less_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value < cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value < cv1 && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value < cv1 && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value < cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value < cv1 && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value < cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'less_or_equal_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value <= cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value <= cv1 && cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value <= cv1 && o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value <= cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value <= cv1 && o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value <= cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            }

                        } else if (conditionFilter.condition == 'or') {
                            if (conditionFilter.c1 == 'equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 == o_value || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (cv1 == o_value || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (cv1 == o_value || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (cv1 == o_value || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (cv1 == o_value || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (cv1 == o_value || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'not_equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 != o_value || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (cv1 != o_value || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (cv1 != o_value || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (cv1 != o_value || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (cv1 != o_value || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (cv1 != o_value || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'greater_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value > cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value > cv1 || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value > cv1 || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value > cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value > cv1 || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value > cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'greater_or_equal_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value >= cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value >= cv1 || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value >= cv1 || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value >= cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value >= cv1 || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value >= cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'less_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value < cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value < cv1 || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value < cv1 || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value < cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value < cv1 || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value < cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'less_or_equal_than') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value <= cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'not_equal') {
                                    if (o_value <= cv1 || cv2 != o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_than') {
                                    if (o_value <= cv1 || o_value > cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'greater_or_equal_than') {
                                    if (o_value <= cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_than') {
                                    if (o_value <= cv1 || o_value < cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'less_or_equal_than') {
                                    if (o_value <= cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            }
                        }
                    }
                });
            } else if (col_type == 'date') {
                var filtered_tr = [];
                _.forEach(table_items, function (o) {
                    var o_date = o.value.split('/');
                    var o_value = moment("" + o_date[2] + "-" + o_date[1] + "-" + o_date[0] + "", "YY-MM-DD").unix();
                    var cv1_date = conditionFilter.cv1.split('/');
                    var cv1 = moment("" + cv1_date[2] + "-" + cv1_date[1] + "-" + cv1_date[0] + "", "YY-MM-DD").unix();
                    var cv2_date = conditionFilter.cv2.split('/');
                    var cv2 = moment("" + cv2_date[2] + "-" + cv2_date[1] + "-" + cv2_date[0] + "", "YY-MM-DD").unix();

                    if (conditionFilter.c2 == 'not_set') {
                        if (conditionFilter.c1 == 'equal') {
                            if (cv1 == o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'is_before') {
                            if (o_value < cv1) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c1 == 'is_after') {
                            if (o_value > cv1) {
                                filtered_tr.push(o);
                            }
                        }
                    } else if (conditionFilter.c1 == 'not_set') {
                        if (conditionFilter.c2 == 'equal') {
                            if (cv2 == o_value) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'is_before') {
                            if (o_value < cv2) {
                                filtered_tr.push(o);
                            }
                        } else if (conditionFilter.c2 == 'is_after') {
                            if (o_value > cv2) {
                                filtered_tr.push(o);
                            }
                        }
                    } else if (conditionFilter.c1 != 'not_set' && conditionFilter.c2 != 'not_set') {
                        if (conditionFilter.condition == 'and') {
                            if (conditionFilter.c1 == 'equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 == o_value && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (cv1 == o_value && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (cv1 == o_value && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'is_before') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value <= cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (o_value <= cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (o_value <= cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'is_after') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value >= cv1 && cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (o_value >= cv1 && o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (o_value >= cv1 && o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            }
                        } else if (conditionFilter.condition == 'or') {
                            if (conditionFilter.c1 == 'equal') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (cv1 == o_value || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (cv1 == o_value || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (cv1 == o_value || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'is_before') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value <= cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (o_value <= cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (o_value <= cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            } else if (conditionFilter.c1 == 'is_after') {
                                if (conditionFilter.c2 == 'equal') {
                                    if (o_value >= cv1 || cv2 == o_value) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_before') {
                                    if (o_value >= cv1 || o_value <= cv2) {
                                        filtered_tr.push(o);
                                    }
                                } else if (conditionFilter.c2 == 'is_after') {
                                    if (o_value >= cv1 || o_value >= cv2) {
                                        filtered_tr.push(o);
                                    }
                                }
                            }
                        }
                    }

                });
            }

            return filtered_tr;
        },

        updateTableResults: function (tr_list) {
            var table = $(this.table);
            table.find('tbody').find('tr').each(function () {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                $this.hide();
                var v = _.findIndex(tr_list, function (o) {
                    return o.trIndex == $this.attr('data-row-index');
                });
                if (v > -1) $this.show();
            });

            if(this.cb){
                this.cb();
            }
        },

        registerFiters: function (e, tr_list, filter_list, condition_filter) {
            var $target = $(e.target);
            var index = $target.attr('data-index');
            $.data(document, "myVariable", "I'm not really hiding");
            if (_.findIndex(this.globalFitlers, function (o) {
                return o.index == index;
            }) < 0) {
                this.globalFitlers.push({
                    index: index,
                    table_tr: tr_list,
                    filtered_list: filter_list,
                    condition_filter: condition_filter
                });
            } else {
                var exist_index = _.findIndex(this.globalFitlers, function (o) {
                    return o.index == index;
                });
                this.globalFitlers.splice(exist_index, 1, {
                    index: index,
                    table_tr: tr_list,
                    filtered_list: filter_list,
                    condition_filter: condition_filter
                });
            }
        },

        cleanFilter: function (e) {
            var current_index = $(e.target).attr('data-index');
            var element_index = _.findIndex(this.globalFitlers, function (o) {
                return o.index == current_index;
            });
            this.globalFitlers.splice(element_index, 1);
            var index = _.last(this.globalFitlers);
            var table_items, filter_list, tr_list;
            // Cuando no haya mas filtros, mostrará todos los tr de la tabla.
            if (index == undefined) {
                var values = [];
                var table = $(this.table);
                table.find('tbody').find('tr').each(function () {
                    var $this = $(this);
                    if ($this.find('td').hasClass('has-tfoot')) return;
                    values.push({
                        trIndex: $this.attr('data-row-index'),
                    });
                });
                tr_list = values;

            } else {
                table_items = this.gatherTableRowsAfterClean(index.index);
                filter_list = index.filtered_list;
                tr_list = this.processFilterByValue(table_items, filter_list);
            }


            this.updateTableResults(tr_list);
            $(e.target).removeClass('active-partners-filter');

            if (this.sumatory) {
                this.sumColsTotal();
            }

            this.hide();
        },

        gatherTableRowsAfterClean: function (index) {
            var table = $(this.table);
            var values = [];
            table.find('tbody').find('tr').each(function () {
                var $this = $(this);
                if ($this.find('td').hasClass('has-tfoot')) return;
                var $_this = $this.find('td').eq(index);
                values.push({
                    trIndex: $this.attr('data-row-index'),
                    value: $_this.text().trim()
                });
            });

            return values;
        },

        toggleFilterView: function (e, a) {
            var $target = $(a.target);
            if ($target.attr('data-view') == 'value') {
                if (this.current_filter_view == 'value') return;
                this.current_filter_view = 'value';
                this.show(e);
            } else if ($target.attr('data-view') == 'condition') {
                if (this.current_filter_view == 'condition') return;
                this.current_filter_view = 'condition';
                this.show(e);
            }
        },

        sortAsc: function (e) {
            var arrData = $(this.table).find('tbody').find('tr').get();
            var col = $(e.target).attr('data-index');
            var sortOrder = 1;
            var colType = $(e.target).closest('th');
            var table = $(this.table);
            arrData.sort(function (a, b) {
                var val1 = $(a).find('td').eq(col).text().toUpperCase();
                var val2 = $(b).find('td').eq(col).text().toUpperCase();
                if (colType.hasClass('filter-number')) {
                    return sortOrder == 1 ? parseFloat(val1.replace(/,/g, '')) - parseFloat(val2.replace(/,/g, '')) : parseFloat(val2.replace(/,/g, '')) - parseFloat(val1.replace(/,/g, ''));
                } else if (colType.hasClass('filter-date')) {
                    var a_date = val1.split('/');
                    var b_date = val2.split('/');
                    var a_unix = moment("" + a_date[2] + "-" + a_date[1] + "-" + a_date[0] + "", "YY-MM-DD").unix();
                    var b_unix = moment("" + b_date[2] + "-" + b_date[1] + "-" + b_date[0] + "", "YY-MM-DD").unix();
                    return sortOrder == 1 ? a_unix - b_unix : b_unix - a_unix;
                    return (val1 < val2) ? -sortOrder : (val1 > val2) ? sortOrder : 0;
                } else if (colType.hasClass('filter-text')) {
                    return (val1 < val2) ? -sortOrder : (val1 > val2) ? sortOrder : 0;
                }

            });
            $.each(arrData, function (index, row) {
                $(table).find('tbody').append(row);
            });

            $('.fa-sort-asc').remove();
            $('.fa-sort-desc').remove();

            var filter_ico = $('<i>')
                .addClass('fa fa-sort-asc')
                .attr('aria-hidden', true)
                .css({
                    color: '#c0c0c0',
                    'font-size': '20px',
                    'margin-left': '10px',
                });
            if ($(e.target).closest('th').find('.fa-sort-asc').length < 1) {
                $(e.target).closest('th').find('.fa-sort-desc').remove();
                $(e.target).closest('th').append(filter_ico);
            }
            this.hide();
        },

        sortDesc: function (e) {
            var arrData = $(this.table).find('tbody').find('tr').get();
            var col = $(e.target).attr('data-index');
            var sortOrder = -1;
            var colType = $(e.target).closest('th');
            var table = $(this.table);
            arrData.sort(function (a, b) {
                var val1 = $(a).find('td').eq(col).text().toUpperCase();
                var val2 = $(b).find('td').eq(col).text().toUpperCase();
                if (colType.hasClass('filter-number')) {
                    return sortOrder == 1 ? parseFloat(val1.replace(/,/g, '')) - parseFloat(val2.replace(/,/g, '')) : parseFloat(val2.replace(/,/g, '')) - parseFloat(val1.replace(/,/g, ''));
                } else if (colType.hasClass('filter-date')) {
                    var a_date = val1.split('/');
                    var b_date = val2.split('/');
                    var a_unix = moment("" + a_date[2] + "-" + a_date[1] + "-" + a_date[0] + "", "YY-MM-DD").unix();
                    var b_unix = moment("" + b_date[2] + "-" + b_date[1] + "-" + b_date[0] + "", "YY-MM-DD").unix();
                    return sortOrder == 1 ? a_unix - b_unix : b_unix - a_unix;
                } else if (colType.hasClass('filter-text')) {
                    return (val1 < val2) ? -sortOrder : (val1 > val2) ? sortOrder : 0;
                }
            });

            $.each(arrData, function (index, row) {
                $(table).find('tbody').append(row);
            });

            $('.fa-sort-asc').remove();
            $('.fa-sort-desc').remove();

            var filter_ico = $('<i>')
                .addClass('fa fa-sort-desc')
                .attr('aria-hidden', true)
                .css({
                    color: '#c0c0c0',
                    'font-size': '20px',
                    'margin-left': '10px',
                });
            if ($(e.target).closest('th').find('.fa-sort-desc').length < 1) {
                $(e.target).closest('th').find('.fa-sort-asc').remove();
                $(e.target).closest('th').append(filter_ico);
            }
            this.hide();
        },

        renderViewCondition: function (e) {
            var el = $(e.target);
            var index = el.attr('data-index');
            var template = this.template_condition;

            var position = this.calculatePosition(e);
            var left = position[0];
            var top = position[1];

            var rendered_filter = $(this.template_condition);
            var $tooltip = rendered_filter.css({
                position: 'absolute',
                left: left,
                top: top,
                right: 'auto',
                display: 'block',
                zIndex: '9999'
            }).show();

            $tooltip.appendTo('body');

            if (el.closest('th').hasClass('filter-date')) {
                $('.condition_value_filter_first').datepicker({
                    format: "dd/mm/yy",
                    todayBtn: "linked",
                    language: "es",
                    autoclose: true,
                    todayHighlight: true,
                    orientation: "auto"
                });
                $('.condition_value_filter_second').datepicker({
                    format: "dd/mm/yy",
                    todayBtn: "linked",
                    language: "es",
                    autoclose: true,
                    todayHighlight: true,
                    orientation: "auto"
                });
            }
            this.renderSelectConditions(e);
            this.renderConditionValues(e);
            return $(template);
        },

        renderConditionValues: function (e) {
            var index = $(e.target).attr('data-index');
            var conditions_filter = false;
            var indexFilter = _.findIndex(this.globalFitlers, function (o) {
                return o.index == index
            });

            if (indexFilter > -1) {
                conditions_filter = _.nth(this.globalFitlers, indexFilter);
                conditions_filter = conditions_filter.condition_filter;
                if (conditions_filter) {
                    if (conditions_filter.condition == 'and') {
                        $('input[name="choose_condition_filter"][value="and"]').attr('checked', true);
                    } else {
                        $('input[name="choose_condition_filter"][value="or"]').attr('checked', true);
                    }
                    $('.condition_value_filter_first').val(conditions_filter.cv1);
                    $('.condition_value_filter_second').val(conditions_filter.cv2);
                }
            }


        },

        renderSelectConditions: function (e) {
            var $target = $(e.target).closest('th');
            var index = $(e.target).attr('data-index');
            var conditions;
            if ($target.hasClass('filter-text')) {
                conditions = [
                    {name: '(Sin definir)', val: 'not_set'},
                    {name: 'Igual', val: 'equal'},
                    {name: 'Diferente', val: 'not_equal'},
                    {name: 'Empieza con', val: 'begins_with'},
                    {name: 'Termina con', val: 'ends_with'},
                    {name: 'Contiene', val: 'contains'},
                    {name: 'No contiene', val: 'not_contains'}
                ];
            } else if ($target.hasClass('filter-date')) {
                conditions = [
                    {name: '(Sin definir)', val: 'not_set'},
                    {name: 'Igual', val: 'equal'},
                    {name: 'Es antes', val: 'is_before'},
                    {name: 'Es después', val: 'is_after'}
                ];
            } else if ($target.hasClass('filter-number')) {
                conditions = [
                    {name: '(Sin definir)', val: 'not_set'},
                    {name: 'Igual', val: 'equal'},
                    {name: 'Diferente', val: 'not_equal'},
                    {name: 'Es mayor que', val: 'greater_than'},
                    {name: 'Es mayor o igual que', val: 'greater_or_equal_than'},
                    {name: 'Es menor que', val: 'less_than'},
                    {name: 'Es menor o igual que', val: 'less_or_equal_than'}
                ];
            }
            var conditions_filter = false;
            var indexFilter = _.findIndex(this.globalFitlers, function (o) {
                return o.index == index
            });

            if (indexFilter > -1) {
                conditions_filter = _.nth(this.globalFitlers, indexFilter);
                conditions_filter = conditions_filter.condition_filter;
            }
            _.forEach(conditions, function (o) {
                if (conditions_filter) {
                    if (conditions_filter.c1 == o.val) {
                        $('.select_condition_values_filter_first').append($('<option>').text(o.name).val(o.val).attr('selected', true));
                    } else {
                        $('.select_condition_values_filter_first').append($('<option>').text(o.name).val(o.val));
                    }
                    if (conditions_filter.c2 == o.val) {
                        $('.select_condition_values_filter_second').append($('<option>').text(o.name).val(o.val).attr('selected', true));
                    } else {
                        $('.select_condition_values_filter_second').append($('<option>').text(o.name).val(o.val));
                    }
                } else {
                    $('.select_condition_values_filter_first').append($('<option>').text(o.name).val(o.val));
                    $('.select_condition_values_filter_second').append($('<option>').text(o.name).val(o.val));
                }

            });
        },

        sumColsTotal: function () {
            var table = this.table;
            var cl = this.sumatory_cols;
            var cols = [];
            var final_totals = [];
            table.find('thead').find('th').each(function () {
                var $this = $(this);
                _.forEach(cl, function (e) {
                    if ($this.hasClass(e)) cols.push($this.index());
                });
            });
            cols = _.uniq(cols);
            _.forEach(cols, function (col) {
                var total = 0;
                table.find('tbody').find('tr:visible').each(function () {
                    var td = $(this).find('td').eq(col);
                    var val = td.text().replace(/,/g, '');
                    total += parseFloat(val);
                });

                final_totals.push({
                    col: col,
                    total: numeral(total).format('0,0.00')
                });
            });

            table.find('tfoot').remove();

            var tfoot = $('<tfoot>').append($('<tr>'));
            tfoot.find('tr').append(
                $('<td>').attr('colspan', cols[0])
                    .text('<strong>Total:</strong>')
            );

            // Los reporteadores que tenemos, tienen todas las columnas de numeros juntas, por eso aquí se puede hacer
            // de esta manera, con el append uno tras otro por que quedan todos juntos. Y al momento de declarar tfoot,
            // Se le agregó el colspan en base a la primer columna de numeros.
            _.forEach(final_totals, function (col) {
                tfoot.find('tr').append($('<td>').text("$" + col.total).css('text-align', 'right').addClass('total-filtered'));
            });
            table.append(tfoot);
        },

        toggleAllCheckboxs: function (e) {
            var target = $(e.target);
            if (target.is(':checked')) {
                $('.checkbox-item').each(function () {
                    if ($(this).closest('.col-item-filter').hasClass('is-showing')) {
                        $(this).prop('checked', true);
                    }
                });
                $('.partners-filter-apply').removeAttr('disabled');
            } else {
                $('.checkbox-item').each(function () {
                    if ($(this).closest('.col-item-filter').hasClass('is-showing')) {
                        $(this).removeAttr('checked');
                    }
                });
                $('.partners-filter-apply').attr('disabled', true);
            }
        },

        toggleSingleCheckbox: function () {
            var non_checked = 0;
            var checked = 1;
            var total_checkbox_checked = 0;

            $('.checkbox-item').each(function () {
                if ($(this).closest('.col-item-filter').hasClass('is-showing')) {
                    if ($(this).is(':checked')) {
                        non_checked = 1;
                    } else {
                        total_checkbox_checked += 1;
                        checked = 0;
                    }
                }

            });

            if (non_checked == 0) {
                $('.all-checkbox-items').removeAttr('checked');
                $('.all-checkbox-items').prop('indeterminate', false);
                $('.partners-filter-apply').attr('disabled', true);
            } else if (total_checkbox_checked == 0) {
                $('.all-checkbox-items').prop('checked', true);
                $('.all-checkbox-items').prop('indeterminate', false);
                $('.partners-filter-apply').removeAttr('disabled');
            } else {
                $('.all-checkbox-items').prop('indeterminate', true);
                $('.partners-filter-apply').removeAttr('disabled');
            }
        },

        filterCheckboxList: function (e) {
            var $target = $(e.target);
            var value = $target.val().toUpperCase().trim();
            var items = $('.col-items-filter-container').find(".col-item-filter");
            if (value == "") {
                // Restore Defaults
                items.addClass('is-showing');
                items.removeClass('is-hiding');
                items.show();
                this.restoreItemsList();
                return;
            }
            //hide all the items
            items.hide();

            //Recusively filter the jquery object to get results.
            items.filter(function () {
                var $t = $(this);
                $t.removeClass('is-hiding');
                $t.removeClass('is-showing');
                if ($t.text().toUpperCase().indexOf(value) > -1) {
                    $t.addClass('is-showing');
                    return true;
                } else {
                    $t.addClass('is-hiding');
                }
                return false;
            }).show();
        },

        restoreItemsList: function () {
            $('.all-checkbox-items').prop('indeterminate', false);
            $('.all-checkbox-items').prop('checked', true);
            $('.checkbox-item').each(function () {
                if ($(this).closest('.col-item-filter').hasClass('is-showing')) {
                    $(this).prop('checked', true);
                }
            });
        },

    };


    $.fn.partnersfilter = function (options, callback) {
        this.each(function () {
            var el = $(this);
            if (el.data('partnersfilter'))
                el.data('partnersfilter').remove();
            el.data('partnersfilter', new PartnersFilter(el, options, callback));
        });
        return this;
    };

    return PartnersFilter;
}));
