/* eslint-disable no-underscore-dangle,no-use-before-define,camelcase */
/* -------------------------------------------------------------------------- */
/*                                 Constantes                                 */
/* -------------------------------------------------------------------------- */

let WIDTH = window.innerWidth;
let HEIGHT = window.innerHeight;

const CANVAS_ID = 'eSignCanvas_';
const CLEAR_ID = 'eSignClear_';
const DATA_URL_ID = 'eSignDataUrl_';
const IMAGE_ID = 'eSignImage_';
const E_SIGN_TEMPLATE = `<div class="eSignContainer" style="width: 100%; height: 90vh;">

    <div style="height: inherit;">
            <canvas id="${CANVAS_ID}#id#" style="width: 100%; height: inherit;">
            Tu navegador no soporta esta funcionalidad.
            </canvas>
    </div>

    <div class="row">
        <div class="col-md-12">
            <button type="button" class="btn btn-lg btn-danger" style="transform: translate(+5%, -105%);" id="${CLEAR_ID}#id#"><i class="fas fa-times"></i> Limpiar</button>
        </div>
    </div>
    <input type="hidden" id="${DATA_URL_ID}#id#" class="form-control" value="dataURL">
    <div class="row">
      <div class="col-md-12">
          <img id="${IMAGE_ID}#id#" src="" alt="Firma" class="d-none"/>
      </div>
    </div>
</div>`;

/* -------------------------------------------------------------------------- */
/*                                      .                                     */
/* -------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------- */
/*                             Renderizar elemento                            */
/* -------------------------------------------------------------------------- */

/**
 * Renderizar componenetes
 */
const eSign_renderComponent = () => {
  const IS_MOBILE = function () {
    let check = false;
    (function (a) { if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true; }(navigator.userAgent || navigator.vendor || window.opera));
    return check;
  };

  if (IS_MOBILE()) {
    WIDTH = window.innerHeight;
    HEIGHT = window.innerWidth;
  }

  const ELEMENTS = document.getElementsByTagName('e-signature');
  [...ELEMENTS].forEach((element) => {
    /* ----------------------------- Crear elemento ----------------------------- */

    let draw;
    const _ID = eSign_randomId();
    const _DATA_ID_URL_ATTR = element.getAttribute('dataIdUrl');
    const _SHOW_IMG = +element.getAttribute('img');
    let _TEMPLATE = E_SIGN_TEMPLATE.replace(/#id#/g, _ID);
    if (_DATA_ID_URL_ATTR) {
      _TEMPLATE = _TEMPLATE.replace(`${DATA_URL_ID}${_ID}`, _DATA_ID_URL_ATTR);
    }
    const _ELEMENT = eSign_htmlToElement(_TEMPLATE);
    element.parentElement.replaceChild(_ELEMENT, element);

    /* ------------------------------------ . ----------------------------------- */

    /* -------------------------------- Elementos ------------------------------- */

    const _CANVAS = document.getElementById(`${CANVAS_ID}${_ID}`);
    const _DATA_URL = document.getElementById((_DATA_ID_URL_ATTR || `${DATA_URL_ID}${_ID}`));
    const _IMAGE = document.getElementById(`${IMAGE_ID}${_ID}`);
    const _CLEAR_BTN = document.getElementById(`${CLEAR_ID}${_ID}`);

    /* ------------------------------------ . ----------------------------------- */

    /* ----------------------------- Iniciar canvas ----------------------------- */

    const _CTX = _CANVAS.getContext('2d');
    _CANVAS.width = WIDTH;
    _CANVAS.height = HEIGHT;
    let mousePos = { x: 0, y: 0 };
    let drawing = false;
    let lastPos = mousePos;
    _CTX.strokeStyle = '#222222';
    _CTX.lineWidth = 4;

    /* ------------------------------------ . ----------------------------------- */

    /* --------------------------------- Desktop -------------------------------- */

    _CANVAS.addEventListener('mousedown', (e) => {
      drawing = true;
      lastPos = eSign_getMousePos(_CANVAS, e);
    }, false);

    document.addEventListener('mouseup', () => {
      drawing = false;
      const dataUrl = _CANVAS.toDataURL();
      _IMAGE.setAttribute('src', dataUrl);
      if (_SHOW_IMG) {
        _IMAGE.classList.remove('d-none');
      }
    }, false);

    _CANVAS.addEventListener('mousemove', (e) => {
      mousePos = eSign_getMousePos(_CANVAS, e);
    }, false);

    /* ------------------------------------ . ----------------------------------- */
    /* ---------------------------------- Móvil --------------------------------- */

    _CANVAS.addEventListener('touchmove', (e) => {
      const touch = e.touches[0];
      const me = new MouseEvent('mousemove', {
        clientX: touch.clientX,
        clientY: touch.clientY,
      });
      _CANVAS.dispatchEvent(me);
    }, false);

    _CANVAS.addEventListener('touchstart', (e) => {
      mousePos = eSign_getTouchPos(_CANVAS, e);
      const touch = e.touches[0];
      const me = new MouseEvent('mousedown', {
        clientX: touch.clientX,
        clientY: touch.clientY,
      });
      _CANVAS.dispatchEvent(me);
    }, false);

    _CANVAS.addEventListener('touchend', () => {
      const me = new MouseEvent('mouseup', {});
      _CANVAS.dispatchEvent(me);

      const dataUrl = _CANVAS.toDataURL();
      _IMAGE.setAttribute('src', dataUrl);
      if (_SHOW_IMG) {
        _IMAGE.classList.remove('d-none');
      }
    }, false);

    /* ------------------------------------ . ----------------------------------- */

    /* -------------------------------- interfaz -------------------------------- */

    _CLEAR_BTN.addEventListener('click', () => {
      eSign_clearCanvas(_CANVAS, _CTX);
      _DATA_URL.value = '';
      _IMAGE.setAttribute('src', '');
      if (_SHOW_IMG) {
        _IMAGE.classList.add('d-none');
      }
    }, false);

    _IMAGE.addEventListener('load', () => {
      _DATA_URL.value = resample(_IMAGE);
    });

    /* ------------------------------------ . ----------------------------------- */

    /* ------------------------- Crear bucle para dibujo ------------------------ */

    /**
     * Actualizar canvas
     */
    const renderCanvas = () => {
      if (drawing) {
        _CTX.moveTo(lastPos.x, lastPos.y);
        _CTX.lineTo(mousePos.x, mousePos.y);
        _CTX.stroke();
        lastPos = mousePos;
      }
    };
    (draw = () => {
      renderCanvas();
      eSign_requestAnimFrame(draw);
    })();

    /* ------------------------------------ . ----------------------------------- */
  });
};

/* -------------------------------------------------------------------------- */
/*                                      .                                     */
/* -------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------- */
/*                                 Auxiliares                                 */
/* -------------------------------------------------------------------------- */

/**
 * Generar ID aleatoria
 */
function eSign_randomId() {
  return Math.floor(Math.random() * 1000000) + 100;
}

/**
 * Convertir HTML a elemento
 *
 * @param {string} html
 * @returns {ChildNode}
 */
function eSign_htmlToElement(html) {
  const template = document.createElement('template');
  template.innerHTML = html.trim();
  return template.content.firstChild;
}

/**
 * Conseguir la posición del mouse
 *
 * @param {HTMLElement} canvasDom
 * @param {Event} mouseEvent
 * @returns {{x : number, y : number}}
 */
function eSign_getMousePos(canvasDom, mouseEvent) {
  const rect = canvasDom.getBoundingClientRect();
  return {
    x: (mouseEvent.clientX * (WIDTH / rect.width)) - rect.left,
    y: (mouseEvent.clientY * (HEIGHT / rect.height)) - rect.top,
  };
}

/**
 * Conseguuir posición de touch
 *
 * @param {HTMLElement} canvasDom
 * @param {Event} touchEvent
 * @returns {{x : number, y : number}}
 */
function eSign_getTouchPos(canvasDom, touchEvent) {
  const rect = canvasDom.getBoundingClientRect();
  return {
    x: (touchEvent.touches[0].clientX * (WIDTH / rect.width)) - rect.left,
    y: (touchEvent.touches[0].clientY * (HEIGHT / rect.height)) - rect.top,
  };
}

/**
 * Limpiar canvas
 *
 * @param {HTMLElement} canvas
 * @param {CanvasRenderingContext2D} ctx
 */
function eSign_clearCanvas(canvas, ctx) {
  // eslint-disable-next-line no-param-reassign
  canvas.width = canvas.width;
  ctx.strokeStyle = '#222222';
  ctx.lineWidth = 4;
}

function resample(IMAGE) {
  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d');
  canvas.width = 300; // target width
  canvas.height = 150; // target height
  ctx.drawImage(IMAGE,
    0, 0, IMAGE.width, IMAGE.height,
    0, 0, canvas.width, canvas.height);
  return canvas.toDataURL();
}

/* -------------------------------------------------------------------------- */
/*                                      .                                     */
/* -------------------------------------------------------------------------- */


/* -------------------------------------------------------------------------- */
/*                           Animationframe portable                          */
/* -------------------------------------------------------------------------- */

/**
 * Request animation frame
 */
const eSign_requestAnimFrame = (function (callback) {
  return window.requestAnimationFrame
    || window.webkitRequestAnimationFrame
    || window.mozRequestAnimationFrame
    || window.oRequestAnimationFrame
    || window.msRequestAnimaitonFrame
    || function () {
      window.setTimeout(callback, 1000 / 60);
    };
}());

/* -------------------------------------------------------------------------- */
/*                                      .                                     */
/* -------------------------------------------------------------------------- */

/* -------------------------------------------------------------------------- */
/*                              Inicio automático                             */
/* -------------------------------------------------------------------------- */

(() => {
  eSign_renderComponent();
})();

/* -------------------------------------------------------------------------- */
/*                                      .                                     */
/* -------------------------------------------------------------------------- */
