(function ($) {

  var PartnersModal = function (el, options) {
    var settings = $.extend({
      element: $(el),
      ajaxUrl: null,
      title: 'Partners Modal',
      content: null,
      headerClassColor: 'bg-primary text-white',
      modalSize: null,
      closeBtnClass: 'btn-danger',
      closeBtnPosition: 'left',
      modalClasses: [],
      modalId: $.now() + '_' + 'temporal',
      forceWidth: null,
      modalTitleAlign: 'center',
      noFooter: false,
      preventHideOnBackdrop: false,
      ajaxSuccessCallback: function () {
      },
      ajaxSuccessAlert: null,
      ajaxErrorAlert: null,
    }, options);


    if (settings.forceWidth !== null) {
      settings.forceWidth = 'style="max-width: ' + settings.forceWidth + '%; "';
    } else {
      settings.forceWidth = ' ';
    }
    (settings.noFooter === true) ? settings.noFooter = '' : settings.noFooter = '<div class="modal-footer" style="justify-content: flex-start !important;"><button type="button" role="button" class="btn btn-danger pull-' + settings.closeBtnPosition + ' cerrar" data-dismiss="modal">Cerrar</button></div>';

    var preventHideOnBackdrop = settings.preventHideOnBackdrop ? "static" : "true";

    settings.template = '<div class="modal fade ' + settings.modalClasses.join(' ') + '" id="' + settings.modalId + '" role="dialog" tabindex="-1" data-backdrop="' + preventHideOnBackdrop + '" >' +
      '<div class="modal-dialog ' + settings.modalSize + '" ' + settings.forceWidth + ' role="document">' +
      '<div class="modal-content" >' +
      '<div class="modal-header ' + settings.headerClassColor + '">' +
      '<h4 class="modal-title w-100 text-' + settings.modalTitleAlign + '">' + settings.title + '</h4>' +
      '<button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>' +
      '</div>' +
      '<div class="modal-body" style="padding:10px 25px !important;"></div>' +
      settings.noFooter +
      '</div>' +
      '</div>' +
      '</div>';

    // Generar Modal
    this.createModal(settings.modalId, settings.template);

    //Abrir Modal
    this.openModal(settings.modalId);

    //
    if (settings.ajaxUrl !== null && settings.content !== null) {
      console.error('No puedes utilizar contenido cargado con ajax y aparte un string de contenido');
      return false;
    } else if (settings.ajaxUrl === null && settings.content === null) {
      console.error('No estás cargando ninún contenido en el Modal');
      return false;
    } else if (settings.ajaxUrl !== null) {
      this.setAjaxContent(settings);

    } else if (settings.content !== null) {
      this.setContent(settings.modalId, settings.content);
    }


  };

  PartnersModal.prototype = {
    createModal: function (prevent, template) {
      $('body').find('#' + prevent).remove(); // prevenir duplicados
      $('body').append(template);
    },

    openModal: function (modalId) {
      $('#' + modalId).modal('show');
    },

    setAjaxContent: function (settings) {
      // Loader Mientras Carga, se eliminará una vez cargue
      $('#' + settings.modalId + ' .modal-body').html('<div class="sk-cube-grid"> <div class="sk-cube sk-cube1"></div> <div class="sk-cube sk-cube2"></div> <div class="sk-cube sk-cube3"></div> <div class="sk-cube sk-cube4"></div> <div class="sk-cube sk-cube5"></div> <div class="sk-cube sk-cube6"></div> <div class="sk-cube sk-cube7"></div> <div class="sk-cube sk-cube8"></div> <div class="sk-cube sk-cube9"></div> </div>');
      $.ajax({
        url: settings.ajaxUrl,
        success: function (data) {
          setTimeout(function () {
            $('#' + settings.modalId + ' .modal-body').html(data);
          }, 300);
          (settings.ajaxSuccessCallback()) ? settings.ajaxSuccessCallback().call() : '';
        },
        error: function () {
          (settings.ajaxErrorAlert !== null) ? alertify.error(settings.ajaxErrorAlert) : '';
        }
      })
    },

    setContent: function (modalId, content) {
      $('#' + modalId + ' .modal-body').html(content);
    }


  };

  $.fn.partnersModal = function (options) {
    this.each(function () {
      var el = $(this);
      if (el.data('PartnersModal'))
        el.removeData('PartnersModal');
      el.data('PartnersModal', new PartnersModal(el, options));
    });
    return this;
  };

  return PartnersModal;

}(jQuery));


(function ($) {

  var PartnersObs = function (el, options) {
    this.modalId = options.modalId;
    this.ajaxUrl = options.ajaxUrl;
    this.index = options.index;
    this.id_index = options.id_index;
    this.tabla = options.tabla;
    this.col = options.col;
    this.only_view = options.only_view;
    this.auth_user = options.auth_user;
    this.closeAfterSuccess = options.closeAfterSuccess;
    this.ajaxSuccessCallback = options.ajaxSuccessCallback;
    this.extra_val = options.extra_val;
    this.extra_col = options.extra_col;
    this.custom_condition = options.custom_condition;
    this.allowReminder = options.allowReminder;
    this.idCliente = options.idCliente;
    this.nombreCliente = options.nombreCliente;
    this.subjectReminder = options.subjectReminder;

    //Cargar Observaciones
    this.cargarObservaciones();

  };

  PartnersObs.prototype = {
    constructor: PartnersObs,

    cargarObservaciones: function () {
      var envio = {};
      var loader = '<div class="sk-cube-grid"> ' +
        '<div class="sk-cube sk-cube1"></div> ' +
        '<div class="sk-cube sk-cube2"></div> ' +
        '<div class="sk-cube sk-cube3"></div> ' +
        '<div class="sk-cube sk-cube4"></div> ' +
        '<div class="sk-cube sk-cube5"></div> ' +
        '<div class="sk-cube sk-cube6"></div> ' +
        '<div class="sk-cube sk-cube7"></div> ' +
        '<div class="sk-cube sk-cube8"></div> ' +
        '<div class="sk-cube sk-cube9"></div> </div>';
      envio.tabla = this.tabla;
      envio.col = this.col;
      envio.index = this.index;
      envio.id_index = this.id_index;
      envio.type = 1;
      envio.only_view = this.only_view;
      envio.allowReminder = this.allowReminder;

      if (this.custom_condition) {
        envio.custom_condition = this.custom_condition;
      }


      envio = JSON.stringify(envio);
      var modalId = this.modalId;
      $(this).partnersModal({
        title: 'Observaciones',
        modalSize: 'modal-lg',
        modalId: this.modalId,
        content: loader
      });

      var $this = this;
      var $this_guardar = this.guardarObservaciones;
      var $this_guardar_recordatorio = this.guardarObservacionesAsReminder;
      console.log($this);
      $.ajax({
        type: 'POST',
        url: this.ajaxUrl,
        data: envio,
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (response) {
          if (response.status == 'success') {
            $('#' + modalId + ' .modal-body').html(response.message);
            $('#guardar-observacion').click($.proxy($this_guardar, $this));
            if ($this.allowReminder) {
              $('#guardar-observacion-as-reminder').click($.proxy($this_guardar_recordatorio, $this));
            }
          } else if (response.status == 'error') {
            iziToast.error({
              title: "Error",
              message: response.message
            });
          }
        },
        error: function (xhr) {
          iziToast.error({
            title: "Ocurrio un error: ",
            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
          });
        }
      });


    },

    guardarObservaciones: function () {
      var textoObservacion = $("#textarea-observacion").val();
      if (!$.trim(textoObservacion).length) {
        iziToast.error({
          title: 'Error',
          message: 'Ingresa una observación'
        });
        return false;
      }
      $('#guardar-observacion').partnersBtnControl('start');

      var ajaxSuccessCallback = false;
      if (this.ajaxSuccessCallback) {
        ajaxSuccessCallback = this.ajaxSuccessCallback;
      }

      var envio = {};
      envio.index = this.index;
      envio.id_index = this.id_index;
      envio.col = this.col;
      envio.tabla = this.tabla;
      envio.new_val = textoObservacion;
      envio.type = 2;
      if (this.extra_val) {
        envio.extra_val = this.extra_val;
        envio.extra_col = this.extra_col;
      }

      if (this.custom_condition) {
        envio.custom_condition = this.custom_condition;
      }
      var modalId = this.modalId;
      var closeAfterSuccess = this.closeAfterSuccess;
      var ajax_url = this.ajaxUrl;
      var ajaxSuccessCallback = false;
      if (this.ajaxSuccessCallback) {
        ajaxSuccessCallback = this.ajaxSuccessCallback;
      }

      var guardarObservacionesAsReminder = this.guardarObservacionesAsReminder;
      var that = this;
      if (this.auth_user) {
        auth_user(function (user_authenticated) {
          envio.name = JSON.parse(user_authenticated)[1];
          envio = JSON.stringify(envio);
          $.ajax({
            type: 'POST',
            url: ajax_url,
            data: envio,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (response) {
              if (response.status == 'success') {
                $('#' + modalId + ' .modal-body .tabla-obs > tbody:last-child').append(response.message);
                if (closeAfterSuccess) {
                  $('#' + modalId).modal('hide');
                } else {
                  $('#guardar-observacion').partnersBtnControl('end');
                  $('#textarea-observacion').focus();
                }

                ajaxSuccessCallback(user_authenticated);
                if (that.allowReminder) {
                  console.log("le vale");
                  guardarObservacionesAsReminder(that);
                }
              } else if (response.status == 'error') {
                iziToast.error({
                  title: "Error",
                  message: response.message
                });
              }
            },
            error: function (xhr) {
              iziToast.error({
                title: "Ocurrio un error: ",
                message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
              });
            }
          });
        });
      } else {
        envio = JSON.stringify(envio);
        $.ajax({
          type: 'POST',
          url: this.ajaxUrl,
          data: envio,
          contentType: "application/json; charset=utf-8",
          dataType: "json",
          success: function (response) {
            if (response.status == 'success') {
              $('#' + modalId + ' .modal-body .tabla-obs > tbody:last-child').append(response.message);
              $('#guardar-observacion').partnersBtnControl('end');
              $('#textarea-observacion').focus();
              $('#textarea-observacion').val('');
              ajaxSuccessCallback();
              if (that.allowReminder) {
                guardarObservacionesAsReminder(that);
              }
            } else if (response.status == 'error') {
              iziToast.error({
                title: "Error",
                message: response.message
              });
            }
          },
          error: function (xhr) {
            iziToast.error({
              title: "Ocurrio un error: ",
              message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
            });
          }
        });
      }
    },

    guardarObservacionesAsReminder: function (that) {
      var textoObservacion = $("#textarea-observacion").val();
      var data = {};
      data.index = that.index;
      data.id_index = that.id_index;
      data.col = that.col;
      data.tabla = that.tabla;
      data.new_val = textoObservacion;
      data.type = 2;
      if (that.extra_val) {
        data.extra_val = that.extra_val;
        data.extra_col = that.extra_col;
      }

      if (that.custom_condition) {
        data.custom_condition = that.custom_condition;
      }
      var modalId = that.modalId;
      var closeAfterSuccess = that.closeAfterSuccess;
      var ajax_url = that.ajaxUrl;
      var ajaxSuccessCallback = false;
      if (that.ajaxSuccessCallback) {
        ajaxSuccessCallback = that.ajaxSuccessCallback;
      }
      var $auth_user = that.auth_user;
      data.obsReminder = textoObservacion;
      data.setReminder = true;

      var subjectReminder = that.subjectReminder;
      data.subjectReminder = subjectReminder;

      var askForOtherCliente = true;
      if (that.idCliente) {
        data.idCliente = that.idCliente;
        data.nombreCliente = that.nombreCliente;
        var htmlCliente = `<div class="row status_use_client_reminder" data-use-predefined="1">
          <div class="col-md-12 predefined_cliente_recordatorio">
              Se usará el cliente <span class="font-weight-bold">${that.nombreCliente}</span> para dar de alta
              el recordatorio.
          </div>
          <div class="col-md-12">
              <button class="btn btn-sm seleccionar_otro_cliente_recordatorio float-left">Usar otro cliente</button>
          </div>
          <div class="col-md-12 container_otro_cliente_recordatorio" style="display: none;">
              <div class="typeahead__container">
                  <div class="typeahead__field">
                  <span class="typeahead__query">
                      <input id="buscar_cliente_reminder" class="form-control" type="search" placeholder="Buscar Cliente"></span>
                  </div>
              </div>
          </div>
      </div>`;

      } else {
        askForOtherCliente = false;
        var htmlCliente = `<div class="row status_use_client_reminder" data-use-predefined="0">
          <div class="col-md-12 container_otro_cliente_recordatorio">
              <div class="typeahead__container">
                  <div class="typeahead__field">
                  <span class="typeahead__query">
                      <input id="buscar_cliente_reminder" class="form-control" type="search" placeholder="Buscar Cliente"></span>
                  </div>
              </div>
          </div>
      </div>`;
      }

      swal({
        title: "Observación capturada",
        html: "Deseas crear un recordatorio?",
        type: "success",
        showCancelButton: true,
        cancelButtonColor: "#DD6B55",
        confirmButtonText: "Si!",
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        onOpen: function () {
          fixBootstrapModal();
        },
        preConfirm: function () {
          return new Promise(function (resolve) {
            swal.mixin({
              confirmButtonText: "Siguiente &rarr;",
              showCancelButton: true,
              cancelButtonText: "Cancelar",
              progressSteps: ['<i class="far fa-user"></i>', '<i class="far fa-calendar-alt"></i>', '<i class="far fa-clock"></i>'],
            })
              .queue([
                {
                  title: "Cliente",
                  html: htmlCliente,
                  onOpen: function () {
                    var loadTypeahead = function () {
                      $('#buscar_cliente_reminder').typeahead({
                        order: "asc",
                        minlength: 1,
                        maxItem: 15,
                        hint: true,
                        accent: true,
                        group: {
                          template: "{{group}}"
                        },
                        maxItemPerGroup: 5,
                        backdrop: {
                          "background-color": "#fff"
                        },
                        template: function (query, item) {
                          var color_t_clasificacion;
                          var tipo_clasificacion = item.tipo_clasificacion;
                          switch (tipo_clasificacion) {
                            case 'a':
                              color_t_clasificacion = "success";
                              break;
                            case 'b':
                              color_t_clasificacion = "success";
                              break;
                            case 'c':
                              color_t_clasificacion = "warning";
                              break;
                            case 'd':
                              color_t_clasificacion = "danger";
                              break;
                            case 'e':
                              color_t_clasificacion = "danger";
                              break;
                          }
                          tipo_clasificacion = tipo_clasificacion.toUpperCase();

                          var credito_contado = (item.credito == 1) ? 'Crédito' : 'Contado';
                          if (item.tipo_cliente != 3) {
                            return '<p>' +
                              '<span>{{nombre_cliente}}</span> ' +
                              '<span class="float-right badge badge-' + color_t_clasificacion + '">' +
                              '<i class="fa fa-star" aria-hidden="true"></i>: ' + tipo_clasificacion +
                              ' | ' + credito_contado + '</span> </p> ';
                          } else {
                            return '<p><span>{{nombre_cliente}}</span> </p> ';
                          }

                        },
                        dynamic: true,
                        dropdownFilter: "Todos",
                        emptyTemplate: '<p>No existe el Cliente:  <i>"{{query}}" </i> <span class="btn btn-sm btn-success float-right agregar_nuevo_cliente" role="button">Agrégalo</span></p>',
                        source: {
                          "Clientes": {
                            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                            ajax: {
                              url: '/system/tools/lista_clientes/' + 'complete',
                              path: "data.datos.clientes",
                            }
                          },
                          "Contactos": {
                            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                            ajax: {
                              url: '/system/tools/lista_clientes/' + 'complete',
                              path: "data.datos.contactos",
                            }
                          },
                          "Proveedores": {
                            display: ["nombre_cliente", "alias", "email", "nombre_facturacion", "pagina_web"],
                            ajax: {
                              url: '/system/tools/lista_clientes/' + 'complete',
                              path: "data.datos.proveedores",
                            }
                          }
                        },
                        callback: {
                          onClickAfter: function (node, a, item, event) {
                            $('.container_otro_cliente_recordatorio').closest('.swal2-content').css('height', 'auto');
                            //Bindear el id del cliente al input
                            node.attr('data-id-cliente', item.id_cliente);
                            node.attr('data-nombre-cliente', item.nombre_cliente);
                            node.attr('data-tipo-cliente', item.tipo_cliente);
                          },
                          onSearch: function (node, a, item, event) {
                            if (a == '') {
                              // Para prevenir errores de sobrescribir o duplicar
                              node.removeAttr('data-id-cliente');
                              node.removeAttr('data-nombre-cliente');
                            }
                          },
                          onResult: function () {
                            setTimeout(function () {
                              var listHeight = $('.typeahead__list').height();
                              $('.container_otro_cliente_recordatorio').closest('.swal2-content').css('height', listHeight + 50);
                            }, 10);
                          },
                          onCancel: function () {
                            node.removeAttr('data-id-cliente');
                          }
                        }
                      });
                    };
                    fixBootstrapModal();

                    // Solo se preguntará si quiere usar otro cliente en caso de que ya venga con un cliente,
                    // Si no viene con ningún cliente, entonces ni preguntar, simplemente mostrar el typeahead
                    if (askForOtherCliente) {
                      $('.seleccionar_otro_cliente_recordatorio').one('click', function () {
                        $('.container_otro_cliente_recordatorio').show();
                        $('.seleccionar_otro_cliente_recordatorio').remove();
                        $('.predefined_cliente_recordatorio').remove();
                        $('.status_use_client_reminder').attr('data-use-predefined', 0);
                        loadTypeahead();
                      });
                    } else {
                      loadTypeahead();
                    }

                  },
                  onAfterClose: function () {
                    $('.seleccionar_otro_cliente_recordatorio').off('click');
                  },
                  preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                      if ($('.status_use_client_reminder').attr('data-use-predefined') == 0) {
                        // Se uso el de usar otro cliente, validar que si lo hayan seleccionado
                        if (!$('#buscar_cliente_reminder').attr('data-id-cliente')) {
                          reject("Selecciona un Cliente");
                        }

                        // sobrescribir el idCliente y nombreCliente con el del typeahead
                        data.idCliente = $('#buscar_cliente_reminder').attr('data-id-cliente');
                        data.nombreCliente = $('#buscar_cliente_reminder').attr('data-nombre-cliente');

                      }
                      resolve();
                    }).catch(function (error) {
                      swal.showValidationError(error)
                    })
                  }
                },
                {
                  title: "Fecha del Recordatorio",
                  html: '<div class="col-sm-12" id="fecha-recordatorio-container"></div>',
                  onOpen: function () {
                    fixBootstrapModal();
                    var now = moment().format('DD-MM-YYYY');
                    $('#fecha-recordatorio-container').datepicker({
                      format: "dd/mm/yyyy",
                      todayBtn: "linked",
                      language: "es",
                      daysOfWeekDisabled: "0",
                      autoclose: true,
                      todayHighlight: true,
                      startDate: now,
                      orientation: "auto",
                    });

                    setTimeout(function () {
                      $('#fecha-recordatorio-container .datepicker').css('margin', 'auto');
                    }, 10);
                  },
                  preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                      if (!$('#fecha-recordatorio-container').datepicker('getDate')) {
                        reject("Selecciona una fecha");
                      }

                      data.fechaReminder = $('#fecha-recordatorio-container').datepicker('getDate');
                      resolve();
                    }).catch(function (error) {
                      swal.showValidationError(error)
                    })
                  }
                },
                {
                  title: "Hora del Recordatorio",
                  html: '<input class="form-control hora_recordatorio" placeholder="Ingresa una hora aproximada" />',
                  confirmButtonText: "Finalizar",
                  showLoaderOnConfirm: true,
                  onOpen: function () {
                    fixBootstrapModal();
                  },
                  preConfirm: function () {
                    return new Promise(function (resolve, reject) {
                      if ($.trim($('.hora_recordatorio').val()) == '') {
                        reject("Ingresa una hora aproximada");
                      }

                      data.horaReminder = $('.hora_recordatorio').val();
                      data = JSON.stringify(data);
                      $.ajax({
                        type: 'POST',
                        url: ajax_url,
                        data: data,
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                          if (response.status == 'success') {
                            resolve();
                          } else if (response.status == 'error') {
                            iziToast.error({
                              title: "Error",
                              message: response.message
                            });
                          }
                        },
                        error: function (xhr) {
                          iziToast.error({
                            title: "Ocurrio un error: ",
                            message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                          });
                        }
                      });
                    }).catch(function (error) {
                      swal.showValidationError(error)
                    })
                  }
                }
              ])
              .then(function (a) {
                $('#textarea-observacion').val('').focus();
                if (a.dismiss == 'cancel') {
                  swal.close();
                } else if (a.value) {
                  swal({
                    title: 'Bien!',
                    timer: 1000,
                    text: 'Recordatorio capturado',
                    type: 'success'
                  });
                }
              });
          });
        },
        allowOutsideClick: false
      }).then(function (a) {
        if (a.dismiss == 'cancel') {
          swal.close();
          $('#textarea-observacion').val('').focus();
        }
      });
    }
  };

  $.fn.partnersObs = function (options) {
    this.each(function () {
      var el = $(this);
      if (el.data('PartnersObs'))
        el.removeData('PartnersObs');
      el.data('PartnersObs', new PartnersObs(el, options));
    });
    return this;
  };

  return PartnersObs;

}
  (jQuery)
)
  ;


(function ($) {

  var PartnersEstatus = function (el, options) {
    this.el = el;
    this.ajaxUrl = options.ajaxUrl;
    this.campo = options.campo;
    this.dataId = options.dataId;
    this.dataValor = options.dataValor;
    this.ajaxSuccessCallback = options.ajaxSuccessCallback;
    this.elementoTr = el.parents('tr');
    this.modalId = 'estatusBitacora';
    this.folio = this.elementoTr.attr(this.dataId);
    this.valor = parseInt(this.elementoTr.attr(this.dataValor)) ? 0 : 1;
    this.bitacora = (options.bitacora) ? options.bitacora : false;
    this.bitacoraModalTitle = (options.bitacoraModalTitle) ? options.bitacoraModalTitle : '';
    this.obsUrl = (options.obsUrl) ? options.obsUrl : null;
    this.bitacoraModalSize = (options.bitacoraModalSize) ? options.bitacoraModalSize : null;

    if (this.bitacora !== false) {
      this.guardarBitacoraTemplate();
    } else {
      this.guardarNormal();
    }

  };

  PartnersEstatus.prototype = {
    constructor: PartnersEstatus,

    guardarNormal: function () {
      var ajaxCallback = this.ajaxSuccessCallback;
      $.ajax({
        url: this.ajaxUrl + this.folio + '/' + this.valor + '/' + this.campo,
        success: function () {
          (ajaxCallback) ? ajaxCallback() : '';
        },
        error: function () {
          alertify.error('Ocurrio un error, intentalo de nuevo.');
        }
      });
    },

    guardarBitacoraTemplate: function () {
      var template = '<div class="show_on_loading"></div><div class="row hide_on_loading">' +
        '<div class="col-md-8"><textarea class="form-control text-bitacora"></textarea></div>' +
        '<div class="col-md-4"><button class="btn btn-success guardar-on-bitacora">Guardar</button></div>' +
        '</div>';
      $(this.el).partnersModal({
        content: template,
        modalSize: this.bitacoraModalSize,
        title: this.bitacoraModalTitle,
        modalId: this.modalId,
      });

      $('.guardar-on-bitacora').click($.proxy(this.guardarBitacora, this));
    },


    guardarBitacora: function () {
      var bitacora_text = $('#' + this.modalId).find('.text-bitacora').val();
      bitacora_text = bitacora_text.replace(/\//g, "~^~^");
      var ajaxCallback = this.ajaxSuccessCallback;
      var ajaxUrl = this.ajaxUrl;
      var folio = this.folio;
      var valor = this.valor;
      var campo = this.campo;
      if (bitacora_text == '') {
        alertify.error("Agrega una descripción para poder guardar el cambio");
        return false;
      } else {
        $('.hide_on_loading').hide();
        $('.show_on_loading').html('<div class="spinner"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>');

        // A veces el internet falla, y por lo mismo clickean varias veces el botón pensando que no se guarda aún, por eso poner un límite de tiempo para que se ingresen los datos.
        var check_timeOut = setTimeout(function () {
          $('.show_on_loading').html('<h3 class="text-danger">Tiempo de espera agotado, revisa tu conexión a internet e intentalo de nuevo.</h3>');
        }, 5000);
        $.ajax({
          url: this.obsUrl + this.folio + '/' + bitacora_text,
          success: function () {
            $.ajax({
              url: ajaxUrl + folio + '/' + valor + '/' + campo,
              success: function () {
                (ajaxCallback) ? ajaxCallback() : '';
                $('.modal').modal('hide');

                //Matar el tiempo de espera
                clearTimeout(check_timeOut);
              }
            });
          }

        })
      }

    }
  };


  $.fn.partnersEstatus = function (options) {
    this.each(function () {
      var el = $(this);
      if (el.data('PartnersEstatus'))
        el.removeData('PartnersEstatus');
      el.data('PartnersEstatus', new PartnersEstatus(el, options));
    });
    return this;
  };
  return PartnersEstatus;
}(jQuery));


(function ($) {
  var PartnersFacturado = function (el, options) {
    this.el = el;
    this.ajaxUrl = options.ajaxUrl;
    this.ajaxSuccessCallback = options.ajaxSuccessCallback;
    this.dataId = options.dataId;
    this.dataDescCaja = options.dataDescCaja;
    this.dataTotalCaja = options.dataTotalCaja;
    this.elementoTr = this.el.parents('tr');
    this.folio = this.elementoTr.attr(this.dataId);
    this.descCaja = this.elementoTr.attr(this.dataDescCaja);
    this.totalCaja = this.elementoTr.attr(this.dataTotalCaja);
    this.modalId = 'facturadoModal';
    this.obsUrl = options.obsUrl;
    this.cajaUrl = options.cajaUrl;

    //template
    var template = '<div class="show_on_loading"></div>' +
      '<div class="row hide_on_loading">' +
      '<div class="col-md-3"><button class="btn btn-danger" id="pagado-no">No</button></div>' +
      '<div class="col-md-4"><button class="btn btn-success" id="pagado-pagado">Pagado</button></div> ' +
      '<div class="col-md-4"><div class="btn btn-info" id="pagado-facturado">Facturado</div></div> ' +
      '</div>' +
      '</div>';

    //Abrir Modal
    $(this.el).partnersModal({
      content: template,
      modalSize: 'modal-sm',
      title: 'Selecciona',
      modalId: this.modalId,
      noFooter: true
    });

    //Bindear clicks
    $('#pagado-pagado').click($.proxy(this.pagado, this));
    $('#pagado-facturado').click($.proxy(this.facturado, this));
    $('#pagado-no').click($.proxy(this.noPagado, this));

  };

  PartnersFacturado.prototype = {
    constructor: PartnersFacturado,

    pagado: function () {
      $('#' + this.modalId).modal('hide');

      // Agregar comas para separar los numeros, aun asi prefiero utilizar mejor el input number
      var total_entrada = parseFloat(this.totalCaja).toLocaleString('es-MX');

      var template = '<div class="show_on_loading"></div>' +
        '<div class="row hide_on_loading">' +
        '<div class="col-md-5"><div class="form-group"> <label>Concepto:</label> <input type="text" class="form-control" value="' + this.descCaja + '" id="desc_caja"> </div></div>' +
        '<div class="col-md-5"><div class="form-group"><label>Entrada:</label><div class="input-group"> <div class="input-group-prepend"> <span class="input-group-text">$</span> </div><input type="text" class="form-control currency_input" value="' + total_entrada + '" id="num_entrada_caja"/></div></div></div>' +
        '<div class="col-md-2"><div class="form-group"> <label>Guardar:</label> <button class="btn btn-success" id="guardar-pagado">Guardar</button> </div></div>' +
        '</div>';

      $(this.el).partnersModal({
        title: 'Guardar en caja',
        content: template,
        modalId: 'modal-pagado-pagado',
        noFooter: true
      });
      $('.currency_input').css('text-align', 'right');
      $('.currency_input').on('keydown', function (e) {
        -1 !== $.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) || /65|67|86|88/.test(e.keyCode) && (!0 === e.ctrlKey || !0 === e.metaKey) || 35 <= e.keyCode && 40 >= e.keyCode || (e.shiftKey || 48 > e.keyCode || 57 < e.keyCode) && (96 > e.keyCode || 105 < e.keyCode) && e.preventDefault();
      });

      // Bindear evento de guardar
      $('#guardar-pagado').click($.proxy(this.guardarPagado, this));

    },

    facturado: function () {
      $('#' + this.modalId).modal('hide');

      var template = '<div class="show_on_loading"></div>' +
        '<div class="row hide_on_loading">' +
        '<div class="col-md-8"><input type="number" class="form-control currency_input" min="0" id="numero_factura" required="required"/></div>' +
        '<div class="col-md-3"><button class="btn btn-success" id="guardar-facturado">Guardar</button></div>';
      '</div>';


      $(this.el).partnersModal({
        title: 'Número de Factura',
        noFooter: true,
        content: template,
        modalSize: 'modal-sm',
        modalId: 'modal-pagado-facturado'
      });


      //Focus
      setTimeout(function () {
        $('#numero_factura').focus();
      }, 500);

      //Permitir solo números
      $('.currency_input').on('keydown', function (e) {
        if (e.keyCode == 13) {
          $('#guardar-facturado').click();
        } else {
          -1 !== $.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) || /65|67|86|88/.test(e.keyCode) && (!0 === e.ctrlKey || !0 === e.metaKey) || 35 <= e.keyCode && 40 >= e.keyCode || (e.shiftKey || 48 > e.keyCode || 57 < e.keyCode) && (96 > e.keyCode || 105 < e.keyCode) && e.preventDefault();
        }
      });


      // Bindear evento de guardar
      $('#guardar-facturado').click($.proxy(this.guardarFacturado, this));


    },

    noPagado: function () {
      var modalId = this.modalId;
      var ajaxCallback = this.ajaxSuccessCallback;

      $('.hide_on_loading').hide();
      $('.show_on_loading').html('<div class="spinner"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>');

      var check_timeOut = setTimeout(function () {
        $('.show_on_loading').html('<h3 class="text-danger">Tiempo de espera agotado, revisa tu conexión a internet e intentalo de nuevo.</h3>');
      }, 5000);

      $.ajax({
        url: this.ajaxUrl + this.folio + '/' + 0,
        success: function () {
          clearTimeout(check_timeOut);
          (ajaxCallback) ? ajaxCallback() : '';
          $('.show_on_loading').html('');
          $('#' + modalId).modal('hide');
        }
      });

    },

    guardarFacturado: function () {
      var modalId = 'modal-pagado-facturado';
      var ajaxCallback = this.ajaxSuccessCallback;
      var folio = this.folio;
      var ajaxUrl = this.ajaxUrl;
      var obsUrl = this.obsUrl;

      var num = $('#numero_factura').val();
      if (num == '') {
        alertify.error('Ingresa un número de factura');
        return false;
      }

      var d = new Date();
      var month = d.getMonth() + 1;
      var day = d.getDate();
      var date_output = d.getFullYear() + '-' +
        (('' + month).length < 2 ? '0' : '') + month + '-' +
        (('' + day).length < 2 ? '0' : '') + day;

      var texto_bitacora = 'Se marcó como facturado el día: ' + date_output + ' con el número de factura : ' + num;

      $('.hide_on_loading').hide();
      $('.show_on_loading').html('<div class="spinner"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>');

      var check_timeOut = setTimeout(function () {
        $('.show_on_loading').html('<h3 class="text-danger">Tiempo de espera agotado, revisa tu conexión a internet e intentalo de nuevo.</h3>');
      }, 5000);

      $.ajax({
        url: obsUrl + folio + '/' + texto_bitacora,
        success: function () {
          //Una vez guarde la observacion, guardar el estatus
          $.ajax({
            url: ajaxUrl + folio + '/' + 2,
            success: function () {
              clearTimeout(check_timeOut);
              (ajaxCallback) ? ajaxCallback() : '';
              $('.show_on_loading').html('');
              $('#' + modalId).modal('hide');
            }
          });
        }
      });

    },

    guardarPagado: function () {
      var desc_caja = $('#desc_caja').val();
      desc_caja = desc_caja.replace(/\//g, "~^~^");
      var total_entrada = $('#num_entrada_caja').val().replace(/[^0-9.-]+/g, '');
      var modalId = 'modal-pagado-pagado';
      var ajaxCallback = this.ajaxSuccessCallback;
      var folio = this.folio;
      var ajaxUrl = this.ajaxUrl;
      var obsUrl = this.obsUrl;
      var cajaUrl = this.cajaUrl;

      if (total_entrada == '') {
        alertify.error('Ingresa una cantidad');
        return false;
      }

      if (desc_caja == '') {
        alertify.error('Ingresa un concepto.');
        return false;
      }

      var d = new Date();
      var month = d.getMonth() + 1;
      var day = d.getDate();
      var date_output = d.getFullYear() + '-' +
        (('' + month).length < 2 ? '0' : '') + month + '-' +
        (('' + day).length < 2 ? '0' : '') + day;

      var texto_bitacora = 'Se capturó en caja el día: ' + date_output + ' bajo el concepto de: ' + desc_caja;

      $('.hide_on_loading').hide();
      $('.show_on_loading').html('<div class="spinner"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>');

      var check_timeOut = setTimeout(function () {
        $('.show_on_loading').html('<h3 class="text-danger">Tiempo de espera agotado, revisa tu conexión a internet e intentalo de nuevo.</h3>');
      }, 5000);


      //Guarda en caja
      $.ajax({
        url: cajaUrl + desc_caja + '/' + total_entrada,
        success: function () {
          // Guarda observación
          $.ajax({
            url: obsUrl + folio + '/' + texto_bitacora,
            success: function () {
              // Cambia el estatus
              $.ajax({
                url: ajaxUrl + folio + '/' + 1,
                success: function () {
                  clearTimeout(check_timeOut);
                  (ajaxCallback) ? ajaxCallback() : '';
                  $('.show_on_loading').html('');
                  $('#' + modalId).modal('hide');
                }
              })
            }
          });
        }
      });

    }


  };

  $.fn.partnersFacturado = function (options) {
    this.each(function () {
      var el = $(this);
      if (el.data('PartnersFacturado'))
        el.removeData('PartnersFacturado');
      el.data('PartnersFacturado', new PartnersFacturado(el, options))
    });
    return this;
  };
  return PartnersFacturado;
}(jQuery));

(function ($) {
  $.fn.partnersBtnControl = function (method) {
    method = method.replace(/^[ ]+|[ ]+$/g, '');
    var el = $(this);
    var current_el_w = el.outerWidth();
    var current_html = el.html();
    if (method == 'start') {
      el.attr('data-html', current_html);
      el.attr('data-width', current_el_w);
      el.attr('disabled', true);
      el.animate({
        'width': current_el_w + 50
      }, 'fast', function () {
        setTimeout(function () {
          el.html(current_html + '<div class="spinner_btn"> <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div> </div>');
        }, 200);
      })
    } else if (method == 'end') {
      setTimeout(function () {
        var save_html = el.attr('data-html');
        var save_w = el.attr('data-width');
        el.removeAttr('disabled');
        el.css('width', save_w);
        el.html(save_html);
      }, 1000);

    }
  }
}(jQuery));


(function ($) {

  /**
   *  BINDING
   */
  this.ruta_url;
  this.partnersEditableContent = function (ruta, callback) {
    this.ruta_url = ruta;
    this.callback = callback;
    $(document).on('click', '.partners-edit', function (e) {
      edit_init(e);
    });
    $(document).on('keyup', '.currently_editing', function (e) {
      if (e.ctrlKey && (e.which === 13)) {
        $(this).closest('.row').find('.save_edit_icon').click();
      }
    });
    $(document).on('click', '.save_edit_icon', function (e) {
      var edit_type = $(this).attr('data-edit-type');
      switch (edit_type) {
        case 'text':
          update_edit_text(e);
          break;
        case 'date':
          update_edit_date(e);
          break;
        case 'radio':
          update_edit_radio(e);
          break;
        case 'select':
          update_edit_select(e);
          break;
        case 'checkbox':
          update_edit_checkbox(e);
          break;
        case 'maps':
          update_edit_maps(e);
          break;
      }

    });

    $(document).on('click', '.cancel_edit_icon', function (e) {
      cancel_edit(e);
    });
  };

  this.edit_init = function (element) {
    // --- Tipos ---
    // |- Text
    // |- Select
    // |- Radio
    // |- Date
    // |- Checkbox
    // |- Maps

    var edit_type = $(element.target).attr('data-edit-type');

    switch (edit_type) {
      case 'text':
        edit_text(element);
        break;
      case 'date':
        edit_date(element);
        break;
      case 'radio':
        edit_radio(element);
        break;
      case 'select':
        edit_select(element);
        break;
      case 'checkbox':
        edit_checkbox(element);
        break;
      case 'maps':
        edit_maps(element);
        break;
    }
  };


  this.cancel_edit = function (element) {
    var edit_type = $(element.target).attr('data-edit-type');

    switch (edit_type) {
      case 'text':
        cancel_edit_text(element);
        break;
      case 'date':
        cancel_edit_date(element);
        break;
      case 'radio':
        cancel_edit_radio(element);
        break;
      case 'select':
        cancel_edit_select(element);
        break;
      case 'checkbox':
        cancel_edit_checkbox(element);
        break;
      case 'maps':
        cancel_edit_maps(element);
        break;
    }
  };


  /**
   *  Edit Type : "TEXT"
   */
  this.edit_text = function (element) {
    var el = $(element.target);

    var widget_type = el.attr('data-edit-widget-type');
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var input_val = el.closest('.row').find('.editable-field').text();
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_widget = el.attr('data-edit-widget-type');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_extra_ruta = el.attr('data-edit-extra-ruta');
    var remove_dato_extra = el.attr('data-remove-dato-extra');

    // Reset
    // el.closest('.row').find('.partners-edit').remove();
    el.closest('.row').find('.cancel_edit_icon').remove();
    el.closest('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success"  data-edit-type="text" data-remove-dato-extra="' + remove_dato_extra + '" data-edit-extra-ruta="' + edit_extra_ruta + '" data-edit-table="' + edit_table + '" data-edit-widget-type="' + edit_widget + '" data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '"  data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-type="text" role="button" aria-hidden="true"></i>');
    var editable_input;

    if (widget_type == 'input' || widget_type == 'link' || widget_type == 'phone' || widget_type == 'email') {
      if (remove_dato_extra == "true") {
        editable_input = $('<div class="row"> <i class="fas fa-minus-circle text-danger cursor-pointer delete_dato_extra col-md-2 text-center" data-id-dato="' + edit_id + '" style="font-size:20px; line-height: 34px;"></i> <input type="text" style="display: none;" class="form-control animated fadeInDownCustom currently_editing col-md-10"/></div>');
      } else {
        editable_input = $('<input type="text" style="display: none;" class="form-control animated fadeInDownCustom currently_editing"/>');
      }
    } else if (widget_type == 'textarea') {
      editable_input = $('<textarea class="form-control animated fadeInDownCustom currently_editing" rows="5" style="display:none;"></textarea>');
    }

    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      editable_input.insertBefore(parent_editable);

      // Se agrega hasta aca el val por .val() para que se permitan las comillas
      el.closest('.row').find('.currently_editing').val(input_val);
      control_btns.insertBefore(el);
      el.closest('.row').find('.currently_editing').show();
      el.closest('.row').find('.save_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').data("first_value", input_val);
    });
  };

  this.save_edit_text = function (element, edit_id, edit_col, edit_widget, edit_table, edit_table_key, edit_extra_ruta, remove_dato_extra) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var new_val = el.closest('.row').find('.currently_editing').val();
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="text" data-remove-dato-extra="' + remove_dato_extra + '" data-edit-extra-ruta="' + edit_extra_ruta + '" role="button" data-edit-table="' + edit_table + '" data-edit-widget-type="' + edit_widget + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    if (edit_widget == 'link') {
      parent_editable.html('<a target="_blank" href="' + new_val + '">' + new_val + '</a>');
    } else if (edit_widget == 'phone') {
      parent_editable.html('<a href="tel:' + new_val + '">' + new_val + '</a>');
    } else if (edit_widget == 'email') {
      parent_editable.html('<a href="mailto:' + new_val + '">' + new_val + '</a>');
    } else {
      parent_editable.html(new_val);
    }
    el.closest('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();
      $('.delete_dato_extra').remove();

      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
      el.closest('.row').find('.save_edit_icon').remove();

    });


  };

  this.cancel_edit_text = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.closest('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.closest('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_widget = el.closest('.row').find('.save_edit_icon').attr('data-edit-widget-type');
    var edit_table = el.closest('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_extra_ruta = el.parents('.row').find('.save_edit_icon').attr('data-edit-extra-ruta');
    var edit_table_key = el.closest('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var remove_dato_extra = el.attr('data-remove-dato-extra');
    var new_val = el.data('first_value');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="text" data-remove-dato-extra="' + remove_dato_extra + '" data-edit-extra-ruta="' + edit_extra_ruta + '" data-edit-table="' + edit_table + '" data-edit-widget-type="' + edit_widget + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    if (edit_widget == 'link') {
      parent_editable.html('<a target="_blank" href="' + new_val + '">' + new_val + '</a>');
    } else if (edit_widget == 'phone') {
      parent_editable.html('<a href="tel:' + new_val + '">' + new_val + '</a>');
    } else if (edit_widget == 'email') {
      parent_editable.html('<a href="mailto:' + new_val + '">' + new_val + '</a>');
    } else {
      parent_editable.html(new_val);
    }
    el.closest('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();
      $('.delete_dato_extra').remove();

      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').remove();
      el.closest('.row').find('.save_edit_icon').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
    });
  };


  /**
   *  Edit Type : "DATE"
   */
  this.edit_date = function (element) {
    var el = $(element.target);

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var input_val = el.parents('.row').find('.editable-field').text();
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');

    // Reset
    el.parent('.row').find('.partners-edit').remove();
    el.parent('.row').find('.cancel_edit_icon').remove();
    el.parent('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success" data-edit-type="date" data-edit-table="' + edit_table + '"  data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '" data-edit-table-key="' + edit_table_key + '"  role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-type="date" role="button" aria-hidden="true"></i>');
    var editable_input = $('<input type="text" style="display: none;" class="form-control animated fadeInDownCustom currently_editing"/>');

    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      editable_input.insertBefore(parent_editable);

      // Se agrega hasta aca el val por .val() para que se permitan las comillas
      var now = moment().format('DD-MM-YYYY');
      el.parents('.row').find('.currently_editing').datepicker({
        format: "dd/mm/yyyy",
        todayBtn: true,
        language: "es",
        daysOfWeekDisabled: "0",
        autoclose: true,
        todayHighlight: true,
        startDate: now
      });

      el.parents('.row').find('.currently_editing').datepicker('update', input_val);

      el.parents('.row').find('.currently_editing').val(input_val);
      control_btns.insertBefore(el);
      el.parents('.row').find('.currently_editing').show();
      el.parents('.row').find('.save_edit_icon').show();
      el.parents('.row').find('.cancel_edit_icon').show();
      el.parents('.row').find('.cancel_edit_icon').data("first_value", input_val);
    });
  };

  this.cancel_edit_date = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.parents('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.parents('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_table = el.parents('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_table_key = el.parents('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var new_val = el.data('first_value');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="date" data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val);
    el.parents('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.parents('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.parents('.row').find('.partners-edit').show();
      el.parents('.row').find('.currently_editing').remove();
      el.parents('.row').find('.save_edit_icon').remove();
      el.parents('.row').find('.cancel_edit_icon').remove();
    });
  };

  this.save_edit_date = function (element, edit_id, edit_col, edit_table, edit_table_key) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var new_val = el.parents('.row').find('.currently_editing').val();
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="date" role="button" data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val);
    el.parents('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.parents('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.parents('.row').find('.partners-edit').show();
      el.parents('.row').find('.currently_editing').remove();
      el.parents('.row').find('.cancel_edit_icon').remove();
      el.parents('.row').find('.save_edit_icon').remove();
    });
  };


  /**
   *  Edit Type : "RADIO"
   */
  this.edit_radio = function (element) {
    var el = $(element.target);

    el.addClass('animated fadeOutDownCustom');

    var radio_options;
    var temp_txt_opt = el.attr('data-edit-radio-options');
    if (temp_txt_opt.slice(-1) == ',') {
      temp_txt_opt = temp_txt_opt.slice(0, -1);
    }
    radio_options = '{' + temp_txt_opt + '}';

    var txt_radio_options = el.attr('data-edit-radio-options');
    radio_options = JSON.parse(radio_options);
    var pre_val = el.closest('.row').find('.editable-field').text().trim();
    var radios = '';
    var random = Math.floor((Math.random() * 100000) + 1);
    $.each(radio_options, function (key, val) {
      var r = Math.floor((Math.random() * 100000) + 1);
      if (key == pre_val) {
        radios += '<div class="form-check form-check-inline currently_editing">' +
          '<div class="custom-control custom-radio custom-control-inline">' +
          '<input name="' + random + '" data-radio-name="' + key + '" type="radio" checked="checked" ' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      } else {
        radios += '<div class="form-check form-check-inline currently_editing">' +
          '<div class="custom-control custom-radio custom-control-inline">' +
          '<input name="' + random + '" data-radio-name="' + key + '" type="radio"' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      }


    });

    radios = $(radios);
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_radio_name;
    if (!el.attr('data-edit-radio-name')) {
      edit_radio_name = random;
    } else {
      edit_radio_name = el.attr('data-edit-radio-name');
    }

    // Reset
    //el.parent('.row').find('.partners-edit').remove();
    el.closest('.row').find('.cancel_edit_icon').remove();
    el.closest('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success" data-edit-type="radio" data-edit-radio-options=\'' + txt_radio_options + '\' data-edit-radio-name="' + edit_radio_name + '" data-edit-table="' + edit_table + '" data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '"  data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-type="radio" role="button" aria-hidden="true"></i>');

    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      radios.insertBefore(parent_editable);

      // Se agrega hasta aca el val por .val() para que se permitan las comillas
      //el.parents('.row').find('.currently_editing').val(input_val);
      control_btns.insertBefore(el);
      el.closest('.row').find('.currently_editing').show();
      el.closest('.row').find('.save_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').data("first_value", pre_val);
    });


  };

  this.save_edit_radio = function (element, edit_id, edit_col, edit_table, edit_table_key, edit_radio_options) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var new_val_txt = el.closest('.row').find('.currently_editing input:checked').attr('data-radio-name');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="radio" role="button" data-edit-radio-options=\'' + edit_radio_options + '\' data-edit-table="' + edit_table + '"  data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val_txt);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').each(function () {
        $(this).remove();
      });
      el.closest('.row').find('.cancel_edit_icon').remove();
      el.closest('.row').find('.save_edit_icon').remove();
    });
  };

  this.cancel_edit_radio = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.closest('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.closest('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_table = el.closest('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_table_key = el.closest('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var edit_radio_name = el.closest('.row').find('.save_edit_icon').attr('data-edit-radio-name');
    var edit_radio_options = el.closest('.row').find('.save_edit_icon').attr('data-edit-radio-options');
    var new_val = el.data('first_value');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="radio" data-edit-radio-options=\'' + edit_radio_options + '\' data-edit-radio-name="' + edit_radio_name + '" data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').each(function () {
        $(this).remove();
      });
      el.closest('.row').find('.save_edit_icon').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
    });
  };


  /**
   *  Edit Type : "CHECKBOX"
   */
  this.edit_checkbox = function (element) {
    var el = $(element.target);

    el.addClass('animated fadeOutDownCustom');

    var checkbox_options;
    var temp_txt_opt = el.attr('data-edit-checkbox-options');
    if (temp_txt_opt.slice(-1) == ',') {
      temp_txt_opt = temp_txt_opt.slice(0, -1);
    }
    checkbox_options = '{' + temp_txt_opt + '}';

    var txt_checkbox_options = el.attr('data-edit-checkbox-options');
    checkbox_options = JSON.parse(checkbox_options);
    var pre_val = el.closest('.row').find('.editable-field').attr('data-values').trim();
    pre_val = pre_val.split(',');
    var checkboxs = '';
    var random = Math.floor((Math.random() * 100000) + 1);
    $.each(checkbox_options, function (key, val) {
      var r = Math.floor((Math.random() * 100000) + 1);
      if ($.inArray(key, pre_val) > -1) {

        checkboxs += '<div class="form-check form-check-inline currently_editing">' +
          ' <div class="custom-control custom-checkbox custom-control-inline">' +
          '<input name="' + random + '" data-checkbox-name="' + key + '" type="checkbox" checked="checked" ' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      } else {
        checkboxs += '<div class="form-check form-check-inline currently_editing">' +
          ' <div class="custom-control custom-checkbox custom-control-inline">' +
          '<input name="' + random + '" data-checkbox-name="' + key + '" type="checkbox"' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      }

    });

    checkboxs = $(checkboxs);
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');


    el.closest('.row').find('.cancel_edit_icon').remove();
    el.closest('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success" data-edit-type="checkbox" data-edit-checkbox-options=\'' + txt_checkbox_options + '\' data-edit-table="' + edit_table + '" data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '"  data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-checkbox-options="' + txt_checkbox_options + '" data-edit-type="checkbox" role="button" aria-hidden="true"></i>');

    var parent_editable = el.closest('.row').find('.editable-field-container');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      checkboxs.insertBefore(parent_editable);

      control_btns.insertBefore(el);
      el.closest('.row').find('.currently_editing').show();
      el.closest('.row').find('.save_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').data("first_value", pre_val);
    });


  };


  this.cancel_edit_checkbox = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.closest('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.closest('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_table = el.closest('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_table_key = el.closest('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var edit_checkbox_options = el.closest('.row').find('.save_edit_icon').attr('data-edit-checkbox-options');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="checkbox" data-edit-checkbox-options=\'' + edit_checkbox_options + '\' data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field-container');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');


    var checkbox_options;
    var temp_txt_opt = el.attr('data-edit-checkbox-options');
    if (temp_txt_opt.slice(-1) == ',') {
      temp_txt_opt = temp_txt_opt.slice(0, -1);
    }
    checkbox_options = '{' + temp_txt_opt + '}';

    checkbox_options = JSON.parse(checkbox_options);
    var pre_val = el.closest('.row').find('.editable-field').attr('data-values').trim();
    pre_val = pre_val.split(',');
    var checkboxs = '';
    var random = Math.floor((Math.random() * 100000) + 1);
    $.each(checkbox_options, function (key, val) {
      var r = Math.floor((Math.random() * 100000) + 1);

      if ($.inArray(key, pre_val) > -1) {
        checkboxs += '<div class="form-check form-check-inline currently_editing">' +
          '<div class="custom-control custom-checkbox">' +
          '<input name="' + random + '" data-checkbox-name="' + key + '" type="checkbox" checked="checked" ' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          ' <label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      } else {
        checkboxs += '<div class="form-check form-check-inline currently_editing">' +
          '<div class="custom-control custom-checkbox">' +
          '<input name="' + random + '" data-checkbox-name="' + key + '" type="checkbox"' +
          'class="custom-control-input " value="' + val + '" id="' + r + '">' +
          ' <label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      }

    });

    checkboxs = $(checkboxs);


    checkboxs.insertBefore(parent_editable);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').each(function () {
        $(this).remove();
      });
      el.closest('.row').find('.save_edit_icon').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
    });
  };

  this.save_edit_checkbox = function (element, edit_id, edit_col, edit_table, edit_table_key, edit_checkbox_options, new_checkbox_options) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');

    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="checkbox" role="button" data-edit-checkbox-options=\'' + edit_checkbox_options + '\' data-edit-table="' + edit_table + '"  data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field-container');
    el.closest('.row').find('.editable-field').attr('data-values', new_checkbox_options);
    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');


    var checkbox_options;
    var temp_txt_opt = edit_checkbox_options;
    if (temp_txt_opt.slice(-1) == ',') {
      temp_txt_opt = temp_txt_opt.slice(0, -1);
    }
    checkbox_options = '{' + temp_txt_opt + '}';

    checkbox_options = JSON.parse(checkbox_options);

    var checkboxs = '';
    $.each(checkbox_options, function (key, val) {
      var r = Math.floor((Math.random() * 100000) + 1);
      if ($.inArray(key, new_checkbox_options) > -1) {
        checkboxs += '<div class="form-check form-check-inline">' +
          '<div class="custom-control custom-checkbox">' +
          '<input data-checkbox-name="' + key + '" type="checkbox" checked="checked" ' +
          'class="custom-control-input " value="' + val + '" onclick="this.checked=!this.checked;" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      } else {
        checkboxs += '<div class="form-check form-check-inline">' +
          '<div class="custom-control custom-checkbox">' +
          '<input data-checkbox-name="' + key + '" type="checkbox" ' +
          'class="custom-control-input " value="' + val + '" onclick="this.checked=!this.checked;" id="' + r + '">' +
          '<label class="custom-control-label" for="' + r + '">' + key + '</label>' +
          '</div>' +
          '</div>';
      }

    });

    parent_editable.html(checkboxs);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').each(function () {
        $(this).remove();
      });
      el.closest('.row').find('.cancel_edit_icon').remove();
      el.closest('.row').find('.save_edit_icon').remove();
    });
  };


  /**
   *  Edit Type : "SELECT"
   */
  this.edit_select = function (element) {
    var el = $(element.target);

    el.addClass('animated fadeOutDownCustom');

    var select_options;
    var temp_txt_opt = el.attr('data-edit-select-options');
    if (temp_txt_opt.slice(-1) == ',') {
      temp_txt_opt = temp_txt_opt.slice(0, -1);
    }
    select_options = '{' + temp_txt_opt + '}';

    var txt_select_options = el.attr('data-edit-select-options');
    select_options = JSON.parse(select_options);
    var pre_val = el.parents('.row').find('.editable-field').text().trim();
    var select = '<select class="form-control currently_editing">';
    $.each(select_options, function (key, val) {
      if (key == pre_val) {
        select += '<option value="' + val + '" selected>' + key + '</option>';
      } else {
        select += '<option value="' + val + '">' + key + '</option>';
      }
    });
    select += '</select>';
    select = $(select);
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_extra_ruta = el.attr('data-edit-extra-ruta');

    // Reset
    el.parent('.row').find('.partners-edit').remove();
    el.parent('.row').find('.cancel_edit_icon').remove();
    el.parent('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success" data-edit-type="select" data-edit-extra-ruta="' + edit_extra_ruta + '" data-edit-select-options=\'' + txt_select_options + '\' data-edit-table="' + edit_table + '" data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '" data-edit-table-key="' + edit_table_key + '"  role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-type="select" role="button" aria-hidden="true"></i>');

    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      select.insertBefore(parent_editable);

      // Se agrega hasta aca el val por .val() para que se permitan las comillas
      //el.parents('.row').find('.currently_editing').val(input_val);
      control_btns.insertBefore(el);
      el.parents('.row').find('.currently_editing').show();
      el.parents('.row').find('.save_edit_icon').show();
      el.parents('.row').find('.cancel_edit_icon').show();
      el.parents('.row').find('.cancel_edit_icon').data("first_value", pre_val);
    });
  };

  this.save_edit_select = function (element, edit_id, edit_col, edit_table, edit_table_key, edit_extra_ruta, edit_select_options) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var new_val_txt = el.parents('.row').find('.currently_editing option:selected').text();
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="select" role="button" data-edit-extra-ruta="' + edit_extra_ruta + '" data-edit-select-options=\'' + edit_select_options + '\' data-edit-table="' + edit_table + '"  data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val_txt);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.parents('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.parents('.row').find('.partners-edit').show();
      el.parents('.row').find('.currently_editing').remove();
      el.parents('.row').find('.cancel_edit_icon').remove();
      el.parents('.row').find('.save_edit_icon').remove();
    });
  };

  this.cancel_edit_select = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.parents('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.parents('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_table = el.parents('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_table_key = el.parents('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var edit_extra_ruta = el.parents('.row').find('.save_edit_icon').attr('data-edit-extra-ruta');
    var edit_select_options = el.parents('.row').find('.save_edit_icon').attr('data-edit-select-options');
    var new_val = el.data('first_value');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="select" data-edit-extra-ruta="' + edit_extra_ruta + '" data-edit-select-options=\'' + edit_select_options + '\' data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.parents('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html(new_val);

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();


      // Completar transición
      el.parents('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.parents('.row').find('.partners-edit').show();
      el.parents('.row').find('.currently_editing').remove();
      el.parents('.row').find('.save_edit_icon').remove();
      el.parents('.row').find('.cancel_edit_icon').remove();
    });
  };


  /**
   *  Edit Type : "MAPS"
   */
  this.edit_maps = function (element) {
    var el = $(element.target);

    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var coordenadas = el.closest('.row').find('.editable-field').attr('data-cord');
    var edit_id = el.attr('data-edit-id');
    var edit_col = el.attr('data-edit-column');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');

    // Reset
    // el.closest('.row').find('.partners-edit').remove();
    el.closest('.row').find('.cancel_edit_icon').remove();
    el.closest('.row').find('.save_edit_icon').remove();


    var control_btns = $('<i style="display: none; overflow: hidden;" class="fas fa-save float-left animated fadeInDownCustom save_edit_icon text-success"  data-edit-type="maps" data-edit-table="' + edit_table + '" data-edit-column="' + edit_col + '" data-edit-id="' + edit_id + '"  data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i><i style="display: none; overflow: hidden;" class="fas fa-ban float-right animated fadeInDownCustom cancel_edit_icon text-danger" data-edit-type="maps" role="button" aria-hidden="true"></i>');
    var editable_input;
    editable_input = $('<input type="hidden" name="coordenadas currently_editing" id="coordenadas_editar" value="' + coordenadas + '" data-id-dato="' + edit_id + '"> <iframe src="clientes/mapa_editar" width="100% !important" height="500px !important" style="border: none;"></iframe>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeOutDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      parent_editable.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.hide();


      // Completar transición
      editable_input.insertBefore(parent_editable);

      // Se agrega hasta aca el val por .val() para que se permitan las comillas
      //el.closest('.row').find('.currently_editing').val(input_val);
      control_btns.insertBefore(el);
      el.closest('.row').find('.currently_editing').show();
      el.closest('.row').find('.save_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').show();
      el.closest('.row').find('.cancel_edit_icon').data("first_value", coordenadas);
    });
  };
  this.save_edit_maps = function (element, edit_id, edit_col, edit_table, edit_table_key, new_val) {
    var el = $(element.target);
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="maps" role="button" data-edit-table="' + edit_table + '"  data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html('<a href="https://www.google.com.mx/maps/dir/Current+Location/' + new_val + '/" target="_blank"><i class="fa fa-street-view" aria-hidden="true"></i> Ubicación Actual </a> | <a href="https://www.google.com.mx/maps/dir/20.685434,-103.354240/' + new_val + '/" target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i> Pc Partners</a>');
    el.closest('.row').find('iframe').remove();
    el.closest('.row').find('input[type="hidden"]').remove();

    el.closest('.row').find('.editable-field').attr('data-cord', new_val);
    el.closest('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();

      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
      el.closest('.row').find('.save_edit_icon').remove();

    });


  };

  this.cancel_edit_maps = function (element, element_external) {
    var el;
    if (element == null) {
      el = element_external;
    } else {
      el = $(element.target);
    }
    // Iniciar transición en el icon.
    el.addClass('animated fadeOutDownCustom');
    var edit_id = el.closest('.row').find('.save_edit_icon').attr('data-edit-id');
    var edit_col = el.closest('.row').find('.save_edit_icon').attr('data-edit-column');
    var edit_table = el.closest('.row').find('.save_edit_icon').attr('data-edit-table');
    var edit_table_key = el.closest('.row').find('.save_edit_icon').attr('data-edit-table-key');
    var new_val = el.data('first_value');
    var control_btns = $('<i class="fas fa-pencil-alt partners-edit" data-edit-type="maps" data-edit-table="' + edit_table + '" data-edit-id="' + edit_id + '" data-edit-column="' + edit_col + '" data-edit-table-key="' + edit_table_key + '" role="button" aria-hidden="true"></i>');
    var parent_editable = el.closest('.row').find('.editable-field');

    //Iniciar transición en el container del dato a editar.
    parent_editable.addClass('animated fadeInDownCustom');
    parent_editable.html('<a href="https://www.google.com.mx/maps/dir/Current+Location/' + new_val + '/" target="_blank"><i class="fa fa-street-view" aria-hidden="true"></i> Ubicación Actual </a> | <a href="https://www.google.com.mx/maps/dir/20.685434,-103.354240/' + new_val + '/" target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i> Pc Partners</a>');
    el.closest('.row').find('iframe').remove();
    el.closest('.row').find('input[type="hidden"]').remove();

    el.closest('.row').find('.currently_editing').addClass('animated fadeInDownCustom');

    //Continuar con las animaciones
    el.on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {

      //Continuar transición
      el.removeClass('animated fadeOutDownCustom');
      el.hide();
      parent_editable.show();
      $('.delete_dato_extra').remove();

      // Completar transición
      el.closest('.row').find('.partners-edit').each(function () {
        $(this).remove();
      });
      control_btns.insertBefore(el);
      el.closest('.row').find('.partners-edit').show();
      el.closest('.row').find('.currently_editing').remove();
      el.closest('.row').find('.save_edit_icon').remove();
      el.closest('.row').find('.cancel_edit_icon').remove();
    });
  };


  /**
   * Guardar en Base de Datos: TEXT
   */
  this.update_edit_text = function (element) {
    var el = $(element.target);
    var new_val = el.closest('.row').find('.currently_editing').val();
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_widget = el.attr('data-edit-widget-type');
    var edit_extra_ruta = el.attr('data-edit-extra-ruta');
    var remove_dato_extra = el.attr('data-remove-dato-extra');
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'text';
    envio = JSON.stringify(envio);
    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_text = this.save_edit_text;
    var cancel_edit_text = this.cancel_edit_text;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          save_edit_text(element, edit_id, edit_col, edit_widget, edit_table, edit_table_key, edit_extra_ruta, remove_dato_extra);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();

          if (edit_extra_ruta != 'undefined') {
            $.ajax({
              type: 'POST',
              url: edit_extra_ruta,
              data: envio,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  iziToast.success({
                    title: "Bien! ",
                    message: response.message,
                    timeout: 1500,
                    progressBar: false
                  });
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          }
        } else if (response.status == 'error') {
          cancel_edit_text(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });

  };


  /**
   * Guardar en Base de Datos: DATE
   */
  this.update_edit_date = function (element) {
    var el = $(element.target);
    var new_val = el.parents('.row').find('.currently_editing').datepicker('getDate');
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'date';
    envio = JSON.stringify(envio);
    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_date = this.save_edit_date;
    var cancel_edit_date = this.cancel_edit_date;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          save_edit_date(element, edit_id, edit_col, edit_table, edit_table_key);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();
        } else if (response.status == 'error') {
          cancel_edit_date(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });
  };

  /**
   * Guardar en Base de Datos: RADIO
   */
  this.update_edit_radio = function (element) {
    var el = $(element.target);
    var new_val = el.closest('.row').find('.currently_editing input:checked').val();
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_radio_options = el.attr('data-edit-radio-options');
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'radio';
    envio = JSON.stringify(envio);

    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_radio = this.save_edit_radio;
    var cancel_edit_radio = this.cancel_edit_radio;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          save_edit_radio(element, edit_id, edit_col, edit_table, edit_table_key, edit_radio_options);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();
        } else if (response.status == 'error') {
          cancel_edit_radio(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });

  };


  /**
   * Guardar en Base de Datos: RADIO
   */
  this.update_edit_checkbox = function (element) {
    var el = $(element.target);

    var new_datos = [];
    var new_val = [];
    el.closest('.row').find('.currently_editing input:checked').each(function () {
      new_datos.push($(this).attr('data-checkbox-name'));
      new_val.push($(this).val());
    });
    var new_val = new_val.toString();
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_checkbox_options = el.attr('data-edit-checkbox-options');
    var new_checkbox_options = new_datos;
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'checkbox';
    envio = JSON.stringify(envio);

    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_checkbox = this.save_edit_checkbox;
    var cancel_edit_checkbox = this.cancel_edit_checkbox;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          save_edit_checkbox(element, edit_id, edit_col, edit_table, edit_table_key, edit_checkbox_options, new_checkbox_options);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();
        } else if (response.status == 'error') {
          cancel_edit_checkbox(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });

  };

  /**
   * Guardar en Base de Datos: SELECT
   */
  this.update_edit_select = function (element) {
    var el = $(element.target);
    var new_val = el.parents('.row').find('.currently_editing option:checked').val();
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var edit_extra_ruta = el.attr('data-edit-extra-ruta');
    var edit_select_options = el.attr('data-edit-select-options');
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'select';
    envio = JSON.stringify(envio);

    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_select = this.save_edit_select;
    var cancel_edit_select = this.cancel_edit_select;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          // Cuando tiene una ruta extra, es porque se necesita que haga otra consulta extra, puede entrar
          // bien la de edit, pero puede tronar en la consulta extra, o truena en el edit y no entra en la
          // consulta extra.

          // Antes que nada si ya entro bien la edición, mostrar las animaciones, despues vendrá la consulta
          // extra.
          save_edit_select(element, edit_id, edit_col, edit_table, edit_table_key, edit_extra_ruta, edit_select_options);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();

          if (edit_extra_ruta) {
            $.ajax({
              type: 'POST',
              url: edit_extra_ruta,
              data: envio,
              contentType: "application/json; charset=utf-8",
              dataType: "json",
              success: function (response) {
                if (response.status == 'success') {
                  iziToast.success({
                    title: "Bien! ",
                    message: response.message,
                    timeout: 1500,
                    progressBar: false
                  });
                } else if (response.status == 'error') {
                  iziToast.error({
                    title: "Error",
                    message: response.message
                  });
                }
              },
              error: function (xhr) {
                iziToast.error({
                  title: "Ocurrio un error: ",
                  message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                });
              }
            });
          }

        } else if (response.status == 'error') {
          cancel_edit_select(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });

  };

  /**
   * Guardar en Base de Datos: MAPS
   */
  this.update_edit_maps = function (element) {
    var el = $(element.target);
    var new_val = el.closest('.row').find('input').val();
    var edit_col = el.attr('data-edit-column');
    var edit_id = el.attr('data-edit-id');
    var edit_table = el.attr('data-edit-table');
    var edit_table_key = el.attr('data-edit-table-key');
    var cancel_button = el.parents('.row').find('.cancel_edit_icon');
    var envio = {};
    envio.new_val = new_val;
    envio.edit_table = edit_table;
    envio.edit_table_key = edit_table_key;
    envio.edit_col = edit_col;
    envio.edit_id = edit_id;
    envio.type = 'maps';
    envio = JSON.stringify(envio);
    var callback = false;
    if (this.callback) {
      callback = this.callback;
    }

    //Bindear afuera del scope de success : function(){}
    var save_edit_maps = this.save_edit_maps;
    var cancel_edit_maps = this.cancel_edit_maps;
    $.ajax({
      type: 'POST',
      url: this.ruta_url,
      data: envio,
      contentType: "application/json; charset=utf-8",
      dataType: "json",
      success: function (response) {
        if (response.status == 'success') {
          save_edit_maps(element, edit_id, edit_col, edit_table, edit_table_key, new_val);
          iziToast.success({
            title: "Bien! ",
            message: response.message,
            timeout: 1500,
            progressBar: false
          });
          if (callback) callback();
        } else if (response.status == 'error') {
          cancel_edit_maps(null, cancel_button);
          iziToast.error({
            title: "Error",
            message: response.message
          });
        }
      },
      error: function (xhr) {
        iziToast.error({
          title: "Ocurrio un error: ",
          message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
        });
      }
    });

  };

}(jQuery));


(function () {
  this.AutoUpdate = function (options) {
    // Inactivo despues de 2 minutos
    ifvisible.setIdleDuration(options.iddle_after);

    this.control = ifvisible.onEvery(options.interval, function () {
      options.toUpdate();
    });

    AutoUpdate.prototype.forceUpdate = function () {
      options.toUpdate();
    }
  }
}());


var fixBootstrapModal = function fixBootstrapModal() {
  var $ = jQuery;
  $('.modal').each(function () {
    $(this).removeAttr('tabindex');
  });
};

// call this before hiding SweetAlert (inside done callback):
var restoreBootstrapModal = function restoreBootstrapModal() {
  var $ = jQuery;
  $('.modal').each(function () {
    $(this).attr('tabindex', '-1');
  });
};

var delay = (function () {
  var timer = 0;
  return function (callback, ms) {
    clearTimeout(timer);
    timer = setTimeout(callback, ms);
  };
})();


function getUrlVars() {
  var vars = {};
  var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
    vars[key] = value;
  });
  return vars;
}

function generar_contactos(ruta, id_cliente) {
  var $ = jQuery;
  var url = location.protocol + "//" + location.host + '/clientes?id_cliente=' + id_cliente + '&type=1';
  $.ajax({
    type: 'POST',
    url: ruta + id_cliente,
    contentType: "application/json; charset=utf-8",
    dataType: "json",
    success: function (response) {
      if (response.status == 'success') {
        var contactos = JSON.parse(response.message);
        var options = '';
        $.each(contactos, function (key, val) {
          options += '<option value="' + val.id_cliente + '" data-email-contacto="' + val.email + '">' + val.nombre_cliente + '</option>';
        });
        $('.select_lista_contactos').empty().append(options);

        $('.contacto_container').show();
        $('.agregar_nuevo_contacto').attr('href', url).attr('target', '_blank');
      } else if (response.status == 'error') {
        iziToast.error({
          title: "Error",
          message: response.message
        });
        $('.agregar_nuevo_contacto').attr('href', url).attr('target', '_blank');
        $('.contacto_container').show();
        $('.select_lista_contactos').empty().append('<option value="0">Cliente sin contactos</option>');
      }
    },
    error: function (xhr) {
      iziToast.error({
        title: "Ocurrio un error: ",
        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
      });
    }
  });
}


//***************************************************************
//------------------------ AUTENTICAR USER   --------------------
//***************************************************************

/**
 * @link https://github.com/ErickGomez98/Interno_dev#system
 * @param callback {function} callback contiene la función a realizar una vez se autorice el usuario,
 * la sintaxis para usar esta función está en la documentación de github.
 */
function auth_user(callback, cb_error) {
  var $ = jQuery;
  fixBootstrapModal();
  $('.modal').modal('hide');
  iziToast.show({
    title: 'Ingresa tu NIP',
    icon: 'fa fa-user',
    position: 'center',
    progressBarColor: 'rgb(0, 255, 184)',
    message: '<input class="form-control autenticar_user"  type="password" autocomplete="new-password" style="background: #565c70; color: #fff; border:2px solid #fff; margin-top:7px;"/>',
    color: 'dark',
    drag: false,
    layout: 2,
    timeout: 60000,
    resetOnHover: true,
    onOpen: function () {
      setTimeout(function () {
        $('.autenticar_user').focus();
      }, 400);
    },
    onClose: function () {
      cb_error();
    }
  });

  var $input = $('.autenticar_user');
  $input.off('keyup');
  $input.on('keyup', function (e) {
    e.stopPropagation();
    var val = $(this).val();
    delay(function () {
      validate_auth(val, callback);
    }, 500);
  })

}

/**
 *  @link https://github.com/ErickGomez98/Interno_dev#system
 * @param nip {string} el nip a buscar en la base de datos para validar al usuario
 * @param callback {function} una vez se valide el usuario, se ejecutará esta función, que ha estado siendo
 * traida desde que se llama auth_user() en otro lado.
 */
function validate_auth(nip, callback) {
  var $ = jQuery;
  $('.autenticar_user').css('background', '#7a7e8e');
  $('.autenticar_user').attr('disabled', true);
  $.ajax({
    type: 'POST',
    url: '/system/tools/auth_user',
    data: JSON.stringify(nip),
    contentType: "application/json; charset=utf-8",
    dataType: "json",
    success: function (response) {
      if (response.status == 'success') {
        callback(response.message);
        iziToast.destroy();
      } else if (response.status == 'error') {
        iziToast.error({
          title: "Error",
          message: response.message
        });
        $('.autenticar_user').css('background', '#565c70');
        $('.autenticar_user').removeAttr('disabled');
        $('.autenticar_user').focus();
      }
    },
    error: function (xhr) {
      iziToast.error({
        title: "Ocurrio un error: ",
        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
      });
    }
  });


}

//***************************************************************
//------------------------ AUTENTICAR USER   --------------------
//***************************************************************

Number.prototype.format = function (n, x) {
  var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
  return this.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
};

function validateEmail(email) {
  var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  return re.test(email);
}

/**
 * Recarga el buscador para que este buscando a ver si ya se capturo el cliente, para no tener que depender
 * del usuario para que lo haga manualmente.
 */

(function ($) {
  $(document).on('click', '.agregar_nuevo_cliente', function () {
    window.open('/clientes?new_cliente=1');
    auto_check_client();
  });
}(jQuery));
(function () {
  Raven.config('https://4be7cc6cbc72408d9167bf8cc06c8307@sentry.io/204694').install();
}());

function auto_check_client() {
  var $ = jQuery;
  var auto_check;
  $(window).one('blur', function () {
    auto_check = setInterval(function () {
      $('#buscar_cliente').trigger('input.typeahead');
    }, 3000);
    $(window).one('focus', function () {
      //Da un margen de 3 segundos para que cheque por última vez.
      setTimeout(function () {
        clearInterval(auto_check);
      }, 3000);
    });
  });
}
