(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//------------------------ MATERIAL DESIGN ----------------------
//***************************************************************
        $('.main-content.grid-80').closest('.row').css('background', '#f2f2f2');
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.nextstep-button'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.nextstep-button-2'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-1'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-2'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-3'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-4'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-5'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.prevstep-button-6'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.proceed-checkout'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_horas_list_item_1'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_horas_list_item_2'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_horas_list_item_3'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_horas_list_item_4'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_horas_list_item_5'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_pago_list_item_1'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_pago_list_item_2'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_pago_list_item_3'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_pago_list_item_4'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_pago_list_item_5'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_tipo_servicio_list_item_1'));
        mdc.ripple.MDCRipple.attachTo(document.querySelector('.select_tipo_servicio_list_item_2'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-nombre'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-email'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-nombre-empresa'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-telefono-particular'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-calle'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-colonia'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-cruzamientos'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-ciudad'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-nombre-contacto'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-email-contacto'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-telefono-contacto'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-telefono-empresa'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-fecha-servicio'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-horario'));
        mdc.textField.MDCTextField.attachTo(document.querySelector('.mdc-text-field-descripcion-servicio'));
//***************************************************************
//------------------------ MATERIAL DESIGN ----------------------
//***************************************************************


//***************************************************************
//------------------------ STEPS CONTROL ------------------------
//***************************************************************
        $(document).on('click', '.select_tipo_servicio_list_item', function () {
            // Avanzar a la etapa de preguntar el tipo de cliente
            $('.step-tipo-cliente').show();
            $('.step-tipo-servicio').hide();

            // Mostrar tipo de Servicio
            $('.info_tipo_servicio').attr('data-tipo-servicio', $(this).attr('data-tipo-servicio'));
            $('.info_tipo_servicio').html($(this).attr('data-nombre-servicio'));
        });

        $(document).on('click', '.select_tipo_cliente_list_item', function () {
            // Avanzar a la etapa de Datos personales, y ahora dependiendo del tipo de cliente seleccionado
            // y del tipo de servicio, mostrar u ocultar ciertos campos.
            $('.step-tipo-cliente').hide();
            $('.step-datos-personales').show();
            $('.info_tipo_cliente').attr('data-tipo-cliente', $(this).attr('data-tipo-cliente'));

            if ($(this).attr('data-tipo-cliente') == 1) { // Particular
                $('.datos_tipo_cliente_particular').show();
                $('.datos_tipo_cliente_empresa').hide();
            } else if ($(this).attr('data-tipo-cliente') == 2) { // Empresa
                $('.datos_tipo_cliente_empresa').show();
                $('.datos_tipo_cliente_particular').hide();
            }

            if ($('.info_tipo_servicio').attr('data-tipo-servicio') == 1) { // Remoto
                $('.container_datos_domicilio').hide();
                $('.container_info_datos_domicilio').hide();
            } else if ($('.info_tipo_servicio').attr('data-tipo-servicio') == 2) { // Domicilio
                $('.container_datos_domicilio').show();
                // Tambien mostrar la info del domicilio en el sidebar de la derecha
                $('.container_info_datos_domicilio').show();
            }
        });

        $(document).on('click', '.prevstep-button-1', function () {
            $('.step-tipo-cliente').hide();
            $('.step-tipo-servicio').show();
        });

        $(document).on('click', '.nextstep-button', function () {
            // Validar campos obligatorios.
            var hasError = 0;
            // Si el tipo de cliente es Particular, entonces validar el los form field .valid_me_datos_particular
            if ($('.info_tipo_cliente').attr('data-tipo-cliente') == 1) {
                if (!valid_form_field('.valid_me_datos_particular')) {
                    hasError++;
                }
            } else if ($('.info_tipo_cliente').attr('data-tipo-cliente') == 2) {
                // Si el tipo de cliente es Empresa, entonces validar el los form field .valid_me_datos_empresa
                if (!valid_form_field('.valid_me_datos_empresa')) {
                    hasError++;
                }
            }

            // Si el tipo de servicio es a Domicilio, entonces validar los form field de .valid_me_datos_domicilio
            if ($('.info_tipo_servicio').attr('data-tipo-servicio') == 2) {
                if (!valid_form_field('.valid_me_datos_domicilio')) {
                    hasError++;
                }
            }

            if (hasError > 0) {
                var snackbar = new mdc.snackbar.MDCSnackbar(document.querySelector('.mdc-snackbar'));
                var data = {
                    message: "Ingresa tus datos correctamente."
                };
                snackbar.show(data);
                return false;
            }


            // En casco de que todos los datos sean correctos, hacer lo correspondiente para capturar el cliente.
            $(this).attr('disabled', 'disabled');
            $('.progress_bar_datos_cliente').show();
            $('.prevstep-button-2').attr('disabled', 'disabled');


            // Datos cliente
            var datos = {};
            datos.tipo_cliente = $('.info_tipo_cliente').attr('data-tipo-cliente');

            if (datos.tipo_cliente == 1) { // Tipo Cliente particular, solo crear un cliente particular
                datos.nombre_cliente = $('#nombre_cliente').val();
                datos.telefono_cliente = $('#telefono_particular_cliente').val();
                datos.correo_cliente = $('#email_cliente').val();

            } else if (datos.tipo_cliente == 2) { // Tipo Cliente empresa, crear cliente tipo negocio y su contacto
                datos.nombre_empresa = $('#nombre_empresa').val();
                datos.telefono_empresa = $('#telefono_empresa_cliente').val();
                datos.nombre_contacto = $('#nombre_contacto_cliente').val();
                datos.correo_contacto = $('#email_contacto_cliente').val();
                datos.telefono_contacto = $('#telefono_contacto_cliente').val();
            }

            datos.tipo_servicio = $('.info_tipo_servicio').attr('data-tipo-servicio');

            if (datos.tipo_servicio == 2) { // El tipo de servicio es a domicilio, entonces capturar los datos de domicilio del cliente.
                datos.calle_cliente = $('#calle_cliente').val();
                datos.colonia_cliente = $('#colonia_cliente').val();
                datos.cruzamientos_cliente = $('#cruzamientos_cliente').val();
                datos.ciudad_cliente = $('#ciudad_cliente').val();
            }

            // Inicializarlos en 0
            datos.id_cliente = 0;
            datos.id_contacto = 0;

            // En caso de existir ya sea el cliente o el contacto, significa que ya se crearon de manera temporal, significa que se
            // regresaron una etapa para atras para modificar el cliente, por lo que entonces será necesario hacer un update de los datos
            // en base a estos ID, para no generar uno nuevo.
            if ($(".info_nombre_cliente").attr('data-id-cliente') != 0) datos.id_cliente = $(".info_nombre_cliente").attr('data-id-cliente');


            if ($(".info_nombre_cliente").attr('data-id-contacto') != 0) datos.id_contacto = $(".info_nombre_cliente").attr('data-id-contacto');

            var envio = JSON.stringify(datos);
            $.ajax({
                type: 'POST',
                url: settings.website.ruta_consultas + 'capturar_cliente_prepago',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        var data = JSON.parse(response.message);
                        // Asignar el id_cliente y id_contacto temporales
                        $(".info_nombre_cliente").attr('data-id-cliente', data.id_cliente);
                        $(".info_nombre_cliente").attr('data-id-contacto', data.id_contacto);


                        $('.step-datos-personales').hide();
                        $('.step-horas-prepagar').show();
                        $('.nextstep-button').removeAttr('disabled');
                        $('.prevstep-button-2').removeAttr('disabled');
                        $('.progress_bar_datos_cliente').hide();
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                        $('.nextstep-button').removeAttr('disabled');
                        $('.prevstep-button-2').removeAttr('disabled');
                        $('.progress_bar_datos_cliente').hide();
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                    $('.nextstep-button').removeAttr('disabled');
                    $('.prevstep-button-2').removeAttr('disabled');
                    $('.progress_bar_datos_cliente').hide();
                }
            });


        });

        $(document).on('click', '.prevstep-button-2', function () {
            // Ocultar datos personales y mostrar tipo cliente
            $('.step-tipo-cliente').show();
            $('.step-datos-personales').hide();

            // Limpiar el formulario de los datos personales
            $('.valid_me_datos_domicilio');
            reset_form_field('.valid_me_datos_domicilio');
            reset_form_field('.valid_me_datos_empresa');
            reset_form_field('.valid_me_datos_particular');

            // Limpiar la info en la sidebar
            $('.info_nombre_cliente').html('');
            $('.info_nombre_empresa').html('');
            $('.info_email_cliente').html('');
            $('.info_ciudad_cliente').html('');
            $('.info_colonia_cliente').html('');
            $('.info_calle_cliente').html('');
            $('.info_cruzamientos_cliente').html('');

            // El form anterior se hace más chico, entonces ayudar haciendo scroll para arriba
            $("html, body").animate({scrollTop: 100}, "fast");

        });

        $(document).on('click', '.select_horas_list_item', function () {
            $('.step-horas-prepagar').hide();
            $('.step-datos-servicio').show();
            $('.info_horas_pagadas').html($(this).attr('data-hora'));
            $('.info_total_pago').html($(this).attr('data-precio'));
            var now = moment().format('DD-MM-YYYY');
            var now_ = moment().format('DD/MM/YYYY');
            $('#fecha_servicio').val(now_);
            $('.mdc-text-field-fecha-servicio #fecha_servicio').datepicker({
                format: "dd/mm/yyyy",
                todayBtn: "linked",
                language: "es",
                daysOfWeekDisabled: "0",
                autoclose: true,
                todayHighlight: true,
                startDate: now,
                orientation: "auto",
                container: '.mdc-text-field-fecha-servicio'
            });
        });

        $(document).on('click', '.prevstep-button-3', function () {
            $('.step-datos-personales').show();
            $('.step-horas-prepagar').hide();
        });

        $(document).on('click', '.nextstep-button-2', function () {
            // Validar campos obligatorios.
            var hasError = 0;

            if (!valid_form_field('.valid_me_datos_servicio')) hasError++;


            // Validar textarea manualmente
            if ($.trim($('#descripcion_servicio_cliente').val()) == '') hasError++;


            if (hasError > 0) {
                var snackbar = new mdc.snackbar.MDCSnackbar(document.querySelector('.mdc-snackbar'));
                var data = {
                    message: "Ingresa tus datos correctamente."
                };
                snackbar.show(data);
                return false;
            }

            // Avanzar a la etapa de metodo de pago
            $('.step-datos-servicio').hide();
            $('.step-metodo-pago-prepagar').show();

        });

        $(document).on('click', '.prevstep-button-4', function () {
            $('.step-horas-prepagar').show();
            $('.step-datos-servicio').hide();
            reset_form_field('.valid_me_datos_servicio');
        });

        $(document).on('click', '.select_pago_list_item', function () {
            $('.layout_info').removeClass('mdc-layout-grid__cell--span-4');
            $('.layout_info').addClass('mdc-layout-grid__cell--span-12');
            $('.layout_info').css('margin', 'auto');
            $('.layout_procedimiento').hide();
            $('.proceed-checkout').show();
            $('.info_metodo_pago').html($(this).attr('data-metodo'));
            $('.info_metodo_pago').attr('metodo-pago', $(this).attr('data-metodo-n'));
            $('.prevstep-button-6').show();
        });

        $(document).on('click', '.prevstep-button-5', function () {
            $('.step-datos-servicio').show();
            $('.step-metodo-pago-prepagar').hide();
        });

        $(document).on('click', '.prevstep-button-6', function () {
            $('.step-metodo-pago-prepagar').show();
            $('.layout_info').removeClass('mdc-layout-grid__cell--span-12');
            $('.layout_info').addClass('mdc-layout-grid__cell--span-4');
            $('.layout_info').removeAttr('style');
            $('.layout_procedimiento').show();
            $('.proceed-checkout').hide();
            $('.info_metodo_pago').html($(this).attr('data-metodo'));
            $('.prevstep-button-6').hide();
            $('.progress_bar_checkout').hide();
            $('.proceed-checkout').removeAttr('disabled');
        });

//***************************************************************
//------------------------ STEPS CONTROL ------------------------
//***************************************************************


//***************************************************************
//------------------------ SIDEBAR INFO -------------------------
//***************************************************************
        $(document).on('change keydown keyup', '.form_nombre_cliente', function () {
            $('.info_nombre_cliente').html($('.form_nombre_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_nombre_contacto_cliente', function () {
            $('.info_nombre_cliente').html($('.form_nombre_contacto_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_email_cliente', function () {
            $('.info_email_cliente').html($('.form_email_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_email_contacto_cliente', function () {
            $('.info_email_cliente').html($('.form_email_contacto_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_nombre_empresa', function () {
            $('.info_nombre_empresa').html($('.form_nombre_empresa').val());
        });

        $(document).on('change keydown keyup', '.form_calle_cliente', function () {
            $('.info_calle_cliente').html($('.form_calle_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_colonia_cliente', function () {
            $('.info_colonia_cliente').html($('.form_colonia_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_cruzamientos_cliente', function () {
            $('.info_cruzamientos_cliente').html($('.form_cruzamientos_cliente').val());
        });

        $(document).on('change keydown keyup', '.form_ciudad_cliente', function () {
            $('.info_ciudad_cliente').html($('.form_ciudad_cliente').val());
        });

        $(document).on('change', '#fecha_servicio', function () {
            $('.info_fecha_servicio').html($('#fecha_servicio').val());
        });

        $(document).on('change keydown keyup', '#horario_cliente', function () {
            $('.info_horario_servicio').html($('#horario_cliente').val());
        });

        $(document).on('change keydown keyup', '#descripcion_servicio_cliente', function () {
            $('.info_descripcion_servicio').html($('#descripcion_servicio_cliente').val());
        });
//***************************************************************
//------------------------ SIDEBAR INFO -------------------------
//***************************************************************


//***************************************************************
//----------------------- VALIDACIONES  -------------------------
//***************************************************************

        /**
         * Resetea los form fields pasando una clase en común de todos los form fields a resetear
         * @param form_field_class
         */
        function reset_form_field(form_field_class) {
            $(form_field_class).each(function () {
                $(this).val('');
                $(this).closest('.text-field').removeClass('mdc-text-field--invalid');
            });
        }

        /**
         * Recibe una clase en común entre todos los form fields a validar, valida que no este vacio (siempre y cuando sea required)
         * y en dado caso de ser input de tipo email, valida el email.
         * En el caso de que todos los campos esten correctamente validos, regresa true
         * En el caso de que al menos un campo no sea valido, marca este campo con una clase para identificarlo y la función regresa falso
         * para establecer que no es valido.
         * @param form_field_class
         * @returns {boolean}
         */
        function valid_form_field(form_field_class) {
            var hasError = 0;
            $(form_field_class).each(function () {
                var $this = $(this);
                var val = $.trim($this.val());
                var attr = $this.attr('required');

                // Solamente trabajar con los campos que son required
                if (typeof attr !== typeof undefined && attr !== false) {
                    // Si el campo está vació, marcarlo con error
                    if (val == '') {
                        $this.closest('.text-field').addClass('mdc-text-field--invalid');
                        hasError++;
                    }

                    // Si el tipo de input es un email, entonces validarlo.
                    if ($this.attr('type') == 'email') {
                        if (!validateEmail(val)) {
                            $this.closest('.text-field').addClass('mdc-text-field--invalid');
                            hasError++;
                        }
                    }
                }
            });

            return !(hasError > 0);
        }

//***************************************************************
//----------------------- VALIDACIONES  -------------------------
//***************************************************************


//***************************************************************
//----------------------- PROCESAR CHECKOUT ---------------------
//***************************************************************
        $(document).on('click', '.proceed-checkout', function () {
            $('.proceed-checkout').attr('disabled', 'disabled');
            $('.progress_bar_checkout').show();
            $('.prevstep-button-6').hide();

            var datos = {};


            datos.tipo_servicio = $('.info_tipo_servicio').attr('data-tipo-servicio');
            datos.tipo_cliente = $('.info_tipo_cliente').attr('data-tipo-cliente');

            // Los datos del cliente ya estan en la base de datos, por eso no es necesario recolectarlos por su input
            datos.id_cliente = $(".info_nombre_cliente").attr('data-id-cliente');
            datos.id_contacto = $(".info_nombre_cliente").attr('data-id-contacto');


            datos.horas = $('.info_horas_pagadas').html();
            datos.metodo_pago = $('.info_metodo_pago').attr('metodo-pago');
            datos.descripcion_servicio = $('#descripcion_servicio_cliente').val();
            datos.fecha_servicio = $('#fecha_servicio').datepicker('getDate');
            datos.horario_servicio = $('#horario_cliente').val();

            var envio = JSON.stringify(datos);

            $.ajax({
                type: 'POST',
                url: settings.website.ruta_consultas + 'procesar_orden_servicio_prepago',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        if (datos.metodo_pago != 5) { // PayPal o PayU que requieren de redireccionar a sus portales.
                            var snackbar = new mdc.snackbar.MDCSnackbar(document.querySelector('.mdc-snackbar'));
                            var data = {
                                message: "Serás redireccionado en 3 segundos para completar el Pago.",
                                timeout: 5000
                            };
                            snackbar.show(data);
                            setTimeout(function () {
                                window.location.replace(response.message);
                            }, 3000);
                        } else { // Método de pago en transferencia bancaría, solo mostrar la información.
                            // Se reutilizará el card de layout_info ya que no será utilizado después.
                            $('.layout_info .resumen_card').css('height', 'auto');
                            $('.layout_info .resumen_card').html(response.message);
                        }
                    } else if (response.status == 'error') {
                        iziToast.error({
                            title: "Error",
                            message: response.message
                        });
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        });
//***************************************************************
//----------------------- PROCESAR CHECKOUT ---------------------
//***************************************************************


    });
})
(jQuery);