(function ($) {
    var settings = Drupal.settings;
    $(document).ready(function () {

//***************************************************************
//---------------------- PROCESS PAYPAL PAYMENT  ----------------
//***************************************************************
        if (getUrlVars()['success']) {
            var status = getUrlVars()['success'];
            if (status == "true") {
                var paymentId = getUrlVars()['paymentId'];
                var token = getUrlVars()['token'];
                var payerID = getUrlVars()['PayerID'];
                var tokenPartners = getUrlVars()['tokenPartners'];
                process_paypal_payment(paymentId, token, payerID, tokenPartners);
            } else {
                setTimeout(function () {
                    window.location.replace('/');
                }, 2000);
            }
            window.history.pushState('paypal_checkout', 'Paypal Checkout', '/prepago/process_paypal');
        } else {
            setTimeout(function () {
                window.location.replace('/');
            }, 20000);
        }

        function process_paypal_payment(paymentId, token, payerID, tokenPartners) {
            var envio = {};
            envio.paymentID = paymentId;
            envio.token = token;
            envio.payerID = payerID;
            envio.tokenPartners = tokenPartners;
            envio = JSON.stringify(envio);
            $.ajax({
                type: 'POST',
                url: settings.website.ruta_consultas + 'process_paypal_payment_prepago',
                data: envio,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (response) {
                    if (response.status == 'success') {
                        $('.text-status').html('Pago realizado exitosamente!');
                        $('.lead').html('Recibirá un correo eléctronico con la información necesaria para dar seguimiento a su Servicio de prepago.');
                        $('.main-jumbotron').css('transition', 'background-color 200ms linear');
                        $('.main-jumbotron').css('background', '#50c5168f', 'important');
                    } else if (response.status == 'error') {
                        $('.text-status').html('Ourrio un error al procesar el pago.');
                        $('.lead').html(' si lo desea, puede volver a generar otra solicitud en <a href="https://www.pcpartners.com.mx/servicios/prepago/">Servicios Prepago</a>');
                        $('.main-jumbotron').css('transition', 'background-color 200ms linear');
                        $('.main-jumbotron').css('background', '#ff000094', 'important');
                    }
                },
                error: function (xhr) {
                    iziToast.error({
                        title: "Ocurrio un error: ",
                        message: 'Request Status: ' + xhr.status + ' Status Text: ' + xhr.statusText
                    });
                }
            });
        }

//***************************************************************
//---------------------- PROCESS PAYPAL PAYMENT  ----------------
//***************************************************************


//***************************************************************
//------------------------ PARALLAX BACKGROUND ------------------
//***************************************************************
        $('.main-jumbotron').parents('.container-fluid').find('.main-content').removeClass('row').addClass('col-md-12 p-0');
        $('.main-jumbotron').parents('.container-fluid').find('.main-content').find('.col-sm-12').addClass('p-0');
        $('.main-jumbotron').parents('.grid-80').removeClass('grid-80');
        $('.main-jumbotron').parallaxBackground({
            parallaxBgImage: '/sites/default/files/img/accountant-2.png',
            parallaxSpeed: 1
        });
//***************************************************************
//------------------------ PARALLAX BACKGROUND ------------------
//***************************************************************

    });
})
(jQuery);